/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.groovy.editor.actions.ImportCandidate;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedClass;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public class FixImportsHelper {
    private static final Logger LOG = Logger.getLogger(FixImportsHelper.class.getName());

    private FixImportsHelper() {
    }

    public static List<ImportCandidate> getImportCandidate(FileObject fo, String missingClass) {
        GroovyIndex index;
        LOG.log(Level.FINEST, "Looking for class: {0}", missingClass);
        ArrayList<ImportCandidate> result = new ArrayList<ImportCandidate>();
        ClasspathInfo pathInfo = FixImportsHelper.getClasspathInfoForFileObject(fo);
        if (pathInfo == null) {
            LOG.log(Level.FINEST, "Problem getting ClasspathInfo");
            return result;
        }
        if (fo != null && (index = GroovyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("classpath/source"), Collections.emptyList(), Collections.emptyList()))) != null) {
            Set<IndexedClass> classes = index.getClasses(missingClass, QuerySupport.Kind.PREFIX, true, false, false);
            for (IndexedClass indexedClass : classes) {
                if (!indexedClass.getName().equals(missingClass)) continue;
                if (indexedClass.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS) {
                    FixImportsHelper.addAsImportCandidate(missingClass, indexedClass.getFqn(), ElementKind.CLASS, result);
                }
                if (indexedClass.getKind() != org.netbeans.modules.csl.api.ElementKind.INTERFACE) continue;
                FixImportsHelper.addAsImportCandidate(missingClass, indexedClass.getFqn(), ElementKind.INTERFACE, result);
            }
        }
        Set typeNames = pathInfo.getClassIndex().getDeclaredTypes(missingClass, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (ElementHandle typeName : typeNames) {
            ElementKind ek = typeName.getKind();
            if (ek != ElementKind.CLASS && ek != ElementKind.INTERFACE) continue;
            FixImportsHelper.addAsImportCandidate(missingClass, typeName.getQualifiedName(), ek, result);
        }
        return result;
    }

    private static ClasspathInfo getClasspathInfoForFileObject(FileObject fo) {
        ClassPath bootPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        ClassPath compilePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        ClassPath srcPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (bootPath == null || compilePath == null || srcPath == null) {
            return null;
        }
        return ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)srcPath);
    }

    private static void addAsImportCandidate(String missingClass, String fqnName, ElementKind kind, List<ImportCandidate> result) {
        int level = FixImportsHelper.getImportanceLevel(fqnName);
        Icon icon = ElementIcons.getElementIcon((ElementKind)kind, null);
        result.add(new ImportCandidate(missingClass, fqnName, icon, level));
    }

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static String getMissingClassName(String errorMessage) {
        int idx;
        String ERR_PREFIX = "unable to resolve class ";
        String missingClass = null;
        if (errorMessage.startsWith(ERR_PREFIX) && (idx = (missingClass = errorMessage.substring(ERR_PREFIX.length())).indexOf(" ")) != -1) {
            return missingClass.substring(0, idx);
        }
        return missingClass;
    }

    private static int getImportPosition(BaseDocument doc) {
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)doc, 1);
        int importEnd = -1;
        int packageOffset = -1;
        while (ts.moveNext()) {
            Token t = ts.token();
            int offset = ts.offset();
            if (t.id() == GroovyTokenId.LITERAL_import) {
                LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_import found");
                importEnd = offset;
                continue;
            }
            if (t.id() != GroovyTokenId.LITERAL_package) continue;
            LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_package found");
            packageOffset = offset;
        }
        int useOffset = 0;
        if (importEnd != -1 && packageOffset > importEnd) {
            LOG.log(Level.FINEST, "packageOffset > importEnd");
            return -1;
        }
        int lineOffset = 0;
        if (importEnd == -1 && packageOffset == -1) {
            LOG.log(Level.FINEST, "importEnd == -1 && packageOffset == -1");
            return 0;
        }
        if (importEnd == -1 && packageOffset != -1) {
            LOG.log(Level.FINEST, "importEnd == -1 && packageOffset != -1");
            useOffset = packageOffset;
            ++lineOffset;
        } else if (importEnd != -1 && packageOffset == -1) {
            LOG.log(Level.FINEST, "importEnd != -1 && packageOffset == -1");
            useOffset = importEnd;
        } else if (importEnd != -1 && packageOffset != -1) {
            LOG.log(Level.FINEST, "importEnd != -1 && packageOffset != -1");
            useOffset = importEnd;
        }
        try {
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINEST, "BadLocationException for offset : {0}", useOffset);
            LOG.log(Level.FINEST, "BadLocationException : {0}", ex.getMessage());
            return -1;
        }
        return Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)((lineOffset += Utilities.getLineOffset((BaseDocument)doc, (int)useOffset)) + 1));
    }

    public static void doImport(FileObject fo, String fqnName) throws MissingResourceException {
        FixImportsHelper.doImports(fo, Collections.singletonList(fqnName));
    }

    public static void doImports(FileObject fo, List<String> fqnNames) throws MissingResourceException {
        BaseDocument baseDoc = LexUtilities.getDocument(fo, true);
        if (baseDoc == null) {
            return;
        }
        EditList edits = new EditList(baseDoc);
        for (String fqnName : fqnNames) {
            int importPosition = FixImportsHelper.getImportPosition(baseDoc);
            if (importPosition == -1) continue;
            LOG.log(Level.FINEST, "Importing here: {0}", importPosition);
            edits.replace(importPosition, 0, "import " + fqnName + "\n", false, 0);
        }
        edits.apply();
    }
}

