/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.actions.ImportCandidate;
import org.netbeans.modules.groovy.editor.actions.ImportChooserInnerPanel;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FixImportsAction
extends BaseAction {
    protected static final String ACTION_NAME = "fix-groovy-imports";
    private static final Logger LOG = Logger.getLogger(FixImportsAction.class.getName());
    private final List<String> missingNames = new ArrayList<String>();
    private final AtomicBoolean cancel = new AtomicBoolean();

    public FixImportsAction() {
        super(10);
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        final FileObject fo = NbEditorUtilities.getDataObject((Document)target.getDocument()).getPrimaryFile();
        Source source = Source.create((FileObject)fo);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new CollectMissingImportsTask());
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        final ArrayList<String> singleCandidates = new ArrayList<String>();
        HashMap<String, List<ImportCandidate>> multipleCandidates = new HashMap<String, List<ImportCandidate>>();
        block6: for (String name : this.missingNames) {
            List<ImportCandidate> importCandidates = FixImportsHelper.getImportCandidate(fo, name);
            switch (importCandidates.size()) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    singleCandidates.add(importCandidates.get(0).getFqnName());
                    continue block6;
                }
            }
            multipleCandidates.put(name, importCandidates);
        }
        if (!multipleCandidates.isEmpty()) {
            List<String> choosenCandidates = this.showFixImportChooser(multipleCandidates);
            singleCandidates.addAll(choosenCandidates);
        }
        if (!singleCandidates.isEmpty()) {
            Collections.sort(singleCandidates);
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FixImportsHelper.doImports(fo, singleCandidates);
                }
            }, (String)"Fix All Imports", (AtomicBoolean)this.cancel, (boolean)false);
        }
    }

    private List<String> showFixImportChooser(Map<String, List<ImportCandidate>> multipleCandidates) {
        List<String> result = new ArrayList<String>();
        ImportChooserInnerPanel panel = new ImportChooserInnerPanel();
        panel.initPanel(multipleCandidates);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(FixImportsAction.class, (String)"FixImportsDialogTitle"));
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        d.setVisible(false);
        d.dispose();
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            result = panel.getSelections();
        }
        return result;
    }

    private class CollectMissingImportsTask
    extends UserTask {
        private CollectMissingImportsTask() {
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult result = ASTUtils.getParseResult(resultIterator.getParserResult());
            if (result != null) {
                ErrorCollector errorCollector = result.getErrorCollector();
                if (errorCollector == null) {
                    return;
                }
                List errors = errorCollector.getErrors();
                if (errors == null) {
                    return;
                }
                this.collectMissingImports(errors);
            }
        }

        private void collectMissingImports(List errors) {
            FixImportsAction.this.missingNames.clear();
            for (Object error : errors) {
                String missingClassName;
                SyntaxException se;
                if (!(error instanceof SyntaxErrorMessage) || (se = ((SyntaxErrorMessage)error).getCause()) == null || (missingClassName = FixImportsHelper.getMissingClassName(se.getMessage())) == null || FixImportsAction.this.missingNames.contains(missingClassName)) continue;
                FixImportsAction.this.missingNames.add(missingClassName);
            }
        }
    }
}

