/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.HTMLEditorKitEx;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalPanel;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PanelBodyContainer
extends JPanel {
    private String head = null;
    private String message = null;
    private JScrollPane customPanel;
    private JPanel bodyPanel = null;
    private JComponent progressPanel = null;
    private JComponent progress;
    private boolean isWaiting = false;
    private Timer delay;
    private ProgressHandle handle;
    private JPanel pBodyPanel;
    private JScrollPane spPanelHeader;
    private JTextPane tpPanelHeader;

    public PanelBodyContainer(String heading, String msg, JPanel bodyPanel) {
        this.head = heading;
        this.message = msg;
        this.bodyPanel = bodyPanel;
        this.initComponents();
        HTMLEditorKitEx htmlkit = new HTMLEditorKitEx();
        StyleSheet css = htmlkit.getStyleSheet();
        if (css.getStyleSheets() == null) {
            StyleSheet css2 = new StyleSheet();
            Font f = new JList().getFont();
            int size = f.getSize();
            css2.addRule(new StringBuffer("body { font-size: ").append(size).append("; font-family: ").append(f.getName()).append("; }").toString());
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
        this.tpPanelHeader.setEditorKit(htmlkit);
        this.writeToHeader(this.head, this.message);
        this.initBodyPanel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBodyContainer.this.bodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
        if (this.isWaiting) {
            this.setWaitingState(true);
        }
    }

    public void setBody(final JPanel newBodyPanel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.bodyPanel = newBodyPanel;
            this.initBodyPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.bodyPanel = newBodyPanel;
                    PanelBodyContainer.this.initBodyPanel();
                }
            });
        }
    }

    public void setWaitingState(boolean isWaiting) {
        this.setWaitingState(isWaiting, 0L);
    }

    public void setWaitingState(boolean isWaiting, final long estimatedTime) {
        if (this.isWaiting == isWaiting) {
            return;
        }
        this.isWaiting = isWaiting;
        if (isWaiting) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.addProgressLine(estimatedTime);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.removeProgressLine();
                }
            });
        }
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            if (isWaiting) {
                rootPane.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                rootPane.setCursor(null);
            }
        }
    }

    private void addProgressLine(long estimatedTime) {
        this.handle = ProgressHandleFactory.createHandle((String)"PanelBodyContainer_ProgressLine");
        JLabel title = this.bodyPanel instanceof LicenseApprovalPanel ? new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWaitForLicense")) : (estimatedTime > 0L ? new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ProgressLine")) : new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWait")));
        this.progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 0, 12);
        gridBagConstraints.gridheight = 0;
        this.progress.setMinimumSize(new Dimension(70, this.progress.getMinimumSize().height));
        this.progressPanel.add((Component)this.progress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 20);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.progressPanel.add((Component)title, gridBagConstraints);
        this.progressPanel.setVisible(false);
        this.delay = new Timer(900, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelBodyContainer.this.delay.stop();
                PanelBodyContainer.this.progressPanel.setVisible(true);
                PanelBodyContainer.this.initBodyPanel();
            }
        });
        this.delay.setRepeats(false);
        this.delay.start();
        String progressDisplayName = NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ProgressLine");
        if (estimatedTime == 0L) {
            this.handle.start();
            this.handle.progress(progressDisplayName);
        } else {
            assert (estimatedTime > 0L) : "Estimated time " + estimatedTime;
            long friendlyEstimatedTime = estimatedTime + 2L;
            this.handle.start((int)friendlyEstimatedTime * 10, friendlyEstimatedTime);
            this.handle.progress(progressDisplayName, 0);
            new UpdateProgress(friendlyEstimatedTime, progressDisplayName).start();
        }
    }

    private void adjustProgressWidth() {
        Dimension min = this.progress.getMinimumSize();
        Dimension preferred = this.progress.getPreferredSize();
        if (min != null && preferred != null && min.width * 2 < preferred.width) {
            int width = preferred.width / 2;
            int height = min.height;
            this.progress.setMinimumSize(new Dimension(150, height));
        }
    }

    private void initBodyPanel() {
        this.pBodyPanel.removeAll();
        this.customPanel = new JScrollPane();
        this.customPanel.setBorder(null);
        this.pBodyPanel.add((Component)this.customPanel, "Center");
        if (this.isWaiting && this.progressPanel != null) {
            this.pBodyPanel.add((Component)this.progressPanel, "South");
        }
        this.customPanel.setViewportView(this.bodyPanel);
        this.customPanel.getVerticalScrollBar().setUnitIncrement(10);
        this.customPanel.getHorizontalScrollBar().setUnitIncrement(10);
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBodyContainer.this.pBodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
    }

    private void removeProgressLine() {
        if (this.progressPanel != null) {
            this.pBodyPanel.remove(this.progressPanel);
            if (this.handle != null) {
                this.handle.finish();
            }
            this.revalidate();
        }
    }

    public void setHeadAndContent(final String heading, final String content) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToHeader(heading, content);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.writeToHeader(heading, content);
                }
            });
        }
    }

    private void writeToHeader(String heading, String msg) {
        this.tpPanelHeader.setText(null);
        this.tpPanelHeader.setText("<br><b>" + heading + "</b> <br>" + msg);
    }

    private void initComponents() {
        this.pBodyPanel = new JPanel();
        this.spPanelHeader = new JScrollPane();
        this.tpPanelHeader = new JTextPane();
        this.pBodyPanel.setLayout(new BorderLayout());
        this.tpPanelHeader.setEditable(false);
        this.tpPanelHeader.setContentType("text/html");
        this.spPanelHeader.setViewportView(this.tpPanelHeader);
        this.tpPanelHeader.getAccessibleContext().setAccessibleName(this.head);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pBodyPanel, -1, 390, Short.MAX_VALUE).addComponent(this.spPanelHeader, GroupLayout.Alignment.TRAILING, -1, 390, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spPanelHeader, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pBodyPanel, -1, 249, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACD"));
    }

    private final class UpdateProgress
    implements Runnable {
        private final long friendlyEstimatedTime;
        private final RequestProcessor.Task task;
        private int i;

        public UpdateProgress(long friendlyEstimatedTime, String progressDisplayName) {
            this.friendlyEstimatedTime = friendlyEstimatedTime;
            this.task = Installer.RP.create((Runnable)this);
            this.i = 0;
        }

        @Override
        public void run() {
            if (PanelBodyContainer.this.isWaiting && PanelBodyContainer.this.isShowing()) {
                if (this.friendlyEstimatedTime * 10L <= (long)this.i++) {
                    PanelBodyContainer.this.handle.switchToIndeterminate();
                    return;
                }
                PanelBodyContainer.this.handle.progress(this.i);
                this.task.schedule(100);
            }
        }

        final void start() {
            this.task.schedule(0);
        }
    }
}

