/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jumpto.symbol;

import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jumpto.symbol.SymbolProviderAccessor;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Parameters;

public interface SymbolProvider {
    public String name();

    public String getDisplayName();

    public void computeSymbolNames(Context var1, Result var2);

    public void cancel();

    public void cleanup();

    public static final class Result {
        private List<? super SymbolDescriptor> result;
        private String[] message;
        private int retry;

        Result(@NonNull List<? super SymbolDescriptor> result, @NonNull String[] message) {
            Parameters.notNull((CharSequence)"result", result);
            Parameters.notNull((CharSequence)"message", (Object)message);
            if (message.length != 1) {
                throw new IllegalArgumentException("message.length != 1");
            }
            this.result = result;
            this.message = message;
        }

        public void setMessage(String msg) {
            this.message[0] = msg;
        }

        public void addResult(SymbolDescriptor symbolDescriptor) {
            this.result.add(symbolDescriptor);
        }

        public void addResult(List<? extends SymbolDescriptor> symbolDescriptor) {
            this.result.addAll(symbolDescriptor);
        }

        public void pendingResult() {
            this.retry = 2000;
        }
    }

    public static final class Context {
        private final Project project;
        private final String text;
        private final SearchType type;

        Context(Project project, String text, SearchType type) {
            this.project = project;
            this.text = text;
            this.type = type;
        }

        public Project getProject() {
            return this.project;
        }

        public String getText() {
            return this.text;
        }

        public SearchType getSearchType() {
            return this.type;
        }

        static {
            SymbolProviderAccessor.DEFAULT = new SymbolProviderAccessor(){

                @Override
                public Context createContext(Project p, String text, SearchType t) {
                    return new Context(p, text, t);
                }

                @Override
                public Result createResult(List<? super SymbolDescriptor> result, String[] message) {
                    return new Result(result, message);
                }

                @Override
                public int getRetry(Result result) {
                    return result.retry;
                }
            };
        }
    }
}

