/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public class FileDescription
extends FileDescriptor {
    private static final Logger LOG = Logger.getLogger(FileDescription.class.getName());
    public static ImageIcon UNKNOWN_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/find.gif", (boolean)false);
    private final FileObject fileObject;
    private final String ownerPath;
    private final Project project;
    private final int lineNr;
    private Icon icon;
    private String projectName;
    private Icon projectIcon;

    public FileDescription(@NonNull FileObject file, @NonNull String ownerPath, @NullAllowed Project project, int lineNr) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"ownerPath", (Object)ownerPath);
        this.fileObject = file;
        this.ownerPath = ownerPath;
        this.project = project;
        this.lineNr = lineNr;
    }

    @Override
    public String getFileName() {
        return this.fileObject.getNameExt();
    }

    @Override
    public synchronized Icon getIcon() {
        if (this.icon == null) {
            DataObject od = this.getDataObject();
            Image i = od == null ? UNKNOWN_PROJECT_ICON.getImage() : od.getNodeDelegate().getIcon(1);
            this.icon = new ImageIcon(i);
        }
        return this.icon;
    }

    @Override
    public String getOwnerPath() {
        return this.ownerPath;
    }

    @Override
    public synchronized String getProjectName() {
        if (this.projectName == null) {
            this.initProjectInfo();
        }
        return this.projectName;
    }

    @Override
    public synchronized Icon getProjectIcon() {
        if (this.projectIcon == null) {
            this.initProjectInfo();
        }
        return this.projectIcon;
    }

    @Override
    public void open() {
        DataObject od = this.getDataObject();
        if (od != null) {
            Editable editable;
            LineCookie lineCookie = (LineCookie)od.getLookup().lookup(LineCookie.class);
            if (lineCookie != null && this.lineNr != -1) {
                try {
                    Line l = lineCookie.getLineSet().getCurrent(this.lineNr - 1);
                    if (l != null) {
                        l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, -1);
                        return;
                    }
                }
                catch (IndexOutOfBoundsException oob) {
                    LOG.log(Level.FINE, "Line no more exists.", oob);
                }
            }
            if ((editable = (Editable)od.getLookup().lookup(Editable.class)) != null) {
                editable.edit();
                return;
            }
            Openable oc = (Openable)od.getLookup().lookup(Openable.class);
            if (oc != null) {
                oc.open();
            }
        }
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    private DataObject getDataObject() {
        try {
            FileObject fo = this.getFileObject();
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private void initProjectInfo() {
        if (this.project != null) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
            this.projectName = pi.getDisplayName();
            this.projectIcon = pi.getIcon();
        } else {
            this.projectName = "";
            this.projectIcon = UNKNOWN_PROJECT_ICON;
        }
    }
}

