/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.lexer.CppStringLexer;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public abstract class CndLexer
implements Lexer<CppTokenId> {
    protected static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<CppTokenId> tokenFactory;
    private int escapedEatenChars;
    private int tokenSplittedByEscapedLine;
    private int lastTokenEndedByEscapedLine;

    protected CndLexer(LexerRestartInfo<CppTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.setState((Integer)info.state());
    }

    public Object state() {
        return this.getState();
    }

    protected final void setState(Integer state) {
        this.lastTokenEndedByEscapedLine = state == null ? 0 : state;
    }

    protected final Integer getState() {
        return this.lastTokenEndedByEscapedLine == 0 ? null : Integer.valueOf(this.lastTokenEndedByEscapedLine);
    }

    protected final void backup(int n) {
        this.input.backup(n + this.escapedEatenChars);
        this.lastTokenEndedByEscapedLine = this.escapedEatenChars;
        this.tokenSplittedByEscapedLine -= this.escapedEatenChars;
    }

    protected final int read(boolean skipEscapedLF) {
        int c = this.input.read();
        this.escapedEatenChars = 0;
        if (skipEscapedLF) {
            while (c == 92) {
                int next;
                ++this.escapedEatenChars;
                switch (this.input.read()) {
                    case 13: {
                        if (this.consumeNewline()) {
                            ++this.escapedEatenChars;
                        }
                    }
                    case 10: {
                        ++this.escapedEatenChars;
                        next = this.input.read();
                        break;
                    }
                    default: {
                        this.input.backup(1);
                        --this.escapedEatenChars;
                        assert (c == 92) : "must be backslash " + (char)c;
                        this.tokenSplittedByEscapedLine += this.escapedEatenChars;
                        return c;
                    }
                }
                c = next;
            }
            this.tokenSplittedByEscapedLine += this.escapedEatenChars;
        }
        return c;
    }

    protected final boolean consumeNewline() {
        return this.input.consumeNewline();
    }

    public Token<CppTokenId> nextToken() {
        int c;
        block77: while (true) {
            if (this.lastTokenEndedByEscapedLine > 0) {
                c = this.read(false);
                --this.lastTokenEndedByEscapedLine;
                assert (c == 92) : "there must be \\";
                c = this.read(false);
                assert (c == 10 || c == 13) : "there must be \r or \n";
                if (c == 13) {
                    --this.lastTokenEndedByEscapedLine;
                    if (this.input.consumeNewline()) {
                        --this.lastTokenEndedByEscapedLine;
                    }
                    return this.token(CppTokenId.ESCAPED_LINE);
                }
                --this.lastTokenEndedByEscapedLine;
                return this.token(CppTokenId.ESCAPED_LINE, "\\\n", PartType.COMPLETE);
            }
            c = this.read(true);
            switch (c) {
                case 34: {
                    Token<CppTokenId> out = this.finishDblQuote();
                    assert (out != null) : "not handled dobule quote";
                    return out;
                }
                case 39: {
                    Token<CppTokenId> out = this.finishSingleQuote();
                    assert (out != null) : "not handled single quote";
                    return out;
                }
                case 35: {
                    Token<CppTokenId> out = this.finishSharp();
                    assert (out != null) : "not handled #";
                    return out;
                }
                case 47: {
                    switch (this.read(true)) {
                        case 47: {
                            Token<CppTokenId> out = this.finishLineComment(true);
                            assert (out != null) : "not handled //";
                            return out;
                        }
                        case 61: {
                            return this.token(CppTokenId.SLASHEQ);
                        }
                        case 42: {
                            Token<CppTokenId> out = this.finishBlockComment(true);
                            assert (out != null) : "not handled /*";
                            return out;
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.SLASH);
                }
                case 61: {
                    if (this.read(true) == 61) {
                        return this.token(CppTokenId.EQEQ);
                    }
                    this.backup(1);
                    return this.token(CppTokenId.EQ);
                }
                case 62: {
                    switch (this.read(true)) {
                        case 62: {
                            if (this.read(true) == 61) {
                                return this.token(CppTokenId.GTGTEQ);
                            }
                            this.backup(1);
                            return this.token(CppTokenId.GTGT);
                        }
                        case 61: {
                            return this.token(CppTokenId.GTEQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.GT);
                }
                case 60: {
                    Token<CppTokenId> out = this.finishLT();
                    assert (out != null) : "not handled '<'";
                    return out;
                }
                case 43: {
                    switch (this.read(true)) {
                        case 43: {
                            return this.token(CppTokenId.PLUSPLUS);
                        }
                        case 61: {
                            return this.token(CppTokenId.PLUSEQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.PLUS);
                }
                case 45: {
                    switch (this.read(true)) {
                        case 45: {
                            return this.token(CppTokenId.MINUSMINUS);
                        }
                        case 62: {
                            if (this.read(true) == 42) {
                                return this.token(CppTokenId.ARROWMBR);
                            }
                            this.backup(1);
                            return this.token(CppTokenId.ARROW);
                        }
                        case 61: {
                            return this.token(CppTokenId.MINUSEQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.MINUS);
                }
                case 42: {
                    switch (this.read(true)) {
                        case 47: {
                            if (this.read(true) == 42) {
                                this.backup(2);
                                return this.token(CppTokenId.STAR);
                            }
                            this.backup(1);
                            return this.token(CppTokenId.INVALID_COMMENT_END);
                        }
                        case 61: {
                            return this.token(CppTokenId.STAREQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.STAR);
                }
                case 124: {
                    switch (this.read(true)) {
                        case 124: {
                            return this.token(CppTokenId.BARBAR);
                        }
                        case 61: {
                            return this.token(CppTokenId.BAREQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.BAR);
                }
                case 38: {
                    switch (this.read(true)) {
                        case 38: {
                            return this.token(CppTokenId.AMPAMP);
                        }
                        case 61: {
                            return this.token(CppTokenId.AMPEQ);
                        }
                    }
                    this.backup(1);
                    return this.token(CppTokenId.AMP);
                }
                case 37: {
                    Token<CppTokenId> out = this.finishPercent();
                    assert (out != null) : "not handled %";
                    return out;
                }
                case 94: {
                    if (this.read(true) == 61) {
                        return this.token(CppTokenId.CARETEQ);
                    }
                    this.backup(1);
                    return this.token(CppTokenId.CARET);
                }
                case 33: {
                    if (this.read(true) == 61) {
                        return this.token(CppTokenId.NOTEQ);
                    }
                    this.backup(1);
                    return this.token(CppTokenId.NOT);
                }
                case 46: {
                    c = this.read(true);
                    if (c == 46) {
                        if (this.read(true) == 46) {
                            return this.token(CppTokenId.ELLIPSIS);
                        }
                        this.input.backup(2);
                    } else {
                        if (48 <= c && c <= 57) {
                            return this.finishNumberLiteral(this.read(true), true);
                        }
                        if (c == 42) {
                            return this.token(CppTokenId.DOTMBR);
                        }
                        this.backup(1);
                    }
                    return this.token(CppTokenId.DOT);
                }
                case 58: {
                    if (this.read(true) == 58) {
                        return this.token(CppTokenId.SCOPE);
                    }
                    this.backup(1);
                    return this.token(CppTokenId.COLON);
                }
                case 126: {
                    return this.token(CppTokenId.TILDE);
                }
                case 44: {
                    return this.token(CppTokenId.COMMA);
                }
                case 59: {
                    return this.token(CppTokenId.SEMICOLON);
                }
                case 63: {
                    return this.token(CppTokenId.QUESTION);
                }
                case 40: {
                    return this.token(CppTokenId.LPAREN);
                }
                case 41: {
                    return this.token(CppTokenId.RPAREN);
                }
                case 91: {
                    return this.token(CppTokenId.LBRACKET);
                }
                case 93: {
                    return this.token(CppTokenId.RBRACKET);
                }
                case 123: {
                    return this.token(CppTokenId.LBRACE);
                }
                case 125: {
                    return this.token(CppTokenId.RBRACE);
                }
                case 96: {
                    return this.token(CppTokenId.GRAVE_ACCENT);
                }
                case 64: {
                    return this.token(CppTokenId.AT);
                }
                case 48: {
                    c = this.read(true);
                    if (c == 120 || c == 88 || c == 98 || c == 66) {
                        boolean inFraction = false;
                        block78: while (true) {
                            switch (this.read(true)) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    continue block78;
                                }
                                case 46: {
                                    if (!inFraction) {
                                        inFraction = true;
                                        continue block78;
                                    }
                                    return this.token(CppTokenId.FLOAT_LITERAL_INVALID);
                                }
                                case 76: 
                                case 108: {
                                    return this.finishLongLiteral(this.read(true));
                                }
                                case 80: 
                                case 112: {
                                    return this.finishFloatExponent();
                                }
                                case 85: 
                                case 117: {
                                    return this.finishUnsignedLiteral(this.read(true));
                                }
                            }
                            break;
                        }
                        this.backup(1);
                        return this.token(inFraction ? CppTokenId.FLOAT_LITERAL_INVALID : CppTokenId.INT_LITERAL);
                    }
                    return this.finishNumberLiteral(c, false);
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.finishNumberLiteral(this.read(true), false);
                }
                case 92: {
                    return this.token(CppTokenId.BACK_SLASH);
                }
                case 36: {
                    return this.token(CppTokenId.DOLLAR);
                }
                case 13: {
                    this.consumeNewline();
                    return this.token(CppTokenId.NEW_LINE);
                }
                case 10: {
                    return this.token(CppTokenId.NEW_LINE, "\n", PartType.COMPLETE);
                }
                case 9: 
                case 11: 
                case 12: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    return this.finishWhitespace();
                }
                case 32: {
                    c = this.read(true);
                    if (c == -1 || !Character.isWhitespace(c) || c == 10 || c == 13) {
                        this.backup(1);
                        return this.token(CppTokenId.WHITESPACE, " ", PartType.COMPLETE);
                    }
                    return this.finishWhitespace();
                }
                case -1: {
                    if (this.isTokenSplittedByEscapedLine()) {
                        this.backup(1);
                        if ($assertionsDisabled || this.lastTokenEndedByEscapedLine > 0) continue block77;
                        throw new AssertionError((Object)("lastTokenEndedByEscapedLine is " + this.lastTokenEndedByEscapedLine));
                    }
                    return null;
                }
            }
            break;
        }
        c = this.translateSurrogates(c);
        if (CndLexerUtilities.isCppIdentifierStart(c)) {
            if (c == 76 || c == 85 || c == 117 || c == 82) {
                boolean raw_string;
                int next = this.read(true);
                boolean bl = raw_string = c == 82;
                if (next == 82 && (c == 117 || c == 85 || c == 76)) {
                    raw_string = true;
                    next = this.read(true);
                } else if (next == 56 && c == 117 && (next = this.read(true)) == 82) {
                    raw_string = true;
                    next = this.read(true);
                }
                if (next == 34) {
                    Token<CppTokenId> out;
                    Token<CppTokenId> token = out = raw_string ? this.finishRawString() : this.finishDblQuote();
                    assert (out != null) : "not handled dobule quote";
                    return out;
                }
                if (next == 39) {
                    Token<CppTokenId> out = this.finishSingleQuote();
                    assert (out != null) : "not handled single quote";
                    return out;
                }
                this.backup(1);
            }
            if (c == 69 && this.isExecSQL(c)) {
                Token<CppTokenId> out = this.finishExecSQL();
                assert (out != null) : "not handled exec sql";
                return out;
            }
            return this.keywordOrIdentifier(c);
        }
        if (Character.isWhitespace(c)) {
            return this.finishWhitespace();
        }
        return this.token(CppTokenId.ERROR);
    }

    protected abstract CppTokenId getKeywordOrIdentifierID(CharSequence var1);

    protected final Token<CppTokenId> finishLineComment(boolean createToken) {
        int c = this.read(true);
        boolean startOfDoxygen = c == 47;
        while (true) {
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    this.backup(1);
                    if (createToken) {
                        return startOfDoxygen ? this.token(CppTokenId.DOXYGEN_LINE_COMMENT) : this.token(CppTokenId.LINE_COMMENT);
                    }
                    return null;
                }
            }
            c = this.read(true);
        }
    }

    protected final Token<CppTokenId> finishBlockComment(boolean createToken) {
        int c = this.read(true);
        int firstChar = c;
        if (firstChar == 42 || firstChar == 33) {
            c = this.read(true);
            if (c == 47 && firstChar != 33) {
                return !createToken ? null : this.token(CppTokenId.BLOCK_COMMENT);
            }
            while (true) {
                if (c == 42) {
                    c = this.read(true);
                    if (c == 47) {
                        return !createToken ? null : this.token(CppTokenId.DOXYGEN_COMMENT);
                    }
                    if (c != -1) continue;
                    return !createToken ? null : this.tokenPart(CppTokenId.DOXYGEN_COMMENT, PartType.START);
                }
                if (c == -1) {
                    return !createToken ? null : this.tokenPart(CppTokenId.DOXYGEN_COMMENT, PartType.START);
                }
                c = this.read(true);
            }
        }
        do {
            c = this.read(true);
            while (c == 42) {
                c = this.read(true);
                if (c == 47) {
                    return !createToken ? null : this.token(CppTokenId.BLOCK_COMMENT);
                }
                if (c != -1) continue;
                return !createToken ? null : this.tokenPart(CppTokenId.BLOCK_COMMENT, PartType.START);
            }
        } while (c != -1);
        return !createToken ? null : this.tokenPart(CppTokenId.BLOCK_COMMENT, PartType.START);
    }

    private int translateSurrogates(int c) {
        if (Character.isHighSurrogate((char)c)) {
            int lowSurr = this.read(true);
            if (lowSurr != -1 && Character.isLowSurrogate((char)lowSurr)) {
                c = Character.toCodePoint((char)c, (char)lowSurr);
            } else {
                this.backup(1);
            }
        }
        return c;
    }

    private Token<CppTokenId> finishWhitespace() {
        int c;
        while ((c = this.read(true)) != -1 && Character.isWhitespace(c) && c != 10 && c != 13) {
        }
        this.backup(1);
        return this.isTokenSplittedByEscapedLine() ? this.token(CppTokenId.ESCAPED_WHITESPACE) : this.token(CppTokenId.WHITESPACE);
    }

    private Token<CppTokenId> keywordOrIdentifier(int c) {
        StringBuilder idText = new StringBuilder();
        idText.append((char)c);
        while (true) {
            if ((c = this.read(true)) == -1 || !CndLexerUtilities.isCppIdentifierPart(c = this.translateSurrogates(c))) {
                this.backup(c >= 65536 ? 2 : 1);
                CppTokenId id = this.getKeywordOrIdentifierID(idText.toString());
                assert (id != null) : "must be valid id for " + idText;
                return this.token(id);
            }
            idText.append((char)c);
        }
    }

    private Token<CppTokenId> finishNumberLiteral(int c, boolean inFraction) {
        while (true) {
            switch (c) {
                case 46: {
                    if (!inFraction) {
                        inFraction = true;
                        break;
                    }
                    return this.token(CppTokenId.FLOAT_LITERAL_INVALID);
                }
                case 76: 
                case 108: {
                    return this.finishLongLiteral(this.read(true));
                }
                case 70: 
                case 102: {
                    return this.token(CppTokenId.FLOAT_LITERAL);
                }
                case 85: 
                case 117: {
                    return this.finishUnsignedLiteral(this.read(true));
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 69: 
                case 101: {
                    return this.finishFloatExponent();
                }
                default: {
                    this.backup(1);
                    return this.token(inFraction ? CppTokenId.DOUBLE_LITERAL : CppTokenId.INT_LITERAL);
                }
            }
            c = this.read(true);
        }
    }

    private Token<CppTokenId> finishFloatExponent() {
        int c = this.read(true);
        if (c == 43 || c == 45) {
            c = this.read(true);
        }
        if (c < 48 || 57 < c) {
            return this.token(CppTokenId.FLOAT_LITERAL_INVALID);
        }
        while (48 <= (c = this.read(true)) && c <= 57) {
        }
        switch (c) {
            case 70: 
            case 102: {
                return this.token(CppTokenId.FLOAT_LITERAL);
            }
            case 76: 
            case 108: {
                return this.token(CppTokenId.DOUBLE_LITERAL);
            }
        }
        this.backup(1);
        return this.token(CppTokenId.DOUBLE_LITERAL);
    }

    protected final Token<CppTokenId> token(CppTokenId id) {
        return this.token(id, id.fixedText(), PartType.COMPLETE);
    }

    protected final Token<CppTokenId> tokenPart(CppTokenId id, PartType part) {
        return this.token(id, null, part);
    }

    private Token<CppTokenId> token(CppTokenId id, String fixedText, PartType part) {
        assert (id != null) : "id must be not null";
        Token token = fixedText != null && !this.isTokenSplittedByEscapedLine() ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : (part != PartType.COMPLETE ? this.tokenFactory.createToken((TokenId)id, this.input.readLength(), part) : this.tokenFactory.createToken((TokenId)id));
        this.tokenSplittedByEscapedLine = 0;
        this.escapedEatenChars = 0;
        assert (token != null) : "token must be created as result for " + (Object)((Object)id);
        this.postTokenCreate(id);
        return token;
    }

    protected Token<CppTokenId> finishSharp() {
        if (this.read(true) == 35) {
            return this.token(CppTokenId.DBL_SHARP);
        }
        this.backup(1);
        return this.token(CppTokenId.SHARP);
    }

    protected Token<CppTokenId> finishPercent() {
        if (this.read(true) == 61) {
            return this.token(CppTokenId.PERCENTEQ);
        }
        this.backup(1);
        return this.token(CppTokenId.PERCENT);
    }

    private Token<CppTokenId> finishRawString() {
        PartType type = CppStringLexer.finishRawString(this.input);
        if (type == PartType.COMPLETE) {
            return this.token(CppTokenId.RAW_STRING_LITERAL);
        }
        return this.tokenPart(CppTokenId.RAW_STRING_LITERAL, type);
    }

    protected Token<CppTokenId> finishDblQuote() {
        while (true) {
            switch (this.read(true)) {
                case 34: {
                    return this.token(CppTokenId.STRING_LITERAL);
                }
                case 92: {
                    this.read(false);
                    break;
                }
                case 10: 
                case 13: {
                    this.backup(1);
                }
                case -1: {
                    return this.tokenPart(CppTokenId.STRING_LITERAL, PartType.START);
                }
            }
        }
    }

    protected Token<CppTokenId> finishSingleQuote() {
        while (true) {
            switch (this.read(true)) {
                case 39: {
                    return this.token(CppTokenId.CHAR_LITERAL);
                }
                case 92: {
                    this.read(false);
                    break;
                }
                case 10: 
                case 13: {
                    this.backup(1);
                }
                case -1: {
                    return this.tokenPart(CppTokenId.CHAR_LITERAL, PartType.START);
                }
            }
        }
    }

    protected Token<CppTokenId> finishLT() {
        switch (this.read(true)) {
            case 60: {
                if (this.read(true) == 61) {
                    return this.token(CppTokenId.LTLTEQ);
                }
                this.backup(1);
                return this.token(CppTokenId.LTLT);
            }
            case 61: {
                return this.token(CppTokenId.LTEQ);
            }
        }
        this.backup(1);
        return this.token(CppTokenId.LT);
    }

    protected boolean isExecSQL(int c) {
        if (c == 69) {
            if (this.read(true) == 88) {
                if (this.read(true) == 69) {
                    if (this.read(true) == 67) {
                        if (this.read(true) == 32) {
                            if (this.read(true) == 83) {
                                if (this.read(true) == 81) {
                                    if (this.read(true) == 76) {
                                        return true;
                                    }
                                    this.backup(1);
                                }
                                this.backup(1);
                            }
                            this.backup(1);
                        }
                        this.backup(1);
                    }
                    this.backup(1);
                }
                this.backup(1);
            }
            this.backup(1);
        }
        return false;
    }

    protected Token<CppTokenId> finishExecSQL() {
        while (true) {
            switch (this.read(true)) {
                case 59: {
                    this.backup(1);
                    return this.token(CppTokenId.PROC_DIRECTIVE);
                }
                case -1: {
                    this.backup(1);
                    return this.token(CppTokenId.PROC_DIRECTIVE);
                }
            }
        }
    }

    private Token<CppTokenId> finishLongLiteral(int c) {
        if (c == 108 || c == 76) {
            c = this.read(true);
            if (c == 117 || c == 85) {
                return this.token(CppTokenId.UNSIGNED_LONG_LONG_LITERAL);
            }
            this.backup(1);
            return this.token(CppTokenId.LONG_LONG_LITERAL);
        }
        if (c == 117 || c == 85) {
            return this.token(CppTokenId.UNSIGNED_LONG_LITERAL);
        }
        this.backup(1);
        return this.token(CppTokenId.LONG_LITERAL);
    }

    private Token<CppTokenId> finishUnsignedLiteral(int c) {
        if (c == 108 || c == 76) {
            c = this.read(true);
            if (c == 108 || c == 76) {
                return this.token(CppTokenId.UNSIGNED_LONG_LONG_LITERAL);
            }
            this.backup(1);
            return this.token(CppTokenId.UNSIGNED_LONG_LITERAL);
        }
        this.backup(1);
        return this.token(CppTokenId.UNSIGNED_LITERAL);
    }

    protected void postTokenCreate(CppTokenId id) {
    }

    public void release() {
    }

    private boolean isTokenSplittedByEscapedLine() {
        return this.tokenSplittedByEscapedLine > 0;
    }
}

