/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.cnd.spi.lexer.CndLexerLanguageEmbeddingProvider;
import org.openide.util.lookup.Lookups;

public final class CndLexerUtilities {
    public static final String LEXER_FILTER = "lexer-filter";
    public static final String FORTRAN_FREE_FORMAT = "fortran-free-format";
    public static final String FORTRAN_MAXIMUM_TEXT_WIDTH = "fortran-maximum-text-width";
    public static final String FLAVOR = "language-flavor";
    private static Filter<CppTokenId> FILTER_STD_C;
    private static Filter<CppTokenId> FILTER_GCC_C;
    private static Filter<CppTokenId> FILTER_STD_CPP;
    private static Filter<CppTokenId> FILTER_STD_CPP11;
    private static Filter<CppTokenId> FILTER_GCC_CPP;
    private static Filter<CppTokenId> FILTER_GCC_CPP11;
    private static Filter<CppTokenId> FILTER_HEADER_C;
    private static Filter<CppTokenId> FILTER_HEADER_CPP;
    private static Filter<CppTokenId> FILTER_HEADER_CPP11;
    private static Filter<CppTokenId> FILTER_PREPRPOCESSOR;
    private static Filter<CppTokenId> FILTER_OMP;
    private static Filter<FortranTokenId> FILTER_FORTRAN;

    private CndLexerUtilities() {
    }

    public static TokenSequence<TokenId> getCppTokenSequence(JTextComponent component, int offset, boolean lexPP, boolean backwardBias) {
        Document doc = component.getDocument();
        return CndLexerUtilities.getCppTokenSequence(doc, offset, lexPP, backwardBias);
    }

    public static Language<CppTokenId> getLanguage(String mime) {
        if ("text/x-c".equals(mime)) {
            return CppTokenId.languageC();
        }
        if ("text/x-c++".equals(mime)) {
            return CppTokenId.languageCpp();
        }
        if ("text/x-h".equals(mime)) {
            return CppTokenId.languageHeader();
        }
        return null;
    }

    public static Language<CppTokenId> getLanguage(Document doc) {
        Language<CppTokenId> lang = (Language<CppTokenId>)doc.getProperty(Language.class);
        if (!CndLexerUtilities.isCppLanguage(lang, true)) {
            lang = CndLexerUtilities.getLanguage((String)doc.getProperty("mimeType"));
        }
        Language<CppTokenId> out = lang;
        return out;
    }

    public static TokenSequence<TokenId> getCppTokenSequence(Document doc, int offset, boolean lexPP, boolean backwardBias) {
        if (doc == null) {
            return null;
        }
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        List tsList = hi.embeddedTokenSequences(offset, backwardBias);
        for (int i = tsList.size() - 1; i >= 0; --i) {
            TokenSequence ts = (TokenSequence)tsList.get(i);
            Language lang = ts.languagePath().innerLanguage();
            if (!CndLexerUtilities.isCppLanguage(lang, lexPP)) continue;
            TokenSequence cppInnerTS = ts;
            return cppInnerTS;
        }
        return null;
    }

    public static TokenSequence<TokenId> getCppTokenSequenceWithoutEmbeddings(Document doc, int offset) {
        TokenSequence ts;
        Language lang;
        if (doc == null) {
            return null;
        }
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        List tsList = hi.embeddedTokenSequences(offset, false);
        if (!tsList.isEmpty() && CndLexerUtilities.isCppLanguage(lang = (ts = (TokenSequence)tsList.get(0)).languagePath().innerLanguage(), false)) {
            TokenSequence cppTS = ts;
            return cppTS;
        }
        return null;
    }

    public static boolean isCppLanguage(Language<?> lang, boolean allowPrepoc) {
        if (!CndLexerEmbeddingProviders.providers.isEmpty()) {
            for (CndLexerLanguageEmbeddingProvider provider : CndLexerEmbeddingProviders.providers) {
                if (!provider.isKnownLanguage(lang)) continue;
                return true;
            }
        }
        return lang == CppTokenId.languageC() || lang == CppTokenId.languageCpp() || lang == CppTokenId.languageHeader() || allowPrepoc && lang == CppTokenId.languagePreproc();
    }

    public static TokenSequence<FortranTokenId> getFortranTokenSequence(Document doc, int offset) {
        TokenHierarchy th = doc != null ? TokenHierarchy.get((Document)doc) : null;
        TokenSequence<FortranTokenId> ts = th != null ? CndLexerUtilities.getFortranTokenSequence(th, offset) : null;
        return ts;
    }

    private static TokenSequence<FortranTokenId> getFortranTokenSequence(TokenHierarchy<?> hierarchy, int offset) {
        if (hierarchy != null) {
            for (TokenSequence ts = hierarchy.tokenSequence(); ts != null && (offset == 0 || ts.moveNext()); ts = ts.embedded()) {
                ts.move(offset);
                if (ts.language() == FortranTokenId.languageFortran()) {
                    TokenSequence innerTS = ts;
                    return innerTS;
                }
                if (ts.moveNext() || ts.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static FortranFormat detectFortranFormat(Document doc) {
        String sequence;
        try {
            sequence = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return FortranFormat.FIXED;
        }
        return CndLexerUtilities.detectFortranFormat(sequence);
    }

    public static FortranFormat detectFortranFormat(CharSequence text) {
        int column = 0;
        boolean ignoreRestLine = false;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                column = 0;
                ignoreRestLine = false;
                continue;
            }
            if (ignoreRestLine) continue;
            switch (++column) {
                case 1: {
                    if (c == 'C' || c == 'c' || c == '*') {
                        ignoreRestLine = true;
                        continue block4;
                    }
                    if (c >= '0' && c <= '9' || c == ' ') continue block4;
                    if (c == '\t') {
                        column = 6;
                        continue block4;
                    }
                    return FortranFormat.FREE;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (c >= '0' && c <= '9' || c == ' ') continue block4;
                    if (c == '\t') {
                        column = 6;
                        continue block4;
                    }
                    return FortranFormat.FREE;
                }
            }
        }
        return FortranFormat.FIXED;
    }

    public static boolean isCppIdentifier(CharSequence id) {
        if (id == null) {
            return false;
        }
        if (id.length() == 0) {
            return false;
        }
        if (!CndLexerUtilities.isCppIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (CndLexerUtilities.isCppIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return CndLexerUtilities.getDefatultFilter(true).check(id) == null && CndLexerUtilities.getDefatultFilter(false).check(id) == null;
    }

    public static boolean isCppIdentifierStart(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || ch == '_' || ch == '$';
    }

    public static boolean isCppIdentifierPart(char ch) {
        return '0' <= ch && ch <= '9' || CndLexerUtilities.isCppIdentifierStart(ch);
    }

    public static boolean isCppIdentifierStart(int codePoint) {
        return Character.isJavaIdentifierStart(codePoint);
    }

    public static boolean isCppIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierPart(codePoint);
    }

    public static boolean isFortranIdentifierPart(int codePoint) {
        return Character.isJavaIdentifierPart(codePoint);
    }

    public static CharSequence removeEscapedLF(CharSequence text, boolean escapedLF) {
        if (!escapedLF) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        int lengthM1 = text.length() - 1;
        for (int i = 0; i <= lengthM1; ++i) {
            char c = text.charAt(i);
            boolean append = true;
            if (c == '\\') {
                if (i < lengthM1 && text.charAt(i + 1) == '\r') {
                    ++i;
                    append = false;
                }
                if (i < lengthM1 && text.charAt(i + 1) == '\n') {
                    ++i;
                    append = false;
                }
            }
            if (!append) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static boolean isKeyword(String str) {
        try {
            CppTokenId id = CppTokenId.valueOf(str.toUpperCase());
            return id != null && ("keyword".equals(id.primaryCategory()) || "keyword-directive".equals(id.primaryCategory()) || "preprocessor-keyword".equals(id.primaryCategory())) || "preprocessor-keyword-directive".equals(id.primaryCategory());
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isType(String str) {
        block4: {
            try {
                if (str.contains(" ")) {
                    String[] parts;
                    for (String part : parts = str.split(" ")) {
                        if (!CndLexerUtilities.isType(part)) continue;
                        return true;
                    }
                    break block4;
                }
                CppTokenId id = CppTokenId.valueOf(str.toUpperCase());
                return CndLexerUtilities.isType(id);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isType(CppTokenId id) {
        switch (id) {
            case AUTO: 
            case BOOL: 
            case CHAR: 
            case CONST: 
            case DOUBLE: 
            case ENUM: 
            case EXPORT: 
            case FLOAT: 
            case INLINE: 
            case _INLINE: 
            case __INLINE: 
            case __INLINE__: 
            case INT: 
            case LONG: 
            case MUTABLE: 
            case REGISTER: 
            case SHORT: 
            case SIGNED: 
            case __SIGNED: 
            case __SIGNED__: 
            case SIZEOF: 
            case TYPEDEF: 
            case TYPEID: 
            case TYPEOF: 
            case __TYPEOF: 
            case __TYPEOF__: 
            case UNSIGNED: 
            case __UNSIGNED__: 
            case VOID: 
            case VOLATILE: 
            case WCHAR_T: 
            case _BOOL: 
            case _COMPLEX: 
            case __COMPLEX__: 
            case _IMAGINARY: 
            case __IMAG__: 
            case _INT64: 
            case __INT64: 
            case __REAL__: 
            case __W64: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSeparatorOrOperator(CppTokenId tokenID) {
        String category = tokenID.primaryCategory();
        return "operator".equals(category) || "separator".equals(category);
    }

    public static Filter<CppTokenId> getDefatultFilter(boolean cpp) {
        return cpp ? CndLexerUtilities.getStdCppFilter() : CndLexerUtilities.getStdCFilter();
    }

    public static synchronized Filter<CppTokenId> getPreprocFilter() {
        if (FILTER_PREPRPOCESSOR == null) {
            FILTER_PREPRPOCESSOR = new Filter();
            CndLexerUtilities.addPreprocKeywords(FILTER_PREPRPOCESSOR);
        }
        return FILTER_PREPRPOCESSOR;
    }

    public static synchronized Filter<CppTokenId> getOmpFilter() {
        if (FILTER_OMP == null) {
            FILTER_OMP = new Filter();
            CndLexerUtilities.addOmpKeywords(FILTER_OMP);
        }
        return FILTER_OMP;
    }

    public static synchronized Filter<CppTokenId> getStdCFilter() {
        if (FILTER_STD_C == null) {
            FILTER_STD_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_STD_C);
        }
        return FILTER_STD_C;
    }

    public static synchronized Filter<CppTokenId> getGccCFilter() {
        if (FILTER_GCC_C == null) {
            FILTER_GCC_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_GCC_C);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_C);
        }
        return FILTER_GCC_C;
    }

    public static synchronized Filter<CppTokenId> getStdCppFilter() {
        if (FILTER_STD_CPP == null) {
            FILTER_STD_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_STD_CPP);
        }
        return FILTER_STD_CPP;
    }

    public static synchronized Filter<CppTokenId> getGccCppFilter() {
        if (FILTER_GCC_CPP == null) {
            FILTER_GCC_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_CPP);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_GCC_CPP);
        }
        return FILTER_GCC_CPP;
    }

    public static synchronized Filter<CppTokenId> getStdCpp11Filter() {
        if (FILTER_STD_CPP11 == null) {
            FILTER_STD_CPP11 = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_STD_CPP11);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_STD_CPP11);
            CndLexerUtilities.addCpp11OnlyKeywords(FILTER_STD_CPP11);
        }
        return FILTER_STD_CPP11;
    }

    public static synchronized Filter<CppTokenId> getGccCpp11Filter() {
        if (FILTER_GCC_CPP11 == null) {
            FILTER_GCC_CPP11 = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_GCC_CPP11);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_GCC_CPP11);
            CndLexerUtilities.addCpp11OnlyKeywords(FILTER_GCC_CPP11);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_GCC_CPP11);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_GCC_CPP11);
        }
        return FILTER_GCC_CPP11;
    }

    public static synchronized Filter<CppTokenId> getHeaderCFilter() {
        if (FILTER_HEADER_C == null) {
            FILTER_HEADER_C = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_HEADER_C);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_HEADER_C);
            CndLexerUtilities.addCOnlyKeywords(FILTER_HEADER_C);
        }
        return FILTER_HEADER_C;
    }

    public static synchronized Filter<CppTokenId> getHeaderCppFilter() {
        if (FILTER_HEADER_CPP == null) {
            FILTER_HEADER_CPP = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_HEADER_CPP);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_HEADER_CPP);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_HEADER_CPP);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_HEADER_CPP);
            CndLexerUtilities.addCOnlyKeywords(FILTER_HEADER_CPP);
        }
        return FILTER_HEADER_CPP;
    }

    public static synchronized Filter<CppTokenId> getHeaderCpp11Filter() {
        if (FILTER_HEADER_CPP11 == null) {
            FILTER_HEADER_CPP11 = new Filter();
            CndLexerUtilities.addCommonCCKeywords(FILTER_HEADER_CPP11);
            CndLexerUtilities.addCppOnlyKeywords(FILTER_HEADER_CPP11);
            CndLexerUtilities.addGccOnlyCommonCCKeywords(FILTER_HEADER_CPP11);
            CndLexerUtilities.addGccOnlyCppOnlyKeywords(FILTER_HEADER_CPP11);
            CndLexerUtilities.addCpp11OnlyKeywords(FILTER_HEADER_CPP11);
        }
        return FILTER_HEADER_CPP11;
    }

    public static synchronized Filter<FortranTokenId> getFortranFilter() {
        if (FILTER_FORTRAN == null) {
            FILTER_FORTRAN = new Filter();
            CndLexerUtilities.addFortranKeywords(FILTER_FORTRAN);
        }
        return FILTER_FORTRAN;
    }

    private static void addPreprocKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.PREPROCESSOR_IF, CppTokenId.PREPROCESSOR_IFDEF, CppTokenId.PREPROCESSOR_IFNDEF, CppTokenId.PREPROCESSOR_ELSE, CppTokenId.PREPROCESSOR_ELIF, CppTokenId.PREPROCESSOR_ENDIF, CppTokenId.PREPROCESSOR_DEFINE, CppTokenId.PREPROCESSOR_UNDEF, CppTokenId.PREPROCESSOR_INCLUDE, CppTokenId.PREPROCESSOR_INCLUDE_NEXT, CppTokenId.PREPROCESSOR_LINE, CppTokenId.PREPROCESSOR_IDENT, CppTokenId.PREPROCESSOR_PRAGMA, CppTokenId.PREPROCESSOR_WARNING, CppTokenId.PREPROCESSOR_ERROR};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addOmpKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.PRAGMA_OMP_START, CppTokenId.PRAGMA_OMP_PARALLEL, CppTokenId.PRAGMA_OMP_SECTIONS, CppTokenId.PRAGMA_OMP_NOWAIT, CppTokenId.PRAGMA_OMP_ORDERED, CppTokenId.PRAGMA_OMP_SCHEDULE, CppTokenId.PRAGMA_OMP_DYNAMIC, CppTokenId.PRAGMA_OMP_GUIDED, CppTokenId.PRAGMA_OMP_RUNTIME, CppTokenId.PRAGMA_OMP_SECTION, CppTokenId.PRAGMA_OMP_SINGLE, CppTokenId.PRAGMA_OMP_MASTER, CppTokenId.PRAGMA_OMP_CRITICAL, CppTokenId.PRAGMA_OMP_BARRIER, CppTokenId.PRAGMA_OMP_ATOMIC, CppTokenId.PRAGMA_OMP_FLUSH, CppTokenId.PRAGMA_OMP_THREADPRIVATE, CppTokenId.PRAGMA_OMP_PRIVATE, CppTokenId.PRAGMA_OMP_FIRSTPRIVATE, CppTokenId.PRAGMA_OMP_LASTPRIVATE, CppTokenId.PRAGMA_OMP_SHARED, CppTokenId.PRAGMA_OMP_NONE, CppTokenId.PRAGMA_OMP_REDUCTION, CppTokenId.PRAGMA_OMP_COPYIN, CppTokenId.PRAGMA_OMP_TASK, CppTokenId.PRAGMA_OMP_TASKWAIT, CppTokenId.PRAGMA_OMP_COLLAPSE, CppTokenId.PRAGMA_OMP_COPYPRIVATE, CppTokenId.PRAGMA_OMP_DEFAULT, CppTokenId.PRAGMA_OMP_STATIC, CppTokenId.PRAGMA_OMP_IF, CppTokenId.PRAGMA_OMP_FOR, CppTokenId.PRAGMA_OMP_AUTO, CppTokenId.PRAGMA_OMP_NUM_THREADS};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addCommonCCKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.AUTO, CppTokenId.BREAK, CppTokenId.CASE, CppTokenId.CHAR, CppTokenId.CONST, CppTokenId.CONTINUE, CppTokenId.DEFAULT, CppTokenId.DO, CppTokenId.DOUBLE, CppTokenId.ELSE, CppTokenId.ENUM, CppTokenId.EXTERN, CppTokenId.FLOAT, CppTokenId.FOR, CppTokenId.__FUNC__, CppTokenId.GOTO, CppTokenId.IF, CppTokenId.INT, CppTokenId.LONG, CppTokenId.REGISTER, CppTokenId.RETURN, CppTokenId.SHORT, CppTokenId.SIGNED, CppTokenId.SIZEOF, CppTokenId.STATIC, CppTokenId.STRUCT, CppTokenId.SWITCH, CppTokenId.TYPEDEF, CppTokenId.UNION, CppTokenId.UNSIGNED, CppTokenId.VOID, CppTokenId.VOLATILE, CppTokenId.WHILE};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addCppOnlyKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.ASM, CppTokenId.BOOL, CppTokenId.CATCH, CppTokenId.CLASS, CppTokenId.CONST_CAST, CppTokenId.DELETE, CppTokenId.DYNAMIC_CAST, CppTokenId.EXPLICIT, CppTokenId.EXPORT, CppTokenId.FINALLY, CppTokenId.FRIEND, CppTokenId.INLINE, CppTokenId._INLINE, CppTokenId.__INLINE, CppTokenId.__INLINE__, CppTokenId.MUTABLE, CppTokenId.NAMESPACE, CppTokenId.NEW, CppTokenId.OPERATOR, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC, CppTokenId.REINTERPRET_CAST, CppTokenId.STATIC_CAST, CppTokenId.TEMPLATE, CppTokenId.THIS, CppTokenId.THROW, CppTokenId.TRY, CppTokenId.TYPEID, CppTokenId.TYPENAME, CppTokenId.TYPEOF, CppTokenId.USING, CppTokenId.VIRTUAL, CppTokenId.WCHAR_T, CppTokenId.TRUE, CppTokenId.FALSE, CppTokenId.ALTERNATE_AND, CppTokenId.ALTERNATE_BITOR, CppTokenId.ALTERNATE_OR, CppTokenId.ALTERNATE_XOR, CppTokenId.ALTERNATE_COMPL, CppTokenId.ALTERNATE_BITAND, CppTokenId.ALTERNATE_AND_EQ, CppTokenId.ALTERNATE_OR_EQ, CppTokenId.ALTERNATE_XOR_EQ, CppTokenId.ALTERNATE_NOT, CppTokenId.ALTERNATE_NOT_EQ};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addCpp11OnlyKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.FINAL, CppTokenId.OVERRIDE, CppTokenId.CONSTEXPR, CppTokenId.DECLTYPE, CppTokenId.__DECLTYPE, CppTokenId.NULLPTR, CppTokenId.THREAD_LOCAL, CppTokenId.STATIC_ASSERT, CppTokenId.ALIGNAS, CppTokenId.CHAR16_T, CppTokenId.CHAR32_T, CppTokenId.NOEXCEPT};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addCOnlyKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.INLINE, CppTokenId._INLINE, CppTokenId.__INLINE, CppTokenId.__INLINE__, CppTokenId.RESTRICT, CppTokenId._BOOL, CppTokenId._COMPLEX, CppTokenId._IMAGINARY, CppTokenId._NORETURN};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addGccOnlyCommonCCKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.__ALIGNOF__, CppTokenId.ASM, CppTokenId._ASM, CppTokenId.__ASM, CppTokenId.__ASM__, CppTokenId.__ATTRIBUTE__, CppTokenId.__ATTRIBUTE, CppTokenId.__COMPLEX__, CppTokenId.__CONST, CppTokenId.__CONST__, CppTokenId.__IMAG__, CppTokenId.INLINE, CppTokenId._INLINE, CppTokenId.__INLINE, CppTokenId.__INLINE__, CppTokenId.__FORCEINLINE, CppTokenId.__REAL__, CppTokenId.__RESTRICT, CppTokenId.__RESTRICT__, CppTokenId.__SIGNED, CppTokenId.__SIGNED__, CppTokenId.TYPEOF, CppTokenId.__TYPEOF, CppTokenId.__TYPEOF__, CppTokenId.__VOLATILE, CppTokenId.__VOLATILE__, CppTokenId.__THREAD, CppTokenId.__GLOBAL, CppTokenId.__HIDDEN, CppTokenId.__SYMBOLIC, CppTokenId.__UNUSED__};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addGccOnlyCppOnlyKeywords(Filter<CppTokenId> filterToModify) {
        CppTokenId[] ids = new CppTokenId[]{CppTokenId.ALIGNOF, CppTokenId._ASM, CppTokenId._INLINE, CppTokenId.PASCAL, CppTokenId._PASCAL, CppTokenId.__PASCAL, CppTokenId.__UNSIGNED__, CppTokenId._CDECL, CppTokenId.__CDECL, CppTokenId.__CLRCALL, CppTokenId.__COMPLEX, CppTokenId._DECLSPEC, CppTokenId.__DECLSPEC, CppTokenId.__EXTENSION__, CppTokenId._FAR, CppTokenId.__FAR, CppTokenId.__FINALLY, CppTokenId._INT64, CppTokenId.__INT64, CppTokenId.__INTERRUPT, CppTokenId._NEAR, CppTokenId.__NEAR, CppTokenId._STDCALL, CppTokenId.__STDCALL, CppTokenId.__TRY, CppTokenId.__W64, CppTokenId.__NULL, CppTokenId.__ALIGNOF, CppTokenId.__IS_CLASS, CppTokenId.__IS_POD, CppTokenId.__IS_BASE_OF, CppTokenId.__HAS_TRIVIAL_CONSTRUCTOR};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addFortranKeywords(Filter<FortranTokenId> filterToModify) {
        FortranTokenId[] ids = new FortranTokenId[]{FortranTokenId.KW_ALLOCATABLE, FortranTokenId.KW_ALLOCATE, FortranTokenId.KW_APOSTROPHE, FortranTokenId.KW_ASSIGNMENT, FortranTokenId.KW_ASSOCIATE, FortranTokenId.KW_ASYNCHRONOUS, FortranTokenId.KW_BACKSPACE, FortranTokenId.KW_BIND, FortranTokenId.KW_BLOCK, FortranTokenId.KW_BLOCKDATA, FortranTokenId.KW_CALL, FortranTokenId.KW_CASE, FortranTokenId.KW_CHARACTER, FortranTokenId.KW_CLASS, FortranTokenId.KW_CLOSE, FortranTokenId.KW_COMMON, FortranTokenId.KW_COMPLEX, FortranTokenId.KW_CONTAINS, FortranTokenId.KW_CONTINUE, FortranTokenId.KW_CYCLE, FortranTokenId.KW_DATA, FortranTokenId.KW_DEALLOCATE, FortranTokenId.KW_DEFAULT, FortranTokenId.KW_DIMENSION, FortranTokenId.KW_DO, FortranTokenId.KW_DOUBLE, FortranTokenId.KW_DOUBLEPRECISION, FortranTokenId.KW_ELEMENTAL, FortranTokenId.KW_ELSE, FortranTokenId.KW_ELSEIF, FortranTokenId.KW_ELSEWHERE, FortranTokenId.KW_END, FortranTokenId.KW_ENDASSOCIATE, FortranTokenId.KW_ENDBLOCK, FortranTokenId.KW_ENDBLOCKDATA, FortranTokenId.KW_ENDDO, FortranTokenId.KW_ENDENUM, FortranTokenId.KW_ENDFILE, FortranTokenId.KW_ENDFORALL, FortranTokenId.KW_ENDFUNCTION, FortranTokenId.KW_ENDIF, FortranTokenId.KW_ENDINTERFACE, FortranTokenId.KW_ENDMAP, FortranTokenId.KW_ENDMODULE, FortranTokenId.KW_ENDPROGRAM, FortranTokenId.KW_ENDSELECT, FortranTokenId.KW_ENDSTRUCTURE, FortranTokenId.KW_ENDSUBROUTINE, FortranTokenId.KW_ENDTYPE, FortranTokenId.KW_ENDUNION, FortranTokenId.KW_ENDWHERE, FortranTokenId.KW_ENDWHILE, FortranTokenId.KW_ENTRY, FortranTokenId.KW_ENUM, FortranTokenId.KW_ENUMERATOR, FortranTokenId.KW_EQUIVALENCE, FortranTokenId.KW_EXIT, FortranTokenId.KW_EXTERNAL, FortranTokenId.KW_FLUSH, FortranTokenId.KW_FORALL, FortranTokenId.KW_FORMAT, FortranTokenId.KW_FUNCTION, FortranTokenId.KW_GO, FortranTokenId.KW_GOTO, FortranTokenId.KW_IF, FortranTokenId.KW_IMPLICIT, FortranTokenId.KW_IN, FortranTokenId.KW_INCLUDE, FortranTokenId.KW_INOUT, FortranTokenId.KW_INQUIRE, FortranTokenId.KW_INTEGER, FortranTokenId.KW_INTENT, FortranTokenId.KW_INTERFACE, FortranTokenId.KW_INTRINSIC, FortranTokenId.KW_KIND, FortranTokenId.KW_LEN, FortranTokenId.KW_LOGICAL, FortranTokenId.KW_MAP, FortranTokenId.KW_MODULE, FortranTokenId.KW_NAMELIST, FortranTokenId.KW_NONE, FortranTokenId.KW_NULLIFY, FortranTokenId.KW_ONLY, FortranTokenId.KW_OPEN, FortranTokenId.KW_OPERATOR, FortranTokenId.KW_OPTIONAL, FortranTokenId.KW_OUT, FortranTokenId.KW_PARAMETER, FortranTokenId.KW_POINTER, FortranTokenId.KW_PRECISION, FortranTokenId.KW_PRINT, FortranTokenId.KW_PRIVATE, FortranTokenId.KW_PROCEDURE, FortranTokenId.KW_PROGRAM, FortranTokenId.KW_PROTECTED, FortranTokenId.KW_PUBLIC, FortranTokenId.KW_PURE, FortranTokenId.KW_QUOTE, FortranTokenId.KW_READ, FortranTokenId.KW_REAL, FortranTokenId.KW_RECURSIVE, FortranTokenId.KW_RESULT, FortranTokenId.KW_RETURN, FortranTokenId.KW_REWIND, FortranTokenId.KW_SAVE, FortranTokenId.KW_SELECT, FortranTokenId.KW_SELECTCASE, FortranTokenId.KW_SELECTTYPE, FortranTokenId.KW_SEQUENCE, FortranTokenId.KW_STAT, FortranTokenId.KW_STOP, FortranTokenId.KW_STRUCTURE, FortranTokenId.KW_SUBROUTINE, FortranTokenId.KW_TARGET, FortranTokenId.KW_THEN, FortranTokenId.KW_TO, FortranTokenId.KW_TYPE, FortranTokenId.KW_UNION, FortranTokenId.KW_USE, FortranTokenId.KW_VALUE, FortranTokenId.KW_VOLATILE, FortranTokenId.KW_WAIT, FortranTokenId.KW_WHERE, FortranTokenId.KW_WHILE, FortranTokenId.KW_WRITE, FortranTokenId.KW_INT, FortranTokenId.KW_SHORT, FortranTokenId.KW_LONG, FortranTokenId.KW_SIGNED, FortranTokenId.KW_UNSIGNED, FortranTokenId.KW_SIZE_T, FortranTokenId.KW_INT8_T, FortranTokenId.KW_INT16_T, FortranTokenId.KW_INT32_T, FortranTokenId.KW_INT64_T, FortranTokenId.KW_INT_LEAST8_T, FortranTokenId.KW_INT_LEAST16_T, FortranTokenId.KW_INT_LEAST32_T, FortranTokenId.KW_INT_LEAST64_T, FortranTokenId.KW_INT_FAST8_T, FortranTokenId.KW_INT_FAST16_T, FortranTokenId.KW_INT_FAST32_T, FortranTokenId.KW_INT_FAST64_T, FortranTokenId.KW_INTMAX_T, FortranTokenId.KW_INTPTR_T, FortranTokenId.KW_FLOAT, FortranTokenId.KW__COMPLEX, FortranTokenId.KW__BOOL, FortranTokenId.KW_CHAR, FortranTokenId.KW_BOOL, FortranTokenId.KWOP_EQ, FortranTokenId.KWOP_NE, FortranTokenId.KWOP_LT, FortranTokenId.KWOP_LE, FortranTokenId.KWOP_GT, FortranTokenId.KWOP_GE, FortranTokenId.KWOP_AND, FortranTokenId.KWOP_OR, FortranTokenId.KWOP_NOT, FortranTokenId.KWOP_EQV, FortranTokenId.KWOP_NEQV, FortranTokenId.KWOP_TRUE, FortranTokenId.KWOP_FALSE};
        CndLexerUtilities.addToFilter(ids, filterToModify);
    }

    private static void addToFilter(CppTokenId[] ids, Filter<CppTokenId> filterToModify) {
        for (CppTokenId id : ids) {
            assert (id.fixedText() != null) : "id " + (Object)((Object)id) + " must have fixed text";
            filterToModify.addMatch(id.fixedText(), id);
        }
    }

    private static void addToFilter(FortranTokenId[] ids, Filter<FortranTokenId> filterToModify) {
        for (FortranTokenId id : ids) {
            assert (id.fixedText() != null) : "id " + (Object)((Object)id) + " must have fixed text";
            filterToModify.addMatch(id.fixedText(), id);
        }
    }

    private static final class CndLexerEmbeddingProviders {
        private static final Collection<? extends CndLexerLanguageEmbeddingProvider> providers = Lookups.forPath((String)"CND/CndLexerLanguageEmbeddingProvider").lookupAll(CndLexerLanguageEmbeddingProvider.class);

        private CndLexerEmbeddingProviders() {
        }
    }

    public static enum FortranFormat {
        FREE,
        FIXED,
        UNDEFINED;

    }
}

