/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.db.dataview.table.celleditor.MonitorableStreamTransfer;
import org.netbeans.modules.db.dataview.util.FileBackedBlob;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class BlobFieldTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Logger LOG = Logger.getLogger(BlobFieldTableCellEditor.class.getName());
    protected static final String EDIT = "edit";
    protected Blob currentValue;
    protected JButton button = new JButton();
    protected JPopupMenu popup;
    protected JTable table;
    protected JMenuItem saveContentMenuItem;
    protected JMenuItem miOpenImageMenuItem;

    public BlobFieldTableCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setContentAreaFilled(false);
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.button.setRolloverEnabled(false);
        this.button.setAlignmentX(0.0f);
        this.button.setHorizontalAlignment(2);
        this.button.setFont(new Font(this.button.getFont().getFamily(), 2, 9));
        this.popup = new JPopupMenu();
        JMenuItem miLobSaveAction = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"saveLob.title"));
        miLobSaveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.saveLobToFile(BlobFieldTableCellEditor.this.currentValue);
                BlobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.saveContentMenuItem = miLobSaveAction;
        this.popup.add(miLobSaveAction);
        JMenuItem miOpenImageAction = new JMenuItem("Open as Image");
        miOpenImageAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.openAsImage(BlobFieldTableCellEditor.this.currentValue);
                BlobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.miOpenImageMenuItem = miOpenImageAction;
        this.popup.add(miOpenImageAction);
        JMenuItem miLobLoadAction = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"loadLob.title"));
        miLobLoadAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Blob newValue = BlobFieldTableCellEditor.this.loadLobFromFile();
                if (newValue != null) {
                    BlobFieldTableCellEditor.this.currentValue = newValue;
                }
                BlobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(miLobLoadAction);
        JMenuItem miLobNullAction = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"nullLob.title"));
        miLobNullAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.currentValue = null;
                BlobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(miLobNullAction);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.popup.show(this.button, 0, this.button.getHeight());
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentValue = (Blob)value;
        if (this.currentValue != null) {
            this.saveContentMenuItem.setEnabled(true);
            this.miOpenImageMenuItem.setEnabled(true);
            try {
                long size = this.currentValue.length();
                StringBuilder stringValue = new StringBuilder();
                stringValue.append("<BLOB ");
                if (size < 1000L) {
                    stringValue.append(String.format("%1$d bytes", size));
                } else if (size < 1000000L) {
                    stringValue.append(String.format("%1$d kB", size / 1000L));
                } else {
                    stringValue.append(String.format("%1$d MB", size / 1000000L));
                }
                stringValue.append(">");
                this.button.setText(stringValue.toString());
            }
            catch (SQLException ex) {
                this.button.setText("<BLOB of unknown size>");
            }
        } else {
            this.saveContentMenuItem.setEnabled(false);
            this.miOpenImageMenuItem.setEnabled(false);
            this.button.setText("<NULL>");
        }
        this.table = table;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return super.isCellEditable(anEvent);
    }

    private void saveLobToFile(Blob b) {
        if (b == null) {
            return;
        }
        JFileChooser c = new JFileChooser();
        int fileDialogState = c.showSaveDialog(this.table);
        if (fileDialogState == 0) {
            File f = c.getSelectedFile();
            try {
                InputStream is = b.getBinaryStream();
                FileOutputStream fos = new FileOutputStream(f);
                if (!this.doTransfer(is, fos, (int)b.length(), "Saving to file: " + f.toString())) {
                    f.delete();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOError while saving BLOB to file", ex);
                this.displayError(f, ex, false);
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while saving BLOB to file", ex);
                this.displayError(f, ex, false);
            }
        }
    }

    private Blob loadLobFromFile() {
        JFileChooser c = new JFileChooser();
        FileBackedBlob result = null;
        int fileDialogState = c.showOpenDialog(this.table);
        if (fileDialogState == 0) {
            File f = c.getSelectedFile();
            try {
                FileInputStream fis = new FileInputStream(f);
                result = new FileBackedBlob();
                if (!this.doTransfer(fis, result.setBinaryStream(1L), (int)f.length(), "Loading file: " + f.toString())) {
                    result = null;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOError while loading BLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while loading BLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
        }
        return result;
    }

    private boolean doTransfer(InputStream is, OutputStream os, Integer size, String title) throws IOException {
        MonitorableStreamTransfer ft = new MonitorableStreamTransfer(is, os, size);
        Throwable t = size == null || size > 0x100000 ? (Throwable)ProgressUtils.showProgressDialogAndRun((ProgressRunnable)ft, (String)title, (boolean)false) : ft.run(null);
        is.close();
        os.close();
        if (t != null && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t != null && t instanceof IOException) {
            throw (IOException)t;
        }
        if (t != null) {
            throw new RuntimeException(t);
        }
        return !ft.isCancel();
    }

    private void displayError(File f, Exception ex, boolean read) {
        String messageMsg;
        String titleMsg;
        DialogDisplayer dd = DialogDisplayer.getDefault();
        String errorObjectMsg = ex instanceof SQLException ? NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"lobErrorObject.database") : NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"lobErrorObject.file");
        if (!read) {
            titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobSaveToFileError.title");
            messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobSaveToFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        } else {
            titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobReadFromFileError.title");
            messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobReadFromFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)messageMsg, titleMsg, 2, 2, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION);
        dd.notifyLater(nd);
    }

    private void openAsImage(Blob b) {
        if (b == null) {
            return;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(b.getBinaryStream());
            Iterator<ImageReader> irs = ImageIO.getImageReaders(iis);
            if (irs.hasNext()) {
                FileSystem fs = FileUtil.createMemoryFileSystem();
                FileObject fob = fs.getRoot().createData(Long.toString(System.currentTimeMillis()), irs.next().getFormatName());
                OutputStream os = fob.getOutputStream();
                os.write(b.getBytes(1L, (int)b.length()));
                os.close();
                DataObject data = DataObject.find((FileObject)fob);
                OpenCookie cookie = (OpenCookie)data.getLookup().lookup(OpenCookie.class);
                if (cookie != null) {
                    cookie.open();
                    return;
                }
            }
            this.displayErrorOpenImage("openImageErrorNotImage.message");
        }
        catch (SQLException ex) {
            LOG.log(Level.INFO, "SQLException while opening BLOB as file", ex);
            this.displayErrorOpenImage("openImageErrorDB.message");
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "IOError while opening BLOB as file", ex);
        }
    }

    private void displayErrorOpenImage(String messageProperty) {
        DialogDisplayer dd = DialogDisplayer.getDefault();
        String messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)messageProperty);
        String titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"openImageError.title");
        NotifyDescriptor nd = new NotifyDescriptor((Object)messageMsg, titleMsg, 2, 2, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION);
        dd.notifyLater(nd);
    }
}

