/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.awt.StatusDisplayer;

public class ResultSetTableCellEditor
extends DefaultCellEditor {
    protected Object val;
    protected boolean editable = true;
    protected JTable table;
    protected static final boolean suppressEditorBorder;

    public ResultSetTableCellEditor(final JTextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                ResultSetTableCellEditor.this.val = value;
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                String txtVal = textField.getText();
                if (ResultSetTableCellEditor.this.val == null && txtVal.equals("")) {
                    return null;
                }
                try {
                    assert (ResultSetTableCellEditor.this.table != null);
                    int col = ResultSetTableCellEditor.this.table.getEditingColumn();
                    return DBReadWriteHelper.validate(txtVal, ((ResultSetJXTable)((Object)ResultSetTableCellEditor.this.table)).getDBColumn(col));
                }
                catch (Exception ex) {
                    StatusDisplayer.getDefault().setStatusText(ex.getMessage());
                    return txtVal;
                }
            }
        };
        textField.addActionListener(this.delegate);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (DataViewUtils.isSQLConstantString(value, null)) {
            value = "";
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public ResultSetTableCellEditor(final JRendererCheckBox checkBox) {
        super((JCheckBox)checkBox);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                ResultSetTableCellEditor.this.val = value;
                checkBox.setSelected(value != null ? checkBox.isSelected() : false);
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                Boolean bolVal = checkBox.isSelected();
                if (ResultSetTableCellEditor.this.val == null && !checkBox.isSelected()) {
                    return null;
                }
                return bolVal;
            }
        };
        checkBox.addActionListener((ActionListener)this.delegate);
    }

    protected void setEditable(int column, Component c, boolean celleditable) {
        assert (this.table != null);
        DBColumn dbCol = ((ResultSetJXTable)((Object)this.table)).getDBColumn(column);
        if (dbCol.isGenerated()) {
            this.editable = false;
        }
        this.editable = !celleditable ? false : dbCol.isEditable();
        if (c instanceof JTextField) {
            ((JTextField)c).setEditable(this.editable);
        } else if (c instanceof JComponent) {
            ((JComponent)c).setEnabled(this.editable);
        }
    }

    static {
        boolean suppressBorder = false;
        suppressBorder |= "GTK".equals(UIManager.getLookAndFeel().getID());
        suppressEditorBorder = suppressBorder |= "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }
}

