/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.table.TableColumnExt;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public final class JXTableRowHeader
extends JComponent {
    private PropertyChangeListener tableSorterListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            JTable t = (JTable)pce.getSource();
            if (pce.getPropertyName().equals("rowSorter") || pce.getPropertyName().equals("sorter")) {
                if (JXTableRowHeader.this.backingSorter != null) {
                    JXTableRowHeader.this.backingSorter.removeRowSorterListener(JXTableRowHeader.this.rowSorterListener);
                }
                if (pce.getNewValue() != null) {
                    JXTableRowHeader.this.backingSorter = (RowSorter)pce.getNewValue();
                    JXTableRowHeader.this.backingSorter.addRowSorterListener(JXTableRowHeader.this.rowSorterListener);
                }
            } else if (pce.getPropertyName().equals("rowHeight")) {
                JXTableRowHeader.this.headerTable.setRowHeight(((Integer)pce.getNewValue()).intValue());
            }
        }
    };
    private RowSorterListener rowSorterListener = new RowSorterListener(){

        @Override
        public void sorterChanged(RowSorterEvent rse) {
            JXTableRowHeader.this.ctm.setCount(((RowSorter)rse.getSource()).getViewRowCount());
        }
    };
    private static Icon rightArrow = new Icon(){

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 4, y + 4, x + 4, y + 4);
            g.translate(x + 4, y + 4);
            g.fillPolygon(new Polygon(new int[]{0, 5, 0}, new int[]{-5, 0, 5}, 3));
        }
    };
    private IconBorder iconBorder = new IconBorder();
    private final CountingTableModel ctm = new CountingTableModel();
    private final JXTable headerTable = new JXTableDecorator(this.ctm, new InternalTableColumnModel());
    private JXTable backingTable;
    private RowSorter<?> backingSorter;

    public JTableHeader getTableHeader() {
        JTableHeader header = this.headerTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public JXTableRowHeader(JXTable table) {
        this.setTable(table);
        this.setLayout(new GridLayout(1, 1));
        this.headerTable.getModel().addTableModelListener(new HeaderResizeListener());
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.getTableHeader().setReorderingAllowed(false);
        this.headerTable.getTableHeader().setResizingAllowed(false);
        this.add((Component)this.headerTable);
        TableColumn column = this.headerTable.getColumnModel().getColumn(0);
        this.headerTable.packAll();
        column.setPreferredWidth(column.getPreferredWidth() + 20);
        column.setCellRenderer(this.createDefaultRenderer());
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
        this.headerTable.setInheritsPopupMenu(true);
        this.headerTable.setShowGrid(true, true);
        this.headerTable.setGridColor(ResultSetJXTable.GRID_COLOR);
        this.headerTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)ResultSetJXTable.ROW_COLOR, (Color)ResultSetJXTable.ALTERNATE_ROW_COLOR)});
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new RowHeaderColumnRenderer();
    }

    public void setTable(JXTable table) {
        if (this.backingTable != null) {
            this.backingTable.removePropertyChangeListener(this.tableSorterListener);
        }
        this.backingTable = table;
        if (this.backingTable != null) {
            this.ctm.setCount(this.backingTable.getRowCount());
            this.backingTable.addPropertyChangeListener(this.tableSorterListener);
            this.headerTable.setRowHeight(this.backingTable.getRowHeight());
            this.headerTable.setSelectionModel(this.backingTable.getSelectionModel());
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.headerTable.getToolTipText(event);
    }

    private class RowHeaderColumnRenderer
    extends DefaultTableRenderer {
        private RowHeaderColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            if (isSelected) {
                JXTableRowHeader.this.iconBorder.setIcon(rightArrow);
                Border origBorder = ((JComponent)comp).getBorder();
                CompoundBorder border = new CompoundBorder(origBorder, (Border)JXTableRowHeader.this.iconBorder);
                ((JComponent)comp).setBorder(border);
                comp.setBackground(UIManager.getColor("Table.selectionBackground"));
                comp.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return comp;
        }
    }

    private class HeaderResizeListener
    implements TableModelListener {
        private HeaderResizeListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            JXTableRowHeader.this.headerTable.packAll();
            TableColumn column = JXTableRowHeader.this.headerTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(column.getPreferredWidth() + 20);
            if (column.getPreferredWidth() != JXTableRowHeader.this.getWidth()) {
                JXTableRowHeader.this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
            }
        }
    }

    private static class CountingTableModel
    implements TableModel {
        private int count;
        Set<TableModelListener> listeners = new HashSet<TableModelListener>();

        private CountingTableModel() {
        }

        public void setCount(int count) {
            this.count = count;
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tl) {
            this.listeners.add(tl);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int i) {
            return "Row number";
        }

        @Override
        public int getRowCount() {
            return this.count;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return Integer.toString(row + 1);
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener tl) {
            this.listeners.remove(tl);
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
            throw new NoSuchMethodError();
        }
    }

    private static class InternalTableColumnModel
    extends DefaultTableColumnModel {
        public InternalTableColumnModel() {
            TableColumnExt col = new TableColumnExt(0, 75);
            col.setEditable(false);
            col.setHeaderValue((Object)"#");
            col.setToolTipText("Row number");
            col.setSortable(false);
            this.addColumn((TableColumn)col);
        }
    }
}

