/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.netbeans.modules.db.dataview.table.CellFocusCustomRenderer;

class ClobCellRenderer
extends CellFocusCustomRenderer {
    ClobCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        long size;
        if (!(value instanceof Clob)) {
            throw new IllegalArgumentException("ClobCellRenderer can only be used for Clobs");
        }
        Clob clobValue = (Clob)value;
        StringBuilder contentPart = new StringBuilder();
        StringBuilder clobDescription = new StringBuilder("<CLOB ");
        try {
            size = clobValue.length();
            if (size < 1000L) {
                clobDescription.append(String.format("%1$d Chars", size));
            } else if (size < 1000000L) {
                clobDescription.append(String.format("%1$d kChars", size / 1000L));
            } else {
                clobDescription.append(String.format("%1$d MChars", size / 1000000L));
            }
        }
        catch (SQLException ex) {
            clobDescription.append("of unknown size");
        }
        clobDescription.append(">");
        try {
            size = clobValue.length();
            long retrievalCount = Math.min(size, 255L);
            String sampleContent = clobValue.getSubString(1L, (int)retrievalCount);
            contentPart.append(sampleContent.replaceAll("[\n\r]+", " "));
            if (size > 255L) {
                contentPart.append(" [...]");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to retrieve CLOB content", ex);
            contentPart.append(clobDescription.toString());
        }
        Component renderer = super.getTableCellRendererComponent(table, contentPart.toString(), isSelected, hasFocus, row, column);
        if (renderer instanceof JComponent) {
            ((JComponent)renderer).setToolTipText(clobDescription.toString());
        }
        return renderer;
    }
}

