/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.dwarfdump.CompileLineService;
import org.netbeans.modules.cnd.dwarfdump.LddService;
import org.netbeans.modules.cnd.dwarfdump.Offset2LineService;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class RemoteJavaExecution {
    private final ExecutionEnvironment env;
    private final FileSystem fileSystem;
    private static final RequestProcessor RP = new RequestProcessor("ReadErrorStream", 2);
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.remote.projectui.wizard.cnd.dwarf");

    public RemoteJavaExecution(FileSystem fileSystem) {
        this.env = FileSystemProvider.getExecutionEnvironment((FileSystem)fileSystem);
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompileLineService.SourceFile> getCompileLines(String executable) {
        NativeProcess process = null;
        RequestProcessor.Task errorTask = null;
        try {
            process = this.getJavaProcess(CompileLineService.class, this.env, new String[]{"-file", executable});
            if (process == null) {
                List<CompileLineService.SourceFile> list = null;
                return list;
            }
            if (process.getState() != NativeProcess.State.ERROR) {
                final NativeProcess startedProcess = process;
                final ArrayList errors = new ArrayList();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            errors.addAll(ProcessUtils.readProcessError((Process)startedProcess));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
                List sourceProperties = CompileLineService.getSourceProperties((BufferedReader)out);
                int rc = process.waitFor();
                logger.log(Level.FINE, "Return code {0}", rc);
                boolean hasException = false;
                for (String error : errors) {
                    if (error.indexOf("Exception") >= 0) {
                        hasException = true;
                    }
                    logger.log(Level.INFO, error);
                }
                if (rc == 0 && !hasException) {
                    logger.log(Level.FINE, "Read debug infirmation of {0} compilation units from executable file {1}", new Object[]{sourceProperties.size(), executable});
                    List list = sourceProperties;
                    return list;
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
        }
        catch (Throwable ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        finally {
            if (errorTask != null) {
                errorTask.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElfReader.SharedLibraries getDlls(String executable) {
        NativeProcess process = null;
        RequestProcessor.Task errorTask = null;
        try {
            process = this.getJavaProcess(LddService.class, this.env, new String[]{executable});
            if (process == null) {
                ElfReader.SharedLibraries sharedLibraries = null;
                return sharedLibraries;
            }
            if (process.getState() != NativeProcess.State.ERROR) {
                final NativeProcess startedProcess = process;
                final ArrayList errors = new ArrayList();
                errorTask = RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            errors.addAll(ProcessUtils.readProcessError((Process)startedProcess));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
                ElfReader.SharedLibraries pubNames = LddService.getPubNames((BufferedReader)out);
                int rc = process.waitFor();
                logger.log(Level.FINE, "Return code {0}", rc);
                boolean hasException = false;
                for (String error : errors) {
                    if (error.indexOf("Exception") >= 0) {
                        hasException = true;
                    }
                    logger.log(Level.INFO, error);
                }
                if (rc == 0 && !hasException) {
                    logger.log(Level.FINE, "Read dlls infirmation from executable file {0}", new Object[]{executable});
                    ElfReader.SharedLibraries sharedLibraries = pubNames;
                    return sharedLibraries;
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
        }
        catch (Throwable ex) {
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        finally {
            if (errorTask != null) {
                errorTask.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
        return null;
    }

    private FileObject findProjectCreator() {
        for (CompilerSet set : CompilerSetManager.get((ExecutionEnvironment)this.env).getCompilerSets()) {
            String directory;
            FileObject dwarfDump;
            if (!set.getCompilerFlavor().isSunStudioCompiler() || (dwarfDump = this.fileSystem.findResource((directory = set.getDirectory()) + "/../lib/netbeans/cnd/modules/org-netbeans-modules-cnd-dwarfdump.jar")) == null || !dwarfDump.isValid()) continue;
            return dwarfDump;
        }
        return this.copyJar();
    }

    private FileObject copyJar() {
        try {
            String path = Offset2LineService.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = path.replace('\\', '/');
            path = path.substring(path.lastIndexOf("/modules/") + 1);
            if (path.indexOf(33) > 0) {
                path = path.substring(0, path.indexOf(33));
            }
            String relPath = path;
            File jar = InstalledFileLocator.getDefault().locate(relPath, "org.netbeans.modules.cnd.dwarfdump", false);
            if (jar != null) {
                FileObject from = FileUtil.toFileObject((File)jar);
                FileObject tempFolder = this.fileSystem.getTempFolder();
                FileObject to = this.fileSystem.createTempFile(tempFolder, "dwarfdump", ".jar", true);
                OutputStream outputStream = to.getOutputStream();
                InputStream inputStream = from.getInputStream();
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.close();
                inputStream.close();
                return to;
            }
        }
        catch (Throwable thr) {
            Exceptions.printStackTrace((Throwable)thr);
        }
        return null;
    }

    private NativeProcess getJavaProcess(Class<?> clazz, ExecutionEnvironment env, String[] arguments) throws IOException {
        FileObject dwarfDump = this.findProjectCreator();
        if (dwarfDump == null) {
            return null;
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
        npb.setCharset(Charset.forName("UTF-8"));
        npb.setExecutable("java");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(dwarfDump.getPath());
        args.add(clazz.getName());
        args.addAll(Arrays.asList(arguments));
        npb.setArguments(args.toArray(new String[args.size()]));
        return npb.call();
    }

    public String getSourceRoot(List<CompileLineService.SourceFile> compileLines) {
        TreeMap<String, AtomicInteger> realRoots = new TreeMap<String, AtomicInteger>();
        for (CompileLineService.SourceFile file : compileLines) {
            ArrayList userIncludes = new ArrayList();
            HashMap userMacros = new HashMap();
            ArrayList undefinedMacros = new ArrayList();
            ArrayList languageArtifacts = new ArrayList();
            List sourcesList = DiscoveryUtils.gatherCompilerLine((String)file.getCompileLine(), (DiscoveryUtils.LogOrigin)DiscoveryUtils.LogOrigin.DwarfCompileLine, userIncludes, userMacros, undefinedMacros, null, languageArtifacts, null, (boolean)true);
            for (String what : sourcesList) {
                if (what == null) continue;
                String dir = file.getCompileDir();
                String path = dir != null ? (what.startsWith("/") ? what : (dir.endsWith("/") ? dir + what : dir + '/' + what)) : what;
                int i = (path = PathUtilities.normalizeUnixPath((String)path)).lastIndexOf(47);
                if (i < 0) continue;
                String folder = path.substring(0, i);
                AtomicInteger val = realRoots.get(folder);
                if (val == null) {
                    val = new AtomicInteger();
                    realRoots.put(folder, val);
                }
                val.incrementAndGet();
            }
        }
        return this.getRoot(realRoots);
    }

    private String getRoot(TreeMap<String, AtomicInteger> roots) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<AtomicInteger> resCount = new ArrayList<AtomicInteger>();
        String current = null;
        AtomicInteger currentCount = null;
        for (Map.Entry<String, AtomicInteger> entry : roots.entrySet()) {
            int length;
            if (current == null) {
                current = entry.getKey();
                currentCount = new AtomicInteger(entry.getValue().get());
                continue;
            }
            String s = this.getCommonPart(entry.getKey(), current);
            String[] split = s.split("/");
            int n = length = split.length > 0 && split[0].isEmpty() ? split.length - 1 : split.length;
            if (length >= 2) {
                current = s;
                currentCount.addAndGet(entry.getValue().get());
                continue;
            }
            res.add(current);
            resCount.add(currentCount);
            current = entry.getKey();
            currentCount = new AtomicInteger(entry.getValue().get());
        }
        if (current != null) {
            res.add(current);
            resCount.add(currentCount);
        }
        TreeMap newRoots = new TreeMap();
        String bestRoot = null;
        int bestCount = 0;
        for (int i = 0; i < res.size(); ++i) {
            newRoots.put(res.get(i), resCount.get(i));
            if (bestRoot == null) {
                bestRoot = (String)res.get(i);
                bestCount = ((AtomicInteger)resCount.get(i)).get();
                continue;
            }
            if (bestCount >= ((AtomicInteger)resCount.get(i)).get()) continue;
            bestRoot = (String)res.get(i);
            bestCount = ((AtomicInteger)resCount.get(i)).get();
        }
        return bestRoot;
    }

    private String getCommonPart(String path, String commonRoot) {
        String[] splitPath = path.split("/");
        ArrayList<String> list1 = new ArrayList<String>();
        boolean isUnixPath = false;
        for (int i = 0; i < splitPath.length; ++i) {
            if (!splitPath[i].isEmpty()) {
                list1.add(splitPath[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixPath = true;
        }
        String[] splitRoot = commonRoot.split("/");
        ArrayList<String> list2 = new ArrayList<String>();
        boolean isUnixRoot = false;
        for (int i = 0; i < splitRoot.length; ++i) {
            if (!splitRoot[i].isEmpty()) {
                list2.add(splitRoot[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixRoot = true;
        }
        if (isUnixPath != isUnixRoot) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (isUnixPath) {
            buf.append('/');
        }
        for (int i = 0; i < Math.min(list1.size(), list2.size()) && ((String)list1.get(i)).equals(list2.get(i)); ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append((String)list1.get(i));
        }
        return buf.toString();
    }
}

