/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;

public class RelocatablePathMapperImpl
implements RelocatablePathMapper {
    public static final Logger LOG = Logger.getLogger(RelocatablePathMapperImpl.class.getName());
    private static final boolean TEST = false;
    private final List<MapperEntry> mapper = new ArrayList<MapperEntry>();
    private final String PATH_MAPPER_FILE = System.getProperty("makeproject.pathMapper.file");
    private final boolean FORBID_AUTO_PATH_MAPPER = Boolean.getBoolean("makeproject.pathMapper.forbid_auto");

    public RelocatablePathMapperImpl(ProjectProxy project) {
        boolean addDefaultMapping = true;
        if (project != null) {
            File file;
            String mapperFile;
            Project makeProject = project.getProject();
            ArrayList<String> list = null;
            if (makeProject != null) {
                // empty if block
            }
            if ((list == null || list.isEmpty()) && (mapperFile = this.PATH_MAPPER_FILE) != null && (file = new File(mapperFile)).exists() && file.canRead()) {
                BufferedReader in = null;
                try {
                    String line;
                    in = new BufferedReader(new FileReader(file));
                    list = new ArrayList<String>();
                    while ((line = in.readLine()) != null) {
                        int i = (line = line.trim()).indexOf(61);
                        if (i <= 0) continue;
                        list.add(line.substring(0, i));
                        list.add(line.substring(i + 1));
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Cannot read mapper file {0}", mapperFile);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (list != null) {
                for (int i = 0; i < list.size(); i += 2) {
                    if (i + 1 >= list.size()) continue;
                    this.mapper.add(new MapperEntry((String)list.get(i), (String)list.get(i + 1)));
                    LOG.log(Level.FINE, "Init path map {0} -> {1}", new Object[]{list.get(i), list.get(i + 1)});
                }
                addDefaultMapping = false;
            }
        }
        if (addDefaultMapping) {
            this.mapper.add(new MapperEntry("/usr", "/usr"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelocatablePathMapper.ResolvedPath getPath(String path) {
        path = path.replace('\\', '/');
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            for (MapperEntry entry : this.mapper) {
                if (!path.startsWith(entry.from)) continue;
                if (path.equals(entry.from)) {
                    return new ResolvedPathImpl(entry.to, entry.to);
                }
                if (path.charAt(entry.from.length()) != '/') continue;
                return new ResolvedPathImpl(entry.to, entry.to + path.substring(entry.from.length()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MapperEntry> dump() {
        ArrayList<MapperEntry> res;
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            res = new ArrayList<MapperEntry>(this.mapper);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discover(RelocatablePathMapper.FS fs, String root, String unknown) {
        if (this.FORBID_AUTO_PATH_MAPPER) {
            return false;
        }
        MapperEntry mapperEntry = this.getMapperEntry(fs, root, unknown);
        if (mapperEntry == null) {
            LOG.log(Level.FINER, "Cannot discover path map of root {0} and canidate {1}", new Object[]{root, unknown});
            return false;
        }
        LOG.log(Level.FINE, "Discover path map of root {0} and canidate {1}", new Object[]{root, unknown});
        LOG.log(Level.FINE, "Found path map {0} -> {1}", new Object[]{mapperEntry.from, mapperEntry.to});
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            if (!this.mapper.contains(mapperEntry)) {
                this.mapper.add(mapperEntry);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String from, String to) {
        MapperEntry mapperEntry = new MapperEntry(from, to);
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            this.mapper.add(mapperEntry);
        }
        return true;
    }

    private MapperEntry getMapperEntry(RelocatablePathMapper.FS fs, String root, String unknown) {
        root = root.replace('\\', '/');
        boolean driverRoot = false;
        if (root.startsWith("/")) {
            root = root.substring(1);
        } else {
            driverRoot = true;
        }
        boolean driverPath = false;
        unknown = unknown.replace('\\', '/');
        if (unknown.startsWith("/")) {
            unknown = unknown.substring(1);
        } else {
            driverPath = true;
        }
        String[] rootSegments = root.split("/");
        String[] unknownSegments = unknown.split("/");
        int min = 0;
        int k = 0;
        while (k < Math.min(unknownSegments.length, rootSegments.length) && unknownSegments[k].equals(rootSegments[k])) {
            min = k++;
        }
        if (min > 2) {
            return null;
        }
        for (k = 1; k < unknownSegments.length; ++k) {
            for (int i = rootSegments.length - 1; i > 1; --i) {
                String path;
                int j;
                StringBuilder buf = new StringBuilder();
                for (j = 0; j < i; ++j) {
                    buf.append('/');
                    buf.append(rootSegments[j]);
                }
                for (j = k; j < unknownSegments.length; ++j) {
                    buf.append('/');
                    buf.append(unknownSegments[j]);
                }
                String string = path = driverRoot ? buf.substring(1) : buf.toString();
                if (!fs.exists(path)) continue;
                if (k == i) {
                    boolean startEquals = true;
                    for (int l = 0; l < k; ++l) {
                        if (unknownSegments[l].equals(rootSegments[l])) continue;
                        startEquals = false;
                        break;
                    }
                    if (startEquals) continue;
                }
                if (k < 2 && k < unknownSegments.length - 1 && i < rootSegments.length - 1 && unknownSegments[k].equals(rootSegments[i])) {
                    ++k;
                    ++i;
                }
                StringBuilder from = new StringBuilder();
                for (int j2 = 0; j2 < k; ++j2) {
                    from.append('/');
                    from.append(unknownSegments[j2]);
                }
                StringBuilder to = new StringBuilder();
                for (int j3 = 0; j3 < i; ++j3) {
                    to.append('/');
                    to.append(rootSegments[j3]);
                }
                String aFrom = driverPath ? from.substring(1) : from.toString();
                String aTo = driverRoot ? to.substring(1) : to.toString();
                return new MapperEntry(aFrom, aTo);
            }
        }
        return null;
    }

    static final class ResolvedPathImpl
    implements RelocatablePathMapper.ResolvedPath {
        private final String root;
        private final String path;

        ResolvedPathImpl(String root, String path) {
            this.root = root;
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getRoot() {
            return this.root;
        }
    }

    static final class MapperEntry {
        final String from;
        final String to;

        MapperEntry(String from, String to) {
            this.to = to;
            this.from = from;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + (this.from != null ? this.from.hashCode() : 0);
            hash = 71 * hash + (this.to != null ? this.to.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapperEntry other = (MapperEntry)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

