/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatableImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class LogReader {
    private String workingDir;
    private String guessWorkingDir;
    private String baseWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private final PathMap pathMapper;
    private final ProjectProxy project;
    private final CompilerSettings compilerSettings;
    private final RelocatablePathMapper localMapper;
    private final FileSystem fileSystem;
    private final Map<String, String> alreadyConverted = new HashMap<String, String>();
    private final Set<String> C_NAMES;
    private final Set<String> CPP_NAMES;
    private final Set<String> FORTRAN_NAMES;
    private boolean isWindows = false;
    private final ArrayList<List<String>> makeStack = new ArrayList();
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final Pattern MAKE_DIRECTORY = Pattern.compile(".*make(?:\\.exe)?(?:\\[([0-9]+)\\])?: .*`([^']*)'$");
    private boolean isEntered;
    private Stack<Integer> relativesLevel = new Stack();
    private Stack<String> relativesTo = new Stack();
    private static final String LABEL_CD = "cd ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private static final String CYGPATH_PATTERN = "cygpath ";
    private HashSet<String> subFolders;
    private Map<String, List<String>> findBase;

    public LogReader(String fileName, String root, ProjectProxy project, RelocatablePathMapper relocatablePathMapper, FileSystem fileSystem) {
        this.root = root.length() > 0 ? CndFileUtils.normalizeFile((File)new File(root)).getAbsolutePath() : root;
        this.fileName = fileName;
        this.project = project;
        this.pathMapper = this.getPathMapper(project);
        this.compilerSettings = new CompilerSettings(project);
        this.localMapper = relocatablePathMapper;
        this.fileSystem = fileSystem;
        this.C_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCompiler);
        this.CPP_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCCompiler);
        this.FORTRAN_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.FortranCompiler);
    }

    private String convertPath(String path) {
        if (this.isPathAbsolute(path)) {
            String local;
            String originalPath = path;
            String converted = this.alreadyConverted.get(path);
            if (converted != null) {
                return converted;
            }
            if (this.pathMapper != null && (local = this.pathMapper.getLocalPath(path)) != null) {
                path = local;
            }
            if (this.localMapper != null && this.fileSystem != null) {
                FileObject fo = this.fileSystem.findResource(path);
                if (fo == null || !fo.isValid()) {
                    RelocatablePathMapper.ResolvedPath resolvedPath = this.localMapper.getPath(path);
                    if (resolvedPath == null) {
                        RelocatablePathMapper.FS fs;
                        if (this.root != null && this.localMapper.discover(fs = new RelocatablePathMapper.FS(){

                            @Override
                            public boolean exists(String path) {
                                FileObject fo = LogReader.this.fileSystem.findResource(path);
                                return fo != null && fo.isValid();
                            }
                        }, this.root, path) && (fo = this.fileSystem.findResource((resolvedPath = this.localMapper.getPath(path)).getPath())) != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    } else {
                        fo = this.fileSystem.findResource(resolvedPath.getPath());
                        if (fo != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    }
                } else {
                    RelocatablePathMapper.ResolvedPath resolvedPath = this.localMapper.getPath(fo.getPath());
                    if (resolvedPath == null) {
                        RelocatablePathMapper.FS fs;
                        if (this.root != null && this.localMapper.discover(fs = new RelocatablePathMapper.FS(){

                            @Override
                            public boolean exists(String path) {
                                FileObject fo = LogReader.this.fileSystem.findResource(path);
                                return fo != null && fo.isValid();
                            }
                        }, this.root, path) && (fo = this.fileSystem.findResource((resolvedPath = this.localMapper.getPath(path)).getPath())) != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    } else {
                        path = fo.getPath();
                        fo = this.fileSystem.findResource(resolvedPath.getPath());
                        if (fo != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    }
                }
            }
            this.alreadyConverted.put(originalPath, path);
        }
        return path;
    }

    private PathMap getPathMapper(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteSyncSupport.getPathMap((Project)p);
        }
        return null;
    }

    private ExecutionEnvironment getExecutionEnvironment(MakeConfiguration conf) {
        ExecutionEnvironment env = null;
        if (conf != null) {
            env = conf.getDevelopmentHost().getExecutionEnvironment();
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private MakeConfiguration getConfiguration(ProjectProxy project) {
        MakeConfigurationDescriptor confDescr;
        ConfigurationDescriptorProvider pdp;
        if (project != null && project.getProject() != null && (pdp = (ConfigurationDescriptorProvider)project.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && pdp.gotDescriptor() && (confDescr = pdp.getConfigurationDescriptor()) != null) {
            return confDescr.getActiveConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "LogReader is run for {0}", this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                MakeConfiguration conf = this.getConfiguration(this.project);
                ExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(conf);
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                        this.isWindows = true;
                    }
                }
                catch (ConnectionManager.CancellationException ex) {
                    ex.printStackTrace(System.err);
                }
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(executionEnvironment);
                BufferedReader in = new BufferedReader(new FileReader(file));
                long length = file.length();
                long read = 0L;
                int done = 0;
                if (length <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int nFoundFiles = 0;
                try {
                    while (!isStoped.get()) {
                        String oneMoreLine;
                        String line = in.readLine();
                        if (line == null) {
                            break;
                        }
                        read += (long)(line.length() + 1);
                        line = line.trim();
                        while (line.endsWith("\\") && (oneMoreLine = in.readLine()) != null) {
                            line = line.substring(0, line.length() - 1) + " " + oneMoreLine.trim();
                        }
                        line = LogReader.trimBackApostropheCalls(line, pkgConfig);
                        String[] cmds = pattern.split(line);
                        for (int i = 0; i < cmds.length; ++i) {
                            if (!this.parseLine(cmds[i].trim(), storage)) continue;
                            ++nFoundFiles;
                        }
                        if (read * 100L / length <= (long)done || done >= 100) continue;
                        ++done;
                        if (progress == null) continue;
                        progress.increment(null);
                    }
                }
                finally {
                    if (progress != null) {
                        progress.done();
                    }
                }
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Files found: {0}", nFoundFiles);
                    DwarfSource.LOG.log(Level.FINE, "Files included in result: {0}", this.result.size());
                }
                in.close();
            }
            catch (IOException ex) {
                DwarfSource.LOG.log(Level.INFO, "Cannot read file " + this.fileName, ex);
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
        if (this.result == null) {
            this.setWorkingDir(this.root);
            this.run(progress, isStoped, storage);
            if (this.subFolders != null) {
                this.subFolders.clear();
                this.subFolders = null;
                this.findBase.clear();
                this.findBase = null;
            }
        }
        return this.result;
    }

    private int getMakeLevel(String line) {
        int i2;
        int i1 = line.indexOf(91);
        if (i1 > 0 && (i2 = line.indexOf(93)) > i1) {
            String s = line.substring(i1 + 1, i2);
            try {
                int res = Integer.parseInt(s);
                return res;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return -1;
    }

    private void enterMakeStack(String dir, int level) {
        if (level < 0) {
            return;
        }
        for (int i = this.makeStack.size(); i <= level; ++i) {
            this.makeStack.add(new ArrayList());
        }
        List<String> list = this.makeStack.get(level);
        list.add(dir);
    }

    private boolean leaveMakeStack(String dir, int level) {
        if (level < 0) {
            return false;
        }
        if (this.makeStack.size() <= level) {
            return false;
        }
        List<String> list = this.makeStack.get(level);
        for (String s : list) {
            if (!s.equals(dir)) continue;
            list.remove(s);
            return true;
        }
        return false;
    }

    private List<String> getMakeTop(int level) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = Math.min(this.makeStack.size(), level - 1); i >= 0; --i) {
            List<String> list = this.makeStack.get(i);
            if (list.size() <= 0) continue;
            if (res.isEmpty()) {
                res.addAll(list);
                continue;
            }
            if (list.size() <= 1) continue;
            res.addAll(list);
        }
        return res;
    }

    private void popPath() {
        if (this.relativesTo.size() > 1) {
            this.relativesTo.pop();
        }
    }

    private String peekPath() {
        if (this.relativesTo.size() > 1) {
            return this.relativesTo.peek();
        }
        return this.root;
    }

    private void popLevel() {
        if (this.relativesLevel.size() > 1) {
            this.relativesLevel.pop();
        }
    }

    private Integer peekLevel() {
        if (this.relativesLevel.size() > 1) {
            return this.relativesLevel.peek();
        }
        return 0;
    }

    private String convertWindowsRelativePath(String path) {
        if (Utilities.isWindows() && (path.startsWith("/") || path.startsWith("\\"))) {
            if (path.length() > 3 && (path.charAt(2) == '/' || path.charAt(2) == '\\') && Character.isLetter(path.charAt(1))) {
                path = "" + path.charAt(1) + ":" + path.substring(2);
            } else if (path.startsWith("/cygdrive/")) {
                path = path.substring("/cygdrive/".length());
                path = "" + path.charAt(0) + ':' + path.substring(1);
            } else if (this.root.length() > 1 && this.root.charAt(1) == ':') {
                path = this.root.substring(0, 2) + path;
            }
        }
        return path;
    }

    private boolean checkDirectoryChange(String line) {
        String d;
        String dir;
        Matcher m;
        boolean found;
        String workDir = null;
        String message = null;
        if (line.startsWith(CURRENT_DIRECTORY)) {
            workDir = this.convertPath(line.substring(CURRENT_DIRECTORY.length() + 1).trim());
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Current working directory] ";
            }
        } else if (line.indexOf(ENTERING_DIRECTORY) >= 0) {
            String dirMessage = line.substring(line.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = workDir = this.convertWindowsRelativePath(workDir);
            this.enterMakeStack(workDir, this.getMakeLevel(line));
        } else if (line.indexOf(LEAVING_DIRECTORY) >= 0) {
            List<String> paths;
            int level;
            String dirMessage = line.substring(line.indexOf(LEAVING_DIRECTORY) + LEAVING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Leaving directory] ";
            }
            if (this.leaveMakeStack(workDir, level = this.getMakeLevel(line)) && (paths = this.getMakeTop(level)).size() == 1) {
                this.baseWorkingDir = paths.get(0);
            }
        } else if (line.startsWith(LABEL_CD)) {
            int end = line.indexOf(MAKE_DELIMITER);
            workDir = this.convertPath((end == -1 ? line : line.substring(0, end)).substring(LABEL_CD.length()).trim());
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [ cd ] ";
            }
            if (workDir.startsWith("/")) {
                this.baseWorkingDir = workDir = this.convertWindowsRelativePath(workDir);
            }
        } else if (line.startsWith("/") && line.indexOf(" ") < 0) {
            workDir = this.convertPath(line.trim());
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [just path string] ";
            }
        } else if (line.indexOf("make") >= 0 && (found = (m = MAKE_DIRECTORY.matcher(line)).find()) && m.start() == 0) {
            String levelString = m.group(1);
            int level = levelString == null ? 0 : Integer.valueOf(levelString);
            int baseLavel = this.peekLevel();
            workDir = m.group(2);
            workDir = this.convertPath(workDir);
            workDir = this.convertWindowsRelativePath(workDir);
            if (level > baseLavel) {
                this.isEntered = true;
                this.relativesLevel.push(level);
                this.isEntered = true;
            } else if (level == baseLavel) {
                this.isEntered = !this.isEntered;
            } else {
                this.isEntered = false;
                this.popLevel();
            }
            if (this.isEntered) {
                this.relativesTo.push(workDir);
            } else {
                this.popPath();
                workDir = this.peekPath();
            }
        }
        if (workDir == null || workDir.length() == 0) {
            return false;
        }
        if (Utilities.isWindows() && workDir.startsWith("/cygdrive/") && workDir.length() > 11) {
            workDir = "" + workDir.charAt(10) + ":" + workDir.substring(11);
        }
        if (workDir.charAt(0) == '/' || workDir.charAt(0) == '\\' || workDir.length() > 1 && workDir.charAt(1) == ':') {
            if (new File(workDir).exists()) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, message);
                }
                this.setWorkingDir(workDir);
                return true;
            }
            String netFile = this.fixNetHost(workDir);
            if (netFile != null) {
                this.setWorkingDir(netFile);
            }
        }
        if (new File(dir = this.workingDir + File.separator + workDir).exists()) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        if (Utilities.isWindows() && workDir.length() > 3 && workDir.charAt(0) == '/' && workDir.charAt(2) == '/' && new File(d = "" + workDir.charAt(1) + ":" + workDir.substring(2)).exists()) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(d);
            return true;
        }
        if (this.baseWorkingDir != null && new File(dir = this.baseWorkingDir + File.separator + workDir).exists()) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        return false;
    }

    private String fixNetHost(String dir) {
        int i;
        if (this.root.startsWith("/net/") && (i = this.root.indexOf(47, 5)) > 0) {
            String netFile;
            String localPath = this.root.substring(i);
            String prefix = this.root.substring(0, i);
            if (dir.startsWith(localPath) && new File(netFile = prefix + dir).exists()) {
                return netFile;
            }
        }
        return null;
    }

    private String[] findCompiler(String line, Set<String> patterns, boolean checkExe) {
        for (String pattern : patterns) {
            int[] find = this.find(line, pattern);
            if (find != null) {
                return new String[]{pattern, line.substring(find[2])};
            }
            if (!checkExe || (find = this.find(line, pattern + ".exe")) == null) continue;
            return new String[]{pattern, line.substring(find[2])};
        }
        return null;
    }

    private int[] find(String line, String pattern) {
        int binaryStart;
        int start;
        int fromIndex = 0;
        while (true) {
            char c;
            char next;
            if ((start = line.indexOf(pattern, fromIndex)) < 0) {
                return null;
            }
            fromIndex = start + 1;
            int prev = 32;
            if (start > 0) {
                prev = line.charAt(start - 1);
            }
            if (prev != 32 && prev != 9 && prev != 47 && prev != 92 || start + pattern.length() >= line.length() || (next = line.charAt(start + pattern.length())) != ' ' && next != '\t') continue;
            binaryStart = start;
            if (prev != 47 && prev != 92) break;
            int first = prev;
            int i = start - 2;
            while (i >= 0 && (c = line.charAt(i)) != ' ' && c != '\t') {
                binaryStart = i--;
                first = c;
            }
            if (first != 45) break;
        }
        int end = start + pattern.length();
        return new int[]{start, end, binaryStart};
    }

    LineInfo testCompilerInvocation(String line) {
        LineInfo li = new LineInfo(line);
        String[] compiler = this.findCompiler(line, this.C_NAMES, this.isWindows);
        if (compiler != null) {
            li.compilerType = CompilerType.C;
            li.compiler = compiler[0];
            li.compileLine = compiler[1];
        } else {
            compiler = this.findCompiler(line, this.CPP_NAMES, this.isWindows);
            if (compiler != null) {
                li.compilerType = CompilerType.CPP;
                li.compiler = compiler[0];
                li.compileLine = compiler[1];
            } else {
                compiler = this.findCompiler(line, this.FORTRAN_NAMES, this.isWindows);
                if (compiler != null) {
                    li.compilerType = CompilerType.FORTRAN;
                    li.compiler = compiler[0];
                    li.compileLine = compiler[1];
                }
            }
        }
        return li;
    }

    private void setWorkingDir(String workingDir) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "**>> new working dir: {0}", workingDir);
        }
        this.workingDir = CndFileUtils.normalizeFile((File)new File(workingDir)).getAbsolutePath();
    }

    private void setGuessWorkingDir(String workingDir) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "**>> alternative guess working dir: {0}", workingDir);
        }
        this.guessWorkingDir = CndFileUtils.normalizeFile((File)new File(workingDir)).getAbsolutePath();
    }

    private boolean parseLine(String line, CompileLineStorage storage) {
        if (this.checkDirectoryChange(line)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        LineInfo li = this.testCompilerInvocation(line);
        if (li.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(li, storage);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String line, PkgConfigManager.PkgConfig pkgConfig) {
        int j;
        int i = line.indexOf(96);
        if (line.lastIndexOf(96) == i) {
            return line;
        }
        if (i < 0 || i == line.length() - 1) {
            return line;
        }
        StringBuilder out = new StringBuilder();
        if (i > 0) {
            out.append(line.substring(0, i));
        }
        if ((j = (line = line.substring(i + 1)).indexOf(96)) < 0) {
            return line;
        }
        String pkg = line.substring(0, j);
        if (pkg.startsWith(PKG_CONFIG_PATTERN)) {
            PkgConfigManager.PackageConfiguration pc;
            pkg = pkg.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer st = new StringTokenizer(pkg);
            boolean readFlags = false;
            String findPkg = null;
            while (st.hasMoreTokens()) {
                String aPkg = st.nextToken();
                if (aPkg.equals("--cflags")) {
                    readFlags = true;
                    continue;
                }
                if (aPkg.startsWith("-")) {
                    readFlags = false;
                    continue;
                }
                findPkg = aPkg;
            }
            if (readFlags && pkgConfig != null && findPkg != null && (pc = pkgConfig.getPkgConfig(findPkg)) != null) {
                for (String p : pc.getIncludePaths()) {
                    out.append(" -I").append(p);
                }
                for (String p : pc.getMacros()) {
                    out.append(" -D").append(p);
                }
                out.append(" ");
            }
        } else if (pkg.startsWith(CYGPATH_PATTERN)) {
            pkg = pkg.substring(CYGPATH_PATTERN.length());
            int start = 0;
            for (int i1 = 0; i1 < pkg.length(); ++i1) {
                char c = pkg.charAt(i1);
                if (c != ' ' && c != '\t') continue;
                start = i1;
                if (i1 + 1 < pkg.length() && pkg.charAt(i1 + 1) != '-') break;
            }
            if ((pkg = pkg.substring(start).trim()).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                out.append(pkg);
            }
        } else if (pkg.startsWith(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                if (st.hasMoreTokens()) {
                    out.append(st.nextToken());
                }
            }
        } else if (pkg.contains(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(pkg.indexOf(ECHO_PATTERN) + ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                if (st.hasMoreTokens()) {
                    out.append(st.nextToken());
                }
            }
        }
        out.append(line.substring(j + 1));
        return LogReader.trimBackApostropheCalls(out.toString(), pkgConfig);
    }

    private void gatherLine(LineInfo li, CompileLineStorage storage) {
        String line = li.compileLine;
        ArrayList<String> userIncludes = new ArrayList<String>();
        HashMap<String, String> userMacros = new HashMap<String, String>();
        ArrayList<String> undefinedMacros = new ArrayList<String>();
        ArrayList<String> languageArtifacts = new ArrayList<String>();
        List sourcesList = DiscoveryUtils.gatherCompilerLine((String)line, (DiscoveryUtils.LogOrigin)DiscoveryUtils.LogOrigin.BuildLog, userIncludes, userMacros, undefinedMacros, null, languageArtifacts, (ProjectBridge)this.compilerSettings.getProjectBridge(), (li.compilerType == CompilerType.CPP ? 1 : 0) != 0);
        for (String what : sourcesList) {
            String file;
            if (what == null || what.endsWith(".s") || what.endsWith(".S")) continue;
            boolean isRelative = true;
            if (this.isPathAbsolute(what)) {
                what = this.convertWindowsRelativePath(what);
                isRelative = false;
                file = what;
            } else {
                file = this.workingDir + "/" + what;
            }
            ArrayList<String> userIncludesCached = new ArrayList<String>(userIncludes.size());
            for (String s : userIncludes) {
                s = this.convertWindowsRelativePath(s);
                userIncludesCached.add(PathCache.getString(s));
            }
            HashMap<String, String> userMacrosCached = new HashMap<String, String>(userMacros.size());
            for (Map.Entry e : userMacros.entrySet()) {
                if (e.getValue() == null) {
                    userMacrosCached.put(PathCache.getString((String)e.getKey()), null);
                    continue;
                }
                userMacrosCached.put(PathCache.getString((String)e.getKey()), PathCache.getString((String)e.getValue()));
            }
            File f = new File(file);
            if (f.exists() && f.isFile()) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**** Gotcha: {0}", file);
                }
                this.result.add(new CommandLineSource(li, languageArtifacts, this.workingDir, what, userIncludesCached, userMacrosCached, undefinedMacros, storage));
                continue;
            }
            if (!isRelative && !(file = this.convertPath(what)).equals(what)) {
                what = file;
                f = new File(file);
                if (f.exists() && f.isFile()) {
                    if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                        DwarfSource.LOG.log(Level.FINE, "**** Gotcha: {0}", file);
                    }
                    this.result.add(new CommandLineSource(li, languageArtifacts, this.workingDir, what, userIncludesCached, userMacrosCached, undefinedMacros, storage));
                    continue;
                }
            }
            if (this.guessWorkingDir != null && !what.startsWith("/") && (f = new File(this.guessWorkingDir + "/" + what)).exists() && f.isFile()) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**** Gotcha guess: {0}", file);
                }
                this.result.add(new CommandLineSource(li, languageArtifacts, this.guessWorkingDir, what, userIncludesCached, userMacrosCached, undefinedMacros, storage));
                continue;
            }
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, "**** Not found {0}", file);
            }
            if (what.startsWith("/") || userIncludes.size() + userMacros.size() <= 0) continue;
            List<String> res = this.findFiles(what);
            if (res == null || res.isEmpty()) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "** And there is no such file under root");
                }
            } else {
                if (res.size() == 1) {
                    this.result.add(new CommandLineSource(li, languageArtifacts, res.get(0), what, userIncludes, userMacros, undefinedMacros, storage));
                    if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                        DwarfSource.LOG.log(Level.FINE, "** Gotcha: {0}{1}{2}", new Object[]{res.get(0), File.separator, what});
                    }
                    this.setGuessWorkingDir(res.get(0));
                    continue;
                }
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**There are several candidates and I'm not clever enough yet to find correct one.");
                }
            }
            if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
            DwarfSource.LOG.log(Level.FINE, "{0} [{1}]", new Object[]{line.length() > 120 ? line.substring(0, 117) + ">>>" : line, what});
        }
    }

    private boolean isPathAbsolute(CharSequence path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        if (CharSequenceUtils.indexOf((CharSequence)path, (char)':') == 1) {
            if (path.length() == 2) {
                return false;
            }
            return path.charAt(2) == '\\' || path.charAt(2) == '/';
        }
        return false;
    }

    private List<String> getFiles(String name) {
        this.getSubfolders();
        return this.findBase.get(name);
    }

    private List<String> findFiles(String relativePath) {
        List<String> files;
        int j;
        String name;
        relativePath = relativePath.replace('\\', '/');
        int i = relativePath.lastIndexOf(47);
        String relativeFolder = null;
        if (i > 0) {
            name = relativePath.substring(i + 1);
            relativeFolder = relativePath.substring(0, i);
        } else {
            name = relativePath;
        }
        String subFolder = null;
        if (relativeFolder != null && (j = relativeFolder.lastIndexOf("../")) >= 0) {
            subFolder = relativePath.substring(j + 2);
        }
        if ((files = this.getFiles(name)) != null) {
            ArrayList<String> res = new ArrayList<String>(files.size());
            for (String s : files) {
                if (relativeFolder == null) {
                    res.add(s);
                    if (res.size() <= 1) continue;
                    return res;
                }
                if (subFolder == null) {
                    String path = s;
                    if (!path.endsWith(relativeFolder) || path.length() <= relativeFolder.length() + 1) continue;
                    path = path.substring(0, path.length() - relativeFolder.length() - 1);
                    res.add(path);
                    if (res.size() <= 1) continue;
                    return res;
                }
                for (String sub : this.getSubfolders()) {
                    String pathCandidate = this.normalizeFile(sub + "/" + relativePath);
                    int j2 = pathCandidate.lastIndexOf(47);
                    if (j2 <= 0 || !this.subFolders.contains(pathCandidate = pathCandidate.substring(0, j2))) continue;
                    res.add(sub);
                    if (res.size() <= 1) continue;
                    return res;
                }
            }
            return res;
        }
        return null;
    }

    private String normalizeFile(String path) {
        int i;
        path = path.replace("/./", "/");
        while ((i = path.indexOf("/../")) >= 0) {
            int prev = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                prev = j;
                break;
            }
            if (prev == -1) break;
            path = path.substring(0, prev) + path.substring(i + 3);
        }
        return path;
    }

    private Set<String> getSubfolders() {
        if (this.subFolders == null) {
            this.subFolders = new HashSet();
            File f = new File(this.root);
            this.gatherSubFolders(f, new HashSet<String>());
            this.findBase = new HashMap<String, List<String>>();
            this.initSearchMap();
        }
        return this.subFolders;
    }

    private void gatherSubFolders(File d, HashSet<String> antiLoop) {
        if (d.exists() && d.isDirectory() && d.canRead()) {
            String canPath;
            if (CndPathUtilitities.isIgnoredFolder((File)d)) {
                return;
            }
            try {
                canPath = d.getCanonicalPath();
            }
            catch (IOException ex) {
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.add(canPath);
                this.subFolders.add(d.getAbsolutePath().replace('\\', '/'));
                File[] ff = d.listFiles();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        if (!ff[i].isDirectory()) continue;
                        this.gatherSubFolders(ff[i], antiLoop);
                    }
                }
            }
        }
    }

    private void initSearchMap() {
        for (String it : this.subFolders) {
            File[] ff;
            File d = new File(it);
            if (!d.exists() || !d.isDirectory() || !d.canRead() || (ff = d.listFiles()) == null) continue;
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].isFile()) continue;
                List<String> l = this.findBase.get(ff[i].getName());
                if (l == null) {
                    l = new ArrayList<String>();
                    this.findBase.put(ff[i].getName(), l);
                }
                l.add(d.getAbsolutePath().replace('\\', '/'));
            }
        }
    }

    static class CommandLineSource
    extends RelocatableImpl
    implements SourceFileProperties {
        private String sourceName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private ItemProperties.LanguageStandard standard = ItemProperties.LanguageStandard.Unknown;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private List<String> undefinedMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private CompileLineStorage storage;
        private int handler = -1;

        CommandLineSource(LineInfo li, List<String> languageArtifacts, String compilePath, String sourcePath, List<String> userIncludes, Map<String, String> userMacros, List<String> undefs, CompileLineStorage storage) {
            String mime;
            this.language = li.getLanguage();
            if (languageArtifacts.contains("c")) {
                this.language = ItemProperties.LanguageKind.C;
            } else if (languageArtifacts.contains("c++")) {
                this.language = ItemProperties.LanguageKind.CPP;
            } else if (this.language == ItemProperties.LanguageKind.Unknown || "cl".equals(li.compiler)) {
                mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)sourcePath);
                if ("text/x-c++".equals(mime)) {
                    if (li.getLanguage() != ItemProperties.LanguageKind.CPP) {
                        this.language = ItemProperties.LanguageKind.CPP;
                    }
                } else if ("text/x-c".equals(mime) && li.getLanguage() != ItemProperties.LanguageKind.C) {
                    this.language = ItemProperties.LanguageKind.C;
                }
            } else if (this.language == ItemProperties.LanguageKind.C && !li.compiler.equals("cc") && "text/x-c++".equals(mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)sourcePath))) {
                this.language = ItemProperties.LanguageKind.CPP;
            }
            for (String lang : languageArtifacts) {
                if ("c89".equals(lang)) {
                    this.standard = ItemProperties.LanguageStandard.C89;
                    continue;
                }
                if ("c99".equals(lang)) {
                    this.standard = ItemProperties.LanguageStandard.C89;
                    continue;
                }
                if ("c++98".equals(lang)) {
                    this.standard = ItemProperties.LanguageStandard.CPP;
                    continue;
                }
                if (!"c++11".equals(lang)) continue;
                this.standard = ItemProperties.LanguageStandard.CPP11;
            }
            this.compiler = li.compiler;
            this.compilePath = compilePath;
            this.sourceName = sourcePath;
            if (CndPathUtilitities.isPathAbsolute((CharSequence)this.sourceName)) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)compilePath, (String)this.sourceName);
            } else {
                this.fullName = compilePath + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = userIncludes;
            this.userMacros = userMacros;
            this.undefinedMacros = undefs;
            this.storage = storage;
            if (storage != null) {
                this.handler = storage.putCompileLine(li.compileLine);
            }
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getCompileLine() {
            if (this.storage != null && this.handler != -1) {
                return this.storage.getCompileLine(this.handler);
            }
            return null;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public List<String> getUndefinedMacros() {
            return this.undefinedMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return this.standard;
        }
    }

    static class LineInfo {
        public String compileLine;
        public String compiler;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String line) {
            this.compileLine = line;
        }

        ItemProperties.LanguageKind getLanguage() {
            switch (this.compilerType) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }
    }

    static enum CompilerType {
        CPP,
        C,
        FORTRAN,
        UNKNOWN;

    }
}

