/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatableImpl;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class DwarfSource
extends RelocatableImpl
implements SourceFileProperties {
    public static final Logger LOG = Logger.getLogger(DwarfSource.class.getName());
    private static final boolean CUT_LOCALHOST_NET_ADRESS = Boolean.getBoolean("cnd.dwarfdiscovery.cut.localhost.net.adress");
    private static boolean ourGatherMacros = true;
    private static boolean ourGatherIncludes = true;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private static final String CYG_DRIVE_WIN = "\\cygdrive\\";
    private static final String CYGWIN_PATH = ":/cygwin";
    private String cygwinPath;
    private String sourceName;
    private final ItemProperties.LanguageKind language;
    private final ItemProperties.LanguageStandard standard;
    private List<String> systemIncludes;
    private boolean haveSystemIncludes;
    private Map<String, String> userMacros;
    private List<String> undefinedMacros;
    private Map<String, String> systemMacros;
    private boolean haveSystemMacros;
    private CompilerSettings normilizeProvider;
    private final Map<String, BaseDwarfProvider.GrepEntry> grepBase;
    private String compilerName;
    private final CompileLineStorage storage;
    private int handler = -1;
    private final CompilerSettings compilerSettings;

    DwarfSource(CompilationUnitInterface cu, ItemProperties.LanguageKind lang, ItemProperties.LanguageStandard standard, CompilerSettings compilerSettings, Map<String, BaseDwarfProvider.GrepEntry> grepBase, CompileLineStorage storage) throws IOException {
        this.language = lang;
        this.grepBase = grepBase;
        this.standard = standard;
        this.storage = storage;
        this.compilerSettings = compilerSettings;
        this.initCompilerSettings(compilerSettings, lang);
        this.initSourceSettings(cu, lang);
    }

    private void countFileName(CompilationUnitInterface cu) throws IOException {
        this.fullName = cu.getSourceFileAbsolutePath();
        this.fullName = this.fixFileName(this.fullName);
        this.fullName = DiscoveryUtils.normalizeAbsolutePath((String)this.fullName);
        this.fullName = this.linkSupport(this.fullName);
        if (this.fullName != null && this.normilizeProvider.isWindows()) {
            this.fullName = this.fullName.replace('/', '\\');
        }
        this.fullName = PathCache.getString(this.fullName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Compilation unit full name:{0}", this.fullName);
        }
    }

    private void initCompilerSettings(CompilerSettings compilerSettings, ItemProperties.LanguageKind lang) {
        List<String> list = compilerSettings.getSystemIncludePaths(lang);
        if (list != null) {
            this.systemIncludes = new ArrayList<String>(list);
            if (compilerSettings.isWindows()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "CompileFlavor:{0}", compilerSettings.getCompileFlavor());
                }
                if (compilerSettings.getCompileFlavor() != null && compilerSettings.getCompileFlavor().isCygwinCompiler()) {
                    this.cygwinPath = compilerSettings.getCygwinDrive();
                    if (this.cygwinPath == null) {
                        for (String path : list) {
                            char c;
                            int i = path.toLowerCase().indexOf(CYGWIN_PATH);
                            if (i <= 0 || this.cygwinPath != null) continue;
                            this.cygwinPath = "" + Character.toUpperCase(path.charAt(0)) + CYGWIN_PATH;
                            i += CYGWIN_PATH.length();
                            while (i < path.length() && (c = path.charAt(i)) != '\\') {
                                this.cygwinPath = this.cygwinPath + "" + c;
                                ++i;
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Detect cygwinPath:{0}", this.cygwinPath);
                            }
                            break;
                        }
                    }
                }
            }
        } else {
            this.systemIncludes = new ArrayList<String>();
        }
        this.haveSystemIncludes = this.systemIncludes.size() > 0;
        Map<String, String> map = compilerSettings.getSystemMacroDefinitions(lang);
        this.systemMacros = map != null ? new HashMap<String, String>(map) : new HashMap<String, String>();
        this.haveSystemMacros = this.systemMacros.size() > 0;
        this.normilizeProvider = compilerSettings;
    }

    public String getCompilePath() {
        return this.compilePath;
    }

    public String getCompileLine() {
        if (this.storage != null && this.handler != -1) {
            return this.storage.getCompileLine(this.handler);
        }
        return null;
    }

    public String getItemPath() {
        return this.fullName;
    }

    public String getItemName() {
        return this.sourceName;
    }

    public List<String> getUserInludePaths() {
        return this.userIncludes;
    }

    public List<String> getSystemInludePaths() {
        return this.systemIncludes;
    }

    public Set<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    public List<String> getUndefinedMacros() {
        return this.undefinedMacros;
    }

    public Map<String, String> getSystemMacros() {
        return this.systemMacros;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    public ItemProperties.LanguageStandard getLanguageStandard() {
        return this.standard;
    }

    public String getCompilerName() {
        return this.compilerName;
    }

    private String fixFileName(String fileName) {
        if (fileName == null) {
            return fileName;
        }
        if (this.normilizeProvider.isWindows()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Try to fix win name:{0}", fileName);
            }
            if (fileName.startsWith(CYG_DRIVE_UNIX)) {
                fileName = fileName.substring(CYG_DRIVE_UNIX.length());
                fileName = "" + Character.toUpperCase(fileName.charAt(0)) + ':' + fileName.substring(1);
                fileName = fileName.replace('\\', '/');
                if (this.cygwinPath == null) {
                    this.cygwinPath = "" + Character.toUpperCase(fileName.charAt(0)) + CYGWIN_PATH;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Set cygwinPath:{0}", this.cygwinPath);
                    }
                }
            } else {
                int i = fileName.indexOf(CYG_DRIVE_WIN);
                if (i > 0) {
                    if (this.cygwinPath == null) {
                        this.cygwinPath = "" + Character.toUpperCase(fileName.charAt(0)) + CYGWIN_PATH;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Set cygwinPath:{0}", this.cygwinPath);
                        }
                    }
                    fileName = fileName.substring(i + CYG_DRIVE_UNIX.length());
                    fileName = "" + Character.toUpperCase(fileName.charAt(0)) + ':' + fileName.substring(1);
                    fileName = fileName.replace('\\', '/');
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "\t{0}", fileName);
            }
        } else if (CUT_LOCALHOST_NET_ADRESS && Utilities.isUnix() && fileName.startsWith("/net/")) {
            try {
                String u;
                InetAddress addr = InetAddress.getLocalHost();
                String host = addr.getHostName();
                if (host != null && host.length() > 0 && fileName.startsWith(u = "/net/" + host + "/")) {
                    fileName = fileName.substring(u.length() - 1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return fileName;
    }

    private String linkSupport(String name) {
        if (this.normilizeProvider.isWindows() && !new File(name).exists()) {
            String link = name + ".lnk";
            if (new File(link).exists()) {
                String resolve = LinkSupport.getOriginalFile((String)link);
                if (resolve != null) {
                    name = resolve;
                }
            } else {
                StringTokenizer st = new StringTokenizer(name, "\\/");
                StringBuilder buf = new StringBuilder();
                while (st.hasMoreTokens()) {
                    String path;
                    String token = st.nextToken();
                    if (buf.length() > 0) {
                        buf.append('\\');
                    }
                    buf.append(token);
                    if (token.length() <= 0 || token.charAt(token.length() - 1) == ':' || new File(path = buf.toString()).exists()) continue;
                    link = path + ".lnk";
                    if (new File(link).exists()) {
                        String resolve = LinkSupport.getOriginalFile((String)link);
                        if (resolve != null) {
                            buf = new StringBuilder(resolve);
                            continue;
                        }
                        return name;
                    }
                    return name;
                }
                name = buf.toString();
            }
        }
        return name;
    }

    static String extractCompilerName(CompilationUnitInterface cui, ItemProperties.LanguageKind lang) throws IOException {
        String compilerName = null;
        if (cui instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)cui;
            if (cu.getCompileOptions() == null) {
                compilerName = cu.getProducer();
            } else {
                int endIndex;
                String compileOptions = cu.getCompileOptions();
                int startIndex = compileOptions.indexOf("R=");
                if (startIndex >= 0 && (endIndex = compileOptions.indexOf(";", startIndex)) >= 0) {
                    compilerName = PathCache.getString(compileOptions.substring(startIndex + 2, endIndex));
                }
                if (compilerName == null) {
                    compilerName = lang == ItemProperties.LanguageKind.CPP ? PathCache.getString("CC") : (lang == ItemProperties.LanguageKind.C ? PathCache.getString("cc") : (lang == ItemProperties.LanguageKind.Fortran ? PathCache.getString("fortran") : PathCache.getString("unknown")));
                }
            }
        }
        return compilerName;
    }

    static boolean isSunStudioCompiler(CompilationUnitInterface cu) throws IOException {
        if (cu instanceof CompilationUnit) {
            return ((CompilationUnit)cu).getCompileOptions() != null;
        }
        return cu.getCommandLine() != null && !cu.getCommandLine().isEmpty();
    }

    private void initSourceSettings(CompilationUnitInterface cu, ItemProperties.LanguageKind lang) throws IOException {
        this.userIncludes = new ArrayList();
        this.userMacros = new HashMap<String, String>();
        this.undefinedMacros = new ArrayList<String>();
        this.includedFiles = new HashSet();
        this.countFileName(cu);
        this.compilerName = PathCache.getString(DwarfSource.extractCompilerName(cu, lang));
        this.compilePath = PathCache.getString(this.fixFileName(cu.getCompilationDir()));
        this.sourceName = PathCache.getString(cu.getSourceFileName());
        if (this.compilePath == null && this.sourceName.lastIndexOf(47) > 0) {
            int i = this.sourceName.lastIndexOf(47);
            this.compilePath = this.sourceName.substring(0, i);
            this.sourceName = this.sourceName.substring(i + 1);
        } else {
            if (this.sourceName.startsWith("/")) {
                this.sourceName = DiscoveryUtils.getRelativePath((String)this.compilePath, (String)this.sourceName);
            }
            if (this.compilePath == null) {
                if (this.fullName != null && this.fullName.lastIndexOf(47) > 0) {
                    int i = this.fullName.lastIndexOf(47);
                    this.compilePath = this.fullName.substring(0, i);
                } else {
                    this.compilePath = "";
                }
            }
        }
    }

    public void process(CompilationUnitInterface cu) throws IOException {
        String line = cu.getCommandLine();
        if (line != null && line.length() > 0) {
            if (this.storage != null) {
                this.handler = this.storage.putCompileLine(line);
            }
            this.gatherLine(line);
            if (cu instanceof CompilationUnit) {
                this.gatherIncludedFiles((CompilationUnit)cu);
            }
        } else if (cu instanceof CompilationUnit) {
            this.gatherMacros((CompilationUnit)cu);
            this.gatherIncludes((CompilationUnit)cu);
        }
    }

    private void addUserIncludePath(String path) {
        if (!this.userIncludes.contains(path)) {
            this.userIncludes.add(path);
        }
    }

    private void gatherLine(String line) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Process command line {0}", line);
        }
        ArrayList aUserIncludes = new ArrayList();
        HashMap aUserMacros = new HashMap();
        ArrayList languageArtifacts = new ArrayList();
        ArrayList aUndefinedMacros = new ArrayList();
        DiscoveryUtils.gatherCompilerLine((String)line, (DiscoveryUtils.LogOrigin)DiscoveryUtils.LogOrigin.DwarfCompileLine, aUserIncludes, aUserMacros, aUndefinedMacros, null, languageArtifacts, (ProjectBridge)this.compilerSettings.getProjectBridge(), (this.language == ItemProperties.LanguageKind.CPP ? 1 : 0) != 0);
        for (String string : aUserIncludes) {
            String include = PathCache.getString(string);
            this.addUserIncludePath(include);
        }
        for (String string : aUndefinedMacros) {
            this.undefinedMacros.add(PathCache.getString(string));
        }
        for (Map.Entry entry : aUserMacros.entrySet()) {
            this.userMacros.put(PathCache.getString((String)entry.getKey()), (String)entry.getValue());
        }
    }

    private String fixCygwinPath(String path) {
        if (this.cygwinPath != null) {
            if (path.startsWith("/usr/lib/")) {
                path = this.cygwinPath + path.substring(4);
            } else if (path.startsWith("/usr")) {
                path = this.cygwinPath + path;
            }
        }
        if (path.startsWith(CYG_DRIVE_UNIX)) {
            path = this.fixFileName(path);
        }
        if (this.normilizeProvider.isWindows()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    private boolean isSystemPath(String path) {
        path = this.fixCygwinPath(path);
        if ((path = this.normalizePath(path)).startsWith("/") || path.length() > 2 && path.charAt(1) == ':') {
            HashSet<String> bits = new HashSet<String>();
            for (String cp : this.systemIncludes) {
                if (path.equals(cp)) {
                    return true;
                }
                for (String sub : this.grepSystemFolder((String)cp).includes) {
                    bits.add(sub);
                }
            }
            for (String cp : this.systemIncludes) {
                for (String sub : bits) {
                    if (!path.startsWith(cp) || !path.substring(cp.length()).startsWith(sub)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void addpath(String path) {
        if (this.haveSystemIncludes) {
            if (!this.isSystemPath(path)) {
                path = this.fixCygwinPath(path);
                path = this.normalizePath(path);
                this.addUserIncludePath(PathCache.getString(path));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "\tuser:{0}", path);
                }
            }
        } else if (path.startsWith("/usr")) {
            path = this.fixCygwinPath(path);
            path = this.normalizePath(path);
            if (!this.systemIncludes.contains(path = PathCache.getString(path))) {
                this.systemIncludes.add(path);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "\tsystem:{0}", path);
            }
        } else {
            path = this.fixCygwinPath(path);
            path = this.normalizePath(path);
            this.addUserIncludePath(PathCache.getString(path));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "\tuser:{0}", path);
            }
        }
    }

    private String normalizePath(String path) {
        if (path.startsWith("/") || path.length() > 2 && path.charAt(1) == ':') {
            return this.normilizeProvider.getNormalizedPath(path);
        }
        return path;
    }

    private void gatherIncludes(CompilationUnit cu) throws IOException {
        if (!ourGatherIncludes) {
            return;
        }
        DwarfStatementList dwarfTable = cu.getStatementList();
        if (dwarfTable == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Include paths not found");
            }
            return;
        }
        Iterator it = dwarfTable.getIncludeDirectories().iterator();
        while (it.hasNext()) {
            this.addpath((String)it.next());
        }
        ArrayList<String> list = this.grepSourceFile((String)this.fullName).includes;
        for (String path : list) {
            this.cutFolderPrefix(path, dwarfTable);
        }
        List dwarfIncludedFiles = dwarfTable.getFilePaths();
        DwarfMacinfoTable dwarfMacroTable = cu.getMacrosTable();
        if (dwarfMacroTable != null) {
            List commandLineIncludedFiles = dwarfMacroTable.getCommandLineIncludedFiles();
            Iterator i$ = commandLineIncludedFiles.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                String includedSource = this.processPath(dwarfTable.getFilePath(i));
                if (this.fullName.replace('\\', '/').equals(includedSource)) continue;
                this.processPath(dwarfTable.getFilePath(i), list, dwarfTable, false);
            }
        }
        for (String path : dwarfIncludedFiles) {
            this.processPath(path, list, dwarfTable, true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Include paths:{0}", this.userIncludes);
        }
    }

    private void processPath(String path, List<String> list, DwarfStatementList dwarfTable, boolean isPath) {
        String includeFullName = this.processPath(path);
        if (isPath) {
            String userPath;
            int i = includeFullName.lastIndexOf(47);
            if (i > 0 && !this.isSystemPath(userPath = includeFullName.substring(0, i))) {
                list = this.grepSourceFile((String)includeFullName).includes;
                for (String included : list) {
                    this.cutFolderPrefix(included, dwarfTable);
                }
                this.addpath(userPath);
            }
        } else {
            this.addpath(includeFullName);
        }
        this.includedFiles.add(PathCache.getString(includeFullName));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Included file:{0}", includeFullName);
        }
    }

    private String processPath(String path) {
        path = path.replace('\\', '/');
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Included file original:{0}", path);
        }
        String includeFullName = path.startsWith("./") ? this.compilePath + path.substring(1) : (path.startsWith("../") ? this.compilePath + File.separator + path : (!path.startsWith("/") && (path.length() <= 2 || path.charAt(1) != ':') ? this.compilePath + File.separator + path : this.fixCygwinPath(path)));
        if (this.normilizeProvider.isWindows()) {
            includeFullName = includeFullName.replace('\\', '/');
        }
        includeFullName = this.normalizePath(includeFullName);
        return includeFullName;
    }

    private void cutFolderPrefix(String path, DwarfStatementList dwarfTable) {
        if (this.normilizeProvider.isWindows()) {
            path = path.replace('\\', '/');
        }
        if (path.indexOf(47) > 0) {
            int n = path.lastIndexOf(47);
            String name = path.substring(n + 1);
            String relativeDir = path.substring(0, n);
            String dir = "/" + relativeDir;
            List paths = dwarfTable.getPathsForFile(name);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Try to find new include paths for:{0} in folder {1}", new Object[]{name, dir});
            }
            for (String dwarfPath : paths) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "    candidate:{0}", dwarfPath);
                }
                if (dwarfPath.endsWith(dir)) {
                    String found = dwarfPath.substring(0, dwarfPath.length() - dir.length());
                    found = this.fixCygwinPath(found);
                    if (this.userIncludes.contains(found = this.normalizePath(found))) break;
                    if (this.haveSystemIncludes) {
                        boolean system = false;
                        if (found.startsWith("/") || found.length() > 2 && found.charAt(1) == ':') {
                            system = this.systemIncludes.contains(found);
                        }
                        if (system) break;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "    Find new include path:{0}", found);
                        }
                        this.addUserIncludePath(PathCache.getString(found));
                        break;
                    }
                    if (dwarfPath.startsWith("/usr")) break;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "    Find new include path:{0}", found);
                    }
                    this.addUserIncludePath(PathCache.getString(found));
                    break;
                }
                if (!dwarfPath.equals(relativeDir)) continue;
                String found = ".";
                if (this.userIncludes.contains(found)) break;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "    Find new include path:{0}", found);
                }
                this.addUserIncludePath(PathCache.getString(found));
                break;
            }
        }
    }

    private void gatherIncludedFiles(CompilationUnit cu) throws IOException {
        if (!ourGatherIncludes) {
            return;
        }
        DwarfStatementList dwarfTable = cu.getStatementList();
        if (dwarfTable == null) {
            return;
        }
        Iterator i$ = dwarfTable.getFilePaths().iterator();
        while (i$.hasNext()) {
            String path;
            String includeFullName = path = (String)i$.next();
            if (path.startsWith("./")) {
                includeFullName = this.compilePath + path.substring(1);
            } else if (path.startsWith("../")) {
                includeFullName = this.compilePath + File.separator + path;
            }
            includeFullName = this.normalizePath(includeFullName);
            this.includedFiles.add(PathCache.getString(includeFullName));
        }
    }

    private void gatherMacros(CompilationUnit cu) throws IOException {
        if (!ourGatherMacros) {
            return;
        }
        DwarfMacinfoTable dwarfTable = cu.getMacrosTable();
        if (dwarfTable == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Macros not found");
            }
            return;
        }
        int firstMacroLine = this.grepSourceFile((String)this.fullName).firstMacroLine;
        List table = dwarfTable.getCommandLineMarcos();
        for (DwarfMacinfoEntry entry : table) {
            String sysValue;
            String macro;
            String def = entry.definition;
            int i = def.indexOf(32);
            String value = null;
            if (i > 0) {
                macro = PathCache.getString(def.substring(0, i));
                value = PathCache.getString(def.substring(i + 1).trim());
            } else {
                macro = PathCache.getString(def);
            }
            if (firstMacroLine == entry.lineNum && macro.equals(this.grepSourceFile((String)this.fullName).firstMacro)) break;
            if (this.haveSystemMacros && this.systemMacros.containsKey(macro) && this.equalValues(sysValue = this.systemMacros.get(macro), value)) continue;
            this.userMacros.put(macro, value);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Macros:{0}", this.userMacros);
        }
    }

    private boolean equalValues(String sysValue, String value) {
        if (value == null || "1".equals(value)) {
            return sysValue == null || "1".equals(sysValue);
        }
        return value.equals(sysValue);
    }

    private BaseDwarfProvider.GrepEntry grepSystemFolder(String path) {
        File[] ff;
        BaseDwarfProvider.GrepEntry res = this.grepBase.get(path);
        if (res != null) {
            return res;
        }
        res = new BaseDwarfProvider.GrepEntry();
        File folder = new File(path);
        if (folder.exists() && folder.canRead() && folder.isDirectory() && (ff = folder.listFiles()) != null) {
            for (File f : ff) {
                if (!f.exists() || !f.canRead() || f.isDirectory()) continue;
                ArrayList<String> l = this.grepSourceFile((String)f.getAbsolutePath()).includes;
                for (String i : l) {
                    if (i.indexOf("..") > 0 || i.startsWith("/") || i.indexOf(":") > 0 || i.indexOf(47) <= 0) continue;
                    int n = i.lastIndexOf(47);
                    String relativeDir = i.substring(0, n);
                    String dir = "/" + relativeDir;
                    if (res.includes.contains(dir)) continue;
                    res.includes.add(PathCache.getString(dir));
                }
            }
        }
        ArrayList<String> secondLevel = new ArrayList<String>();
        for (String sub : res.includes) {
            File subFolder = new File(path + sub);
            try {
                if (!subFolder.getCanonicalFile().getAbsolutePath().startsWith(path + sub)) continue;
                for (String s : this.grepSystemFolder((String)new StringBuilder().append((String)path).append((String)sub).toString()).includes) {
                    secondLevel.add(s);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        for (String s : secondLevel) {
            if (res.includes.contains(s)) continue;
            res.includes.add(PathCache.getString(s));
        }
        this.grepBase.put(PathCache.getString(path), res);
        return res;
    }

    private BaseDwarfProvider.GrepEntry grepSourceFile(String fileName) {
        BaseDwarfProvider.GrepEntry res = this.grepBase.get(fileName);
        if (res != null) {
            return res;
        }
        res = new BaseDwarfProvider.GrepEntry();
        File file = new File(fileName);
        if (file.exists() && file.canRead() && !file.isDirectory()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                int lineNo = 0;
                block11: while ((line = in.readLine()) != null) {
                    StringTokenizer st;
                    int i;
                    int first;
                    ++lineNo;
                    int size = line.length();
                    if (size == 0) continue;
                    block12: for (first = 0; first < size; ++first) {
                        switch (line.charAt(first)) {
                            case '\t': 
                            case ' ': {
                                continue block12;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                continue block11;
                            }
                        }
                    }
                    if (++first >= size) continue;
                    block13: while (first < size) {
                        switch (line.charAt(first)) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case 'i': {
                                if (first + 1 >= size || line.charAt(first + 1) == 'n') break block13;
                                continue block11;
                            }
                            case 'd': {
                                break block13;
                            }
                            default: {
                                continue block11;
                            }
                        }
                        ++first;
                    }
                    if (first >= size) continue;
                    if ((line = line.substring(first)).startsWith("include")) {
                        char c;
                        int i2;
                        if ((line = line.substring(7).trim()).length() <= 2) continue;
                        if (line.startsWith("/*") && (i2 = line.indexOf("*/")) > 0) {
                            line = line.substring(i2 + 2).trim();
                        }
                        if ((c = line.charAt(0)) == '\"') {
                            if (line.indexOf(34, 1) <= 0) continue;
                            res.includes.add(PathCache.getString(line.substring(1, line.indexOf(34, 1))));
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, "find in source:{0}", line.substring(1, line.indexOf(34, 1)));
                            continue;
                        }
                        if (c != '<' || line.indexOf(62) <= 0) continue;
                        res.includes.add(PathCache.getString(line.substring(1, line.indexOf(62))));
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "find in source:{0}", line.substring(1, line.indexOf(62)));
                        continue;
                    }
                    if (!line.startsWith("define") || res.firstMacroLine != -1 || (line = line.substring(6).trim()).length() <= 0) continue;
                    if (line.startsWith("/*") && (i = line.indexOf("*/")) > 0) {
                        line = line.substring(i + 2).trim();
                    }
                    if (!(st = new StringTokenizer(line, "\t (")).hasMoreTokens()) continue;
                    res.firstMacroLine = lineNo;
                    res.firstMacro = PathCache.getString(st.nextToken());
                }
                in.close();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Cannot grep file: " + fileName, ex);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Cannot grep file:{0}", fileName);
        }
        res.includes.trimToSize();
        this.grepBase.put(fileName, res);
        return res;
    }
}

