/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;

public abstract class DwarfProvider
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    public static final String EXECUTABLES_KEY = "binaries";

    public DwarfProvider() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXECUTABLES_KEY, new ProviderProperty(){
            private String[] myPath;

            public String getName() {
                return DwarfProvider.i18n("Binaries_Files_Name");
            }

            public String getDescription() {
                return DwarfProvider.i18n("Binaries_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String[]) {
                    this.myPath = (String[])value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFiles;
            }
        });
    }

    public String getID() {
        return "dwarf-binaries";
    }

    public String getName() {
        return DwarfProvider.i18n("Binaries_Provider_Name");
    }

    public String getDescription() {
        return DwarfProvider.i18n("Binaries_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    String[] objFileNames;
                    if (this.myFileProperties == null && (objFileNames = (String[])DwarfProvider.this.getProperty(DwarfProvider.EXECUTABLES_KEY).getValue()) != null) {
                        this.myFileProperties = DwarfProvider.this.getSourceFileProperties(objFileNames, null, project, null, new CompileLineStorage());
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (DwarfProvider.this.isStoped.get()) break;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            if (DwarfProvider.this.isStoped.get()) break;
                            File file = new File(path);
                            if (!CndFileUtils.exists((File)file)) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(DwarfProvider.class, (String)id);
    }
}

