/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.openide.util.Utilities;

public class CompilerSettings {
    private ProjectBridge projectBridge;
    private final List<String> systemIncludePathsC;
    private final List<String> systemIncludePathsCpp;
    private final Map<String, String> systemMacroDefinitionsC;
    private final Map<String, String> systemMacroDefinitionsCpp;
    private Map<String, String> normalizedPaths = new ConcurrentHashMap<String, String>();
    private final CompilerFlavor compileFlavor;
    private final String cygwinDriveDirectory;
    private final boolean isWindows;

    public CompilerSettings(ProjectProxy project) {
        this.projectBridge = DiscoveryUtils.getProjectBridge((ProjectProxy)project);
        this.systemIncludePathsCpp = DiscoveryUtils.getSystemIncludePaths((ProjectBridge)this.projectBridge, (boolean)true);
        this.systemIncludePathsC = DiscoveryUtils.getSystemIncludePaths((ProjectBridge)this.projectBridge, (boolean)false);
        this.systemMacroDefinitionsCpp = DiscoveryUtils.getSystemMacroDefinitions((ProjectBridge)this.projectBridge, (boolean)true);
        this.systemMacroDefinitionsC = DiscoveryUtils.getSystemMacroDefinitions((ProjectBridge)this.projectBridge, (boolean)false);
        this.compileFlavor = DiscoveryUtils.getCompilerFlavor((ProjectBridge)this.projectBridge);
        this.isWindows = Utilities.isWindows();
        this.cygwinDriveDirectory = this.isWindows ? DiscoveryUtils.getCygwinDrive((ProjectBridge)this.projectBridge) : null;
    }

    public ProjectBridge getProjectBridge() {
        return this.projectBridge;
    }

    public List<String> getSystemIncludePaths(ItemProperties.LanguageKind lang) {
        if (lang == ItemProperties.LanguageKind.CPP) {
            return this.systemIncludePathsCpp;
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return this.systemIncludePathsC;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getSystemMacroDefinitions(ItemProperties.LanguageKind lang) {
        if (lang == ItemProperties.LanguageKind.CPP) {
            return this.systemMacroDefinitionsCpp;
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return this.systemMacroDefinitionsC;
        }
        return Collections.emptyMap();
    }

    public String getNormalizedPath(String path) {
        String res = this.normalizedPaths.get(path);
        if (res == null) {
            res = PathCache.getString(this.normalizePath(path));
            this.normalizedPaths.put(PathCache.getString(path), res);
        }
        return res;
    }

    protected String normalizePath(String path) {
        path = DiscoveryUtils.normalizeAbsolutePath((String)path);
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public CompilerFlavor getCompileFlavor() {
        return this.compileFlavor;
    }

    public String getCygwinDrive() {
        return this.cygwinDriveDirectory;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public void dispose() {
        this.systemIncludePathsC.clear();
        this.systemIncludePathsCpp.clear();
        this.systemMacroDefinitionsC.clear();
        this.systemMacroDefinitionsCpp.clear();
        this.normalizedPaths.clear();
        this.normalizedPaths = new ConcurrentHashMap<String, String>();
    }
}

