/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.Relocatable;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapperImpl;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class BaseDwarfProvider
implements DiscoveryProvider {
    public static final String RESTRICT_SOURCE_ROOT = "restrict_source_root";
    public static final String RESTRICT_COMPILE_ROOT = "restrict_compile_root";
    protected AtomicBoolean isStoped = new AtomicBoolean(false);
    private RelocatablePathMapperImpl mapper;
    private CompilerSettings myCommpilerSettings;
    private Map<String, GrepEntry> grepBase = new ConcurrentHashMap<String, GrepEntry>();

    public final void init(ProjectProxy project) {
        this.myCommpilerSettings = new CompilerSettings(project);
        this.mapper = new RelocatablePathMapperImpl(project);
    }

    public boolean isApplicable(ProjectProxy project) {
        return true;
    }

    public void stop() {
        this.isStoped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String[] objFileName, Progress progress, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
        CountDownLatch countDownLatch = new CountDownLatch(objFileName.length);
        RequestProcessor rp = new RequestProcessor("Parallel analyzing", CndUtils.getNumberCndWorkerThreads());
        try {
            ConcurrentHashMap map = new ConcurrentHashMap();
            for (String file : objFileName) {
                MyRunnable r = new MyRunnable(countDownLatch, file, map, progress, project, dlls, storage);
                rp.post((Runnable)r);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ArrayList<SourceFileProperties> list = new ArrayList<SourceFileProperties>();
            list.addAll(map.values());
            ArrayList<SourceFileProperties> arrayList = list;
            return arrayList;
        }
        finally {
            PathCache.dispose();
            this.grepBase.clear();
            this.grepBase = new ConcurrentHashMap<String, GrepEntry>();
            this.getCommpilerSettings().dispose();
        }
    }

    protected FileSystem getFileSystem(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteFileUtil.getProjectSourceFileSystem((Project)p);
        }
        return CndFileUtils.getLocalFileSystem();
    }

    protected RelocatablePathMapper getRelocatablePathMapper() {
        return this.mapper;
    }

    protected FileObject resolvePath(ProjectProxy project, String buildArtifact, final FileSystem fileSystem, SourceFileProperties f, String name) {
        RelocatablePathMapper.ResolvedPath resolvedPath;
        FileObject fo = fileSystem.findResource(name);
        if (!(f instanceof Relocatable)) {
            return fo;
        }
        RelocatablePathMapper.FS fs = new RelocatablePathMapper.FS(){

            @Override
            public boolean exists(String path) {
                FileObject fo = fileSystem.findResource(path);
                return fo != null && fo.isValid();
            }
        };
        String sourceRoot = null;
        if (project != null && (sourceRoot = project.getSourceRoot()) != null && sourceRoot.length() < 2) {
            sourceRoot = null;
        }
        if (sourceRoot == null && (sourceRoot = PathUtilities.getDirName((String)buildArtifact)) != null && sourceRoot.length() < 2) {
            sourceRoot = null;
        }
        if (fo == null || !fo.isValid()) {
            resolvedPath = this.mapper.getPath(name);
            if (resolvedPath == null) {
                if (sourceRoot != null && this.mapper.discover(fs, sourceRoot, name) && (fo = fileSystem.findResource((resolvedPath = this.mapper.getPath(name)).getPath())) != null && fo.isValid() && fo.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, fs);
                    return fo;
                }
            } else {
                fo = fileSystem.findResource(resolvedPath.getPath());
                if (fo != null && fo.isValid() && fo.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, fs);
                    return fo;
                }
            }
        }
        if (fo != null && fo.isData()) {
            name = fo.getPath();
            resolvedPath = this.mapper.getPath(name);
            if (resolvedPath == null) {
                FileObject resolved;
                if (sourceRoot != null && !name.startsWith(sourceRoot) && this.mapper.discover(fs, sourceRoot, name) && (resolved = fileSystem.findResource((resolvedPath = this.mapper.getPath(name)).getPath())) != null && resolved.isValid() && resolved.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, fs);
                    return resolved;
                }
            } else {
                FileObject resolved = fileSystem.findResource(resolvedPath.getPath());
                if (resolved != null && resolved.isValid() && resolved.isData()) {
                    ((Relocatable)f).resetItemPath(resolvedPath, this.mapper, fs);
                    return resolved;
                }
            }
            sourceRoot = null;
            if (project != null && (sourceRoot = project.getSourceRoot()) != null && sourceRoot.length() < 2) {
                sourceRoot = null;
            }
            if (sourceRoot == null && (sourceRoot = PathUtilities.getBaseName((String)name)) != null && sourceRoot.length() < 2) {
                sourceRoot = null;
            }
            if (sourceRoot != null) {
                ((Relocatable)f).resolveIncludePaths(sourceRoot, this.mapper, fs);
            }
            return fo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processObjectFile(String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
        String s;
        String s2;
        if (this.isStoped.get()) {
            return true;
        }
        ProjectBridge bridge = null;
        if (project.getProject() != null) {
            bridge = new ProjectBridge(project.getProject());
        }
        String restrictSourceRoot = null;
        ProviderProperty p = this.getProperty(RESTRICT_SOURCE_ROOT);
        if (p != null && (s2 = (String)p.getValue()).length() > 0) {
            restrictSourceRoot = CndFileUtils.normalizeFile((File)new File(s2)).getAbsolutePath();
        }
        String restrictCompileRoot = null;
        p = this.getProperty(RESTRICT_COMPILE_ROOT);
        if (p != null && (s = (String)p.getValue()).length() > 0) {
            restrictCompileRoot = CndFileUtils.normalizeFile((File)new File(s)).getAbsolutePath();
        }
        FileSystem fileSystem = this.getFileSystem(project);
        for (SourceFileProperties f : this.getSourceFileProperties(file, map, project, dlls, storage)) {
            if (this.isStoped.get()) break;
            String name = f.getItemPath();
            if (name == null || restrictSourceRoot != null && !name.startsWith(restrictSourceRoot)) continue;
            FileObject fo = this.resolvePath(project, file, fileSystem, f, name);
            if (fo == null) {
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "Not Exist {0}", name);
                continue;
            }
            boolean skip = false;
            if (restrictCompileRoot != null && f.getCompilePath() != null && !f.getCompilePath().startsWith(restrictCompileRoot)) {
                String relPath;
                Item item;
                skip = true;
                if (bridge != null && (item = bridge.getProjectItem(relPath = bridge.getRelativepath(fo.getPath()))) != null) {
                    skip = false;
                }
            }
            if (skip) {
                if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                DwarfSource.LOG.log(Level.FINE, "Skiped {0}", name);
                continue;
            }
            name = fo.getPath();
            SourceFileProperties existed = map.get(name);
            if (existed == null) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserInludePaths().size() < f.getUserInludePaths().size()) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserInludePaths().size() != f.getUserInludePaths().size()) continue;
            if (existed.getUserMacros().size() < f.getUserMacros().size()) {
                map.put(name, f);
                continue;
            }
            if (existed.getUserMacros().size() != f.getUserMacros().size() || this.macrosWeight(existed) >= this.macrosWeight(f)) continue;
            map.put(name, f);
        }
        if (progress != null) {
            Progress progress2 = progress;
            synchronized (progress2) {
                progress.increment(file);
            }
        }
        return false;
    }

    private int macrosWeight(SourceFileProperties f) {
        int sum = 0;
        for (String m : f.getUserMacros().keySet()) {
            for (int i = 0; i < m.length(); ++i) {
                sum += m.charAt(i);
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicableImpl sizeComilationUnit(String objFileName, Set<String> dlls, boolean findMain) {
        HashMap<String, AtomicInteger> compilers;
        int foundDebug;
        TreeMap<String, AtomicInteger> roots;
        TreeMap<String, AtomicInteger> realRoots;
        ArrayList searchPaths;
        ArrayList<String> errors;
        MyPosition position;
        int sunStudio;
        int res;
        block36: {
            res = 0;
            sunStudio = 0;
            Dwarf dump = null;
            position = null;
            errors = new ArrayList<String>();
            searchPaths = new ArrayList();
            realRoots = new TreeMap<String, AtomicInteger>();
            roots = new TreeMap<String, AtomicInteger>();
            foundDebug = 0;
            compilers = new HashMap<String, AtomicInteger>();
            try {
                Object lang;
                dump = new Dwarf(objFileName);
                Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    ItemProperties.LanguageKind language;
                    CompilationUnitInterface cu = iterator.next();
                    if (cu == null || cu.getSourceFileName() == null || (lang = cu.getSourceLanguage()) == null) continue;
                    ++foundDebug;
                    String path = cu.getSourceFileAbsolutePath();
                    this.incrementRoot(path, realRoots);
                    path = DiscoveryUtils.normalizeAbsolutePath((String)path);
                    if (!CndFileUtils.isExistingFile((String)path)) {
                        String fileFinder = Dwarf.fileFinder((String)objFileName, (String)path);
                        if (fileFinder == null || !CndFileUtils.isExistingFile((String)(fileFinder = DiscoveryUtils.normalizeAbsolutePath((String)fileFinder)))) continue;
                        path = fileFinder;
                    }
                    if (LANG.DW_LANG_C.toString().equals(lang) || LANG.DW_LANG_C89.toString().equals(lang) || LANG.DW_LANG_C99.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.C;
                        ++res;
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.CPP;
                        ++res;
                    } else {
                        if (!LANG.DW_LANG_Fortran77.toString().equals(lang) && !LANG.DW_LANG_Fortran90.toString().equals(lang) && !LANG.DW_LANG_Fortran95.toString().equals(lang)) continue;
                        language = ItemProperties.LanguageKind.Fortran;
                        ++res;
                    }
                    this.incrementRoot(path, roots);
                    String compilerName = DwarfSource.extractCompilerName(cu, language);
                    if (compilerName != null) {
                        AtomicInteger count = (AtomicInteger)compilers.get(compilerName);
                        if (count == null) {
                            count = new AtomicInteger();
                            compilers.put(compilerName, count);
                        }
                        count.incrementAndGet();
                    }
                    if (DwarfSource.isSunStudioCompiler(cu)) {
                        ++sunStudio;
                    }
                    if (!findMain || position != null || !cu.hasMain()) continue;
                    if (cu instanceof CompilationUnit) {
                        List topLevelEntries = ((CompilationUnit)cu).getTopLevelEntries();
                        for (DwarfEntry entry : topLevelEntries) {
                            if (entry.getKind() != TAG.DW_TAG_subprogram || !"main".equals(entry.getName()) || !entry.isExternal()) continue;
                            position = new MyPosition(path, entry.getLine());
                        }
                        continue;
                    }
                    position = new MyPosition(path, 1);
                }
                if (dlls == null) break block36;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                lang = dlls;
                synchronized (lang) {
                    for (String dll : pubNames.getDlls()) {
                        dlls.add(dll);
                    }
                    searchPaths.addAll(pubNames.getPaths());
                }
            }
            catch (FileNotFoundException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"FileNotFoundException", (Object)objFileName));
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (WrongFileFormatException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"WrongFileFormatException", (Object)objFileName));
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (IOException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"IOException", (Object)objFileName, (Object)ex.toString()));
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            catch (Exception ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"Exception", (Object)objFileName, (Object)ex.toString()));
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            finally {
                if (dump != null) {
                    dump.dispose();
                }
            }
        }
        int max = 0;
        String top = "";
        for (Map.Entry entry : compilers.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= max) continue;
            max = ((AtomicInteger)entry.getValue()).get();
            top = (String)entry.getKey();
        }
        ArrayList<String> dllResult = null;
        if (dlls != null) {
            dllResult = new ArrayList<String>(dlls);
        }
        ArrayList pathsResult = null;
        if (dlls != null) {
            pathsResult = new ArrayList(searchPaths);
        }
        String commonRoot = this.getRoot(roots);
        if (res > 0) {
            return new ApplicableImpl(true, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
        }
        if (errors.isEmpty()) {
            if (foundDebug > 0) {
                String notFoundRoot = this.getRoot(realRoots);
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"BadDebugInformation", (Object)notFoundRoot));
            } else {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"NotFoundDebugInformation", (Object)objFileName));
            }
        }
        return new ApplicableImpl(false, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
    }

    private void incrementRoot(String path, Map<String, AtomicInteger> roots) {
        int i = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (i >= 0) {
            String folder = path.substring(0, i);
            AtomicInteger val = roots.get(folder);
            if (val == null) {
                val = new AtomicInteger();
                roots.put(folder, val);
            }
            val.incrementAndGet();
        }
    }

    private String getCommonPart(String path, String commonRoot) {
        String[] splitPath = path.split("/");
        ArrayList<String> list1 = new ArrayList<String>();
        boolean isUnixPath = false;
        for (int i = 0; i < splitPath.length; ++i) {
            if (!splitPath[i].isEmpty()) {
                list1.add(splitPath[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixPath = true;
        }
        String[] splitRoot = commonRoot.split("/");
        ArrayList<String> list2 = new ArrayList<String>();
        boolean isUnixRoot = false;
        for (int i = 0; i < splitRoot.length; ++i) {
            if (!splitRoot[i].isEmpty()) {
                list2.add(splitRoot[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixRoot = true;
        }
        if (isUnixPath != isUnixRoot) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (isUnixPath) {
            buf.append('/');
        }
        for (int i = 0; i < Math.min(list1.size(), list2.size()) && ((String)list1.get(i)).equals(list2.get(i)); ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append((String)list1.get(i));
        }
        return buf.toString();
    }

    private String getRoot(TreeMap<String, AtomicInteger> roots) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<AtomicInteger> resCount = new ArrayList<AtomicInteger>();
        String current = null;
        AtomicInteger currentCount = null;
        for (Map.Entry<String, AtomicInteger> entry : roots.entrySet()) {
            int length;
            if (current == null) {
                current = entry.getKey();
                currentCount = new AtomicInteger(entry.getValue().get());
                continue;
            }
            String s = this.getCommonPart(entry.getKey(), current);
            String[] split = s.split("/");
            int n = length = split.length > 0 && split[0].isEmpty() ? split.length - 1 : split.length;
            if (length >= 2) {
                current = s;
                currentCount.addAndGet(entry.getValue().get());
                continue;
            }
            res.add(current);
            resCount.add(currentCount);
            current = entry.getKey();
            currentCount = new AtomicInteger(entry.getValue().get());
        }
        if (current != null) {
            res.add(current);
            resCount.add(currentCount);
        }
        TreeMap newRoots = new TreeMap();
        String bestRoot = null;
        int bestCount = 0;
        for (int i = 0; i < res.size(); ++i) {
            newRoots.put(res.get(i), resCount.get(i));
            if (bestRoot == null) {
                bestRoot = (String)res.get(i);
                bestCount = ((AtomicInteger)resCount.get(i)).get();
                continue;
            }
            if (bestCount >= ((AtomicInteger)resCount.get(i)).get()) continue;
            bestRoot = (String)res.get(i);
            bestCount = ((AtomicInteger)resCount.get(i)).get();
        }
        return bestRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
        ArrayList<SourceFileProperties> list;
        block39: {
            list = new ArrayList<SourceFileProperties>();
            Dwarf dump = null;
            try {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Process file {0}", objFileName);
                }
                dump = new Dwarf(objFileName);
                Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    CompilationUnitInterface cu = iterator.next();
                    if (cu == null) continue;
                    if (this.isStoped.get()) break;
                    if (cu.getSourceFileName() == null) {
                        if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                        DwarfSource.LOG.log(Level.FINE, "Compilation unit has broken name in file {0}", objFileName);
                        continue;
                    }
                    String lang = cu.getSourceLanguage();
                    if (lang == null) {
                        if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                        DwarfSource.LOG.log(Level.FINE, "Compilation unit has unresolved language in file {0}for {1}", new Object[]{objFileName, cu.getSourceFileName()});
                        continue;
                    }
                    DwarfSource source = null;
                    if (LANG.DW_LANG_C.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_C89.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C89, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_C99.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C99, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.CPP, ItemProperties.LanguageStandard.Unknown, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_Fortran77.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F77, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_Fortran90.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F90, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (LANG.DW_LANG_Fortran95.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F95, this.getCommpilerSettings(), this.grepBase, storage);
                    } else if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                        DwarfSource.LOG.log(Level.FINE, "Unknown language: {0}", lang);
                    }
                    if (source == null) continue;
                    if (source.getCompilePath() == null) {
                        if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                        DwarfSource.LOG.log(Level.FINE, "Compilation unit has NULL compile path in file {0}", objFileName);
                        continue;
                    }
                    String name = source.getItemPath();
                    SourceFileProperties old = map.get(name);
                    if (old != null && old.getUserInludePaths().size() > 0) {
                        if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
                        DwarfSource.LOG.log(Level.FINE, "Compilation unit already exist. Skip {0}", name);
                        continue;
                    }
                    source.process(cu);
                    list.add(source);
                }
                if (dlls == null) break block39;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                Set<String> set = dlls;
                synchronized (set) {
                    for (String dll : pubNames.getDlls()) {
                        dlls.add(dll);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (WrongFileFormatException ex) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
                }
            }
            catch (IOException ex) {
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            catch (Exception ex) {
                DwarfSource.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
            }
            finally {
                if (dump != null) {
                    dump.dispose();
                }
            }
        }
        return list;
    }

    public CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    private static class MyPosition
    implements DiscoveryExtensionInterface.Position {
        private final String path;
        private final int line;

        private MyPosition(String path, int line) {
            this.path = path;
            this.line = line;
        }

        public String getFilePath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.path + ":" + this.line;
        }
    }

    private class MyRunnable
    implements Runnable {
        private final String file;
        private final Map<String, SourceFileProperties> map;
        private final Progress progress;
        private final CountDownLatch countDownLatch;
        private final ProjectProxy project;
        private final Set<String> dlls;
        private final CompileLineStorage storage;

        private MyRunnable(CountDownLatch countDownLatch, String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
            this.file = file;
            this.map = map;
            this.progress = progress;
            this.countDownLatch = countDownLatch;
            this.project = project;
            this.dlls = dlls;
            this.storage = storage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!BaseDwarfProvider.this.isStoped.get()) {
                    Thread.currentThread().setName("Parallel analyzing " + this.file);
                    BaseDwarfProvider.this.processObjectFile(this.file, this.map, this.progress, this.project, this.dlls, this.storage);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    public static class GrepEntry {
        ArrayList<String> includes = new ArrayList();
        String firstMacro = null;
        int firstMacroLine = -1;
    }
}

