/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.LogReader;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AnalyzeMakeLog
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String MAKE_LOG_KEY = "make-log-file";
    public static final String MAKE_LOG_PROVIDER_ID = "make-log";
    private Progress progress;

    public AnalyzeMakeLog() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(MAKE_LOG_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Name");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.MakeLogFile;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeMakeLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeMakeLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return MAKE_LOG_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    @Override
    public boolean isApplicable(ProjectProxy project) {
        Object o = this.getProperty("restrict_compile_root").getValue();
        if (o == null || "".equals(o.toString())) {
            this.getProperty("restrict_compile_root").setValue((Object)project.getSourceRoot());
            return true;
        }
        return false;
    }

    private String detectMakeLog(ProjectProxy project) {
        String root = project.getSourceRoot();
        if (root != null && root.length() > 1) {
            int i = root.indexOf("/usr/src/");
            if (i < 0 && root.endsWith("/usr/src")) {
                i = root.indexOf("/usr/src");
            }
            if (i > 0) {
                File[] ff;
                String latest = null;
                String logfolder = root.substring(0, i) + "/log";
                File log = new File(logfolder);
                if (log.exists() && log.isDirectory() && log.canRead() && (ff = log.listFiles()) != null) {
                    block0: for (File when : ff) {
                        File[] ww;
                        if (!when.exists() || !when.isDirectory() || !when.canRead() || (ww = when.listFiles()) == null) continue;
                        for (File l : ww) {
                            String folder2;
                            String current = l.getAbsolutePath();
                            if (!current.endsWith("/nightly.log")) continue;
                            if (latest == null) {
                                latest = current;
                                continue block0;
                            }
                            String folder1 = latest.substring(0, latest.lastIndexOf("/nightly.log"));
                            if (folder1.compareTo(folder2 = current.substring(0, current.lastIndexOf("/nightly.log"))) >= 0) continue block0;
                            latest = current;
                            continue block0;
                        }
                    }
                }
                return latest;
            }
        }
        return null;
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
        String set = (String)this.getProperty(MAKE_LOG_KEY).getValue();
        if ((set == null || set.length() == 0) && (set = this.detectMakeLog(project)) != null && set.length() > 0) {
            this.getProperty(MAKE_LOG_KEY).setValue((Object)set);
        }
        if (set == null || set.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeMakeLog.class, (String)"NotFoundMakeLog")));
        }
        return new ApplicableImpl(true, null, null, 80, false, null, null, null, null);
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, CompileLineStorage storage) {
        ProviderProperty p = this.getProperty("restrict_compile_root");
        String root = "";
        if (p != null) {
            root = (String)p.getValue();
        }
        List<SourceFileProperties> res = this.runLogReader(objFileName, root, this.progress, project, storage);
        this.progress = null;
        return res;
    }

    List<SourceFileProperties> runLogReader(String objFileName, String root, Progress progress, ProjectProxy project, CompileLineStorage storage) {
        FileSystem fileSystem = this.getFileSystem(project);
        LogReader clrf = new LogReader(objFileName, root, project, this.getRelocatablePathMapper(), fileSystem);
        List<SourceFileProperties> list = clrf.getResults(progress, this.isStoped, storage);
        return list;
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        this.progress = progress;
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        String set = (String)AnalyzeMakeLog.this.getProperty(AnalyzeMakeLog.MAKE_LOG_KEY).getValue();
                        if (set == null || set.length() == 0) {
                            set = AnalyzeMakeLog.this.detectMakeLog(project);
                        }
                        if (set != null && set.length() > 0) {
                            this.myFileProperties = AnalyzeMakeLog.this.getSourceFileProperties(new String[]{set}, null, project, null, new CompileLineStorage());
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeMakeLog.this.isStoped.get()) break;
                            if (!(source instanceof DwarfSource)) continue;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            if (AnalyzeMakeLog.this.isStoped.get()) break;
                            File file = new File(path);
                            if (!CndFileUtils.exists((File)file)) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeMakeLog.class, (String)id);
    }
}

