/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.AnalyzeFolder;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RemoteJavaExecution;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AnalyzeExecutable
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String EXECUTABLE_KEY = "executable";
    public static final String LIBRARIES_KEY = "libraries";
    public static final String FILE_SYSTEM = "filesystem";
    public static final String FIND_MAIN_KEY = "find_main";
    public static final String EXECUTABLE_PROVIDER_ID = "dwarf-executable";

    public AnalyzeExecutable() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXECUTABLE_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Executable_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Executable_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFile;
            }
        });
        this.myProperties.put(FILE_SYSTEM, new ProviderProperty(){
            private FileSystem fs;

            public String getName() {
                return "";
            }

            public String getDescription() {
                return "";
            }

            public Object getValue() {
                return this.fs;
            }

            public void setValue(Object value) {
                if (value instanceof FileSystem) {
                    this.fs = (FileSystem)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Object;
            }
        });
        this.myProperties.put(LIBRARIES_KEY, new ProviderProperty(){
            private String[] myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Libraries_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Libraries_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String[]) {
                    this.myPath = (String[])value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFiles;
            }
        });
        this.myProperties.put(FIND_MAIN_KEY, new ProviderProperty(){
            private Boolean findMain = Boolean.TRUE;

            public String getName() {
                return "";
            }

            public String getDescription() {
                return "";
            }

            public Object getValue() {
                return this.findMain;
            }

            public void setValue(Object value) {
                if (value instanceof Boolean) {
                    this.findMain = (Boolean)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Boolean;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return EXECUTABLE_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeExecutable.i18n("Executable_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecutable.i18n("Executable_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
        String set = (String)this.getProperty(EXECUTABLE_KEY).getValue();
        if (set == null || set.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"NoExecutable")));
        }
        boolean findMain = (Boolean)this.getProperty(FIND_MAIN_KEY).getValue();
        HashSet<String> dlls = new HashSet<String>();
        FileSystem fs = (FileSystem)this.getProperty(FILE_SYSTEM).getValue();
        if (fs == null) {
            ApplicableImpl applicable = this.sizeComilationUnit(set, dlls, findMain);
            if (applicable.isApplicable()) {
                return new ApplicableImpl(true, applicable.getErrors(), applicable.getCompilerName(), 70, applicable.isSunStudio(), applicable.getDependencies(), applicable.getSearchPaths(), applicable.getSourceRoot(), applicable.getMainFunction());
            }
            if (applicable.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable((List)applicable.getErrors());
            }
        } else {
            RemoteJavaExecution processor = new RemoteJavaExecution(fs);
            ElfReader.SharedLibraries libs = processor.getDlls(set);
            if (libs != null) {
                return new ApplicableImpl(true, null, null, 0, false, libs.getDlls(), libs.getPaths(), processor.getSourceRoot(processor.getCompileLines(set)), null);
            }
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"CannotAnalyzeExecutable", (Object)set)));
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;
                private Set<String> myDependencies;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    if (this.myDependencies == null) {
                        this.getSourcesConfiguration();
                    }
                    return new ArrayList<String>(this.myDependencies);
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myDependencies = new HashSet<String>();
                        String set = (String)AnalyzeExecutable.this.getProperty(AnalyzeExecutable.EXECUTABLE_KEY).getValue();
                        if (set != null && set.length() > 0) {
                            String[] add = (String[])AnalyzeExecutable.this.getProperty(AnalyzeExecutable.LIBRARIES_KEY).getValue();
                            if (add == null || add.length == 0) {
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(new String[]{set}, null, project, this.myDependencies, new CompileLineStorage());
                            } else {
                                String[] all = new String[add.length + 1];
                                all[0] = set;
                                System.arraycopy(add, 0, all, 1, add.length);
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(all, null, project, this.myDependencies, new CompileLineStorage());
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            if (!(source instanceof DwarfSource)) continue;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            File file = new File(path);
                            if (!CndFileUtils.exists((File)file)) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)id);
    }
}

