/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.litemodel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.dwarfdiscovery.litemodel.DwarfRenderer;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.litemodel.api.Declaration;
import org.netbeans.modules.cnd.litemodel.api.Model;
import org.netbeans.modules.cnd.litemodel.api.ModelAccessor;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;

public class LiteModel
extends ModelAccessor {
    public Model createModel(Project project, ModelAccessor.ModelKind kind) {
        MakeArtifactProvider artifactProvider = (MakeArtifactProvider)project.getLookup().lookup(MakeArtifactProvider.class);
        if (artifactProvider != null) {
            for (MakeArtifact artifact : artifactProvider.getBuildArtifacts()) {
                String output = artifact.getOutput();
                if (output == null) continue;
                if (!CndPathUtilitities.isPathAbsolute((CharSequence)output)) {
                    output = artifact.getWorkingDirectory() + "/" + output;
                }
                return this.createModel(output, kind);
            }
        }
        return null;
    }

    private Model createModel(String binary, ModelAccessor.ModelKind kind) {
        DwarfRenderer renderer = this.LWM(binary, kind);
        final Map<String, Map<String, Declaration>> lwm = renderer.getLWM();
        return new Model(){

            public Map<String, Declaration> getFile(String path) {
                return (Map)lwm.get(path);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DwarfRenderer LWM(String objFileName, ModelAccessor.ModelKind kind) {
        DwarfRenderer dwarfRenderer;
        switch (kind) {
            case TOP_LEVEL_DECLARATIONS: {
                dwarfRenderer = DwarfRenderer.createTopLevelDeclarationsRenderer();
                break;
            }
            case TOP_LEVEL_DECLARATIONS_IN_COMPILATION_UNIT: {
                dwarfRenderer = DwarfRenderer.createTopLevelDeclarationsCompilationUnitsRenderer();
                break;
            }
            default: {
                dwarfRenderer = DwarfRenderer.createFullRenderer();
            }
        }
        Dwarf dump = null;
        try {
            dump = new Dwarf(objFileName);
            Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                String lang;
                CompilationUnitInterface cu = iterator.next();
                if (cu == null || cu.getRoot() == null || cu.getSourceFileName() == null || (lang = cu.getSourceLanguage()) == null || !LANG.DW_LANG_C.toString().equals(lang) && !LANG.DW_LANG_C89.toString().equals(lang) && !LANG.DW_LANG_C99.toString().equals(lang) && !LANG.DW_LANG_C_plus_plus.toString().equals(lang) && !LANG.DW_LANG_Fortran77.toString().equals(lang) && !LANG.DW_LANG_Fortran90.toString().equals(lang) && !LANG.DW_LANG_Fortran95.toString().equals(lang)) continue;
                dwarfRenderer.process(cu);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (WrongFileFormatException ex) {
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
        return dwarfRenderer;
    }
}

