/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfProvider;

public class DwarfAnalyzer {
    public static void analyze(String[] files) {
        DwarfProvider provider = new DwarfProvider(){

            public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
                return new ApplicableImpl(true, null, null, 1, false, null, null, null, null);
            }
        };
        provider.getProperty("binaries").setValue((Object)files);
        DwarfAnalyzer.dumpProject(provider, new ProjectProxy(){

            public boolean createSubProjects() {
                return false;
            }

            public Project getProject() {
                return null;
            }

            public String getMakefile() {
                return null;
            }

            public String getSourceRoot() {
                return null;
            }

            public String getExecutable() {
                return null;
            }

            public String getWorkingFolder() {
                return null;
            }

            public boolean mergeProjectProperties() {
                return false;
            }
        });
    }

    private static void dumpProject(DwarfProvider provider, ProjectProxy project) {
        List<Configuration> confs = provider.analyze(project, null);
        for (Configuration conf : confs) {
            List langList = conf.getProjectConfiguration();
            for (ProjectProperties proj : langList) {
                String lang = ItemProperties.LanguageKind.CPP == proj.getLanguageKind() ? "c++" : "c";
                System.out.println("Project " + lang);
                System.out.println("User include paths:");
                StringBuilder buf = new StringBuilder();
                for (String string : proj.getUserInludePaths()) {
                    System.out.println(string);
                    if (!string.startsWith(File.separator)) continue;
                    if (buf.length() > 0) {
                        buf.append(":");
                    }
                    buf.append(string);
                }
                System.out.println("Configuration string:");
                System.out.println("    " + buf.toString());
                System.out.println("User macros:");
                for (Map.Entry entry : proj.getUserMacros().entrySet()) {
                    System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                List folders = proj.getConfiguredFolders();
                for (FolderProperties folder : folders) {
                    DwarfAnalyzer.dumpFolder(folder);
                }
            }
        }
    }

    private static void dumpFolder(FolderProperties folder) {
        System.out.println("Folder " + folder.getItemPath());
        System.out.println("User include paths:");
        StringBuilder buf = new StringBuilder();
        for (String string : folder.getUserInludePaths()) {
            System.out.println(string);
            if (!string.startsWith(File.separator)) continue;
            if (buf.length() > 0) {
                buf.append(":");
            }
            buf.append(string);
        }
        System.out.println("Configuration string:");
        System.out.println("    " + buf.toString());
        System.out.println("User macros:");
        for (Map.Entry entry : folder.getUserMacros().entrySet()) {
            System.out.println((String)entry.getKey() + "=" + (String)entry.getValue());
        }
    }
}

