/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRemoteDiffEditor
implements ISVNEditor {
    private SVNWCContext context;
    private File target;
    private SVNRepository repository;
    private long revision;
    private boolean walkDeletedDirs;
    private boolean pureRemoteDiff;
    private ISvnDiffCallback diffCallback;
    private long targetRevision;
    private File emptyFile;
    private Map<File, DeletedPath> deletedPaths;
    private DirBaton currentDir;
    private SvnDiffCallbackResult currentResult;
    private FileBaton currentFile;
    private ISVNEventHandler eventHandler;
    private File globalTmpDir;
    private Collection<File> tmpFiles;

    public static SvnNgRemoteDiffEditor createEditor(SVNWCContext context, File target, SVNDepth depth, SVNRepository repository, long revision, boolean walkDeletedDirs, boolean dryRun, boolean pureRemoteDiff, ISvnDiffCallback diffCallback, ISVNEventHandler handler) {
        SvnNgRemoteDiffEditor editor = new SvnNgRemoteDiffEditor();
        editor.context = context;
        editor.target = target;
        editor.repository = repository;
        editor.revision = revision;
        editor.walkDeletedDirs = walkDeletedDirs;
        editor.diffCallback = diffCallback;
        editor.deletedPaths = new HashMap<File, DeletedPath>();
        editor.pureRemoteDiff = pureRemoteDiff;
        editor.tmpFiles = new ArrayList<File>();
        editor.currentResult = new SvnDiffCallbackResult();
        editor.eventHandler = handler;
        return editor;
    }

    public File getGlobalTmpDir() throws SVNException {
        if (this.globalTmpDir == null) {
            this.globalTmpDir = SVNFileUtil.createTempDirectory("svndiff");
        }
        return this.globalTmpDir;
    }

    private DirBaton makeDirBaton(String path, DirBaton parent, boolean added) {
        DirBaton baton = new DirBaton();
        baton.parent = parent;
        baton.added = added;
        baton.wcPath = SVNFileUtil.createFilePath(this.target, path);
        baton.propChanges = new SVNProperties();
        return baton;
    }

    private FileBaton makeFileBaton(String path, boolean added) {
        FileBaton baton = new FileBaton();
        baton.added = added;
        baton.repoPath = path;
        baton.wcPath = SVNFileUtil.createFilePath(this.target, path);
        baton.propChanges = new SVNProperties();
        baton.baseRevision = this.revision;
        return baton;
    }

    private void handleEvent(SVNEvent event) throws SVNException {
        if (event != null && this.eventHandler != null) {
            this.eventHandler.handleEvent(event, -1.0);
        }
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (this.currentFile.skip) {
            return;
        }
        this.currentFile.deltaProcessor = new SVNDeltaProcessor();
        if (!this.currentFile.added) {
            this.currentFile.loadFile(this.context, this.repository, false, this.tmpFiles);
        } else {
            this.currentFile.startRevisionFile = this.getEmptyFile();
        }
        File tmpDir = this.pureRemoteDiff ? this.getGlobalTmpDir() : this.context.getDb().getWCRootTempDir(this.target);
        this.currentFile.endRevisionFile = SVNFileUtil.createUniqueFile(tmpDir, SVNPathUtil.tail(path), ".tmp", false);
        this.tmpFiles.add(this.currentFile.endRevisionFile);
        this.currentFile.deltaProcessor.applyTextDelta(this.currentFile.startRevisionFile, this.currentFile.endRevisionFile, true);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.currentFile.deltaProcessor != null) {
            return this.currentFile.deltaProcessor.textDeltaChunk(diffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.currentFile.deltaProcessor != null) {
            String checksum = this.currentFile.deltaProcessor.textDeltaEnd();
            this.currentFile.resultMd5Checksum = SvnChecksum.fromString("$md5 $" + checksum);
        }
    }

    public void targetRevision(long revision) throws SVNException {
        this.targetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        DirBaton baton = this.makeDirBaton("", null, false);
        baton.wcPath = this.target;
        baton.loadProperties(this.repository, "", revision);
        this.currentDir = baton;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            return;
        }
        SVNNodeKind kind = this.repository.checkPath(path, this.revision);
        SVNEventAction action = SVNEventAction.SKIP;
        this.currentResult.contentState = SVNStatusType.INAPPLICABLE;
        if (kind == SVNNodeKind.FILE) {
            FileBaton b = this.makeFileBaton(path, false);
            b.loadFile(this.context, this.repository, false, this.tmpFiles);
            b.endRevisionFile = this.getEmptyFile();
            String[] mTypes = b.getMimeTypes();
            this.diffCallback.fileDeleted(this.currentResult, b.wcPath, b.startRevisionFile, b.endRevisionFile, mTypes[0], mTypes[1], b.pristineProps);
        } else if (kind == SVNNodeKind.DIR) {
            this.diffCallback.dirDeleted(this.currentResult, SVNFileUtil.createFilePath(this.target, path));
            if (this.walkDeletedDirs) {
                this.diffDeletedDir(path, this.revision, this.repository);
            }
        }
        if (this.currentResult.contentState != SVNStatusType.MISSING && this.currentResult.contentState != SVNStatusType.OBSTRUCTED && !this.currentResult.treeConflicted) {
            action = SVNEventAction.UPDATE_DELETE;
        }
        if (this.eventHandler != null) {
            DeletedPath dp = new DeletedPath();
            dp.action = this.currentResult.treeConflicted ? SVNEventAction.TREE_CONFLICT : action;
            dp.kind = kind;
            dp.state = this.currentResult.contentState;
            this.deletedPaths.put(SVNFileUtil.createFilePath(this.target, path), dp);
        }
    }

    private void diffDeletedDir(String path, long revision, SVNRepository repository) throws SVNException {
        this.context.checkCancelled();
        Collection<SVNDirEntry> entries = repository.getDir(path, revision, null, 1, (Collection)null);
        for (SVNDirEntry entry : entries) {
            if (entry.getName() == null || "".equals(entry.getName())) continue;
            String entryPath = SVNPathUtil.append(path, entry.getName());
            if (entry.getKind() == SVNNodeKind.FILE) {
                FileBaton fb = this.makeFileBaton(entryPath, false);
                fb.loadFile(this.context, repository, false, this.tmpFiles);
                File emptyFile = this.getEmptyFile();
                String[] mTypes = fb.getMimeTypes();
                this.diffCallback.fileDeleted(null, fb.wcPath, fb.startRevisionFile, emptyFile, mTypes[0], mTypes[1], fb.pristineProps);
                continue;
            }
            if (entry.getKind() != SVNNodeKind.DIR) continue;
            this.diffDeletedDir(entryPath, revision, repository);
        }
    }

    private File getEmptyFile() throws SVNException {
        if (this.emptyFile == null) {
            File tmpDir = this.pureRemoteDiff ? this.getGlobalTmpDir() : this.context.getDb().getWCRootTempDir(this.target);
            this.emptyFile = SVNFileUtil.createUniqueFile(tmpDir, "empty", ".tmp", false);
            this.tmpFiles.add(this.emptyFile);
        }
        return this.emptyFile;
    }

    public void absentDir(String path) throws SVNException {
        File file = SVNFileUtil.createFilePath(this.currentDir.wcPath, SVNPathUtil.tail(path));
        SVNEvent event = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.SKIP, null, null, null);
        this.handleEvent(event);
    }

    public void absentFile(String path) throws SVNException {
        File file = SVNFileUtil.createFilePath(this.currentDir.wcPath, SVNPathUtil.tail(path));
        SVNEvent event = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.SKIP, null, null, null);
        this.handleEvent(event);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton db = this.makeDirBaton(path, this.currentDir, true);
        db.pristineProperties = new SVNProperties();
        DirBaton pb = this.currentDir;
        this.currentDir = db;
        if (pb.skip || pb.skipChildren || pb.treeConflicted) {
            this.currentDir.skip = true;
            return;
        }
        this.diffCallback.dirAdded(this.currentResult.reset(), db.wcPath, this.targetRevision, copyFromPath, copyFromRevision);
        db.skip = this.currentResult.skip;
        db.skipChildren = this.currentResult.skipChildren;
        db.treeConflicted = this.currentResult.treeConflicted;
        SVNNodeKind kind = SVNNodeKind.DIR;
        SVNEventAction action = null;
        DeletedPath dp = this.deletedPaths.get(db.wcPath);
        if (dp != null) {
            this.currentResult.contentState = dp.state;
            kind = dp.kind;
            this.deletedPaths.remove(db.wcPath);
        }
        action = db.treeConflicted ? SVNEventAction.TREE_CONFLICT : (dp != null ? (dp.action == SVNEventAction.UPDATE_DELETE ? SVNEventAction.UPDATE_REPLACE : dp.action) : (this.currentResult.contentState == SVNStatusType.MISSING || this.currentResult.contentState == SVNStatusType.OBSTRUCTED ? SVNEventAction.SKIP : SVNEventAction.UPDATE_ADD));
        SVNEvent event = SVNEventFactory.createSVNEvent(db.wcPath, kind, null, -1L, this.currentResult.contentState, this.currentResult.contentState, SVNStatusType.LOCK_INAPPLICABLE, action, action, null, null, null);
        this.handleEvent(event);
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton db = this.makeDirBaton(path, this.currentDir, false);
        db.pristineProperties = new SVNProperties();
        DirBaton pb = this.currentDir;
        this.currentDir = db;
        if (pb.skip || pb.skipChildren || pb.treeConflicted) {
            this.currentDir.skip = true;
            return;
        }
        db.loadProperties(this.repository, path, revision);
        this.diffCallback.dirOpened(this.currentResult.reset(), db.wcPath, revision);
        db.skip = this.currentResult.skip;
        db.skipChildren = this.currentResult.skipChildren;
        db.treeConflicted = this.currentResult.treeConflicted;
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.currentDir.skip) {
            return;
        }
        this.currentDir.propChanges.put(name, value);
    }

    public void closeDir() throws SVNException {
        boolean skipped = false;
        this.currentResult.reset();
        this.currentResult.contentState = SVNStatusType.UNKNOWN;
        this.currentResult.propState = SVNStatusType.UNKNOWN;
        DirBaton b = this.currentDir;
        if (b.skip) {
            this.currentDir = b.parent;
            return;
        }
        if (!b.added && b.propChanges.size() > 0) {
            this.removeNonPropChanges(b.pristineProperties, b.propChanges);
        }
        if (b.propChanges.size() > 0) {
            this.diffCallback.dirPropsChanged(this.currentResult, b.wcPath, b.added, b.propChanges, b.pristineProperties);
            if (this.currentResult.propState == SVNStatusType.OBSTRUCTED || this.currentResult.propState == SVNStatusType.MISSING) {
                this.currentResult.contentState = this.currentResult.propState;
                skipped = true;
            }
        }
        this.diffCallback.dirClosed(null, b.wcPath, b.added);
        if (!skipped && !b.added) {
            for (File d : this.deletedPaths.keySet()) {
                DeletedPath dp = this.deletedPaths.get(d);
                SVNEvent event = SVNEventFactory.createSVNEvent(d, dp.kind, null, -1L, dp.state, dp.state, SVNStatusType.LOCK_INAPPLICABLE, dp.action, dp.action, null, null, null);
                this.handleEvent(event);
            }
            this.deletedPaths.clear();
        }
        if (!b.added) {
            SVNEventAction action = null;
            action = b.treeConflicted ? SVNEventAction.TREE_CONFLICT : (skipped ? SVNEventAction.SKIP : SVNEventAction.UPDATE_UPDATE);
            SVNEvent event = SVNEventFactory.createSVNEvent(b.wcPath, SVNNodeKind.DIR, null, -1L, this.currentResult.contentState, this.currentResult.propState, SVNStatusType.LOCK_INAPPLICABLE, action, action, null, null, null);
            this.handleEvent(event);
        }
        this.currentDir = b.parent;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        FileBaton fb;
        this.currentFile = fb = this.makeFileBaton(path, true);
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            fb.skip = true;
            return;
        }
        fb.pristineProps = new SVNProperties();
    }

    public void openFile(String path, long revision) throws SVNException {
        FileBaton fb;
        this.currentFile = fb = this.makeFileBaton(path, false);
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            fb.skip = true;
            return;
        }
        fb.baseRevision = revision;
        this.diffCallback.fileOpened(this.currentResult.reset(), fb.wcPath, revision);
        fb.treeConflicted = this.currentResult.treeConflicted;
        fb.skip = this.currentResult.skip;
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (this.currentFile.skip) {
            return;
        }
        this.currentFile.propChanges.put(propertyName, propertyValue);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        SvnChecksum expected;
        if (this.currentFile.skip) {
            this.currentFile = null;
            return;
        }
        FileBaton b = this.currentFile;
        if (textChecksum != null && (expected = SvnChecksum.fromString("$md5 $" + textChecksum)) != null && b.resultMd5Checksum != null && !expected.equals(b.resultMd5Checksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)b.repoPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!b.added && b.propChanges.size() > 0) {
            if (b.pristineProps == null) {
                b.loadFile(this.context, this.repository, true, this.tmpFiles);
            }
            this.removeNonPropChanges(b.pristineProps, b.propChanges);
        }
        if (b.endRevisionFile != null || b.propChanges.size() > 0) {
            String[] mTypes = b.getMimeTypes();
            if (b.added) {
                this.diffCallback.fileAdded(this.currentResult.reset(), b.wcPath, b.endRevisionFile != null ? b.startRevisionFile : null, b.endRevisionFile, 0L, this.targetRevision, mTypes[0], mTypes[1], null, -1L, b.propChanges, b.pristineProps);
                b.treeConflicted = this.currentResult.treeConflicted;
            } else {
                this.diffCallback.fileChanged(this.currentResult.reset(), b.wcPath, b.endRevisionFile != null ? b.startRevisionFile : null, b.endRevisionFile, this.revision, this.targetRevision, mTypes[0], mTypes[1], b.propChanges, b.pristineProps);
                b.treeConflicted = this.currentResult.treeConflicted;
            }
        }
        SVNNodeKind kind = SVNNodeKind.FILE;
        SVNEventAction action = null;
        DeletedPath dp = this.deletedPaths.get(b.wcPath);
        if (dp != null) {
            this.deletedPaths.remove(b.wcPath);
            kind = dp.kind;
            this.currentResult.contentState = dp.state;
            this.currentResult.propState = dp.state;
        }
        SVNEventAction expectedAction = null;
        if (b.treeConflicted) {
            action = SVNEventAction.TREE_CONFLICT;
        } else if (dp != null) {
            action = dp.action == SVNEventAction.UPDATE_DELETE && b.added ? SVNEventAction.UPDATE_REPLACE : dp.action;
        } else if (this.currentResult.contentState == SVNStatusType.OBSTRUCTED || this.currentResult.contentState == SVNStatusType.MISSING) {
            action = SVNEventAction.SKIP;
            expectedAction = b.added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        } else {
            action = b.added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        }
        if (expectedAction == null) {
            expectedAction = action;
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(b.wcPath, kind, null, -1L, this.currentResult.contentState, this.currentResult.propState, SVNStatusType.LOCK_INAPPLICABLE, action, expectedAction, null, null, null);
        this.handleEvent(event);
    }

    private void removeNonPropChanges(SVNProperties pristineProps, SVNProperties propChanges) {
        HashSet<String> removed = new HashSet<String>();
        for (String propertyName : propChanges.nameSet()) {
            SVNPropertyValue oldValue;
            SVNPropertyValue newValue = propChanges.getSVNPropertyValue(propertyName);
            if (newValue == null || (oldValue = pristineProps.getSVNPropertyValue(propertyName)) == null || !oldValue.equals(newValue)) continue;
            removed.add(propertyName);
        }
        for (String name : removed) {
            propChanges.remove(name);
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.cleanup();
        return null;
    }

    public void cleanup() {
        for (File tmpFile : this.tmpFiles) {
            try {
                SVNFileUtil.deleteFile(tmpFile);
            }
            catch (SVNException sVNException) {}
        }
        if (this.globalTmpDir != null) {
            SVNFileUtil.deleteAll(this.globalTmpDir, true);
        }
    }

    public void abortEdit() throws SVNException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileBaton {
        boolean added;
        boolean treeConflicted;
        boolean skip;
        String repoPath;
        File wcPath;
        File startRevisionFile;
        File endRevisionFile;
        SVNProperties pristineProps;
        long baseRevision;
        SvnChecksum resultMd5Checksum;
        SVNProperties propChanges;
        public SVNDeltaProcessor deltaProcessor;

        private FileBaton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFile(SVNWCContext context, SVNRepository repos, boolean propsOnly, Collection<File> tmpFiles) throws SVNException {
            if (!propsOnly) {
                File tmpDir = SvnNgRemoteDiffEditor.this.pureRemoteDiff ? SvnNgRemoteDiffEditor.this.getGlobalTmpDir() : context.getDb().getWCRootTempDir(this.wcPath);
                this.startRevisionFile = SVNFileUtil.createUniqueFile(tmpDir, "diff", ".tmp", false);
                tmpFiles.add(this.startRevisionFile);
                OutputStream os = null;
                try {
                    os = SVNFileUtil.openFileForWriting(this.startRevisionFile);
                    os = new SVNChecksumOutputStream(os, "MD5", true);
                    this.pristineProps = new SVNProperties();
                    repos.getFile(this.repoPath, this.baseRevision, this.pristineProps, os);
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
            } else {
                this.pristineProps = new SVNProperties();
                repos.getFile(this.repoPath, this.baseRevision, this.pristineProps, null);
            }
        }

        public String[] getMimeTypes() {
            String[] r = new String[2];
            if (this.pristineProps != null) {
                r[0] = this.pristineProps.getStringValue("svn:mime-type");
                r[1] = r[0];
            }
            if (this.propChanges != null) {
                r[1] = this.propChanges.getStringValue("svn:mime-type");
            }
            return r;
        }
    }

    private static class DirBaton {
        boolean added;
        boolean treeConflicted;
        boolean skip;
        boolean skipChildren;
        File wcPath;
        DirBaton parent;
        SVNProperties propChanges;
        SVNProperties pristineProperties;

        private DirBaton() {
        }

        public void loadProperties(SVNRepository repos, String path, long revision) throws SVNException {
            this.pristineProperties = new SVNProperties();
            repos.getDir(path, revision, this.pristineProperties, 0, (ISVNDirEntryHandler)null);
        }
    }

    private static class DeletedPath {
        SVNNodeKind kind;
        SVNEventAction action;
        SVNStatusType state;

        private DeletedPath() {
        }
    }
}

