/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeinfoUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgMergeDriver
implements ISVNEventHandler {
    boolean force;
    boolean dryRun;
    boolean recordOnly;
    boolean sourcesAncestral;
    boolean sameRepos;
    private boolean mergeinfoCapable;
    private boolean ignoreAncestry;
    private boolean targetMissingChild;
    boolean reintegrateMerge;
    File targetAbsPath;
    File addedPath;
    SVNURL reposRootUrl;
    MergeSource source;
    private SVNMergeRangeList implicitSrcGap;
    SVNWCContext context;
    private boolean addNecessiatedMerge;
    Collection<File> dryRunDeletions;
    Collection<File> dryRunAdded;
    private Collection<File> conflictedPaths;
    Collection<File> pathsWithNewMergeInfo;
    Collection<File> pathsWithDeletedMergeInfo;
    SVNDiffOptions diffOptions;
    SVNRepository repos1;
    SVNRepository repos2;
    SvnMerge operation;
    SvnRepositoryAccess repositoryAccess;
    private Map<File, MergePath> childrenWithMergeInfo;
    private int currentAncestorIndex;
    private boolean singleFileMerge;
    private int operativeNotifications;
    private int notifications;
    private Collection<File> addedPaths;
    private Collection<File> mergedPaths;
    private Collection<File> skippedPaths;
    private Collection<File> treeConflictedPaths;

    public SvnNgMergeDriver(SVNWCContext context, SvnMerge operation, SvnRepositoryAccess repositoryAccess, SVNDiffOptions diffOptions) {
        this.context = context;
        this.operation = operation;
        this.repositoryAccess = repositoryAccess;
        this.diffOptions = diffOptions;
    }

    public void ensureWcIsSuitableForMerge(File targetAbsPath, boolean allowMixedRevs, boolean allowLocalMods, boolean allowSwitchedSubtrees) throws SVNException {
        SVNErrorMessage err;
        if (!allowMixedRevs) {
            long[] revs = SvnWcDbReader.getMinAndMaxRevisions((SVNWCDb)this.context.getDb(), targetAbsPath);
            if (revs[0] < 0L && revs[1] >= 0L) {
                if (!this.context.isNodeAdded(targetAbsPath)) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot determine revision of working copy");
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            } else if (revs[0] != revs[1]) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MERGE_UPDATE_REQUIRED, "Cannot merge into mixed-revision working copy [{0}:{1}]; try updating first", revs[0], revs[1]);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
        }
        if (!allowSwitchedSubtrees && SvnWcDbReader.hasSwitchedSubtrees((SVNWCDb)this.context.getDb(), targetAbsPath)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot merge into a working copy with a switched subtree");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!allowLocalMods && SvnWcDbReader.hasLocalModifications(this.context, targetAbsPath)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot merge into a working copy that has local modifications");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public void mergeCousinsAndSupplementMergeInfo(File targetWCPath, SVNRepository repository1, SVNRepository repository2, SVNURL url1, long rev1, SVNURL url2, long rev2, long youngestCommonRev, SVNURL sourceReposRoot, SVNURL wcReposRoot, SVNDepth depth, boolean ignoreAncestry, boolean force, boolean recordOnly, boolean dryRun) throws SVNException {
        List<MergeSource> addSources = null;
        List<MergeSource> removeSources = null;
        SVNRevision sRev = SVNRevision.create(rev1);
        SVNRevision eRev = SVNRevision.create(youngestCommonRev);
        SVNRevisionRange range = new SVNRevisionRange(sRev, eRev);
        LinkedList<SVNRevisionRange> ranges = new LinkedList<SVNRevisionRange>();
        ranges.add(range);
        repository1.setLocation(url1, false);
        removeSources = this.normalizeMergeSources(SvnTarget.fromURL(url1), url1, sourceReposRoot, sRev, ranges, repository1);
        sRev = eRev;
        eRev = SVNRevision.create(rev2);
        range = new SVNRevisionRange(sRev, eRev);
        ranges.clear();
        ranges.add(range);
        repository2.setLocation(url2, false);
        addSources = this.normalizeMergeSources(SvnTarget.fromURL(url2), url2, sourceReposRoot, eRev, ranges, repository2);
        boolean sameRepos = sourceReposRoot.equals(wcReposRoot);
        Collection<File> modifiedSubtrees = null;
        if (!recordOnly) {
            MergeSource fauxSource = new MergeSource();
            fauxSource.url1 = url1;
            fauxSource.url2 = url2;
            fauxSource.rev1 = rev1;
            fauxSource.rev2 = rev2;
            LinkedList<MergeSource> fauxSources = new LinkedList<MergeSource>();
            fauxSources.add(fauxSource);
            modifiedSubtrees = this.doMerge(null, fauxSources, targetWCPath, false, true, sameRepos, ignoreAncestry, force, dryRun, false, null, true, false, depth, this.diffOptions);
        } else if (!sameRepos) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (sameRepos && !dryRun) {
            TreeMap<File, Map<String, SVNMergeRangeList>> addResultsCatalog = new TreeMap<File, Map<String, SVNMergeRangeList>>();
            TreeMap<File, Map<String, SVNMergeRangeList>> removeResultsCatalog = new TreeMap<File, Map<String, SVNMergeRangeList>>();
            if (this.context.getEventHandler() != null) {
                SVNEvent mergeStartedEvent = SVNEventFactory.createSVNEvent(this.targetAbsPath, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, null);
                this.context.getEventHandler().handleEvent(mergeStartedEvent, -1.0);
            }
            this.doMerge(addResultsCatalog, addSources, targetWCPath, true, true, sameRepos, ignoreAncestry, force, dryRun, true, modifiedSubtrees, true, true, depth, this.diffOptions);
            this.doMerge(removeResultsCatalog, removeSources, targetWCPath, true, true, sameRepos, ignoreAncestry, force, dryRun, true, modifiedSubtrees, true, true, depth, this.diffOptions);
            SVNMergeInfoUtil.mergeCatalog(addResultsCatalog, removeResultsCatalog);
            if (!addResultsCatalog.isEmpty()) {
                for (File file : addResultsCatalog.keySet()) {
                    Map mergeinfo = (Map)addResultsCatalog.get(file);
                    try {
                        this.recordMergeinfo(file, mergeinfo, true);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) continue;
                        throw e;
                    }
                }
            }
        }
    }

    public List<MergeSource> normalizeMergeSources(SvnTarget source, SVNURL sourceURL, SVNURL sourceRootURL, SVNRevision pegRevision, Collection<SVNRevisionRange> rangesToMerge, SVNRepository repository) throws SVNException {
        Structure<SvnRepositoryAccess.RevisionsPair> pair = this.repositoryAccess.getRevisionNumber(repository, source, pegRevision, null);
        long pegRevNum = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        if (pegRevNum < 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ArrayList<SVNMergeRange> mergeRanges = new ArrayList<SVNMergeRange>();
        for (SVNRevisionRange revRange : rangesToMerge) {
            long endRev;
            SVNRevision rangeStart = revRange.getStartRevision();
            SVNRevision rangeEnd = revRange.getEndRevision();
            if (!rangeStart.isValid() || !rangeEnd.isValid()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            pair = this.repositoryAccess.getRevisionNumber(repository, source, rangeStart, pair);
            long startRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            if (startRev == (endRev = (pair = this.repositoryAccess.getRevisionNumber(repository, source, rangeEnd, pair)).lng(SvnRepositoryAccess.RevisionsPair.revNumber))) continue;
            mergeRanges.add(new SVNMergeRange(startRev, endRev, true));
        }
        pair.release();
        if (mergeRanges.isEmpty()) {
            return Collections.emptyList();
        }
        long oldestRequested = -1L;
        long youngesRequested = -1L;
        for (SVNMergeRange mergeRange : mergeRanges) {
            long minRev = Math.min(mergeRange.getStartRevision(), mergeRange.getEndRevision());
            long maxRev = Math.max(mergeRange.getStartRevision(), mergeRange.getEndRevision());
            if (oldestRequested < 0L || minRev < oldestRequested) {
                oldestRequested = minRev;
            }
            if (youngesRequested >= 0L && maxRev <= youngesRequested) continue;
            youngesRequested = maxRev;
        }
        if (pegRevNum < youngesRequested) {
            this.repositoryAccess.getLocations(repository, SvnTarget.fromURL(sourceURL), SVNRevision.create(pegRevNum), SVNRevision.create(youngesRequested), SVNRevision.UNDEFINED);
            pegRevNum = youngesRequested;
        }
        List<SVNLocationSegment> segments = repository.getLocationSegments("", pegRevNum, youngesRequested, oldestRequested);
        long trimRevision = -1L;
        if (!segments.isEmpty()) {
            SVNLocationSegment segment = segments.get(0);
            if (segment.getStartRevision() != oldestRequested) {
                trimRevision = segment.getStartRevision();
            } else if (segment.getPath() == null && segments.size() > 1) {
                SVNLocationSegment segment2 = segments.get(1);
                SVNURL segmentURL = sourceRootURL.appendPath(segment2.getPath(), false);
                SVNLocationEntry copyFromLocation = this.repositoryAccess.getCopySource(SvnTarget.fromURL(segmentURL), SVNRevision.create(segment2.getStartRevision()));
                String copyFromPath = copyFromLocation.getPath();
                long copyFromRevision = copyFromLocation.getRevision();
                if (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                    SVNLocationSegment newSegment = new SVNLocationSegment(copyFromRevision, copyFromRevision, copyFromPath);
                    segment.setStartRevision(copyFromRevision + 1L);
                    segments.add(0, newSegment);
                }
            }
        }
        SVNLocationSegment[] segmentsArray = segments.toArray(new SVNLocationSegment[segments.size()]);
        ArrayList<MergeSource> resultMergeSources = new ArrayList<MergeSource>();
        for (SVNMergeRange range : mergeRanges) {
            if (SVNRevision.isValidRevisionNumber(trimRevision)) {
                if (Math.max(range.getStartRevision(), range.getEndRevision()) < trimRevision) continue;
                if (range.getStartRevision() < trimRevision) {
                    range.setStartRevision(trimRevision);
                }
                if (range.getEndRevision() < trimRevision) {
                    range.setEndRevision(trimRevision);
                }
            }
            List<MergeSource> mergeSources = this.combineRangeWithSegments(range, segmentsArray, sourceRootURL);
            resultMergeSources.addAll(mergeSources);
        }
        return resultMergeSources;
    }

    private List<MergeSource> combineRangeWithSegments(SVNMergeRange range, SVNLocationSegment[] segments, SVNURL sourceRootURL) throws SVNException {
        long minRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
        long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
        boolean subtractive = range.getStartRevision() > range.getEndRevision();
        ArrayList<MergeSource> mergeSources = new ArrayList<MergeSource>();
        for (int i = 0; i < segments.length; ++i) {
            SVNLocationSegment segment = segments[i];
            if (segment.getEndRevision() < minRev || segment.getStartRevision() > maxRev || segment.getPath() == null) continue;
            String path1 = null;
            long rev1 = Math.max(segment.getStartRevision(), minRev) - 1L;
            if (minRev <= segment.getStartRevision()) {
                if (i > 0) {
                    path1 = segments[i - 1].getPath();
                }
                if (path1 == null && i > 1) {
                    path1 = segments[i - 2].getPath();
                    rev1 = segments[i - 2].getEndRevision();
                }
            } else {
                path1 = segment.getPath();
            }
            if (path1 == null || segment.getPath() == null) continue;
            MergeSource mergeSource = new MergeSource();
            mergeSource.url1 = sourceRootURL.appendPath(path1, false);
            mergeSource.url2 = sourceRootURL.appendPath(segment.getPath(), false);
            mergeSource.rev1 = rev1;
            mergeSource.rev2 = Math.min(segment.getEndRevision(), maxRev);
            if (subtractive) {
                long tmpRev = mergeSource.rev1;
                SVNURL tmpURL = mergeSource.url1;
                mergeSource.rev1 = mergeSource.rev2;
                mergeSource.url1 = mergeSource.url2;
                mergeSource.rev2 = tmpRev;
                mergeSource.url2 = tmpURL;
            }
            mergeSources.add(mergeSource);
        }
        if (subtractive && !mergeSources.isEmpty()) {
            Collections.sort(mergeSources, new Comparator<MergeSource>(){

                @Override
                public int compare(MergeSource o1, MergeSource o2) {
                    MergeSource source1 = o1;
                    MergeSource source2 = o2;
                    long src1Rev1 = source1.rev1;
                    long src2Rev1 = source2.rev1;
                    if (src1Rev1 == src2Rev1) {
                        return 0;
                    }
                    return src1Rev1 < src2Rev1 ? 1 : -1;
                }
            });
        }
        return mergeSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<File> doMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, List<MergeSource> mergeSources, File targetAbsPath, boolean sourcesAncestral, boolean sourcesRelated, boolean sameRepository, boolean ignoreAncestry, boolean force, boolean dryRun, boolean recordOnly, Collection<File> recordOnlyPaths, boolean reintegrateMerge, boolean squelcheMergeInfoNotifications, SVNDepth depth, SVNDiffOptions diffOptions) throws SVNException {
        SVNNodeKind targetKind;
        if (recordOnly) {
            SVNErrorMessage err;
            if (!sourcesAncestral) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Use of two URLs is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (!sameRepository) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dryRun) {
                return null;
            }
        }
        if ((targetKind = this.context.readKind(targetAbsPath, false)) != SVNNodeKind.DIR && targetKind != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge target ''{0}'' does not exist in the working copy");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        this.force = force;
        this.dryRun = dryRun;
        this.recordOnly = recordOnly;
        this.ignoreAncestry = ignoreAncestry;
        this.sameRepos = sameRepository;
        this.mergeinfoCapable = false;
        this.sourcesAncestral = sourcesAncestral;
        this.targetMissingChild = false;
        this.reintegrateMerge = reintegrateMerge;
        this.targetAbsPath = targetAbsPath;
        this.reposRootUrl = this.context.getNodeReposInfo((File)targetAbsPath).reposRootUrl;
        this.diffOptions = diffOptions;
        this.notifications = 0;
        this.operativeNotifications = 0;
        this.mergedPaths = recordOnly && recordOnlyPaths != null ? recordOnlyPaths : null;
        this.skippedPaths = null;
        this.addedPaths = null;
        this.treeConflictedPaths = null;
        this.singleFileMerge = false;
        this.childrenWithMergeInfo = null;
        this.currentAncestorIndex = -1;
        boolean checkedMergeInfoCapability = false;
        HashSet<File> modifiedSubtrees = new HashSet<File>();
        for (int i = 0; i < mergeSources.size(); ++i) {
            MergeSource mergeSource = mergeSources.get(i);
            SVNURL url1 = mergeSource.url1;
            SVNURL url2 = mergeSource.url2;
            long revision1 = mergeSource.rev1;
            long revision2 = mergeSource.rev2;
            if (revision1 == revision2 && mergeSource.url1.equals(mergeSource.url2)) continue;
            try {
                this.repos1 = this.ensureRepository(this.repos1, url1);
                this.repos2 = this.ensureRepository(this.repos2, url2);
                this.source = mergeSource;
                this.implicitSrcGap = null;
                this.addedPath = null;
                this.addNecessiatedMerge = false;
                this.dryRunDeletions = dryRun ? new HashSet() : null;
                this.dryRunAdded = dryRun ? new HashSet() : null;
                this.conflictedPaths = null;
                this.pathsWithDeletedMergeInfo = null;
                this.pathsWithNewMergeInfo = null;
                if (!checkedMergeInfoCapability) {
                    this.mergeinfoCapable = this.repos1.hasCapability(SVNCapability.MERGE_INFO);
                    checkedMergeInfoCapability = true;
                }
                if (targetKind == SVNNodeKind.FILE) {
                    this.doFileMerge(targetAbsPath, resultCatalog, url1, revision1, url2, revision2, depth, sourcesRelated, squelcheMergeInfoNotifications);
                } else if (targetKind == SVNNodeKind.DIR) {
                    boolean abortOnConflicts = i < mergeSources.size() - 1;
                    this.doDirectoryMerge(targetAbsPath, resultCatalog, url1, revision1, url2, revision2, depth, abortOnConflicts, squelcheMergeInfoNotifications);
                    if (this.addedPaths != null) {
                        modifiedSubtrees.addAll(this.addedPaths);
                    }
                    if (this.mergedPaths != null) {
                        modifiedSubtrees.addAll(this.mergedPaths);
                    }
                    if (this.treeConflictedPaths != null) {
                        modifiedSubtrees.addAll(this.treeConflictedPaths);
                    }
                    if (this.skippedPaths != null) {
                        modifiedSubtrees.addAll(this.skippedPaths);
                    }
                }
                if (!dryRun) {
                    SvnNgMergeinfoUtil.elideMergeInfo(this.context, this.repos1, targetAbsPath, null);
                }
                if (this.context.getEventHandler() == null) continue;
                SVNEvent mergeCompletedEvent = SVNEventFactory.createSVNEvent(targetAbsPath, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_COMPLETE, null, null, null);
                this.context.getEventHandler().handleEvent(mergeCompletedEvent, -1.0);
                continue;
            }
            finally {
                if (this.repos1 != null) {
                    this.repos1.closeSession();
                }
                if (this.repos2 != null) {
                    this.repos2.closeSession();
                }
            }
        }
        return modifiedSubtrees;
    }

    protected void doMergeInfoUnawareDirectoryMerge(File targetPath, SVNURL url1, long revision1, SVNURL url2, long revision2, SVNDepth depth) throws SVNException {
        boolean isRollBack = revision1 > revision2;
        MergePath item = new MergePath(targetPath);
        SVNMergeRange itemRange = new SVNMergeRange(revision1, revision2, true);
        item.remainingRanges = new SVNMergeRangeList(itemRange);
        this.childrenWithMergeInfo = new TreeMap<File, MergePath>();
        this.childrenWithMergeInfo.put(targetPath, item);
        SvnNgMergeCallback mergeCallback = new SvnNgMergeCallback(this);
        this.driveMergeReportEditor(targetPath, url1, revision1, url2, revision2, this.childrenWithMergeInfo, isRollBack, depth, mergeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFileMerge(File targetPath, Map<File, Map<String, SVNMergeRangeList>> resultCatalog, SVNURL url1, long revision1, SVNURL url2, long revision2, SVNDepth depth, boolean sourceRelated, boolean squelchMergeinfoNotifications) throws SVNException {
        SVNMergeRangeList filteredRangeList;
        SVNEvent mergeBeginEvent;
        this.singleFileMerge = true;
        SVNURL targetURL = this.context.getNodeUrl(targetPath);
        SVNMergeRange range = new SVNMergeRange(revision1, revision2, true);
        boolean isRollback = revision1 > revision2;
        SVNURL primaryURL = isRollback ? url1 : url2;
        SVNMergeRangeList remainingRanges = null;
        String mergeInfoPath = null;
        MergePath mergeTarget = null;
        boolean[] inherited = new boolean[1];
        Map<String, SVNMergeRangeList> targetMergeInfo = null;
        if (this.isHonorMergeInfo()) {
            mergeTarget = new MergePath(targetPath);
            SVNURL sourceReposRootURL = this.repos1.getRepositoryRoot(true);
            mergeInfoPath = this.getPathRelativeToRoot(primaryURL, sourceReposRootURL, this.repos1);
            this.repos1.setLocation(targetURL, false);
            Map<String, SVNMergeRangeList>[] mis = this.getFullMergeInfo(true, true, inherited, SVNMergeInfoInheritance.INHERITED, this.repos1, targetPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            mergeTarget.implicitMergeInfo = mis[1];
            targetMergeInfo = mis[0];
            this.repos1.setLocation(url1, false);
            if (!this.recordOnly) {
                this.calculateRemainingRanges(null, mergeTarget, sourceReposRootURL, url1, revision1, url2, revision2, targetMergeInfo, this.implicitSrcGap, false, false, this.repos1);
                remainingRanges = mergeTarget.remainingRanges;
            }
        }
        if (this.recordOnly || !this.isHonorMergeInfo()) {
            remainingRanges = new SVNMergeRangeList(range);
        }
        SVNMergeRange conflictedRange = null;
        if (!this.recordOnly) {
            SVNMergeRangeList ranges = remainingRanges;
            if (this.sourcesAncestral && remainingRanges.getSize() > 1) {
                SVNURL oldUrl = this.ensureSessionURL(this.repos1, primaryURL);
                ranges = this.removeNoOpMergeRanges(this.repos1, remainingRanges);
                if (oldUrl != null) {
                    this.repos1.setLocation(oldUrl, false);
                }
            }
            SVNMergeRange[] rangesToMerge = ranges.getRanges();
            for (int i = 0; i < rangesToMerge.length; ++i) {
                SVNMergeRange rng = rangesToMerge[i];
                mergeBeginEvent = SVNEventFactory.createSVNEvent(targetPath, SVNNodeKind.FILE, null, -1L, this.sameRepos ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, this.sourcesAncestral ? rng : null);
                SVNRepository rep1 = this.repos1;
                SVNRepository rep2 = this.repos2;
                if (this.isHonorMergeInfo() && !url1.equals(url2)) {
                    if (!isRollback && rng.getStartRevision() != revision1) {
                        rep1 = rep2;
                    } else if (isRollback && rng.getEndRevision() != revision2) {
                        rep2 = rep1;
                    }
                }
                File tmpDir = this.context.getDb().getWCRootTempDir(targetPath);
                File tmpFile1 = SVNFileUtil.createUniqueFile(tmpDir, targetPath.getName(), ".tmp", false);
                File tmpFile2 = SVNFileUtil.createUniqueFile(tmpDir, targetPath.getName(), ".tmp", false);
                SVNProperties props1 = new SVNProperties();
                SVNProperties props2 = new SVNProperties();
                OutputStream os1 = null;
                OutputStream os2 = null;
                try {
                    os1 = SVNFileUtil.openFileForWriting(tmpFile1);
                    try {
                        rep1.getFile("", rng.getStartRevision(), props1, os1);
                    }
                    finally {
                        SVNFileUtil.closeFile(os1);
                    }
                    os2 = SVNFileUtil.openFileForWriting(tmpFile2);
                    try {
                        rep2.getFile("", rng.getEndRevision(), props2, os2);
                    }
                    finally {
                        SVNFileUtil.closeFile(os2);
                    }
                    String mType1 = props1.getStringValue("svn:mime-type");
                    String mType2 = props2.getStringValue("svn:mime-type");
                    SVNProperties propChanges = props1.compareTo(props2);
                    SvnNgMergeCallback callback = new SvnNgMergeCallback(this);
                    SvnDiffCallbackResult result = new SvnDiffCallbackResult();
                    if (!this.ignoreAncestry && !sourceRelated) {
                        callback.fileDeleted(result, targetPath, tmpFile1, tmpFile2, mType1, mType2, props1);
                        boolean sent = this.singleFileMergeNotify(targetPath, result.treeConflicted ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_DELETE, result.contentState, SVNStatusType.UNKNOWN, mergeBeginEvent, false);
                        result = result.reset();
                        callback.fileAdded(result, targetPath, tmpFile1, tmpFile2, rng.getStartRevision(), rng.getEndRevision(), mType1, mType2, null, -1L, propChanges, props1);
                        this.singleFileMergeNotify(targetPath, result.treeConflicted ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_ADD, result.contentState, result.propState, mergeBeginEvent, sent);
                    } else {
                        callback.fileChanged(result, targetPath, tmpFile1, tmpFile2, rng.getStartRevision(), rng.getEndRevision(), mType1, mType2, propChanges, props1);
                        this.singleFileMergeNotify(targetPath, result.treeConflicted ? SVNEventAction.TREE_CONFLICT : SVNEventAction.UPDATE_UPDATE, result.contentState, result.propState, mergeBeginEvent, false);
                    }
                }
                finally {
                    SVNFileUtil.deleteFile(tmpFile1);
                    SVNFileUtil.deleteFile(tmpFile2);
                }
                if (i >= rangesToMerge.length - 1 || this.conflictedPaths == null || this.conflictedPaths.size() <= 0) continue;
                conflictedRange = rng;
                break;
            }
        }
        if (this.isRecordMergeInfo() && remainingRanges.getSize() > 0 && !(filteredRangeList = this.filterNaturalHistoryFromMergeInfo(mergeInfoPath, mergeTarget.implicitMergeInfo, range)).isEmpty() && (this.skippedPaths == null || this.skippedPaths.isEmpty())) {
            TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>();
            if (inherited[0]) {
                this.recordMergeinfo(targetPath, targetMergeInfo, false);
            }
            merges.put(targetPath, filteredRangeList);
            if (!squelchMergeinfoNotifications) {
                long[] revs = SVNMergeInfoUtil.getRangeEndPoints(merges);
                SVNMergeRange r = new SVNMergeRange(revs[1], revs[0], true);
                mergeBeginEvent = SVNEventFactory.createSVNEvent(this.targetAbsPath, SVNNodeKind.FILE, null, -1L, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, r);
                if (this.context.getEventHandler() != null) {
                    this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
                }
            }
            this.updateWCMergeInfo(resultCatalog, targetPath, mergeInfoPath, merges, isRollback);
        }
        if (conflictedRange != null) {
            SVNErrorMessage err = this.makeMergeConflictError(targetPath, conflictedRange);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private boolean singleFileMergeNotify(File path, SVNEventAction action, SVNStatusType contents, SVNStatusType props, SVNEvent header, boolean headerSent) throws SVNException {
        SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.FILE, null, -1L, contents, props, SVNStatusType.LOCK_INAPPLICABLE, action, null, null, null, null);
        if (contents == SVNStatusType.MISSING) {
            action = SVNEventAction.SKIP;
        }
        if (SvnNgMergeDriver.isOperativeNotification(event) && header != null && !headerSent) {
            this.handleEvent(header, -1.0);
            headerSent = true;
        }
        this.handleEvent(event, -1.0);
        return headerSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDirectoryMerge(File targetPath, Map<File, Map<String, SVNMergeRangeList>> resultCatalog, SVNURL url1, long revision1, SVNURL url2, long revision2, SVNDepth depth, boolean abortOnConflicts, boolean squelchMergeinfoNotifications) throws SVNException {
        SVNErrorMessage err;
        SVNMergeRange range;
        String mergeInfoPath;
        boolean recordMergeInfo;
        block23: {
            SvnNgMergeCallback mergeCallback;
            boolean isRollBack;
            block24: {
                isRollBack = revision1 > revision2;
                SVNURL primaryURL = isRollBack ? url1 : url2;
                boolean honorMergeInfo = this.isHonorMergeInfo();
                recordMergeInfo = this.isRecordMergeInfo();
                boolean sameURLs = url1.equals(url2);
                mergeCallback = new SvnNgMergeCallback(this);
                Map<File, MergePath> childrenWithMergeInfo = new TreeMap<File, MergePath>();
                if (!honorMergeInfo) {
                    this.doMergeInfoUnawareDirectoryMerge(targetPath, url1, revision1, url2, revision2, depth);
                    return;
                }
                SVNRepository repository = isRollBack ? this.repos1 : this.repos2;
                SVNURL sourceRootURL = repository.getRepositoryRoot(true);
                mergeInfoPath = this.getPathRelativeToRoot(primaryURL, sourceRootURL, null);
                childrenWithMergeInfo = this.getMergeInfoPaths(childrenWithMergeInfo, mergeInfoPath, sourceRootURL, url1, url2, revision1, revision2, repository, depth);
                this.childrenWithMergeInfo = childrenWithMergeInfo;
                MergePath targetMergePath = childrenWithMergeInfo.values().iterator().next();
                this.targetMissingChild = targetMergePath.missingChild;
                this.populateRemainingRanges(childrenWithMergeInfo, sourceRootURL, url1, revision1, url2, revision2, honorMergeInfo, repository, mergeInfoPath);
                range = new SVNMergeRange(revision1, revision2, true);
                err = null;
                if (!honorMergeInfo || this.reintegrateMerge) break block24;
                long newRangeStart = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollBack);
                if (SVNRevision.isValidRevisionNumber(newRangeStart)) {
                    range.setStartRevision(newRangeStart);
                }
                if (!isRollBack) {
                    this.removeNoOpSubtreeRanges(url1, revision1, url2, revision2, repository);
                }
                this.fixDeletedSubtreeRanges(url1, revision1, url2, revision2, repository);
                long startRev = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollBack);
                if (!SVNRevision.isValidRevisionNumber(startRev)) break block23;
                long endRev = this.getMostInclusiveEndRevision(childrenWithMergeInfo, isRollBack);
                while (SVNRevision.isValidRevisionNumber(endRev)) {
                    long nextEndRev;
                    SVNURL oldURL2;
                    block22: {
                        SVNMergeRange firstTargetRange;
                        SVNMergeRange sVNMergeRange = firstTargetRange = targetMergePath.remainingRanges != null && !targetMergePath.remainingRanges.isEmpty() ? targetMergePath.remainingRanges.getRanges()[0] : null;
                        if (firstTargetRange != null && startRev != firstTargetRange.getStartRevision()) {
                            if (isRollBack) {
                                if (endRev < firstTargetRange.getStartRevision()) {
                                    endRev = firstTargetRange.getStartRevision();
                                }
                            } else if (endRev > firstTargetRange.getStartRevision()) {
                                endRev = firstTargetRange.getStartRevision();
                            }
                        }
                        this.sliceRemainingRanges(childrenWithMergeInfo, isRollBack, endRev);
                        this.currentAncestorIndex = -1;
                        SVNURL realURL1 = url1;
                        SVNURL realURL2 = url2;
                        SVNURL oldURL1 = null;
                        oldURL2 = null;
                        nextEndRev = -1L;
                        if (!sameURLs) {
                            if (isRollBack && endRev != revision2) {
                                realURL2 = url1;
                                oldURL2 = this.ensureSessionURL(this.repos2, realURL2);
                            }
                            if (!isRollBack && startRev != revision1) {
                                realURL1 = url2;
                                oldURL1 = this.ensureSessionURL(this.repos1, realURL1);
                            }
                        }
                        try {
                            this.driveMergeReportEditor(this.targetAbsPath, realURL1, startRev, realURL2, endRev, childrenWithMergeInfo, isRollBack, depth, mergeCallback);
                            if (oldURL1 == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (oldURL1 != null) {
                                this.repos1.setLocation(oldURL1, false);
                            }
                            if (oldURL2 != null) {
                                this.repos2.setLocation(oldURL2, false);
                            }
                            throw throwable;
                        }
                        this.repos1.setLocation(oldURL1, false);
                    }
                    if (oldURL2 != null) {
                        this.repos2.setLocation(oldURL2, false);
                    }
                    this.processChildrenWithNewMergeInfo(childrenWithMergeInfo);
                    this.processChildrenWithDeletedMergeInfo(childrenWithMergeInfo);
                    this.removeFirstRangeFromRemainingRanges(endRev, childrenWithMergeInfo);
                    nextEndRev = this.getMostInclusiveEndRevision(childrenWithMergeInfo, isRollBack);
                    if ((nextEndRev != -1L || abortOnConflicts) && this.conflictedPaths != null && !this.conflictedPaths.isEmpty()) {
                        SVNMergeRange conflictedRange = new SVNMergeRange(startRev, endRev, false);
                        err = this.makeMergeConflictError(this.targetAbsPath, conflictedRange);
                        range.setEndRevision(endRev);
                        break block23;
                    }
                    startRev = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollBack);
                    endRev = nextEndRev;
                }
                break block23;
            }
            if (!this.recordOnly) {
                this.currentAncestorIndex = -1;
                this.driveMergeReportEditor(this.targetAbsPath, url1, revision1, url2, revision2, null, isRollBack, depth, mergeCallback);
            }
        }
        if (recordMergeInfo) {
            this.recordMergeInfoForDirectoryMerge(resultCatalog, range, mergeInfoPath, depth, squelchMergeinfoNotifications);
            if (range.getStartRevision() < range.getEndRevision()) {
                this.recordMergeInfoForAddedSubtrees(range, mergeInfoPath, depth, squelchMergeinfoNotifications);
            }
        }
        if (err != null) {
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private void removeNoOpSubtreeRanges(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNRepository repository) throws SVNException {
        if (revision1 > revision2) {
            return;
        }
        if (this.childrenWithMergeInfo.size() < 2) {
            return;
        }
        Iterator<MergePath> mps = this.childrenWithMergeInfo.values().iterator();
        MergePath rootPath = mps.next();
        SVNMergeRangeList requestedRanges = new SVNMergeRangeList(new SVNMergeRange(Math.min(revision1, revision2), Math.max(revision1, revision2), true));
        SVNMergeRangeList subtreeGapRanges = requestedRanges.remove(rootPath.remainingRanges, false);
        if (subtreeGapRanges.isEmpty()) {
            return;
        }
        SVNMergeRangeList subtreeRemainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        while (mps.hasNext()) {
            MergePath child = mps.next();
            if (child.remainingRanges == null || child.remainingRanges.isEmpty()) continue;
            subtreeRemainingRanges = subtreeRemainingRanges.merge(child.remainingRanges);
        }
        if (subtreeRemainingRanges.isEmpty()) {
            return;
        }
        if ((subtreeGapRanges = subtreeGapRanges.intersect(subtreeRemainingRanges, false)).isEmpty()) {
            return;
        }
        SVNMergeRange oldestGapRev = subtreeGapRanges.getRanges()[0];
        SVNMergeRange youngestRev = subtreeGapRanges.getRanges()[subtreeGapRanges.getSize() - 1];
        SVNURL reposRootURL = this.context.getNodeReposInfo((File)this.targetAbsPath).reposRootUrl;
        NoopLogHandler logHandler = new NoopLogHandler();
        logHandler.sourceReposAbsPath = this.getPathRelativeToRoot(url2, reposRootURL, null);
        logHandler.mergedRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        logHandler.operativeRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        repository.log(new String[]{""}, oldestGapRev.getStartRevision() + 1L, youngestRev.getEndRevision(), true, true, -1L, false, null, logHandler);
        SVNMergeRangeList inoperativeRanges = new SVNMergeRangeList(oldestGapRev.getStartRevision(), youngestRev.getEndRevision(), true);
        inoperativeRanges = inoperativeRanges.remove(logHandler.operativeRanges, false);
        logHandler.mergedRanges = logHandler.mergedRanges.merge(inoperativeRanges);
        Iterator<MergePath> iterator = this.childrenWithMergeInfo.values().iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            MergePath child = iterator.next();
            if (child.remainingRanges == null || child.remainingRanges.isEmpty()) continue;
            child.remainingRanges = child.remainingRanges.remove(logHandler.mergedRanges, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnNgRemoteDiffEditor driveMergeReportEditor(File targetWCPath, SVNURL url1, long revision1, SVNURL url2, final long revision2, final Map<File, MergePath> childrenWithMergeInfo, final boolean isRollBack, SVNDepth depth, SvnNgMergeCallback mergeCallback) throws SVNException {
        final boolean honorMergeInfo = this.isHonorMergeInfo();
        long targetStart = revision1;
        if (honorMergeInfo) {
            targetStart = revision2;
            if (childrenWithMergeInfo != null && !childrenWithMergeInfo.isEmpty()) {
                MergePath targetMergePath = childrenWithMergeInfo.values().iterator().next();
                SVNMergeRangeList remainingRanges = targetMergePath.remainingRanges;
                if (remainingRanges != null && !remainingRanges.isEmpty()) {
                    SVNMergeRange[] ranges = remainingRanges.getRanges();
                    SVNMergeRange range = ranges[0];
                    targetStart = !isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2 ? revision2 : range.getStartRevision();
                }
            }
        }
        SvnNgRemoteDiffEditor editor = SvnNgRemoteDiffEditor.createEditor(this.context, this.targetAbsPath, depth, this.repos2, revision1, false, this.dryRun, false, mergeCallback, this);
        SVNURL oldURL = this.ensureSessionURL(this.repos2, url1);
        try {
            final SVNDepth reportDepth = depth;
            final long reportStart = targetStart;
            final String targetPath = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
            this.repos1.diff(url2, revision2, revision2, null, this.ignoreAncestry, depth, true, new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, reportStart, reportDepth, false);
                    if (honorMergeInfo && childrenWithMergeInfo != null) {
                        Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
                        for (int i = 0; i < childrenWithMergeInfoArray.length; ++i) {
                            MergePath childMergePath = (MergePath)childrenWithMergeInfoArray[i];
                            MergePath parent = null;
                            if (childMergePath == null || childMergePath.absent) continue;
                            int parentIndex = SvnNgMergeDriver.this.findNearestAncestor(childrenWithMergeInfoArray, false, childMergePath.absPath);
                            if (parentIndex >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                                parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                            }
                            SVNMergeRange range = null;
                            if (childMergePath.remainingRanges != null && !childMergePath.remainingRanges.isEmpty()) {
                                SVNMergeRangeList remainingRangesList = childMergePath.remainingRanges;
                                SVNMergeRange[] remainingRanges = remainingRangesList.getRanges();
                                range = remainingRanges[0];
                                if (!isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2) continue;
                                if (parent.remainingRanges != null && !parent.remainingRanges.isEmpty()) {
                                    SVNMergeRange parentRange = parent.remainingRanges.getRanges()[0];
                                    SVNMergeRange childRange = childMergePath.remainingRanges.getRanges()[0];
                                    if (parentRange.getStartRevision() == childRange.getStartRevision()) {
                                        continue;
                                    }
                                }
                            } else if (parent.remainingRanges == null || parent.remainingRanges.isEmpty()) continue;
                            String childPath = childMergePath.absPath.getAbsolutePath();
                            String relChildPath = (childPath = childPath.replace(File.separatorChar, '/')).substring(targetPath.length());
                            if (relChildPath.startsWith("/")) {
                                relChildPath = relChildPath.substring(1);
                            }
                            if (childMergePath.remainingRanges == null || childMergePath.remainingRanges.isEmpty() || isRollBack && range.getStartRevision() < revision2 || !isRollBack && range.getStartRevision() > revision2) {
                                reporter.setPath(relChildPath, null, revision2, reportDepth, false);
                                continue;
                            }
                            reporter.setPath(relChildPath, null, range.getStartRevision(), reportDepth, false);
                        }
                    }
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this.operation.getCanceller(), SVNDebugLog.getDefaultLog()));
        }
        finally {
            if (oldURL != null) {
                this.repos2.setLocation(oldURL, false);
            }
            editor.cleanup();
        }
        if (this.conflictedPaths == null) {
            this.conflictedPaths = mergeCallback.getConflictedPaths();
        }
        return editor;
    }

    protected boolean isHonorMergeInfo() {
        return this.sourcesAncestral && this.sameRepos && !this.ignoreAncestry && this.mergeinfoCapable;
    }

    public boolean isRecordMergeInfo() {
        return !this.dryRun && this.isHonorMergeInfo();
    }

    protected SVNURL ensureSessionURL(SVNRepository repository, SVNURL url) throws SVNException {
        SVNURL oldURL = repository.getLocation();
        if (url == null) {
            url = repository.getRepositoryRoot(true);
        }
        if (!url.equals(oldURL)) {
            repository.setLocation(url, false);
            return oldURL;
        }
        return oldURL;
    }

    private int findNearestAncestor(Object[] childrenWithMergeInfoArray, boolean pathIsOwnAncestor, File path) {
        if (childrenWithMergeInfoArray == null) {
            return 0;
        }
        int ancestorIndex = 0;
        for (int i = 0; i < childrenWithMergeInfoArray.length; ++i) {
            String pathStr;
            MergePath child = (MergePath)childrenWithMergeInfoArray[i];
            String childPath = child.absPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (!SVNPathUtil.isAncestor(childPath, pathStr = path.getAbsolutePath().replace(File.separatorChar, '/')) || childPath.equals(pathStr) && !pathIsOwnAncestor) continue;
            ancestorIndex = i;
        }
        return ancestorIndex;
    }

    private Map<File, MergePath> getMergeInfoPaths(Map<File, MergePath> children, String mergeSrcPath, SVNURL sourceRootURL, SVNURL url1, SVNURL url2, long revision1, long revision2, SVNRepository repository, SVNDepth depth) throws SVNException {
        Collection<File> excludedTrees;
        TreeMap<File, MergePath> childrenWithMergeInfo = children == null ? new TreeMap<File, MergePath>() : children;
        SvnGetProperties pg = this.operation.getOperationFactory().createGetProperties();
        final TreeMap subtreesWithMergeinfo = new TreeMap();
        pg.setDepth(depth);
        pg.setSingleTarget(SvnTarget.fromFile(this.targetAbsPath, SVNRevision.WORKING));
        pg.setRevision(SVNRevision.WORKING);
        pg.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                String value = object.getStringValue("svn:mergeinfo");
                if (value != null) {
                    subtreesWithMergeinfo.put(target.getFile(), value);
                }
            }
        });
        pg.run();
        if (!subtreesWithMergeinfo.isEmpty()) {
            for (File wcPath : subtreesWithMergeinfo.keySet()) {
                Map<String, SVNMergeRangeList> mi;
                String value = (String)subtreesWithMergeinfo.get(wcPath);
                MergePath mp = new MergePath(wcPath);
                try {
                    mi = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(value), null);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_MERGEINFO_NO_MERGETRACKING, "Invalid mergeinfo detected on ''{0}'', mergetracking not possible");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    throw e;
                }
                mp.preMergeMergeInfo = mi;
                mp.hasNonInheritable = value != null && value.indexOf(SVNMergeRangeList.MERGE_INFO_NONINHERITABLE_STRING) >= 0;
                childrenWithMergeInfo.put(mp.absPath, mp);
            }
        }
        final HashMap shallowSubtrees = new HashMap();
        final HashSet missingSubtrees = new HashSet();
        final HashSet switchedSubtrees = new HashSet();
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(this.targetAbsPath, this.context, this.operation.getOptions(), true, true, depth, new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                boolean fileExternal;
                block8: {
                    fileExternal = false;
                    if (status.isVersioned() && status.isSwitched() && status.getKind() == SVNNodeKind.FILE) {
                        try {
                            Structure<StructureFields.ExternalNodeInfo> info = SvnWcDbExternals.readExternal(SvnNgMergeDriver.this.context, status.getPath(), SvnNgMergeDriver.this.targetAbsPath, StructureFields.ExternalNodeInfo.kind);
                            fileExternal = info.get(StructureFields.ExternalNodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File;
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block8;
                            throw e;
                        }
                    }
                }
                if (status.isSwitched() && !fileExternal) {
                    switchedSubtrees.add(status.getPath());
                }
                if (status.getDepth() == SVNDepth.EMPTY || status.getDepth() == SVNDepth.FILES) {
                    shallowSubtrees.put(status.getPath(), status.getDepth());
                }
                if (status.getNodeStatus() == SVNStatusType.STATUS_MISSING) {
                    boolean parentPresent = false;
                    for (File missingRoot : missingSubtrees) {
                        if (!SVNWCUtils.isAncestor(missingRoot, status.getPath())) continue;
                        parentPresent = true;
                        break;
                    }
                    if (!parentPresent) {
                        missingSubtrees.add(status.getPath());
                    }
                }
            }
        });
        statusEditor.walkStatus(this.targetAbsPath, depth, true, true, true, null);
        if (!missingSubtrees.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("Merge tracking not allowed with missing subtrees; try restoring these items first:\n");
            Object[] values = new Object[missingSubtrees.size()];
            int index = 0;
            for (File missingPath : missingSubtrees) {
                values[index] = missingPath;
                errorMessage.append("{" + index + "}\n");
                ++index;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, errorMessage.toString(), values);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!switchedSubtrees.isEmpty()) {
            for (File switchedPath : switchedSubtrees) {
                MergePath child = this.getChildWithMergeinfo(childrenWithMergeInfo, switchedPath);
                if (child != null) {
                    child.switched = true;
                    continue;
                }
                child = new MergePath(switchedPath);
                child.switched = true;
                childrenWithMergeInfo.put(child.absPath, child);
            }
        }
        if (!shallowSubtrees.isEmpty()) {
            for (File shallowPath : shallowSubtrees.keySet()) {
                MergePath child = this.getChildWithMergeinfo(childrenWithMergeInfo, shallowPath);
                SVNDepth childDepth = (SVNDepth)shallowSubtrees.get(shallowPath);
                boolean newChild = false;
                if (child != null) {
                    if (childDepth == SVNDepth.EMPTY || childDepth == SVNDepth.FILES) {
                        child.missingChild = true;
                    }
                } else {
                    newChild = true;
                    child = new MergePath(shallowPath);
                    if (childDepth == SVNDepth.EMPTY || childDepth == SVNDepth.FILES) {
                        child.missingChild = true;
                    }
                }
                if (!(child.hasNonInheritable || childDepth != SVNDepth.EMPTY && childDepth != SVNDepth.FILES)) {
                    child.hasNonInheritable = true;
                }
                if (!newChild) continue;
                childrenWithMergeInfo.put(child.absPath, child);
            }
        }
        if ((excludedTrees = SvnWcDbReader.getServerExcludedNodes((SVNWCDb)this.context.getDb(), this.targetAbsPath)) != null && !excludedTrees.isEmpty()) {
            for (File excludedTree : excludedTrees) {
                MergePath mp = this.getChildWithMergeinfo(childrenWithMergeInfo, excludedTree);
                if (mp != null) {
                    mp.absent = true;
                    continue;
                }
                mp = new MergePath(excludedTree);
                mp.absent = true;
                childrenWithMergeInfo.put(mp.absPath, mp);
            }
        }
        if (this.getChildWithMergeinfo(childrenWithMergeInfo, this.targetAbsPath) == null) {
            childrenWithMergeInfo.put(this.targetAbsPath, new MergePath(this.targetAbsPath));
        }
        if (depth == SVNDepth.IMMEDIATES || depth == SVNDepth.FILES) {
            List<File> immediateChildren = this.context.getChildrenOfWorkingNode(this.targetAbsPath, false);
            for (File immeidateChild : immediateChildren) {
                SVNNodeKind childKind = this.context.readKind(immeidateChild, false);
                if ((childKind != SVNNodeKind.DIR || depth != SVNDepth.IMMEDIATES) && (childKind != SVNNodeKind.FILE || depth != SVNDepth.FILES) || this.getChildWithMergeinfo(childrenWithMergeInfo, immeidateChild) != null) continue;
                MergePath mp = new MergePath(immeidateChild);
                if (childKind == SVNNodeKind.DIR && depth == SVNDepth.IMMEDIATES) {
                    mp.immediateChildDir = true;
                }
                childrenWithMergeInfo.put(mp.absPath, mp);
            }
        }
        if (depth.compareTo(SVNDepth.EMPTY) <= 0) {
            return childrenWithMergeInfo;
        }
        for (File childPath : new TreeSet(childrenWithMergeInfo.keySet())) {
            MergePath child = (MergePath)childrenWithMergeInfo.get(childPath);
            if (child.hasNonInheritable) {
                List<File> childrenOfNonInheritable = this.context.getNodeChildren(child.absPath, false);
                for (File childOfNonInheritable : childrenOfNonInheritable) {
                    SVNNodeKind childKind;
                    MergePath mpOfNonInheritable = this.getChildWithMergeinfo(childrenWithMergeInfo, childOfNonInheritable);
                    if (mpOfNonInheritable != null || depth == SVNDepth.FILES && (childKind = this.context.readKind(childOfNonInheritable, false)) != SVNNodeKind.FILE) continue;
                    mpOfNonInheritable = new MergePath(childOfNonInheritable);
                    mpOfNonInheritable.childOfNonInheritable = true;
                    childrenWithMergeInfo.put(mpOfNonInheritable.absPath, mpOfNonInheritable);
                    if (this.dryRun || !this.sameRepos) continue;
                    SvnNgMergeinfoUtil.SvnMergeInfoInfo info = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, mpOfNonInheritable.absPath, this.targetAbsPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false);
                    this.recordMergeinfo(childOfNonInheritable, info.mergeinfo, false);
                }
            }
            this.insertParentAndSiblingsOfAbsentDelSubtree(childrenWithMergeInfo, child, depth);
        }
        return childrenWithMergeInfo;
    }

    private void insertParentAndSiblingsOfAbsentDelSubtree(Map<File, MergePath> childrenWithMergeInfo, MergePath child, SVNDepth depth) throws SVNException {
        if (!(child.absent || child.switched && !this.targetAbsPath.equals(child.absPath))) {
            return;
        }
        File parentPath = SVNFileUtil.getParentFile(child.absPath);
        MergePath parentMp = this.getChildWithMergeinfo(childrenWithMergeInfo, parentPath);
        if (parentMp != null) {
            parentMp.missingChild = true;
        } else {
            parentMp = new MergePath(parentPath);
            parentMp.missingChild = true;
            childrenWithMergeInfo.put(parentPath, parentMp);
        }
        List<File> files = this.context.getNodeChildren(parentPath, false);
        for (File file : files) {
            MergePath siblingMp = this.getChildWithMergeinfo(childrenWithMergeInfo, file);
            if (siblingMp != null || depth == SVNDepth.FILES && this.context.readKind(file, false) != SVNNodeKind.FILE) continue;
            childrenWithMergeInfo.put(file, new MergePath(file));
        }
    }

    private MergePath getChildWithMergeinfo(Map<File, MergePath> childrenWithMergeInfo, File path) {
        return childrenWithMergeInfo.get(path);
    }

    private void populateRemainingRanges(Map<File, MergePath> childrenWithMergeInfo, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, boolean honorMergeInfo, SVNRepository repository, String parentMergeSrcCanonPath) throws SVNException {
        if (!honorMergeInfo || this.recordOnly) {
            int index = 0;
            Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
            for (MergePath child : childrenWithMergeInfo.values()) {
                SVNMergeRange range = new SVNMergeRange(revision1, revision2, true);
                child.remainingRanges = new SVNMergeRangeList(range);
                if (index == 0) {
                    boolean[] indirect = new boolean[]{false};
                    Map<String, SVNMergeRangeList>[] mergeInfo = this.getFullMergeInfo(false, true, indirect, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
                    child.implicitMergeInfo = mergeInfo[1];
                } else {
                    int parentIndex = this.findNearestAncestor(childrenWithMergeInfoArray, false, child.absPath);
                    MergePath parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                    boolean childInheritsImplicit = parent != null && !child.switched;
                    this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, revision1, revision2, repository);
                }
                ++index;
            }
            return;
        }
        long[] gap = new long[2];
        this.findGapsInMergeSourceHistory(gap, parentMergeSrcCanonPath, url1, revision1, url2, revision2, repository);
        if (gap[0] >= 0L && gap[1] >= 0L) {
            this.implicitSrcGap = new SVNMergeRangeList(gap[0], gap[1], true);
        }
        int index = 0;
        for (MergePath child : childrenWithMergeInfo.values()) {
            Object[] childrenWithMergeInfoArray;
            int parentIndex;
            if (child == null || child.absent) {
                ++index;
                continue;
            }
            String childRelativePath = null;
            childRelativePath = this.targetAbsPath.equals(child.absPath) ? "" : SVNPathUtil.getRelativePath(this.targetAbsPath.getAbsolutePath(), child.absPath.getAbsolutePath());
            MergePath parent = null;
            SVNURL childURL1 = url1.appendPath(childRelativePath, false);
            SVNURL childURL2 = url2.appendPath(childRelativePath, false);
            boolean[] inherited = new boolean[]{false};
            Map<String, SVNMergeRangeList>[] mergeInfo = this.getFullMergeInfo(child.preMergeMergeInfo == null, index == 0, inherited, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            if (child.preMergeMergeInfo == null) {
                child.preMergeMergeInfo = mergeInfo[0];
            }
            if (index == 0) {
                child.implicitMergeInfo = mergeInfo[1];
            }
            child.inheritedMergeInfo = inherited[0];
            if (index > 0 && (parentIndex = this.findNearestAncestor(childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray(), false, child.absPath)) >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
            }
            boolean childInheritsImplicit = parent != null && !child.switched;
            this.calculateRemainingRanges(parent, child, sourceRootURL, childURL1, revision1, childURL2, revision2, child.preMergeMergeInfo, this.implicitSrcGap, index > 0, childInheritsImplicit, repository);
            if (child.remainingRanges.getSize() > 0 && this.implicitSrcGap != null) {
                boolean properSubset = false;
                boolean equals = false;
                boolean overlapsOrAdjoins = false;
                if (revision1 > revision2) {
                    child.remainingRanges.reverse();
                }
                for (int j = 0; j < child.remainingRanges.getSize(); ++j) {
                    long start = child.remainingRanges.getRanges()[j].getStartRevision();
                    long end = child.remainingRanges.getRanges()[j].getEndRevision();
                    if (start <= gap[0] && gap[1] < end || start < gap[0] && gap[1] <= end) {
                        properSubset = true;
                        break;
                    }
                    if (gap[0] == start && gap[1] == end) {
                        equals = true;
                        break;
                    }
                    if (gap[0] > end || start > gap[1]) continue;
                    overlapsOrAdjoins = true;
                    break;
                }
                if (!properSubset) {
                    if (overlapsOrAdjoins) {
                        child.remainingRanges = child.remainingRanges.merge(this.implicitSrcGap);
                    } else if (equals) {
                        child.remainingRanges = child.remainingRanges.diff(this.implicitSrcGap, false);
                    }
                }
                if (revision1 > revision2) {
                    child.remainingRanges.reverse();
                }
            }
            ++index;
        }
    }

    protected Map<String, SVNMergeRangeList>[] getFullMergeInfo(boolean getRecorded, boolean getImplicit, boolean[] inherited, SVNMergeInfoInheritance inherit, SVNRepository repos, File target, long start, long end) throws SVNException {
        SvnNgMergeinfoUtil.SvnMergeInfoCatalogInfo catalog;
        Map[] result = new Map[2];
        SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(start) && SVNRevision.isValidRevisionNumber(end) && start > end, null, SVNLogType.WC);
        if (getRecorded && (catalog = SvnNgMergeinfoUtil.getWcOrReposMergeInfoCatalog(this.context, repos, target, false, false, false, inherit)) != null) {
            result[0] = catalog.catalog != null ? catalog.catalog.values().iterator().next() : null;
            inherited[0] = catalog.inherited;
        }
        if (getImplicit) {
            File reposRelPath = null;
            SVNURL reposRootUrl = null;
            long targetRevision = -1L;
            Structure<StructureFields.NodeOriginInfo> originInfo = this.context.getNodeOrigin(target, false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
            reposRelPath = (File)originInfo.get(StructureFields.NodeOriginInfo.reposRelpath);
            reposRootUrl = (SVNURL)originInfo.get(StructureFields.NodeOriginInfo.reposRootUrl);
            targetRevision = originInfo.lng(StructureFields.NodeOriginInfo.revision);
            if (reposRelPath == null) {
                result[1] = new TreeMap();
            } else if (targetRevision <= end) {
                result[1] = new TreeMap();
            } else {
                SVNURL url = SVNWCUtils.join(reposRootUrl, reposRelPath);
                SVNURL sessionUrl = this.ensureSessionURL(repos, url);
                if (targetRevision < start) {
                    start = targetRevision;
                }
                result[1] = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, SVNRevision.create(targetRevision)), start, end);
                this.ensureSessionURL(repos, sessionUrl);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map calculateImplicitMergeInfo(SVNRepository repos, SVNURL url, long[] targetRev, long start, long end) throws SVNException {
        Map<String, SVNMergeRangeList> implicitMergeInfo = null;
        boolean closeSession = false;
        SVNURL sessionURL = null;
        try {
            if (repos != null) {
                sessionURL = this.ensureSessionURL(repos, url);
            } else {
                repos = this.repositoryAccess.createRepository(url, null, false);
                closeSession = true;
            }
            if (targetRev[0] < start) {
                this.repositoryAccess.getLocations(repos, SvnTarget.fromURL(url), SVNRevision.create(targetRev[0]), SVNRevision.create(start), SVNRevision.UNDEFINED);
                targetRev[0] = start;
            }
            implicitMergeInfo = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, SVNRevision.create(targetRev[0])), start, end);
            if (sessionURL != null) {
                repos.setLocation(sessionURL, false);
            }
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
        return implicitMergeInfo;
    }

    private void inheritImplicitMergeinfoFromParent(MergePath parent, MergePath child, long revision1, long revision2, SVNRepository repository) throws SVNException {
        if (parent.implicitMergeInfo == null) {
            Map<String, SVNMergeRangeList>[] mergeinfo = this.getFullMergeInfo(false, true, null, SVNMergeInfoInheritance.INHERITED, repository, parent.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            parent.implicitMergeInfo = mergeinfo[1];
        }
        child.implicitMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        String ancestorPath = SVNPathUtil.getCommonPathAncestor(parent.absPath.getAbsolutePath().replace(File.separatorChar, '/'), child.absPath.getAbsolutePath().replace(File.separatorChar, '/'));
        String childPath = SVNPathUtil.getPathAsChild(ancestorPath, child.absPath.getAbsolutePath().replace(File.separatorChar, '/'));
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        SVNMergeInfoUtil.adjustMergeInfoSourcePaths(child.implicitMergeInfo, childPath, parent.implicitMergeInfo);
    }

    private void ensureImplicitMergeinfo(MergePath parent, MergePath child, boolean childInheritsParent, long revision1, long revision2, SVNRepository repository) throws SVNException {
        if (child.implicitMergeInfo != null) {
            return;
        }
        if (childInheritsParent) {
            this.inheritImplicitMergeinfoFromParent(parent, child, revision1, revision2, repository);
        } else {
            Map<String, SVNMergeRangeList>[] mergeinfo = this.getFullMergeInfo(false, true, null, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            child.implicitMergeInfo = mergeinfo[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findGapsInMergeSourceHistory(long[] gap, String mergeSrcCanonPath, SVNURL url1, long rev1, SVNURL url2, long rev2, SVNRepository repos) throws SVNException {
        long youngRev = Math.max(rev1, rev2);
        long oldRev = Math.min(rev1, rev2);
        SVNURL url = rev2 < rev1 ? url1 : url2;
        gap[1] = -1L;
        gap[0] = -1L;
        SVNRevision pegRevision = SVNRevision.create(youngRev);
        SVNURL oldURL = null;
        if (repos != null) {
            oldURL = this.ensureSessionURL(repos, url);
        }
        Map<String, SVNMergeRangeList> implicitSrcMergeInfo = null;
        try {
            implicitSrcMergeInfo = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, pegRevision), youngRev, oldRev);
        }
        finally {
            if (repos != null && oldURL != null) {
                repos.setLocation(oldURL, false);
            }
        }
        SVNMergeRangeList rangelist = implicitSrcMergeInfo.get(mergeSrcCanonPath);
        if (rangelist != null) {
            if (rangelist.getSize() > 1) {
                gap[0] = Math.min(rev1, rev2);
                gap[1] = rangelist.getRanges()[rangelist.getSize() - 1].getStartRevision();
            } else if (implicitSrcMergeInfo.size() > 1) {
                SVNMergeRangeList implicitMergeRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
                SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(Math.min(rev1, rev2), Math.max(rev1, rev2), true);
                for (String path : implicitSrcMergeInfo.keySet()) {
                    rangelist = implicitSrcMergeInfo.get(path);
                    implicitMergeRangeList = implicitMergeRangeList != null ? implicitMergeRangeList.merge(rangelist) : rangelist;
                }
                SVNMergeRangeList gapRangeList = requestedMergeRangeList.diff(implicitMergeRangeList, false);
                if (gapRangeList.getSize() > 0) {
                    gap[0] = gapRangeList.getRanges()[0].getStartRevision();
                    gap[1] = gapRangeList.getRanges()[0].getEndRevision();
                }
            }
        }
    }

    public void calculateRemainingRanges(MergePath parent, MergePath child, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, Map targetMergeInfo, SVNMergeRangeList implicitSrcGap, boolean isSubtree, boolean childInheritsImplicit, SVNRepository repository) throws SVNException {
        block7: {
            SVNURL primaryURL = revision1 < revision2 ? url2 : url1;
            Map<String, SVNMergeRangeList> adjustedTargetMergeInfo = null;
            String mergeInfoPath = this.getPathRelativeToRoot(primaryURL, sourceRootURL, repository);
            if (implicitSrcGap != null && child.preMergeMergeInfo != null) {
                SVNMergeRangeList explicitMergeInfoGapRanges = child.preMergeMergeInfo.get(mergeInfoPath);
                if (explicitMergeInfoGapRanges != null) {
                    TreeMap<String, SVNMergeRangeList> gapMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                    gapMergeInfo.put(mergeInfoPath, implicitSrcGap);
                    adjustedTargetMergeInfo = SVNMergeInfoUtil.removeMergeInfo(gapMergeInfo, targetMergeInfo, false);
                }
            } else {
                adjustedTargetMergeInfo = targetMergeInfo;
            }
            this.filterMergedRevisions(parent, child, repository, mergeInfoPath, adjustedTargetMergeInfo, revision1, revision2, childInheritsImplicit);
            long childBaseRevision = this.context.getNodeBaseRev(child.absPath);
            if (childBaseRevision >= 0L && (child.remainingRanges == null || child.remainingRanges.isEmpty()) && revision2 < revision1 && childBaseRevision <= revision2) {
                try {
                    Structure<SvnRepositoryAccess.LocationsInfo> locations = this.repositoryAccess.getLocations(repository, SvnTarget.fromURL(url1), SVNRevision.create(revision1), SVNRevision.create(childBaseRevision), SVNRevision.UNDEFINED);
                    SVNURL startURL = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                    if (startURL.equals(this.context.getNodeUrl(child.absPath))) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reverse-merge a range from a path's own future history; try updating first");
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                }
                catch (SVNException svne) {
                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block7;
                    throw svne;
                }
            }
        }
    }

    private void adjustDeletedSubTreeRanges(MergePath child, MergePath parent, long revision1, long revision2, SVNURL primaryURL, SVNRepository repository) throws SVNException {
        long pegRev;
        SVNErrorManager.assertionFailure(parent.remainingRanges != null, "parent must already have non-null remaining ranges set", SVNLogType.WC);
        String relativePath = this.getPathRelativeToRoot(primaryURL, repository.getLocation(), repository);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        boolean isRollback = revision2 < revision1;
        long youngerRev = pegRev = isRollback ? revision1 : revision2;
        long olderRev = isRollback ? revision2 : revision1;
        List<SVNLocationSegment> locationSegments = null;
        try {
            locationSegments = repository.getLocationSegments(relativePath, pegRev, youngerRev, olderRev);
        }
        catch (SVNException e) {
            SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
            if (errCode == SVNErrorCode.FS_NOT_FOUND || errCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                SVNNodeKind kind = repository.checkPath(relativePath, olderRev);
                if (kind == SVNNodeKind.NONE) {
                    child.remainingRanges = parent.remainingRanges.dup();
                } else {
                    long primaryURLDeletedRevision = repository.getDeletedRevision(relativePath, olderRev, youngerRev);
                    SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(primaryURLDeletedRevision), "deleted revision must exist", SVNLogType.WC);
                    if (isRollback) {
                        child.remainingRanges = child.remainingRanges.reverse();
                        parent.remainingRanges = parent.remainingRanges.reverse();
                    }
                    SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, primaryURLDeletedRevision - 1L, true));
                    child.remainingRanges = child.remainingRanges.intersect(existingRangeList, false);
                    SVNMergeRangeList deletedRangeList = new SVNMergeRangeList(new SVNMergeRange(primaryURLDeletedRevision - 1L, pegRev, true));
                    deletedRangeList = parent.remainingRanges.intersect(deletedRangeList, false);
                    child.remainingRanges = child.remainingRanges.merge(deletedRangeList);
                    if (isRollback) {
                        child.remainingRanges = child.remainingRanges.reverse();
                        parent.remainingRanges = parent.remainingRanges.reverse();
                    }
                }
            }
            throw e;
        }
        if (locationSegments != null && !locationSegments.isEmpty()) {
            SVNLocationSegment segment = locationSegments.get(locationSegments.size() - 1);
            if (segment.getStartRevision() == olderRev) {
                return;
            }
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(segment.getStartRevision(), pegRev, true));
            child.remainingRanges = child.remainingRanges.intersect(existingRangeList, false);
            SVNMergeRangeList nonExistentRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, segment.getStartRevision(), true));
            nonExistentRangeList = parent.remainingRanges.intersect(nonExistentRangeList, false);
            child.remainingRanges = child.remainingRanges.merge(nonExistentRangeList);
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
        }
    }

    private void filterMergedRevisions(MergePath parent, MergePath child, SVNRepository repository, String mergeInfoPath, Map targetMergeInfo, long rev1, long rev2, boolean childInheritsImplicit) throws SVNException {
        SVNMergeRangeList targetRangeList = null;
        SVNMergeRangeList targetImplicitRangeList = null;
        SVNMergeRangeList explicitRangeList = null;
        SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(new SVNMergeRange(rev1, rev2, true));
        if (rev1 > rev2) {
            SVNMergeRangeList[] diff = SVNMergeInfoUtil.diffMergeRangeLists(requestedMergeRangeList = requestedMergeRangeList.reverse(), explicitRangeList = (targetRangeList = targetMergeInfo != null ? (SVNMergeRangeList)targetMergeInfo.get(mergeInfoPath) : null) != null ? targetRangeList.intersect(requestedMergeRangeList, false) : new SVNMergeRangeList(new SVNMergeRange[0]), false);
            SVNMergeRangeList deletedRangeList = diff[0];
            if (deletedRangeList == null || deletedRangeList.isEmpty()) {
                requestedMergeRangeList = requestedMergeRangeList.reverse();
                child.remainingRanges = requestedMergeRangeList.dup();
            } else {
                SVNMergeRangeList implicitRangeList = null;
                this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, rev1, rev2, repository);
                targetImplicitRangeList = child.implicitMergeInfo.get(mergeInfoPath);
                implicitRangeList = targetImplicitRangeList != null ? targetImplicitRangeList.intersect(requestedMergeRangeList, false) : new SVNMergeRangeList(new SVNMergeRange[0]);
                implicitRangeList = implicitRangeList.merge(explicitRangeList);
                implicitRangeList = implicitRangeList.reverse();
                child.remainingRanges = implicitRangeList.dup();
            }
        } else {
            targetRangeList = targetMergeInfo != null ? (SVNMergeRangeList)targetMergeInfo.get(mergeInfoPath) : null;
            explicitRangeList = targetRangeList != null ? requestedMergeRangeList.remove(targetRangeList, false) : requestedMergeRangeList.dup();
            if (explicitRangeList == null || explicitRangeList.isEmpty()) {
                child.remainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
            } else {
                this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, rev1, rev2, repository);
                targetImplicitRangeList = child.implicitMergeInfo.get(mergeInfoPath);
                child.remainingRanges = targetImplicitRangeList != null ? explicitRangeList.remove(targetImplicitRangeList, false) : explicitRangeList.dup();
            }
        }
    }

    protected String getPathRelativeToRoot(SVNURL url, SVNURL reposRootURL, SVNRepository repos) throws SVNException {
        if (reposRootURL == null) {
            reposRootURL = repos.getRepositoryRoot(true);
        }
        String reposRootPath = reposRootURL.getPath();
        String absPath = url.getPath();
        if (!absPath.startsWith(reposRootPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", url, reposRootURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!(absPath = absPath.substring(reposRootPath.length())).startsWith("/")) {
            absPath = "/" + absPath;
        }
        return absPath;
    }

    private void sliceRemainingRanges(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack, long endRevision) {
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent || child.remainingRanges.isEmpty()) continue;
            SVNMergeRange[] originalRemainingRanges = child.remainingRanges.getRanges();
            SVNMergeRange range = originalRemainingRanges[0];
            if ((!isRollBack || range.getStartRevision() <= endRevision || range.getEndRevision() >= endRevision) && (isRollBack || range.getStartRevision() >= endRevision || range.getEndRevision() <= endRevision)) continue;
            SVNMergeRange splitRange1 = new SVNMergeRange(range.getStartRevision(), endRevision, range.isInheritable());
            SVNMergeRange splitRange2 = new SVNMergeRange(endRevision, range.getEndRevision(), range.isInheritable());
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length + 1];
            remainingRanges[0] = splitRange1;
            remainingRanges[1] = splitRange2;
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 2, originalRemainingRanges.length - 1);
            child.remainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private long getMostInclusiveEndRevision(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack) {
        long endRev = -1L;
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent || child.remainingRanges.getSize() <= 0) continue;
            SVNMergeRange[] ranges = child.remainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (SVNRevision.isValidRevisionNumber(endRev) && (!isRollBack || range.getEndRevision() <= endRev) && (isRollBack || range.getEndRevision() >= endRev)) continue;
            endRev = range.getEndRevision();
        }
        return endRev;
    }

    private long getMostInclusiveStartRevision(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack) {
        long startRev = -1L;
        boolean first = true;
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent) {
                first = false;
                continue;
            }
            if (child.remainingRanges.isEmpty()) {
                first = false;
                continue;
            }
            SVNMergeRange[] ranges = child.remainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (first && range.getStartRevision() == range.getEndRevision()) {
                first = false;
                continue;
            }
            if (!SVNRevision.isValidRevisionNumber(startRev) || isRollBack && range.getStartRevision() > startRev || !isRollBack && range.getStartRevision() < startRev) {
                startRev = range.getStartRevision();
            }
            first = false;
        }
        return startRev;
    }

    private void processChildrenWithNewMergeInfo(Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        if (this.pathsWithNewMergeInfo != null && !this.dryRun) {
            for (File pathWithNewMergeInfo : this.pathsWithNewMergeInfo) {
                SvnNgMergeinfoUtil.SvnMergeInfoInfo pathExplicitMergeInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, pathWithNewMergeInfo, this.targetAbsPath, SVNMergeInfoInheritance.EXPLICIT, false);
                SVNURL oldURL = null;
                if (pathExplicitMergeInfo != null) {
                    oldURL = this.ensureSessionURL(this.repos2, this.context.getNodeUrl(pathWithNewMergeInfo));
                    Map<String, SVNMergeRangeList> pathInheritedMergeInfo = SvnNgMergeinfoUtil.getWCOrReposMergeInfo(this.context, pathWithNewMergeInfo, this.repos2, false, SVNMergeInfoInheritance.NEAREST_ANCESTOR);
                    if (pathInheritedMergeInfo != null) {
                        pathExplicitMergeInfo.mergeinfo = SVNMergeInfoUtil.mergeMergeInfos(pathExplicitMergeInfo.mergeinfo, pathInheritedMergeInfo);
                        String value = SVNMergeInfoUtil.formatMergeInfoToString(pathExplicitMergeInfo.mergeinfo, "");
                        SvnNgPropertiesManager.setProperty(this.context, pathWithNewMergeInfo, "svn:mergeinfo", SVNPropertyValue.create(value), SVNDepth.EMPTY, true, null, null);
                    }
                    MergePath newChild = new MergePath(pathWithNewMergeInfo);
                    if (!childrenWithMergeInfo.containsKey(newChild.absPath)) {
                        Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
                        int parentIndex = this.findNearestAncestor(childrenWithMergeInfoArray, false, pathWithNewMergeInfo);
                        MergePath parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                        newChild.remainingRanges = parent.remainingRanges.dup();
                        childrenWithMergeInfo.put(newChild.absPath, newChild);
                    }
                }
                if (oldURL == null) continue;
                this.repos2.setLocation(oldURL, false);
            }
        }
    }

    private void processChildrenWithDeletedMergeInfo(Map<File, MergePath> childrenWithMergeInfo) {
        if (this.pathsWithDeletedMergeInfo != null && !this.dryRun) {
            Iterator<MergePath> children = childrenWithMergeInfo.values().iterator();
            children.next();
            while (children.hasNext()) {
                MergePath path = children.next();
                if (path == null || !this.pathsWithDeletedMergeInfo.contains(path.absPath)) continue;
                children.remove();
            }
        }
    }

    private void removeFirstRangeFromRemainingRanges(long endRevision, Map<File, MergePath> childrenWithMergeInfo) {
        for (MergePath child : childrenWithMergeInfo.values()) {
            SVNMergeRange[] originalRemainingRanges;
            SVNMergeRange firstRange;
            if (child == null || child.absent || child.remainingRanges.isEmpty() || (firstRange = (originalRemainingRanges = child.remainingRanges.getRanges())[0]).getEndRevision() != endRevision) continue;
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length - 1];
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 0, originalRemainingRanges.length - 1);
            child.remainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private SVNErrorMessage makeMergeConflictError(File targetPath, SVNMergeRange range) {
        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "One or more conflicts were produced while merging r{0}:{1} into\n''{2}'' --\nresolve all conflicts and rerun the merge to apply the remaining\nunmerged revisions", Long.toString(range.getStartRevision()), Long.toString(range.getEndRevision()), targetPath);
        return error;
    }

    private void removeAbsentChildren(File targetWCPath, Map<File, MergePath> childrenWithMergeInfo) {
        Iterator<File> children = childrenWithMergeInfo.keySet().iterator();
        while (children.hasNext()) {
            File childPath = children.next();
            MergePath child = childrenWithMergeInfo.get(childPath);
            String topDir = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
            String childPathStr = child.absPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (child == null || !child.absent && !child.scheduledForDeletion || !SVNPathUtil.isAncestor(topDir, childPathStr)) continue;
            children.remove();
        }
    }

    protected void recordMergeInfoForDirectoryMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, SVNMergeRange mergeRange, String mergeInfoPath, SVNDepth depth, boolean squelchMergeinfoNotifications) throws SVNException {
        boolean isRollBack = mergeRange.getStartRevision() > mergeRange.getEndRevision();
        boolean operativeMerge = false;
        SVNMergeRange range = mergeRange.dup();
        if (this.mergedPaths != null && !this.mergedPaths.isEmpty() || this.skippedPaths != null && !this.skippedPaths.isEmpty() || this.addedPaths != null && !this.addedPaths.isEmpty() || this.treeConflictedPaths != null && !this.treeConflictedPaths.isEmpty()) {
            operativeMerge = true;
        }
        if (!operativeMerge) {
            range.setInheritable(true);
        }
        this.removeAbsentChildren(this.targetAbsPath, this.childrenWithMergeInfo);
        Map<File, String> inoperativeImmediateChildren = null;
        if (!this.recordOnly && range.getStartRevision() <= range.getEndRevision() && depth == SVNDepth.IMMEDIATES) {
            inoperativeImmediateChildren = this.getInoperativeImmediateChildrent(mergeInfoPath, range.getStartRevision() + 1L, range.getEndRevision(), this.targetAbsPath, this.repos1);
        }
        Object[] array = this.childrenWithMergeInfo.values().toArray();
        for (int index = 0; index < array.length; ++index) {
            MergePath child = (MergePath)array[index];
            if (child.absent) continue;
            if (!(index <= 0 || this.recordOnly && !this.reintegrateMerge || child.immediateChildDir && child.preMergeMergeInfo == null || operativeMerge && this.isSubtreeTouchedByMerge(child.absPath))) {
                if (child.childOfNonInheritable) {
                    this.recordMergeinfo(child.absPath, null, false);
                }
            } else {
                SVNMergeRangeList childMergeRangelist;
                String childMergeSrcCanonPath;
                boolean childNodeDeleted = this.context.isNodeStatusDeleted(child.absPath);
                if (childNodeDeleted || inoperativeImmediateChildren != null && inoperativeImmediateChildren.containsKey(child.absPath)) continue;
                String childReposPath = SVNWCUtils.getPathAsChild(this.targetAbsPath, child.absPath);
                if (childReposPath == null) {
                    childReposPath = "";
                }
                if (!(childMergeSrcCanonPath = SVNPathUtil.append(mergeInfoPath, childReposPath)).startsWith("/")) {
                    childMergeSrcCanonPath = "/" + childMergeSrcCanonPath;
                }
                if ((childMergeRangelist = this.filterNaturalHistoryFromMergeInfo(childMergeSrcCanonPath, child.implicitMergeInfo, range)).isEmpty()) continue;
                if (!squelchMergeinfoNotifications) {
                    SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(child.absPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, mergeRange);
                    if (this.context.getEventHandler() != null) {
                        this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
                    }
                }
                if (index == 0) {
                    this.recordSkips(mergeInfoPath, childMergeRangelist, isRollBack);
                } else if (this.skippedPaths != null && this.skippedPaths.contains(child.absPath)) continue;
                boolean rangelistInheritance = this.calculateMergeInheritance(childMergeRangelist, child.absPath, index == 0, child.missingChild, depth);
                if (child.inheritedMergeInfo) {
                    this.recordMergeinfo(child.absPath, child.preMergeMergeInfo, false);
                }
                if (this.implicitSrcGap != null) {
                    if (isRollBack) {
                        childMergeRangelist = childMergeRangelist.reverse();
                    }
                    childMergeRangelist = childMergeRangelist.remove(this.implicitSrcGap, false);
                    if (isRollBack) {
                        childMergeRangelist = childMergeRangelist.reverse();
                    }
                }
                TreeMap<File, SVNMergeRangeList> childMerges = new TreeMap<File, SVNMergeRangeList>();
                if (!(this.recordOnly && !this.reintegrateMerge || isRollBack)) {
                    SVNURL oldUrl;
                    block26: {
                        SVNURL subtreeMergeUrl = this.reposRootUrl.appendPath(childMergeSrcCanonPath, false);
                        oldUrl = this.ensureSessionURL(this.repos2, subtreeMergeUrl);
                        Map<String, SVNMergeRangeList> subtreeHistory = null;
                        try {
                            subtreeHistory = this.repositoryAccess.getHistoryAsMergeInfo(this.repos2, SvnTarget.fromURL(subtreeMergeUrl, SVNRevision.create(mergeRange.getEndRevision())), Math.max(mergeRange.getStartRevision(), mergeRange.getEndRevision()), Math.min(mergeRange.getStartRevision(), mergeRange.getEndRevision()));
                            SVNMergeRangeList childMergeSrcRangelist = subtreeHistory.get(childMergeSrcCanonPath);
                            childMergeRangelist = childMergeRangelist.intersect(childMergeSrcRangelist, false);
                            if (!rangelistInheritance) {
                                childMergeRangelist.setInheritable(false);
                            }
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) break block26;
                            throw e;
                        }
                    }
                    if (oldUrl != null) {
                        this.repos2.setLocation(oldUrl, false);
                    }
                }
                childMerges.put(child.absPath, childMergeRangelist);
                this.updateWCMergeInfo(resultCatalog, child.absPath, childMergeSrcCanonPath, childMerges, isRollBack);
            }
            if (index <= 0) continue;
            boolean inSwitchedSubtree = false;
            if (child.switched) {
                inSwitchedSubtree = true;
            } else if (index > 1) {
                for (int j = index - 1; j > 0; --j) {
                    MergePath parent = (MergePath)array[j];
                    if (parent == null || !parent.switched || !SVNWCUtils.isAncestor(parent.absPath, child.absPath)) continue;
                    inSwitchedSubtree = true;
                    break;
                }
            }
            SvnNgMergeinfoUtil.elideMergeInfo(this.context, this.repos1, child.absPath, inSwitchedSubtree ? null : this.targetAbsPath);
        }
    }

    private boolean calculateMergeInheritance(SVNMergeRangeList rangeList, File localAbsPath, boolean wcPathIsMergeTarget, boolean wcPathHasMissingChild, SVNDepth depth) throws SVNException {
        SVNNodeKind kind = this.context.readKind(localAbsPath, false);
        boolean result = true;
        if (kind == SVNNodeKind.FILE) {
            rangeList.setInheritable(true);
        } else if (kind == SVNNodeKind.DIR) {
            if (wcPathIsMergeTarget) {
                if (wcPathHasMissingChild || depth == SVNDepth.FILES || depth == SVNDepth.EMPTY) {
                    rangeList.setInheritable(false);
                    result = false;
                } else {
                    rangeList.setInheritable(true);
                }
            } else if (wcPathHasMissingChild || depth == SVNDepth.IMMEDIATES) {
                rangeList.setInheritable(false);
                result = false;
            } else {
                rangeList.setInheritable(true);
            }
        }
        return result;
    }

    private void recordSkips(String mergeInfoPath, SVNMergeRangeList childMergeRangelist, boolean isRollBack) throws SVNException {
        if (this.skippedPaths == null || this.skippedPaths.isEmpty()) {
            return;
        }
        TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>();
        for (File skippedPath : this.skippedPaths) {
            ObstructionState os = this.performObstructionCheck(skippedPath, SVNNodeKind.UNKNOWN);
            if (os != null && (os.obstructionState == SVNStatusType.OBSTRUCTED || os.obstructionState == SVNStatusType.MISSING)) continue;
            merges.put(skippedPath, new SVNMergeRangeList(new SVNMergeRange[0]));
        }
        this.updateWCMergeInfo(null, this.targetAbsPath, mergeInfoPath, merges, isRollBack);
    }

    private void updateWCMergeInfo(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, File targetAbsPath, String reposRelPath, Map<File, SVNMergeRangeList> merges, boolean isRollBack) throws SVNException {
        for (File localAbsPath : merges.keySet()) {
            String localAbsPathRelToTarget;
            String relPath;
            SVNMergeRangeList rangelist;
            SvnNgMergeinfoUtil.SvnMergeInfoInfo mergeinfoInfo;
            Map<String, SVNMergeRangeList> mergeinfo = null;
            SVNMergeRangeList ranges = merges.get(localAbsPath);
            try {
                String propValue;
                SVNProperties properties = this.context.getDb().readProperties(localAbsPath);
                String string = propValue = properties != null ? properties.getStringValue("svn:mergeinfo") : null;
                if (propValue != null) {
                    mergeinfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue), null);
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw e;
            }
            if (mergeinfo == null && ranges.isEmpty() && (mergeinfoInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, localAbsPath, targetAbsPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false)) != null) {
                mergeinfo = mergeinfoInfo.mergeinfo;
            }
            if (mergeinfo == null) {
                mergeinfo = new TreeMap<String, SVNMergeRangeList>();
            }
            if ((rangelist = mergeinfo.get(relPath = (localAbsPathRelToTarget = SVNWCUtils.getPathAsChild(targetAbsPath, localAbsPath)) != null ? SVNPathUtil.append(reposRelPath, localAbsPathRelToTarget) : reposRelPath)) == null) {
                rangelist = new SVNMergeRangeList(new SVNMergeRange[0]);
            }
            if (isRollBack) {
                ranges = ranges.dup().reverse();
                rangelist = rangelist.remove(ranges, false);
            } else {
                rangelist = rangelist.merge(ranges);
            }
            mergeinfo.put(relPath, rangelist);
            if (isRollBack && mergeinfo.isEmpty()) {
                mergeinfo = null;
            }
            SVNMergeInfoUtil.removeEmptyRangeLists(mergeinfo);
            if (resultCatalog != null) {
                Map<String, SVNMergeRangeList> existingMergeInfo = resultCatalog.get(localAbsPath);
                if (existingMergeInfo != null) {
                    mergeinfo = SVNMergeInfoUtil.mergeMergeInfos(mergeinfo, existingMergeInfo);
                }
                resultCatalog.put(localAbsPath, mergeinfo);
                continue;
            }
            try {
                this.recordMergeinfo(localAbsPath, mergeinfo, true);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) continue;
                throw e;
            }
        }
    }

    private void recordMergeinfo(File localAbsPath, Map<String, SVNMergeRangeList> mergeinfo, boolean notify) throws SVNException {
        String mergeInfoValue = null;
        if (mergeinfo != null) {
            mergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(mergeinfo, null);
        }
        boolean mergeInfoChanged = false;
        if (notify && this.context.getEventHandler() != null) {
            SVNWCContext.PropDiffs propDiff = this.context.getPropDiffs(localAbsPath);
            mergeInfoChanged = propDiff.propChanges != null && propDiff.propChanges.containsName("svn:mergeinfo");
        }
        SvnNgPropertiesManager.setProperty(this.context, localAbsPath, "svn:mergeinfo", mergeInfoValue != null ? SVNPropertyValue.create(mergeInfoValue) : null, SVNDepth.EMPTY, true, null, null);
        if (notify && this.context.getEventHandler() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.INAPPLICABLE, mergeInfoChanged ? SVNStatusType.MERGED : SVNStatusType.CHANGED, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_RECORD_INFO, null, null, null);
            this.context.getEventHandler().handleEvent(event, -1.0);
        }
    }

    private boolean isSubtreeTouchedByMerge(File absPath) {
        return this.isSubtree(absPath, this.mergedPaths) || this.isSubtree(absPath, this.skippedPaths) || this.isSubtree(absPath, this.addedPaths) || this.isSubtree(absPath, this.treeConflictedPaths);
    }

    private boolean isSubtree(File path, Collection<File> paths) {
        if (path != null && paths != null) {
            for (File subtree : paths) {
                if (!SVNWCUtils.isAncestor(path, subtree)) continue;
                return true;
            }
        }
        return false;
    }

    private SVNMergeRangeList filterNaturalHistoryFromMergeInfo(String srcPath, Map<String, SVNMergeRangeList> implicitMergeInfo, SVNMergeRange requestedRange) {
        SVNMergeRangeList impliedRangeList;
        SVNMergeRangeList requestedRangeList = new SVNMergeRangeList(requestedRange.dup());
        SVNMergeRangeList filteredRangeList = null;
        if (implicitMergeInfo != null && requestedRange.getStartRevision() < requestedRange.getEndRevision() && (impliedRangeList = implicitMergeInfo.get(srcPath)) != null) {
            filteredRangeList = requestedRangeList.diff(impliedRangeList, false);
        }
        if (filteredRangeList == null) {
            filteredRangeList = requestedRangeList;
        }
        return filteredRangeList;
    }

    private Map<File, String> getInoperativeImmediateChildrent(String mergeSourceReposAbsPath, long oldestRev, long youngestRev, File targetAbsPath, SVNRepository repos) throws SVNException {
        final TreeMap<File, String> result = new TreeMap<File, String>();
        for (File childPath : this.childrenWithMergeInfo.keySet()) {
            MergePath child = this.childrenWithMergeInfo.get(childPath);
            if (!child.immediateChildDir) continue;
            String relPath = SVNWCUtils.getPathAsChild(targetAbsPath, child.absPath);
            String fullPath = SVNPathUtil.append(mergeSourceReposAbsPath, relPath);
            result.put(child.absPath, fullPath);
        }
        if (!result.isEmpty()) {
            repos.log(new String[]{""}, youngestRev, oldestRev, true, false, -1L, false, null, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    for (String changedPath : logEntry.getChangedPaths().keySet()) {
                        File removedPath = null;
                        for (File iPath : result.keySet()) {
                            String reposPath = (String)result.get(iPath);
                            if (reposPath == null || !SVNPathUtil.isAncestor(reposPath, changedPath)) continue;
                            removedPath = iPath;
                            break;
                        }
                        if (removedPath == null) continue;
                        result.remove(removedPath);
                    }
                }
            });
        }
        return result;
    }

    private void recordMergeInfoForAddedSubtrees(SVNMergeRange range, String mergeInfoPath, SVNDepth depth, boolean squelchMergeinfoNotifications) throws SVNException {
        if (this.addedPaths == null) {
            return;
        }
        for (File addedPath : this.addedPaths) {
            File dirPath = SVNFileUtil.getFileDir(addedPath);
            SvnNgMergeinfoUtil.SvnMergeInfoInfo miInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, addedPath, null, SVNMergeInfoInheritance.EXPLICIT, false);
            SvnNgMergeinfoUtil.SvnMergeInfoInfo parentMiInfo = null;
            if (miInfo.mergeinfo == null) {
                parentMiInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, dirPath, null, SVNMergeInfoInheritance.EXPLICIT, false);
                miInfo.inherited = parentMiInfo.inherited;
            }
            if (miInfo.mergeinfo == null && !SVNMergeInfoUtil.isNonInheritable(parentMiInfo.mergeinfo)) continue;
            MergePath targetMergePath = this.childrenWithMergeInfo.values().iterator().next();
            SVNNodeKind kind = this.context.readKind(addedPath, false);
            SVNMergeRange rng = range.dup();
            if (kind == SVNNodeKind.FILE) {
                rng.setInheritable(true);
            } else {
                rng.setInheritable(depth != SVNDepth.INFINITY && depth != SVNDepth.IMMEDIATES);
            }
            SVNMergeRangeList rangelist = new SVNMergeRangeList(rng);
            Map<String, SVNMergeRangeList> mergeMergeino = new TreeMap<String, SVNMergeRangeList>();
            String relAddedPath = SVNWCUtils.getPathAsChild(targetMergePath.absPath, addedPath);
            String addedMergeInfoPath = SVNPathUtil.append(mergeInfoPath, relAddedPath);
            mergeMergeino.put(addedMergeInfoPath, rangelist);
            SVNURL addedMergeInfoUrl = this.reposRootUrl.appendPath(addedMergeInfoPath, false);
            SVNRevision pegRevision = SVNRevision.create(Math.max(range.getStartRevision(), range.getEndRevision()));
            SVNURL oldUrl = this.ensureSessionURL(this.repos2, addedMergeInfoUrl);
            Map<String, SVNMergeRangeList> addsHistory = this.repositoryAccess.getHistoryAsMergeInfo(this.repos2, SvnTarget.fromURL(addedMergeInfoUrl, pegRevision), Math.max(range.getStartRevision(), range.getEndRevision()), Math.min(range.getStartRevision(), range.getEndRevision()));
            if (oldUrl != null) {
                this.repos2.setLocation(oldUrl, false);
            }
            mergeMergeino = SVNMergeInfoUtil.intersectMergeInfo(mergeMergeino, addsHistory, false);
            if (miInfo.mergeinfo != null) {
                mergeMergeino = SVNMergeInfoUtil.mergeMergeInfos(mergeMergeino, miInfo.mergeinfo);
            }
            this.recordMergeinfo(addedPath, mergeMergeino, !squelchMergeinfoNotifications);
        }
    }

    private SVNMergeRangeList removeNoOpMergeRanges(SVNRepository repository, SVNMergeRangeList ranges) throws SVNException {
        long oldestRev = -1L;
        long youngestRev = -1L;
        SVNMergeRange[] mergeRanges = ranges.getRanges();
        for (int i = 0; i < ranges.getSize(); ++i) {
            SVNMergeRange range = mergeRanges[i];
            long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            long minRev = Math.min(range.getStartRevision(), range.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(youngestRev) || maxRev > youngestRev) {
                youngestRev = maxRev;
            }
            if (SVNRevision.isValidRevisionNumber(oldestRev) && minRev >= oldestRev) continue;
            oldestRev = minRev;
        }
        final LinkedList changedRevs = new LinkedList();
        repository.log(new String[]{""}, youngestRev, oldestRev, false, false, 0L, false, new String[0], new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                changedRevs.add(new Long(logEntry.getRevision()));
            }
        });
        long youngestChangedRevision = -1L;
        long oldestChangedRevision = -1L;
        if (changedRevs.size() > 0) {
            youngestChangedRevision = (Long)changedRevs.get(0);
            oldestChangedRevision = (Long)changedRevs.get(changedRevs.size() - 1);
        }
        LinkedList<SVNMergeRange> operativeRanges = new LinkedList<SVNMergeRange>();
        block1: for (int i = 0; i < ranges.getSize(); ++i) {
            SVNMergeRange range = mergeRanges[i];
            long rangeMinRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
            long rangeMaxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            if (rangeMinRev > youngestChangedRevision || rangeMaxRev < oldestChangedRevision) continue;
            Iterator changedRevsIter = changedRevs.iterator();
            while (changedRevsIter.hasNext()) {
                long changedRev = (Long)changedRevsIter.next();
                if (changedRev < rangeMinRev || changedRev > rangeMaxRev) continue;
                operativeRanges.add(range);
                continue block1;
            }
        }
        return SVNMergeRangeList.fromCollection(operativeRanges);
    }

    private void fixDeletedSubtreeRanges(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNRepository repository) throws SVNException {
        boolean isRollback = revision2 < revision1;
        SVNURL sourceRootUrl = repository.getRepositoryRoot(true);
        Object[] array = this.childrenWithMergeInfo.values().toArray();
        for (MergePath child : this.childrenWithMergeInfo.values()) {
            if (child.absent) continue;
            int parentIndex = this.findNearestAncestor(array, false, child.absPath);
            MergePath parent = (MergePath)array[parentIndex];
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            SVNMergeRangeList added = child.remainingRanges.diff(parent.remainingRanges, true);
            SVNMergeRangeList deleted = parent.remainingRanges.diff(child.remainingRanges, true);
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            if (added.isEmpty() && deleted.isEmpty()) continue;
            String childReposSrcPath = SVNWCUtils.getPathAsChild(this.targetAbsPath, child.absPath);
            SVNURL childPrimarySrcUrl = revision1 < revision2 ? url2 : url1;
            childPrimarySrcUrl = childPrimarySrcUrl.appendPath(childReposSrcPath, false);
            this.adjustDeletedSubTreeRanges(child, parent, revision1, revision2, childPrimarySrcUrl, repository);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
    }

    private static boolean isOperativeNotification(SVNEvent event) {
        return event.getContentsStatus() == SVNStatusType.CONFLICTED || event.getContentsStatus() == SVNStatusType.MERGED || event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.CONFLICTED || event.getPropertiesStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.CHANGED || event.getAction() == SVNEventAction.UPDATE_ADD || event.getAction() == SVNEventAction.TREE_CONFLICT;
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        if (this.recordOnly && event.getAction() != SVNEventAction.UPDATE_UPDATE && event.getAction() != SVNEventAction.MERGE_RECORD_INFO_BEGIN) {
            return;
        }
        boolean operative = false;
        if (SvnNgMergeDriver.isOperativeNotification(event)) {
            ++this.operativeNotifications;
            operative = true;
        }
        if (this.sourcesAncestral || this.reintegrateMerge) {
            if (event.getContentsStatus() == SVNStatusType.MERGED || event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.CHANGED || event.getAction() == SVNEventAction.UPDATE_ADD) {
                if (this.mergedPaths == null) {
                    this.mergedPaths = new HashSet<File>();
                }
                this.mergedPaths.add(event.getFile());
            }
            if (event.getAction() == SVNEventAction.SKIP) {
                if (this.skippedPaths == null) {
                    this.skippedPaths = new HashSet<File>();
                }
                this.skippedPaths.add(event.getFile());
            }
            if (event.getAction() == SVNEventAction.TREE_CONFLICT) {
                if (this.treeConflictedPaths == null) {
                    this.treeConflictedPaths = new HashSet<File>();
                }
                this.treeConflictedPaths.add(event.getFile());
            }
            if (event.getAction() == SVNEventAction.UPDATE_ADD) {
                boolean subtreeRoot = true;
                if (this.addedPaths == null) {
                    this.addedPaths = new HashSet<File>();
                } else {
                    File addedPathParent = SVNFileUtil.getFileDir(event.getFile());
                    while (!this.targetAbsPath.equals(addedPathParent)) {
                        if (this.addedPaths.contains(addedPathParent)) {
                            subtreeRoot = false;
                            break;
                        }
                        addedPathParent = SVNFileUtil.getFileDir(addedPathParent);
                    }
                }
                if (subtreeRoot) {
                    this.addedPaths.add(event.getFile());
                }
            }
            if (event.getAction() == SVNEventAction.UPDATE_DELETE && this.addedPaths != null) {
                this.addedPaths.remove(event.getFile());
            }
        }
        if (this.sourcesAncestral) {
            Object[] array;
            int index;
            ++this.notifications;
            if (!this.singleFileMerge && operative && (index = this.findNearestAncestor(array = this.childrenWithMergeInfo.values().toArray(), event.getAction() != SVNEventAction.UPDATE_DELETE, event.getFile())) != this.currentAncestorIndex) {
                MergePath child = (MergePath)array[index];
                this.currentAncestorIndex = index;
                if (!(this.context.getEventHandler() == null || child.absent || child.remainingRanges.isEmpty() || index == 0 && child.remainingRanges == null)) {
                    SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(child.absPath, SVNNodeKind.NONE, null, -1L, this.sameRepos ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, child.remainingRanges.getRanges()[0]);
                    this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
                }
            }
        } else if (this.context.getEventHandler() != null && !this.singleFileMerge && this.operativeNotifications == 1 && operative) {
            SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(this.targetAbsPath, SVNNodeKind.NONE, null, -1L, this.sameRepos ? SVNEventAction.MERGE_BEGIN : SVNEventAction.FOREIGN_MERGE_BEGIN, null, null, null);
            this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
        }
        if (this.context.getEventHandler() != null) {
            this.context.getEventHandler().handleEvent(event, -1.0);
        }
    }

    protected SVNRepository ensureRepository(SVNRepository repository, SVNURL url) throws SVNException {
        if (repository != null) {
            try {
                this.ensureSessionURL(repository, url);
                return repository;
            }
            catch (SVNException sVNException) {
                repository = null;
            }
        }
        if (repository == null) {
            repository = this.repositoryAccess.createRepository(url, null, false);
        }
        return repository;
    }

    public ObstructionState performObstructionCheck(File localAbsPath, SVNNodeKind expectedKind) throws SVNException {
        ObstructionState result = new ObstructionState();
        result.obstructionState = SVNStatusType.INAPPLICABLE;
        result.kind = SVNNodeKind.NONE;
        if (this.dryRun) {
            if (this.isDryRunDeletion(localAbsPath)) {
                result.deleted = true;
                if (expectedKind != SVNNodeKind.UNKNOWN && expectedKind != SVNNodeKind.NONE) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                }
                return result;
            }
            if (this.isDryRunAddition(localAbsPath)) {
                result.added = true;
                result.kind = SVNNodeKind.DIR;
                return result;
            }
        }
        boolean checkRoot = localAbsPath.equals(this.targetAbsPath);
        this.checkWcForObstruction(result, localAbsPath, checkRoot);
        if (result.obstructionState == SVNStatusType.INAPPLICABLE && expectedKind != SVNNodeKind.UNKNOWN && result.kind != expectedKind) {
            result.obstructionState = SVNStatusType.OBSTRUCTED;
        }
        return result;
    }

    boolean isDryRunAddition(File path) {
        return this.dryRun && this.dryRunAdded != null && this.dryRunAdded.contains(path);
    }

    boolean isDryRunDeletion(File path) {
        return this.dryRun && this.dryRunDeletions != null && this.dryRunDeletions.contains(path);
    }

    private void checkWcForObstruction(ObstructionState result, File localAbsPath, boolean noWcRootCheck) throws SVNException {
        boolean isRoot;
        result.kind = SVNNodeKind.NONE;
        result.obstructionState = SVNStatusType.INAPPLICABLE;
        SVNFileType diskKind = SVNFileType.getType(localAbsPath);
        ISVNWCDb.SVNWCDbStatus status = null;
        ISVNWCDb.SVNWCDbKind dbKind = null;
        boolean conflicted = false;
        try {
            Structure<StructureFields.NodeInfo> info = this.context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
            dbKind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.NodeInfo.kind));
            conflicted = info.is(StructureFields.NodeInfo.conflicted);
            info.release();
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            if (diskKind != SVNFileType.NONE) {
                result.obstructionState = SVNStatusType.OBSTRUCTED;
                return;
            }
            try {
                Structure<StructureFields.NodeInfo> parentInfo = this.context.getDb().readInfo(SVNFileUtil.getParentFile(localAbsPath), StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
                ISVNWCDb.SVNWCDbStatus parentStatus = (ISVNWCDb.SVNWCDbStatus)((Object)parentInfo.get(StructureFields.NodeInfo.status));
                ISVNWCDb.SVNWCDbKind parentDbKind = (ISVNWCDb.SVNWCDbKind)((Object)parentInfo.get(StructureFields.NodeInfo.kind));
                if (parentDbKind != ISVNWCDb.SVNWCDbKind.Dir || parentStatus != ISVNWCDb.SVNWCDbStatus.Normal && parentStatus != ISVNWCDb.SVNWCDbStatus.Added) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                }
                parentInfo.release();
            }
            catch (SVNException e2) {
                if (e2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                    return;
                }
                throw e;
            }
            return;
        }
        if (!noWcRootCheck && dbKind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal && (isRoot = this.context.getDb().isWCRoot(localAbsPath))) {
            result.obstructionState = SVNStatusType.OBSTRUCTED;
            return;
        }
        result.kind = dbKind.toNodeKind(status, false);
        switch (status) {
            case Deleted: {
                result.deleted = true;
            }
            case NotPresent: {
                if (diskKind == SVNFileType.NONE) break;
                result.obstructionState = SVNStatusType.OBSTRUCTED;
                break;
            }
            case Excluded: 
            case ServerExcluded: 
            case Incomplete: {
                result.obstructionState = SVNStatusType.MISSING;
                break;
            }
            case Added: {
                result.added = true;
            }
            case Normal: {
                if (diskKind == SVNFileType.NONE) {
                    result.obstructionState = SVNStatusType.MISSING;
                    break;
                }
                SVNNodeKind expectedKind = dbKind.toNodeKind();
                if (SVNFileType.getNodeKind(diskKind) == expectedKind) break;
                result.obstructionState = SVNStatusType.OBSTRUCTED;
            }
        }
        if (conflicted) {
            SVNWCContext.ConflictInfo ci = this.context.getConflicted(localAbsPath, true, true, true);
            result.conflicted = ci != null && (ci.propConflicted || ci.textConflicted || ci.treeConflicted);
        }
    }

    public static class ObstructionState {
        SVNStatusType obstructionState;
        boolean added;
        boolean deleted;
        boolean conflicted;
        SVNNodeKind kind;
    }

    private class NoopLogHandler
    implements ISVNLogEntryHandler {
        private SVNMergeRangeList operativeRanges;
        private SVNMergeRangeList mergedRanges;
        private String sourceReposAbsPath;

        private NoopLogHandler() {
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            this.operativeRanges = this.operativeRanges.mergeRevision(logEntry.getRevision());
            boolean logEntryRevisionRequired = false;
            long revision = logEntry.getRevision();
            for (String changedPath : logEntry.getChangedPaths().keySet()) {
                String relativePath = SVNPathUtil.getRelativePath(this.sourceReposAbsPath, changedPath);
                if (relativePath == null) continue;
                File cwmiPath = SVNFileUtil.createFilePath(SvnNgMergeDriver.this.targetAbsPath, relativePath);
                SVNMergeRangeList pathExclplicitRangeList = null;
                boolean mergeInfoInherited = false;
                while (!logEntryRevisionRequired) {
                    MergePath child = (MergePath)SvnNgMergeDriver.this.childrenWithMergeInfo.get(cwmiPath);
                    if (child != null && child.preMergeMergeInfo != null) {
                        pathExclplicitRangeList = child.preMergeMergeInfo.get(changedPath);
                        break;
                    }
                    if (cwmiPath == null || cwmiPath.equals(SvnNgMergeDriver.this.targetAbsPath)) break;
                    cwmiPath = SVNFileUtil.getParentFile(cwmiPath);
                    changedPath = SVNPathUtil.removeTail(changedPath);
                    mergeInfoInherited = true;
                }
                if (pathExclplicitRangeList != null) {
                    SVNMergeRangeList rl = new SVNMergeRangeList(new SVNMergeRange(revision - 1L, revision, true));
                    SVNMergeRangeList intersection = pathExclplicitRangeList.intersect(rl, mergeInfoInherited);
                    if (intersection.getSize() != 0) continue;
                    logEntryRevisionRequired = true;
                    continue;
                }
                logEntryRevisionRequired = true;
            }
            if (!logEntryRevisionRequired) {
                this.mergedRanges.mergeRevision(revision);
            }
        }
    }

    protected class MergePath
    implements Comparable {
        protected File absPath;
        protected boolean missingChild;
        protected boolean switched;
        protected boolean hasNonInheritable;
        protected boolean absent;
        protected boolean childOfNonInheritable;
        protected SVNMergeRangeList remainingRanges;
        protected Map<String, SVNMergeRangeList> preMergeMergeInfo;
        protected Map<String, SVNMergeRangeList> implicitMergeInfo;
        protected boolean inheritedMergeInfo;
        protected boolean scheduledForDeletion;
        protected boolean immediateChildDir;

        public MergePath(File path) {
            this.absPath = path;
        }

        public int compareTo(Object obj) {
            if (obj == null || obj.getClass() != MergePath.class) {
                return -1;
            }
            MergePath mergePath = (MergePath)obj;
            if (this == mergePath) {
                return 0;
            }
            return this.absPath.compareTo(mergePath.absPath);
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            String str = String.format("missingChild=%s,switched=%s,hasNonInheritable=%s,absent=%s, childOfNonInh=%s,inhMi=%s,scheduledForDeletion=%s,immediateChildDir=%s", this.missingChild, this.switched, this.hasNonInheritable, this.absent, this.childOfNonInheritable, this.inheritedMergeInfo, this.scheduledForDeletion, this.immediateChildDir);
            return this.absPath.toString() + " [" + str + "]";
        }
    }

    public static class MergeSource {
        SVNURL url1;
        long rev1;
        SVNURL url2;
        long rev2;
    }
}

