/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.compat;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNTreeHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.core.wc2.ISvnAddParameters;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnAnnotateItem;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnDiffStatus;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnSchedule;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnWorkingCopyInfo;
import org.tmatesoft.svn.core.wc2.hooks.ISvnCommitHandler;
import org.tmatesoft.svn.core.wc2.hooks.ISvnExternalsHandler;
import org.tmatesoft.svn.core.wc2.hooks.ISvnFileListHook;
import org.tmatesoft.svn.core.wc2.hooks.ISvnPropertyValueProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCodec {
    public static SVNDiffStatus diffStatus(SvnDiffStatus diffStatus) {
        return new SVNDiffStatus(diffStatus.getFile(), diffStatus.getUrl(), diffStatus.getPath(), diffStatus.getModificationType(), diffStatus.isPropertiesModified(), diffStatus.getKind());
    }

    public static SvnDiffStatus diffStatus(SVNDiffStatus diffStatus) {
        SvnDiffStatus result = new SvnDiffStatus();
        result.setFile(diffStatus.getFile());
        result.setUrl(diffStatus.getURL());
        result.setPath(diffStatus.getPath());
        result.setModificationType(diffStatus.getModificationType());
        result.setPropertiesModified(diffStatus.isPropertiesModified());
        result.setKind(diffStatus.getKind());
        result.setUserData(diffStatus);
        return result;
    }

    public static ISvnObjectReceiver<SVNAdminPath> treeReceiver(final ISVNTreeHandler handler) {
        return new ISvnObjectReceiver<SVNAdminPath>(){

            @Override
            public void receive(SvnTarget target, SVNAdminPath path) throws SVNException {
                if (handler != null) {
                    handler.handlePath(path);
                }
            }
        };
    }

    public static ISvnObjectReceiver<SVNAdminPath> changedHistoryReceiver(final ISVNHistoryHandler handler) {
        return new ISvnObjectReceiver<SVNAdminPath>(){

            @Override
            public void receive(SvnTarget target, SVNAdminPath path) throws SVNException {
                if (handler != null) {
                    handler.handlePath(path);
                }
            }
        };
    }

    public static ISvnObjectReceiver<String> changedDirectoriesReceiver(final ISVNChangedDirectoriesHandler handler) {
        return new ISvnObjectReceiver<String>(){

            @Override
            public void receive(SvnTarget target, String path) throws SVNException {
                if (handler != null) {
                    handler.handleDir(path);
                }
            }
        };
    }

    public static ISvnObjectReceiver<SVNChangeEntry> changeEntryReceiver(final ISVNChangeEntryHandler handler) {
        return new ISvnObjectReceiver<SVNChangeEntry>(){

            @Override
            public void receive(SvnTarget target, SVNChangeEntry entry) throws SVNException {
                if (handler != null) {
                    handler.handleEntry(entry);
                }
            }
        };
    }

    public static ISvnObjectReceiver<String> changelistReceiver(final ISVNChangelistHandler handler) {
        return new ISvnObjectReceiver<String>(){

            @Override
            public void receive(SvnTarget target, String object) throws SVNException {
                if (handler != null) {
                    handler.handle(target.getFile(), object);
                }
            }
        };
    }

    public static ISvnObjectReceiver<SVNPropertyData> propertyReceiver(final ISVNPropertyHandler handler) {
        return new ISvnObjectReceiver<SVNPropertyData>(){

            @Override
            public void receive(SvnTarget target, SVNPropertyData object) throws SVNException {
                if (handler != null) {
                    handler.handleProperty(target.getFile(), object);
                }
            }
        };
    }

    public static ISvnObjectReceiver<SVNLogEntry> logReceiver(final ISVNLogEntryHandler handler) {
        return new ISvnObjectReceiver<SVNLogEntry>(){

            @Override
            public void receive(SvnTarget target, SVNLogEntry object) throws SVNException {
                if (handler != null) {
                    handler.handleLogEntry(object);
                }
            }
        };
    }

    public static ISvnObjectReceiver<SvnAnnotateItem> annotateReceiver(final ISVNAnnotateHandler handler) {
        return new ISvnObjectReceiver<SvnAnnotateItem>(){

            @Override
            public void receive(SvnTarget target, SvnAnnotateItem item) throws SVNException {
                if (handler != null) {
                    if (item.isEof()) {
                        handler.handleEOF();
                    } else if (item.isLine()) {
                        handler.handleLine(item.getDate(), item.getRevision(), item.getAuthor(), item.getLine(), item.getMergedDate(), item.getMergedRevision(), item.getMergedAuthor(), item.getMergedPath(), item.getLineNumber());
                    } else if (item.isRevision()) {
                        item.setReturnResult(handler.handleRevision(item.getDate(), item.getRevision(), item.getAuthor(), item.getContents()));
                    }
                }
            }
        };
    }

    public static ISvnObjectReceiver<SvnDiffStatus> diffStatusReceiver(final ISVNDiffStatusHandler handler) {
        return new ISvnObjectReceiver<SvnDiffStatus>(){

            @Override
            public void receive(SvnTarget target, SvnDiffStatus svnDiffStatus) throws SVNException {
                if (handler != null) {
                    handler.handleDiffStatus(SvnCodec.diffStatus(svnDiffStatus));
                }
            }
        };
    }

    public static SvnStatus status(SVNStatus status) {
        SvnStatus result = new SvnStatus();
        result.setUserData(status);
        result.setPath(status.getFile());
        result.setChangedAuthor(status.getAuthor());
        result.setChangedDate(SVNDate.fromDate(status.getCommittedDate()));
        result.setChangedRevision(SvnCodec.revisionNumber(status.getCommittedRevision()));
        result.setChangelist(status.getChangelistName());
        result.setConflicted(status.isConflicted());
        result.setCopied(status.isCopied());
        result.setDepth(status.getDepth());
        result.setFileExternal(status.isFileExternal());
        result.setKind(status.getKind());
        result.setLock(status.getLocalLock());
        result.setNodeStatus(status.getNodeStatus());
        result.setTextStatus(status.getContentsStatus());
        result.setPropertiesStatus(status.getPropertiesStatus());
        result.setRepositoryChangedAuthor(status.getRemoteAuthor());
        result.setRepositoryChangedDate(SVNDate.fromDate(status.getRemoteDate()));
        result.setRepositoryChangedRevision(SvnCodec.revisionNumber(status.getRemoteRevision()));
        result.setRepositoryKind(status.getRemoteKind());
        result.setRepositoryLock(status.getRemoteLock());
        result.setRepositoryNodeStatus(status.getRemoteNodeStatus());
        result.setRepositoryTextStatus(status.getRemoteContentsStatus());
        result.setRepositoryPropertiesStatus(status.getRemotePropertiesStatus());
        result.setRepositoryRelativePath(status.getRepositoryRelativePath());
        result.setRepositoryRootUrl(status.getRepositoryRootURL());
        result.setRepositoryUuid(status.getRepositoryUUID());
        result.setRevision(SvnCodec.revisionNumber(status.getRevision()));
        result.setSwitched(status.isSwitched());
        result.setVersioned(status.isVersioned());
        result.setWcLocked(status.isLocked());
        try {
            result.setCopyFromUrl(status.getCopyFromURL() != null ? SVNURL.parseURIEncoded(status.getCopyFromURL()) : null);
            result.setCopyFromRevision(status.getCopyFromRevision() != null ? status.getCopyFromRevision().getNumber() : -1L);
        }
        catch (SVNException e) {
            result.setCopyFromUrl(null);
        }
        return result;
    }

    public static long revisionNumber(SVNRevision revision) {
        if (revision == null) {
            return -1L;
        }
        return revision.getNumber();
    }

    public static SVNStatus status(SVNWCContext context, SvnStatus status) throws SVNException {
        if (status.getUserData() instanceof SVNStatus) {
            return (SVNStatus)status.getUserData();
        }
        SVNStatus result = new SVNStatus();
        result.setFile(status.getPath());
        result.setKind(status.getKind());
        result.setIsVersioned(status.isVersioned());
        result.setIsConflicted(status.isConflicted());
        result.setNodeStatus(status.getNodeStatus());
        result.setContentsStatus(status.getTextStatus());
        result.setPropertiesStatus(status.getPropertiesStatus());
        if (status.getKind() == SVNNodeKind.DIR) {
            result.setIsLocked(status.isWcLocked());
        }
        result.setIsFileExternal(status.isFileExternal());
        result.setIsCopied(status.isCopied());
        result.setRevision(SVNRevision.create(status.getRevision()));
        result.setCommittedRevision(SVNRevision.create(status.getChangedRevision()));
        result.setAuthor(status.getChangedAuthor());
        result.setCommittedDate(status.getChangedDate());
        result.setRepositoryRootURL(status.getRepositoryRootUrl());
        result.setRepositoryRelativePath(status.getRepositoryRelativePath());
        result.setRepositoryUUID(status.getRepositoryUuid());
        result.setIsSwitched(status.isSwitched());
        if (!status.isVersioned() || !status.isSwitched() || status.getKind() == SVNNodeKind.FILE) {
            // empty if block
        }
        result.setLocalLock(status.getLock());
        result.setChangelistName(status.getChangelist());
        result.setDepth(status.getDepth());
        result.setRemoteKind(status.getRepositoryKind());
        result.setRemoteNodeStatus(status.getRepositoryNodeStatus());
        result.setRemoteContentsStatus(status.getRepositoryTextStatus());
        result.setRemotePropertiesStatus(status.getRepositoryPropertiesStatus());
        result.setRemoteLock(status.getRepositoryLock());
        result.setRemoteAuthor(status.getRepositoryChangedAuthor());
        result.setRemoteRevision(SVNRevision.create(status.getRepositoryChangedRevision()));
        result.setRemoteDate(status.getRepositoryChangedDate());
        if (status.isVersioned() && status.isConflicted()) {
            SVNWCContext.ConflictInfo info = context.getConflicted(status.getPath(), true, true, true);
            if (info.textConflicted) {
                result.setContentsStatus(SVNStatusType.STATUS_CONFLICTED);
            }
            if (info.propConflicted) {
                result.setPropertiesStatus(SVNStatusType.STATUS_CONFLICTED);
            }
            if (info.textConflicted || info.propConflicted) {
                result.setNodeStatus(SVNStatusType.STATUS_CONFLICTED);
            }
        }
        if (status.getRepositoryRootUrl() != null && status.getRepositoryRelativePath() != null) {
            SVNURL url = status.getRepositoryRootUrl().appendPath(status.getRepositoryRelativePath(), false);
            if (status.isVersioned()) {
                result.setURL(url);
            }
            result.setRemoteURL(url);
        }
        if (context != null && status.isVersioned() && status.getRevision() == -1L && !status.isCopied()) {
            if (status.getNodeStatus() == SVNStatusType.STATUS_REPLACED) {
                SvnCodec.fetchStatusRevision(context, status, result);
            } else if (status.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
                SvnCodec.fetchStatusRevision(context, status, result);
            }
        }
        if (context != null && status.isConflicted()) {
            boolean hasTreeConflict = false;
            SVNWCContext.ConflictInfo conflictedInfo = null;
            if (status.isVersioned()) {
                block21: {
                    try {
                        conflictedInfo = context.getConflicted(status.getPath(), true, true, true);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_UPGRADE_REQUIRED) break block21;
                        throw e;
                    }
                }
                hasTreeConflict = conflictedInfo != null && conflictedInfo.treeConflicted;
            } else {
                hasTreeConflict = true;
            }
            if (hasTreeConflict) {
                SVNTreeConflictDescription treeConflictDescription = context.getTreeConflict(status.getPath());
                result.setTreeConflict(treeConflictDescription);
            }
            if (conflictedInfo != null) {
                result.setConflictWrkFile(conflictedInfo.localFile);
                result.setConflictOldFile(conflictedInfo.baseFile);
                result.setConflictNewFile(conflictedInfo.repositoryFile);
                result.setPropRejectFile(conflictedInfo.propRejectFile);
            }
        }
        if (result.getNodeStatus() == SVNStatusType.STATUS_ADDED) {
            result.setPropertiesStatus(SVNStatusType.STATUS_NONE);
        }
        result.setWorkingCopyFormat(29);
        result.setCopyFromRevision(status.getCopyFromRevision() >= 0L ? SVNRevision.create(status.getCopyFromRevision()) : SVNRevision.UNDEFINED);
        result.setCopyFromURL(status.getCopyFromUrl() != null ? status.getCopyFromUrl().toString() : null);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fetchStatusRevision(SVNWCContext context, SvnStatus source, SVNStatus result) throws SVNException {
        Structure<StructureFields.NodeInfo> info = context.getDb().readInfo(source.getPath(), StructureFields.NodeInfo.revision, StructureFields.NodeInfo.changedAuthor, StructureFields.NodeInfo.changedDate, StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveWork, StructureFields.NodeInfo.haveMoreWork, StructureFields.NodeInfo.status);
        if (source.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
            result.setAuthor(info.text(StructureFields.NodeInfo.changedAuthor));
            result.setCommittedDate((Date)info.get(StructureFields.NodeInfo.changedDate));
            result.setCommittedRevision(SVNRevision.create(info.lng(StructureFields.NodeInfo.changedRev)));
        }
        result.setRevision(SVNRevision.create(info.lng(StructureFields.NodeInfo.revision)));
        ISVNWCDb.SVNWCDbStatus st = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
        if (info.is(StructureFields.NodeInfo.haveWork) || info.lng(StructureFields.NodeInfo.revision) == -1L || source.getNodeStatus() == SVNStatusType.STATUS_DELETED && info.lng(StructureFields.NodeInfo.changedRev) == -1L || st != ISVNWCDb.SVNWCDbStatus.Added && st != ISVNWCDb.SVNWCDbStatus.Deleted) {
            info.release();
            try {
                ISVNWCDb.WCDbBaseInfo binfo = context.getDb().getBaseInfo(source.getPath(), ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate);
                if (source.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
                    result.setAuthor(binfo.changedAuthor);
                    result.setCommittedDate(binfo.changedDate);
                    result.setCommittedRevision(SVNRevision.create(binfo.changedRev));
                }
                result.setRevision(SVNRevision.create(binfo.revision));
                return;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) return;
                throw e;
            }
        } else {
            info.release();
        }
    }

    public static SvnInfo info(SVNInfo info) {
        SvnInfo result = new SvnInfo();
        result.setUserData(info);
        result.setKind(info.getKind());
        result.setLastChangedAuthor(info.getAuthor());
        result.setLastChangedDate(SVNDate.fromDate(info.getCommittedDate()));
        result.setLastChangedRevision(info.getCommittedRevision().getNumber());
        result.setLock(info.getLock());
        result.setRepositoryRootURL(info.getRepositoryRootURL());
        result.setRepositoryUuid(info.getRepositoryUUID());
        result.setRevision(info.getRevision().getNumber());
        result.setSize(-1L);
        result.setUrl(info.getURL());
        SvnWorkingCopyInfo wcInfo = new SvnWorkingCopyInfo();
        result.setWcInfo(wcInfo);
        wcInfo.setChangelist(info.getChangelistName());
        if (info.getChecksum() != null) {
            SvnChecksum checksum = new SvnChecksum(SvnChecksum.Kind.md5, info.getChecksum());
            wcInfo.setChecksum(checksum);
        }
        if (info.getTreeConflict() != null || info.getConflictWrkFile() != null || info.getConflictNewFile() != null || info.getConflictOldFile() != null || info.getPropConflictFile() != null) {
            SVNWCConflictDescription17 cd;
            ArrayList<SVNConflictDescription> conflicts = new ArrayList<SVNConflictDescription>();
            if (info.getTreeConflict() != null) {
                conflicts.add(info.getTreeConflict());
            }
            if (info.getConflictWrkFile() != null || info.getConflictNewFile() != null || info.getConflictOldFile() != null) {
                cd = SVNWCConflictDescription17.createText(info.getFile());
                cd.setTheirFile(info.getConflictNewFile());
                cd.setBaseFile(info.getConflictOldFile());
                cd.setMyFile(info.getConflictWrkFile());
                conflicts.add(cd.toConflictDescription());
            }
            if (info.getPropConflictFile() != null) {
                cd = SVNWCConflictDescription17.createProp(info.getFile(), info.getKind(), null);
                cd.setTheirFile(info.getPropConflictFile());
                conflicts.add(cd.toConflictDescription());
            }
            wcInfo.setConflicts(conflicts);
        }
        wcInfo.setCopyFromRevision(info.getCommittedRevision().getNumber());
        wcInfo.setCopyFromUrl(info.getCopyFromURL());
        wcInfo.setDepth(info.getDepth());
        wcInfo.setPath(info.getFile());
        wcInfo.setRecordedSize(info.getWorkingSize());
        if (info.getTextTime() != null) {
            wcInfo.setRecordedTime(info.getTextTime().getTime());
        }
        wcInfo.setSchedule(SvnSchedule.fromString(info.getSchedule()));
        File wcRoot = null;
        try {
            wcRoot = SVNWCUtil.getWorkingCopyRoot(info.getFile(), true);
        }
        catch (SVNException e) {
            // empty catch block
        }
        wcInfo.setWcRoot(wcRoot);
        return result;
    }

    public static SVNInfo info(SvnInfo info) {
        if (info.getUserData() instanceof SVNInfo) {
            return (SVNInfo)info.getUserData();
        }
        if (info.getWcInfo() == null) {
            String rootPath = info.getRepositoryRootUrl().getPath();
            String itemPath = info.getUrl().getPath();
            if ((itemPath = SVNPathUtil.getPathAsChild(rootPath, itemPath)) == null) {
                itemPath = "";
            }
            return new SVNInfo(itemPath, info.getUrl(), SVNRevision.create(info.getRevision()), info.getKind(), info.getRepositoryUuid(), info.getRepositoryRootUrl(), info.getLastChangedRevision(), info.getLastChangedDate(), info.getLastChangedAuthor(), info.getLock(), SVNDepth.UNKNOWN, info.getSize());
        }
        SvnWorkingCopyInfo wcInfo = info.getWcInfo();
        String conflictOld = null;
        String conflictNew = null;
        String conflictWorking = null;
        String propRejectFile = null;
        SVNTreeConflictDescription treeConflict = null;
        Collection<SVNConflictDescription> conflicts = wcInfo.getConflicts();
        if (conflicts != null) {
            for (SVNConflictDescription conflictDescription : conflicts) {
                if (conflictDescription.isTreeConflict() && conflictDescription instanceof SVNTreeConflictDescription) {
                    treeConflict = (SVNTreeConflictDescription)conflictDescription;
                    continue;
                }
                if (conflictDescription.isTextConflict()) {
                    if (conflictDescription.getMergeFiles() == null) continue;
                    if (conflictDescription.getMergeFiles().getBaseFile() != null) {
                        conflictOld = conflictDescription.getMergeFiles().getBaseFile().getName();
                    }
                    if (conflictDescription.getMergeFiles().getRepositoryFile() != null) {
                        conflictNew = conflictDescription.getMergeFiles().getRepositoryFile().getName();
                    }
                    if (conflictDescription.getMergeFiles().getLocalFile() == null) continue;
                    conflictWorking = conflictDescription.getMergeFiles().getLocalFile().getName();
                    continue;
                }
                if (!conflictDescription.isPropertyConflict() || conflictDescription.getMergeFiles() == null) continue;
                propRejectFile = conflictDescription.getMergeFiles().getRepositoryFile().getName();
            }
        }
        String schedule = wcInfo.getSchedule() != null ? wcInfo.getSchedule().asString() : null;
        SVNInfo i = new SVNInfo(wcInfo.getPath(), info.getUrl(), info.getRepositoryRootUrl(), info.getRevision(), info.getKind(), info.getRepositoryUuid(), info.getLastChangedRevision(), info.getLastChangedDate() != null ? info.getLastChangedDate().format() : null, info.getLastChangedAuthor(), schedule, wcInfo.getCopyFromUrl(), wcInfo.getCopyFromRevision(), wcInfo.getRecordedTime() > 0L ? SVNWCUtils.readDate(wcInfo.getRecordedTime()).format() : null, null, wcInfo.getChecksum() != null ? wcInfo.getChecksum().getDigest() : null, conflictOld, conflictNew, conflictWorking, propRejectFile, info.getLock(), wcInfo.getDepth(), wcInfo.getChangelist(), wcInfo.getRecordedSize(), treeConflict);
        i.setWorkingCopyRoot(wcInfo.getWcRoot());
        return i;
    }

    public static ISvnFileListHook fileListHook(final ISVNStatusFileProvider provider) {
        if (provider == null) {
            return null;
        }
        return new ISvnFileListHook(){

            @Override
            public Map<String, File> listFiles(File parent) {
                return provider.getChildrenFiles(parent);
            }
        };
    }

    public static ISVNStatusFileProvider fileListProvider(final ISvnFileListHook hook) {
        if (hook == null) {
            return null;
        }
        return new ISVNStatusFileProvider(){

            @Override
            public Map<String, File> getChildrenFiles(File parent) {
                return hook.listFiles(parent);
            }
        };
    }

    public static SVNCommitItem commitItem(SvnCommitItem item) {
        return new SVNCommitItem(item.getPath(), item.getUrl(), item.getCopyFromUrl(), item.getKind(), SVNRevision.create(item.getRevision()), SVNRevision.create(item.getCopyFromRevision()), item.hasFlag(1), item.hasFlag(2), item.hasFlag(8), item.hasFlag(4), item.hasFlag(16), item.hasFlag(32));
    }

    public static SvnCommitItem commitItem(SVNCommitItem item) {
        SvnCommitItem i = new SvnCommitItem();
        i.setPath(item.getFile());
        i.setUrl(item.getURL());
        i.setKind(item.getKind());
        if (item.getCopyFromRevision() != null) {
            i.setCopyFromRevision(item.getCopyFromRevision().getNumber());
        } else {
            i.setCopyFromRevision(-1L);
        }
        i.setCopyFromUrl(i.getCopyFromUrl());
        i.setRevision(item.getRevision() != null ? item.getRevision().getNumber() : -1L);
        int flags = 0;
        if (item.isAdded()) {
            flags |= 1;
        }
        if (item.isContentsModified()) {
            flags |= 4;
        }
        if (item.isPropertiesModified()) {
            flags |= 8;
        }
        if (item.isCopied()) {
            flags |= 0x10;
        }
        if (item.isDeleted()) {
            flags |= 2;
        }
        if (item.isLocked()) {
            flags |= 0x20;
        }
        i.setFlags(flags);
        return i;
    }

    public static SVNCommitPacket commitPacket(SvnCommit operation, SvnCommitPacket packet) {
        ArrayList<SVNCommitItem> oldItems = new ArrayList<SVNCommitItem>();
        for (SVNURL reposRoot : packet.getRepositoryRoots()) {
            for (SvnCommitItem item : packet.getItems(reposRoot)) {
                oldItems.add(SvnCodec.commitItem(item));
            }
        }
        SVNCommitItem[] allItems = oldItems.toArray(new SVNCommitItem[oldItems.size()]);
        HashMap<String, String> oldLockTokens = new HashMap<String, String>();
        if (packet.getLockTokens() != null) {
            for (SVNURL url : packet.getLockTokens().keySet()) {
                String token = packet.getLockTokens().get(url);
                oldLockTokens.put(url.toString(), token);
            }
        }
        return new SVNCommitPacketWrapper(operation, packet, allItems, oldLockTokens);
    }

    public static SvnCommitPacket commitPacket(ISvnCommitRunner runner, SVNCommitPacket oldPacket) {
        SVNCommitItem item;
        SvnCommitPacket packet = new SvnCommitPacket();
        packet.setLockingContext(runner, oldPacket);
        HashMap<SVNURL, String> lockTokens = new HashMap<SVNURL, String>();
        SVNCommitItem[] items = oldPacket.getCommitItems();
        Map locks = oldPacket.getLockTokens();
        if (locks != null) {
            for (String url : locks.keySet()) {
                try {
                    lockTokens.put(SVNURL.parseURIEncoded(url), (String)locks.get(url));
                }
                catch (SVNException e) {}
            }
        }
        HashSet<SVNURL> allUrl = new HashSet<SVNURL>();
        SVNURL rootUrl = null;
        for (int j = 0; j < items.length; ++j) {
            item = items[j];
            allUrl.add(item.getURL());
            if (item.getCopyFromURL() == null) continue;
            allUrl.add(item.getCopyFromURL());
        }
        for (SVNURL svnurl : allUrl) {
            if (rootUrl == null) {
                rootUrl = svnurl;
                continue;
            }
            rootUrl = SVNURLUtil.getCommonURLAncestor(rootUrl, svnurl);
        }
        for (int j = 0; j < items.length; ++j) {
            item = items[j];
            int flags = 0;
            if (item.isAdded()) {
                flags |= 1;
            }
            if (item.isContentsModified()) {
                flags |= 4;
            }
            if (item.isCopied()) {
                flags |= 0x10;
            }
            if (item.isDeleted()) {
                flags |= 2;
            }
            if (item.isLocked()) {
                flags |= 0x20;
            }
            if (item.isPropertiesModified()) {
                flags |= 8;
            }
            try {
                packet.addItem(item.getFile(), rootUrl, item.getKind(), item.getURL(), item.getRevision() != null ? item.getRevision().getNumber() : -1L, item.getCopyFromURL(), item.getCopyFromRevision() != null ? item.getCopyFromRevision().getNumber() : -1L, flags);
                continue;
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        packet.setLockTokens(lockTokens);
        return packet;
    }

    public static SVNRevisionRange revisionRange(SvnRevisionRange range) {
        return new SVNRevisionRange(range.getStart(), range.getEnd());
    }

    public static SvnRevisionRange revisionRange(SVNRevisionRange range) {
        return SvnRevisionRange.create(range.getStartRevision(), range.getEndRevision());
    }

    public static Collection<SvnRevisionRange> revisionRanges(Collection<SVNRevisionRange> ranges) {
        ArrayList<SvnRevisionRange> result = new ArrayList<SvnRevisionRange>();
        if (ranges != null) {
            for (SVNRevisionRange range : ranges) {
                result.add(SvnCodec.revisionRange(range));
            }
        }
        return result;
    }

    public static Collection<SVNRevisionRange> oldRevisionRanges(Collection<SvnRevisionRange> ranges) {
        ArrayList<SVNRevisionRange> result = new ArrayList<SVNRevisionRange>();
        if (ranges != null) {
            for (SvnRevisionRange range : ranges) {
                result.add(SvnCodec.revisionRange(range));
            }
        }
        return result;
    }

    public static SVNCopySource copySource(SvnCopySource newSource) {
        if (newSource.getSource().getURL() != null) {
            SVNCopySource copySource = new SVNCopySource(newSource.getSource().getResolvedPegRevision(), newSource.getRevision(), newSource.getSource().getURL());
            copySource.setCopyContents(newSource.isCopyContents());
            return copySource;
        }
        SVNCopySource copySource = new SVNCopySource(newSource.getSource().getResolvedPegRevision(), newSource.getRevision(), newSource.getSource().getFile());
        copySource.setCopyContents(newSource.isCopyContents());
        return copySource;
    }

    public static SvnCopySource copySource(SVNCopySource oldSource) {
        SvnTarget target = oldSource.isURL() ? SvnTarget.fromURL(oldSource.getURL(), oldSource.getPegRevision()) : SvnTarget.fromFile(oldSource.getFile(), oldSource.getPegRevision());
        SvnCopySource copySource = SvnCopySource.create(target, oldSource.getRevision());
        copySource.setCopyContents(oldSource.isCopyContents());
        return copySource;
    }

    public static ISvnCommitHandler commitHandler(final ISVNCommitHandler target) {
        if (target == null) {
            return null;
        }
        return new ISvnCommitHandler(){

            public SVNProperties getRevisionProperties(String message, SvnCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
                SVNCommitItem[] targetItems = new SVNCommitItem[commitables.length];
                for (int i = 0; i < targetItems.length; ++i) {
                    targetItems[i] = SvnCodec.commitItem(commitables[i]);
                }
                return target.getRevisionProperties(message, targetItems, revisionProperties);
            }

            public String getCommitMessage(String message, SvnCommitItem[] commitables) throws SVNException {
                SVNCommitItem[] targetItems = new SVNCommitItem[commitables.length];
                for (int i = 0; i < targetItems.length; ++i) {
                    targetItems[i] = SvnCodec.commitItem(commitables[i]);
                }
                return target.getCommitMessage(message, targetItems);
            }
        };
    }

    public static ISVNCommitHandler commitHandler(final ISvnCommitHandler target) {
        if (target == null) {
            return null;
        }
        return new ISVNCommitHandler(){

            public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
                SvnCommitItem[] targetItems = new SvnCommitItem[commitables.length];
                for (int i = 0; i < targetItems.length; ++i) {
                    targetItems[i] = SvnCodec.commitItem(commitables[i]);
                }
                return target.getRevisionProperties(message, targetItems, revisionProperties);
            }

            public String getCommitMessage(String message, SVNCommitItem[] commitables) throws SVNException {
                SvnCommitItem[] targetItems = new SvnCommitItem[commitables.length];
                for (int i = 0; i < targetItems.length; ++i) {
                    targetItems[i] = SvnCodec.commitItem(commitables[i]);
                }
                return target.getCommitMessage(message, targetItems);
            }
        };
    }

    public static ISVNExternalsHandler externalsHandler(final ISvnExternalsHandler target) {
        if (target == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return new ISVNExternalsHandler(){

            public SVNRevision[] handleExternal(File externalPath, SVNURL externalURL, SVNRevision externalRevision, SVNRevision externalPegRevision, String externalsDefinition, SVNRevision externalsWorkingRevision) {
                return target.handleExternal(externalPath, externalURL, externalRevision, externalPegRevision, externalsDefinition, externalsWorkingRevision);
            }
        };
    }

    public static ISvnExternalsHandler externalsHandler(final ISVNExternalsHandler target) {
        if (target == null) {
            return new ISvnExternalsHandler(){

                public SVNRevision[] handleExternal(File externalPath, SVNURL externalURL, SVNRevision externalRevision, SVNRevision externalPegRevision, String externalsDefinition, SVNRevision externalsWorkingRevision) {
                    return new SVNRevision[]{externalRevision, externalPegRevision};
                }
            };
        }
        return new ISvnExternalsHandler(){

            public SVNRevision[] handleExternal(File externalPath, SVNURL externalURL, SVNRevision externalRevision, SVNRevision externalPegRevision, String externalsDefinition, SVNRevision externalsWorkingRevision) {
                return target.handleExternal(externalPath, externalURL, externalRevision, externalPegRevision, externalsDefinition, externalsWorkingRevision);
            }
        };
    }

    public static ISvnCommitParameters commitParameters(final ISVNCommitParameters old) {
        if (old == null) {
            return null;
        }
        return new ISvnCommitParameters(){

            public ISvnCommitParameters.Action onMissingFile(File file) {
                ISVNCommitParameters.Action a = old.onMissingFile(file);
                return this.action(a);
            }

            public ISvnCommitParameters.Action onMissingDirectory(File file) {
                ISVNCommitParameters.Action a = old.onMissingDirectory(file);
                return this.action(a);
            }

            private ISvnCommitParameters.Action action(ISVNCommitParameters.Action a) {
                if (a == ISVNCommitParameters.DELETE) {
                    return ISvnCommitParameters.Action.DELETE;
                }
                if (a == ISVNCommitParameters.ERROR) {
                    return ISvnCommitParameters.Action.ERROR;
                }
                return ISvnCommitParameters.Action.SKIP;
            }

            public boolean onDirectoryDeletion(File directory) {
                return old.onDirectoryDeletion(directory);
            }

            public boolean onFileDeletion(File file) {
                return old.onFileDeletion(file);
            }
        };
    }

    public static ISVNCommitParameters commitParameters(final ISvnCommitParameters old) {
        if (old == null) {
            return null;
        }
        return new ISVNCommitParameters(){

            public ISVNCommitParameters.Action onMissingFile(File file) {
                ISvnCommitParameters.Action a = old.onMissingFile(file);
                return this.action(a);
            }

            public ISVNCommitParameters.Action onMissingDirectory(File file) {
                ISvnCommitParameters.Action a = old.onMissingDirectory(file);
                return this.action(a);
            }

            private ISVNCommitParameters.Action action(ISvnCommitParameters.Action a) {
                if (a == ISvnCommitParameters.Action.DELETE) {
                    return ISVNCommitParameters.DELETE;
                }
                if (a == ISvnCommitParameters.Action.ERROR) {
                    return ISVNCommitParameters.ERROR;
                }
                return ISVNCommitParameters.SKIP;
            }

            public boolean onDirectoryDeletion(File directory) {
                return old.onDirectoryDeletion(directory);
            }

            public boolean onFileDeletion(File file) {
                return old.onFileDeletion(file);
            }
        };
    }

    public static ISvnAddParameters addParameters(final ISVNAddParameters old) {
        if (old == null) {
            return null;
        }
        return new ISvnAddParameters(){

            public ISvnAddParameters.Action onInconsistentEOLs(File file) {
                ISVNAddParameters.Action a = old.onInconsistentEOLs(file);
                if (a == ISVNAddParameters.ADD_AS_BINARY) {
                    return ISvnAddParameters.Action.ADD_AS_BINARY;
                }
                if (a == ISVNAddParameters.ADD_AS_IS) {
                    return ISvnAddParameters.Action.ADD_AS_IS;
                }
                return ISvnAddParameters.Action.REPORT_ERROR;
            }
        };
    }

    public static ISVNAddParameters addParameters(final ISvnAddParameters old) {
        if (old == null) {
            return null;
        }
        return new ISVNAddParameters(){

            public ISVNAddParameters.Action onInconsistentEOLs(File file) {
                ISvnAddParameters.Action a = old.onInconsistentEOLs(file);
                if (a == ISvnAddParameters.Action.ADD_AS_BINARY) {
                    return ISVNAddParameters.ADD_AS_BINARY;
                }
                if (a == ISvnAddParameters.Action.ADD_AS_IS) {
                    return ISVNAddParameters.ADD_AS_IS;
                }
                return ISVNAddParameters.REPORT_ERROR;
            }
        };
    }

    public static ISvnPropertyValueProvider propertyValueProvider(final ISVNPropertyValueProvider propertyValueProvider) {
        if (propertyValueProvider == null) {
            return null;
        }
        return new ISvnPropertyValueProvider(){

            public SVNProperties providePropertyValues(File path, SVNProperties properties) throws SVNException {
                return propertyValueProvider.providePropertyValues(path, properties);
            }
        };
    }

    public static ISVNPropertyValueProvider propertyValueProvider(final ISvnPropertyValueProvider propertyValueProvider) {
        if (propertyValueProvider == null) {
            return null;
        }
        return new ISVNPropertyValueProvider(){

            public SVNProperties providePropertyValues(File path, SVNProperties properties) throws SVNException {
                return propertyValueProvider.providePropertyValues(path, properties);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SVNCommitPacketWrapper
    extends SVNCommitPacket {
        private SvnCommitPacket packet;
        private SvnCommit operation;

        public SVNCommitPacketWrapper(SvnCommit operation, SvnCommitPacket packet, SVNCommitItem[] items, Map<String, String> lockTokens) {
            super(null, items, lockTokens);
            this.operation = operation;
            this.packet = packet;
        }

        @Override
        public void dispose() throws SVNException {
            this.packet.dispose();
        }

        public SvnCommit getOperation() {
            return this.operation;
        }
    }
}

