/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support.lang;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.APTLiteLiteralToken;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public abstract class APTBaseLanguageFilter
implements APTLanguageFilter {
    private final Map<CharSequence, Integer> filter;
    private final Set<Integer> keywords = new HashSet<Integer>();

    protected APTBaseLanguageFilter(boolean caseInsensitive) {
        this.filter = caseInsensitive ? new TreeMap<CharSequence, Integer>(CharSequenceUtils.ComparatorIgnoreCase) : new HashMap<CharSequence, Integer>();
    }

    @Override
    public TokenStream getFilteredStream(TokenStream origStream) {
        return new FilterStream(origStream);
    }

    protected void filter(String text, int ttype) {
        this.filter.put(CharSequences.create((CharSequence)text), ttype);
        this.keywords.add(ttype);
    }

    protected Token onID(Token token) {
        if (token instanceof APTLiteLiteralToken) {
            APTLiteLiteralToken literalToken = (APTLiteLiteralToken)token;
            if (this.keywords.contains(literalToken.getLiteralType())) {
                assert (literalToken.getLiteralType() == this.filter.get(((APTToken)token).getTextID()).intValue());
                return new FilterLiteralToken((APTLiteLiteralToken)token);
            }
            return token;
        }
        return this.defaultWrap(token);
    }

    protected final Token defaultWrap(Token token) {
        Integer newType = this.filter.get(((APTToken)token).getTextID());
        if (newType != null) {
            int ttype = newType;
            token = new FilterToken((APTToken)token, ttype);
        }
        return token;
    }

    protected Token onToken(Token token) {
        if (token.getType() == 91) {
            token = this.onID(token);
        }
        return token;
    }

    public boolean isKeyword(Token token) {
        Integer newType;
        return token.getType() == 91 && (newType = this.filter.get(((APTToken)token).getTextID())) != null;
    }

    public boolean isKeyword(int ttype) {
        return this.keywords.contains(ttype);
    }

    private static class FilterLiteralToken
    implements APTToken {
        private final APTLiteLiteralToken origToken;

        public FilterLiteralToken(APTLiteLiteralToken origToken) {
            this.origToken = origToken;
        }

        @Override
        public int getOffset() {
            return this.origToken.getOffset();
        }

        @Override
        public void setOffset(int o) {
            this.origToken.setOffset(o);
        }

        @Override
        public int getEndOffset() {
            return this.origToken.getEndOffset();
        }

        @Override
        public void setEndOffset(int o) {
            this.origToken.setEndOffset(o);
        }

        @Override
        public int getEndColumn() {
            return this.origToken.getEndColumn();
        }

        @Override
        public void setEndColumn(int c) {
            this.origToken.setEndColumn(c);
        }

        @Override
        public int getEndLine() {
            return this.origToken.getEndLine();
        }

        @Override
        public void setEndLine(int l) {
            this.origToken.setEndLine(l);
        }

        @Override
        public String getText() {
            return this.origToken.getText();
        }

        @Override
        public CharSequence getTextID() {
            return this.origToken.getTextID();
        }

        @Override
        public void setTextID(CharSequence id) {
            this.origToken.setTextID(id);
        }

        @Override
        public Object getProperty(Object key) {
            return null;
        }

        public int getColumn() {
            return this.origToken.getColumn();
        }

        public void setColumn(int c) {
            this.origToken.setColumn(c);
        }

        public int getLine() {
            return this.origToken.getLine();
        }

        public void setLine(int l) {
            this.origToken.setLine(l);
        }

        public String getFilename() {
            return this.origToken.getFilename();
        }

        public void setFilename(String name) {
            this.origToken.setFilename(name);
        }

        public void setText(String t) {
            this.origToken.setText(t);
        }

        public int getType() {
            return this.origToken.getLiteralType();
        }

        public void setType(int t) {
            throw new IllegalStateException("Not supported");
        }

        public String toString() {
            return "FilterToken: " + APTUtils.getAPTTokenName(this.getType()) + (this.origToken == null ? "null" : this.origToken.toString());
        }
    }

    public static final class FilterToken
    implements APTToken {
        private final APTToken origToken;
        private int type;

        public FilterToken(APTToken origToken, int type) {
            this.origToken = origToken;
            this.type = type;
        }

        public APTToken getOriginalToken() {
            return this.origToken;
        }

        @Override
        public int getOffset() {
            return this.origToken.getOffset();
        }

        @Override
        public void setOffset(int o) {
            this.origToken.setOffset(o);
        }

        @Override
        public int getEndColumn() {
            return this.origToken.getEndColumn();
        }

        @Override
        public void setEndColumn(int c) {
            this.origToken.setEndColumn(c);
        }

        @Override
        public int getEndLine() {
            return this.origToken.getEndLine();
        }

        @Override
        public void setEndLine(int l) {
            this.origToken.setEndLine(l);
        }

        @Override
        public int getEndOffset() {
            return this.origToken.getEndOffset();
        }

        @Override
        public void setEndOffset(int o) {
            this.origToken.setEndOffset(o);
        }

        @Override
        public CharSequence getTextID() {
            return this.origToken.getTextID();
        }

        @Override
        public void setTextID(CharSequence id) {
            this.origToken.setTextID(id);
        }

        public int getColumn() {
            return this.origToken.getColumn();
        }

        public void setColumn(int c) {
            this.origToken.setColumn(c);
        }

        public int getLine() {
            return this.origToken.getLine();
        }

        public void setLine(int l) {
            this.origToken.setLine(l);
        }

        public String getFilename() {
            return this.origToken.getFilename();
        }

        public void setFilename(String name) {
            this.origToken.setFilename(name);
        }

        @Override
        public String getText() {
            return this.origToken.getText();
        }

        public void setText(String t) {
            this.origToken.setText(t);
        }

        public int getType() {
            return this.type;
        }

        public void setType(int t) {
            this.type = t;
        }

        public String toString() {
            return "FilterToken: " + APTUtils.getAPTTokenName(this.type) + (this.origToken == null ? "null" : this.origToken.toString());
        }

        @Override
        public Object getProperty(Object key) {
            return null;
        }
    }

    private final class FilterStream
    implements TokenStream {
        private TokenStream orig;

        public FilterStream(TokenStream orig) {
            this.orig = orig;
        }

        public Token nextToken() throws TokenStreamException {
            Token token = this.orig.nextToken();
            token = APTBaseLanguageFilter.this.onToken(token);
            return token;
        }
    }
}

