/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.APTPreprocessorToken;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTStream;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.TokenBasedTokenStream;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;

public abstract class APTWalker {
    private final APTMacroMap macros;
    private final APTFile root;
    private Boolean walkerUsedForTokenStreamGeneration = null;
    private boolean stopped = false;
    private final Map<APT, Map<Object, Object>> nodeProperties = new IdentityHashMap<APT, Map<Object, Object>>();
    private APT curAPT;
    private boolean curWasInChild;
    private LinkedList<TokenStream> tokens = new LinkedList();
    private LinkedList<WalkerState> visits = new LinkedList();

    public APTWalker(APTFile apt, APTMacroMap macros) {
        assert (apt != null) : "how can we work on null tree?";
        this.root = apt;
        this.macros = macros;
    }

    public void visit() {
        this.init(false);
        while (!this.finished()) {
            this.toNextNode();
        }
    }

    public TokenStream getTokenStream() {
        return new WalkerTokenStream();
    }

    protected boolean needPPTokens() {
        return false;
    }

    protected abstract void onInclude(APT var1);

    protected abstract void onIncludeNext(APT var1);

    protected abstract void onDefine(APT var1);

    protected abstract void onUndef(APT var1);

    protected abstract boolean onIf(APT var1);

    protected abstract boolean onIfdef(APT var1);

    protected abstract boolean onIfndef(APT var1);

    protected abstract boolean onElif(APT var1, boolean var2);

    protected abstract boolean onElse(APT var1, boolean var2);

    protected abstract void onEndif(APT var1, boolean var2);

    protected abstract void onPragmaNode(APT var1);

    protected void onStreamNode(APT apt) {
    }

    protected void onErrorNode(APT apt) {
    }

    protected void onOtherNode(APT apt) {
    }

    protected void onEOF() {
    }

    protected boolean stopOnErrorDirective() {
        return true;
    }

    protected boolean onAPT(APT node, boolean wasInBranch) {
        boolean visitChild = false;
        switch (node.getType()) {
            case 9: {
                visitChild = this.onIf(node);
                break;
            }
            case 7: {
                visitChild = this.onIfdef(node);
                break;
            }
            case 8: {
                visitChild = this.onIfndef(node);
                break;
            }
            case 10: {
                visitChild = this.onElif(node, wasInBranch);
                break;
            }
            case 11: {
                visitChild = this.onElse(node, wasInBranch);
                break;
            }
            case 12: {
                this.onEndif(node, wasInBranch);
                break;
            }
            case 5: {
                this.onDefine(node);
                break;
            }
            case 6: {
                this.onUndef(node);
                break;
            }
            case 3: {
                this.onInclude(node);
                break;
            }
            case 4: {
                this.onIncludeNext(node);
                break;
            }
            case 2: {
                this.onStreamNode(node);
                break;
            }
            case 15: {
                this.onErrorNode(node);
                break;
            }
            case 13: {
                this.onPragmaNode(node);
                break;
            }
            case 0: 
            case 14: 
            case 16: {
                this.onOtherNode(node);
                break;
            }
            default: {
                assert (false) : "unsupported " + APTTraceUtils.getTypeName(node);
                break;
            }
        }
        if (APTUtils.LOG.isLoggable(Level.FINE)) {
            APTUtils.LOG.log(Level.FINE, "onAPT: {0}; {1} {2}", new Object[]{node, wasInBranch ? "Was before;" : "", visitChild ? "Will visit children" : ""});
        }
        this.fillTokensIfNeeded(node);
        return visitChild;
    }

    protected final void pushState() {
        this.visits.addLast(new WalkerState(this.curAPT, this.curWasInChild));
    }

    protected void preInit() {
    }

    private boolean popState() {
        if (this.visits.isEmpty()) {
            return false;
        }
        WalkerState state = this.visits.removeLast();
        this.curAPT = state.lastNode;
        this.curWasInChild = state.wasInChild;
        return true;
    }

    private void init(boolean needStream) {
        if (this.walkerUsedForTokenStreamGeneration != null) {
            throw new IllegalStateException("walker could be used only once");
        }
        this.walkerUsedForTokenStreamGeneration = needStream;
        this.preInit();
        this.curAPT = this.root.getFirstChild();
        this.curWasInChild = false;
        this.pushState();
    }

    private APTToken nextTokenImpl() throws TokenStreamException {
        while (true) {
            if (!this.tokens.isEmpty()) {
                TokenStream ts = this.tokens.peek();
                APTToken theRetToken = (APTToken)ts.nextToken();
                if (!APTUtils.isEOF(theRetToken)) {
                    return theRetToken;
                }
                this.tokens.removeFirst();
                continue;
            }
            if (this.finished()) {
                this.onEOF();
                return APTUtils.EOF_TOKEN;
            }
            this.toNextNode();
        }
    }

    private void toNextNode() {
        this.popState();
        if (this.finished()) {
            return;
        }
        if (this.curAPT == null) {
            APTUtils.LOG.log(Level.SEVERE, "incomplete APT {0}", new Object[]{this.root});
            do {
                this.popState();
                if (this.curAPT == null) continue;
                this.curAPT = this.curAPT.getNextSibling();
            } while (this.curAPT == null && !this.finished());
            if (this.curAPT == null) {
                return;
            }
        }
        if (APTUtils.isStartConditionNode(this.curAPT.getType())) {
            this.curWasInChild = false;
        }
        boolean visitChild = this.onAPT(this.curAPT, this.curWasInChild);
        this.curWasInChild |= visitChild;
        if (visitChild) {
            assert (APTUtils.isStartOrSwitchConditionNode(this.curAPT.getType()));
            if (this.curAPT.getFirstChild() != null) {
                this.pushState();
                this.curAPT = this.curAPT.getFirstChild();
                this.curWasInChild = false;
            } else {
                this.curAPT = this.curAPT.getNextSibling();
            }
        } else {
            if (this.curAPT.getType() == 12) {
                APT endif;
                this.curAPT = endif = this.curAPT;
            } else if (this.curAPT.getType() == 15) {
                if (this.stopOnErrorDirective()) {
                    this.stop();
                    return;
                }
            } else if (this.curAPT.getType() == 13 && this.isStopped() && this.stopOnErrorDirective()) {
                return;
            }
            this.curAPT = this.curAPT.getNextSibling();
            while (this.curAPT == null && !this.finished()) {
                this.popState();
                this.curAPT = this.curAPT.getNextSibling();
            }
        }
        if (!this.finished()) {
            this.pushState();
        }
    }

    protected final void putNodeProperty(APT node, Object key, Object value) {
        Map props = this.nodeProperties.get(node);
        if (props == null) {
            props = TinyMaps.createMap((int)2);
            this.nodeProperties.put(node, props);
        } else {
            Map expanded = TinyMaps.expandForNextKey(props, (Object)node);
            if (expanded != props) {
                props = expanded;
                this.nodeProperties.put(node, props);
            }
        }
        props.put(key, value);
    }

    private void fillTokensIfNeeded(APT node) {
        if (this.walkerUsedForTokenStreamGeneration == Boolean.TRUE && node != null && node.getType() == 2) {
            TokenStream ts = ((APTStream)node).getTokenStream();
            this.tokens.addFirst(ts);
        }
    }

    final void beforeInclude(APTInclude aptInclude, ResolvedPath resolvedPath) {
        if (this.walkerUsedForTokenStreamGeneration == Boolean.TRUE && this.needPPTokens()) {
            this.tokens.add(new TokenBasedTokenStream(new APTPreprocessorToken(aptInclude, true, resolvedPath, this.nodeProperties.get(aptInclude))));
        }
    }

    final void afterInclude(APTInclude aptInclude, ResolvedPath resolvedPath) {
        if (this.walkerUsedForTokenStreamGeneration == Boolean.TRUE && this.needPPTokens()) {
            this.tokens.add(new TokenBasedTokenStream(new APTPreprocessorToken(aptInclude, false, resolvedPath, this.nodeProperties.get(aptInclude))));
        }
    }

    private boolean finished() {
        return this.curAPT == null && this.visits.isEmpty() || this.isStopped();
    }

    protected final APTMacroMap getMacroMap() {
        return this.macros;
    }

    protected final APT getCurNode() {
        return this.curAPT;
    }

    public final APTFile getRootFile() {
        return this.root;
    }

    protected final boolean isStopped() {
        return this.stopped;
    }

    protected final void stop() {
        this.stopped = true;
    }

    private static final class WalkerState {
        private final APT lastNode;
        private final boolean wasInChild;

        private WalkerState(APT node, boolean wasInChildState) {
            this.lastNode = node;
            this.wasInChild = wasInChildState;
        }
    }

    private final class WalkerTokenStream
    implements TokenStream,
    APTTokenStream {
        private WalkerTokenStream() {
            APTWalker.this.init(true);
        }

        @Override
        public APTToken nextToken() {
            try {
                return APTWalker.this.nextTokenImpl();
            }
            catch (TokenStreamException ex) {
                APTUtils.LOG.log(Level.WARNING, "{0}:{1}", new Object[]{APTWalker.this.root.getPath(), ex});
                return APTUtils.EOF_TOKEN;
            }
        }
    }
}

