/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.TokenStreamSelector;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroParamExpansion;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.apt.utils.TokenBasedTokenStream;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.openide.util.CharSequences;

public class APTExpandedStream
implements TokenStream,
APTTokenStream {
    private final TokenStreamSelector selector = new TokenStreamSelector();
    private final APTMacroCallback callback;
    private boolean extractingMacroParams = false;
    private final boolean expandPPExpression;
    private APTToken paramsRParen = null;
    private static final int BODY_STREAM = 0;
    private static final int STRINGIZE_PARAM = 1;
    private static final int CONCATENATE = 2;
    private static final long MACRO_EXPANDING_THREASHOLD = 16384L;

    public APTExpandedStream(TokenStream stream, APTMacroCallback callback, boolean expandPPExpression) {
        this.selector.select(stream);
        this.callback = callback;
        this.expandPPExpression = expandPPExpression;
        assert (!(callback instanceof APTSystemMacroMap)) : "system macro map can't be used as callback";
    }

    public APTExpandedStream(TokenStream stream, APTMacroCallback callback) {
        this(stream, callback, false);
    }

    @Override
    public APTToken nextToken() {
        APTToken token;
        boolean switchMacroExpanding;
        do {
            try {
                token = (APTToken)this.selector.nextToken();
            }
            catch (TokenStreamException ex) {
                APTUtils.LOG.log(Level.SEVERE, ex.getMessage());
                return APTUtils.EOF_TOKEN;
            }
            if (this.extractingMacroParams) {
                return token;
            }
            switchMacroExpanding = false;
            if (APTUtils.isID(token)) {
                if (!this.callback.popPPDefined()) {
                    APTMacro macro = this.callback.getMacro(token);
                    if (macro != null && !this.callback.isExpanding(token)) {
                        switchMacroExpanding = this.pushMacroExpanding(token, macro);
                        continue;
                    }
                    if (macro != null || !this.isExpandingPPExpression() || !"defined".contentEquals(token.getTextID())) continue;
                    if (this.callback.pushPPDefined()) {
                        token = new APTBaseLanguageFilter.FilterToken(token, 56);
                        continue;
                    }
                    APTUtils.LOG.log(Level.SEVERE, "not handled 'defined' operator on expanding {0}\n", token);
                    continue;
                }
                token = new APTBaseLanguageFilter.FilterToken(token, 486);
                continue;
            }
            if (!APTUtils.isEOF(token)) continue;
            switchMacroExpanding = this.continueOnEOF();
        } while (switchMacroExpanding);
        return token;
    }

    private boolean isExpandingPPExpression() {
        return this.expandPPExpression;
    }

    private boolean pushMacroExpanding(APTToken token, APTMacro macro) {
        boolean res = true;
        try {
            APTTokenStream expanded = this.createMacroBodyWrapper(token, macro);
            res = this.callback.pushExpanding(token);
            if (res) {
                this.selector.push((TokenStream)expanded);
            }
        }
        catch (RecognitionException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on expanding {0}\n{1}", new Object[]{token, ex.getMessage()});
            res = false;
        }
        catch (TokenStreamException ex) {
            APTUtils.LOG.log(Level.SEVERE, ex.getMessage());
            res = false;
        }
        return res;
    }

    private boolean popMacroExpanding() {
        boolean res = true;
        this.callback.popExpanding();
        this.selector.pop();
        return res;
    }

    protected APTTokenStream createMacroBodyWrapper(APTToken token, APTMacro macro) throws TokenStreamException, RecognitionException {
        APTTokenStream out;
        assert (macro != null) : "must be valid macro object";
        assert (macro.getName() != null) : "macro object must have valid name token";
        assert (!this.callback.isExpanding(macro.getName())) : "macro must not be under recursive expanding";
        this.paramsRParen = null;
        if (!macro.isFunctionLike()) {
            TokenStream body = macro.getBody();
            Token toCheck = body.nextToken();
            boolean needsSubstitution = false;
            while (!APTUtils.isEOF(toCheck)) {
                if (toCheck.getType() == 57) {
                    needsSubstitution = true;
                    break;
                }
                toCheck = body.nextToken();
            }
            out = new APTCommentsFilter(macro.getBody());
            if (this.isExpandingPPExpression()) {
                out = APTUtils.isEOF(out.nextToken()) ? new TokenBasedTokenStream(APTUtils.DEF_MACRO_BODY) : new APTCommentsFilter(macro.getBody());
            }
            if (needsSubstitution) {
                List<APTToken> substParamsList = APTExpandedStream.subsituteParams(macro, Collections.<List<APTToken>>emptyList(), this.callback, this.isExpandingPPExpression());
                out = new ListBasedTokenStream(substParamsList);
            }
        } else {
            APTToken next;
            boolean cont;
            do {
                cont = false;
                while (APTUtils.isCommentToken(next = (APTToken)this.selector.nextToken())) {
                }
            } while (cont = APTUtils.isEOF(next) && this.continueOnEOF());
            if (next.getType() == 12) {
                List<List<APTToken>> params = this.extractParams(macro, token, next);
                List<APTToken> substParamsList = APTExpandedStream.subsituteParams(macro, params, this.callback, this.isExpandingPPExpression());
                out = new ListBasedTokenStream(substParamsList);
            } else {
                ArrayList<APTToken> l = new ArrayList<APTToken>(2);
                l.add(token);
                l.add(next);
                out = new ListBasedTokenStream(l);
            }
        }
        APTUtils.LOG.log(Level.INFO, "token {0} \n was expanded by macro substitution to \n {1}", new Object[]{token, out});
        return out;
    }

    private boolean continueOnEOF() {
        boolean cont = false;
        if (!this.selector.isEmpty()) {
            cont = this.popMacroExpanding();
        }
        return cont;
    }

    protected final APTToken getLastExtractedParamRPAREN() {
        return this.paramsRParen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<APTToken>> extractParams(APTMacro macro, APTToken token, APTToken next) throws TokenStreamException, RecognitionException {
        assert (!this.extractingMacroParams) : "already extracting params";
        this.extractingMacroParams = true;
        ArrayList<List<APTToken>> params = new ArrayList<List<APTToken>>();
        try {
            if (next.getType() != 12) {
                throw new RecognitionException("Error on expanding " + token + "\n by macro " + macro + "\n Expecting LPAREN, found " + next);
            }
            int paren = 0;
            ArrayList<APTToken> param = new ArrayList<APTToken>();
            next = this.nextToken();
            block8: while (!APTUtils.isEOF(next) || this.continueOnEOF()) {
                switch (next.getType()) {
                    case 12: {
                        this.add2Param(param, next);
                        ++paren;
                        break;
                    }
                    case 13: {
                        if (paren == 0) {
                            params.add(param);
                            param = null;
                            this.paramsRParen = next;
                            break block8;
                        }
                        this.add2Param(param, next);
                        if (--paren >= 0) break;
                        throw new RecognitionException("Error on expanding " + token + "\n by macro " + macro + "\n Unbalanced RPAREN " + next);
                    }
                    case 8: {
                        if (paren == 0) {
                            params.add(param);
                            param = new ArrayList();
                            break;
                        }
                        this.add2Param(param, next);
                        break;
                    }
                    default: {
                        this.add2Param(param, next);
                    }
                }
                next = this.nextToken();
            }
            if (APTUtils.isEOF(next)) {
                APTUtils.LOG.log(Level.SEVERE, "error expanding macro {0} : unterminated arguments list", token);
            }
        }
        finally {
            this.extractingMacroParams = false;
        }
        return params;
    }

    private void add2Param(List<APTToken> param, APTToken next) {
        if (!APTUtils.isCommentToken(next)) {
            param.add(next);
        }
    }

    private static List<APTToken> subsituteParams(APTMacro macro, List<List<APTToken>> params, APTMacroCallback callback, boolean expandPPExpression) throws TokenStreamException {
        Map<CharSequence, List<APTToken>> paramsMap = APTExpandedStream.createParamsMap(macro, params);
        LinkedList<APTToken> expanded = new LinkedList<APTToken>();
        APTCommentsFilter body = new APTCommentsFilter(macro.getBody());
        int state = 0;
        APTToken token = null;
        APTToken laToken = body.nextToken();
        APTToken leftConcatToken = null;
        do {
            block0 : switch (state) {
                case 0: {
                    token = laToken;
                    laToken = body.nextToken();
                    switch (laToken.getType()) {
                        case 57: {
                            leftConcatToken = token;
                            state = 2;
                            token = null;
                            break block0;
                        }
                    }
                    switch (token.getType()) {
                        case 58: {
                            state = 1;
                            token = null;
                            break;
                        }
                        case 91: {
                            List<APTToken> paramValue = paramsMap.get(token.getTextID());
                            if (paramValue == null) break;
                            List<APTToken> expandedValue = APTExpandedStream.expandParamValue(paramValue, callback, expandPPExpression);
                            ArrayList<APTToken> expandedValueWrapper = new ArrayList<APTToken>();
                            for (APTToken t : expandedValue) {
                                expandedValueWrapper.add(new APTMacroParamExpansion(t, token));
                            }
                            expandedValue = expandedValueWrapper;
                            if ((long)expandedValue.size() > 16384L) {
                                if (DebugUtils.STANDALONE) {
                                    System.err.printf("parameter '%s' was empty substituted due to very long output value when expanding macros:\n %s\n", token.getText(), macro.getName());
                                } else {
                                    APTUtils.LOG.log(Level.WARNING, "parameter '{0}' was empty substituted due to very long output value when expanding macros:\n {1}\n", new Object[]{token.getText(), macro.getName()});
                                }
                                return Collections.emptyList();
                            }
                            token = null;
                            expanded.addAll(expandedValue);
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    token = null;
                    assert (laToken.getType() == 57);
                    assert (leftConcatToken != null);
                    ArrayList<APTToken> rightConcatTokens = new ArrayList<APTToken>();
                    rightConcatTokens.add(body.nextToken());
                    laToken = body.nextToken();
                    if (((APTToken)rightConcatTokens.get(0)).getType() == 58 && laToken.getType() == 91) {
                        rightConcatTokens.set(0, APTExpandedStream.stringizeParam(paramsMap.get(laToken.getTextID())));
                        laToken = body.nextToken();
                    } else if (APTExpandedStream.isImplicitConcat((APTToken)rightConcatTokens.get(0), laToken)) {
                        rightConcatTokens.add(laToken);
                        laToken = body.nextToken();
                    }
                    List<APTToken> concatList = APTExpandedStream.createConcatenation(leftConcatToken, rightConcatTokens, paramsMap);
                    switch (laToken.getType()) {
                        case 57: {
                            int lastInd = concatList.size() - 1;
                            APTToken aPTToken = leftConcatToken = lastInd < 0 ? APTUtils.EMPTY_ID_TOKEN : concatList.remove(lastInd);
                            if (concatList.size() > 0) {
                                expanded.addAll(concatList);
                            }
                            state = 2;
                            break block0;
                        }
                    }
                    leftConcatToken = null;
                    expanded.addAll(concatList);
                    state = 0;
                    break;
                }
                case 1: {
                    token = null;
                    if (laToken != null && laToken.getType() == 91) {
                        APTToken stringized = APTExpandedStream.stringizeParam(paramsMap.get(laToken.getTextID()));
                        laToken = body.nextToken();
                        switch (laToken.getType()) {
                            case 57: {
                                leftConcatToken = stringized;
                                state = 2;
                                break block0;
                            }
                        }
                        token = stringized;
                        state = 0;
                        break;
                    }
                    state = 0;
                }
            }
            if (token == null) continue;
            if (APTUtils.isEOF(token)) break;
            expanded.add(token);
            token = null;
        } while (token == null);
        return expanded;
    }

    private static boolean isImplicitConcat(APTToken left, APTToken right) {
        return APTUtils.isInt(left) && APTUtils.isID(right) && APTUtils.areAdjacent(left, right);
    }

    private static Map<CharSequence, List<APTToken>> createParamsMap(APTMacro macro, List<List<APTToken>> params) {
        if (!macro.isFunctionLike()) {
            return Collections.emptyMap();
        }
        HashMap<CharSequence, List<APTToken>> map = new HashMap<CharSequence, List<APTToken>>();
        Collection<APTToken> macroParams = macro.getParams();
        int numInList = params.size();
        int i = 0;
        APTToken lastMacroParam = null;
        for (APTToken macroParam : macroParams) {
            map.put(macroParam.getTextID(), i < numInList ? params.get(i) : Collections.emptyList());
            ++i;
            lastMacroParam = macroParam;
        }
        if (i < numInList && APTUtils.isVaArgsToken(lastMacroParam)) {
            List vaArgsVal = (List)map.get(lastMacroParam.getTextID());
            while (i < numInList) {
                vaArgsVal.add(APTUtils.COMMA_TOKEN);
                vaArgsVal.addAll((Collection)params.get(i));
                ++i;
            }
        }
        return map;
    }

    private static List<APTToken> createConcatenation(APTToken tokenLeft, List<APTToken> tokensRight, Map<CharSequence, List<APTToken>> paramsMap) {
        List<APTToken> valLeft = paramsMap.get(tokenLeft.getTextID());
        String leftText = valLeft != null ? APTExpandedStream.toText(valLeft, false) : tokenLeft.getText();
        StringBuilder tokensRightMerged = new StringBuilder();
        for (APTToken token : tokensRight) {
            if (APTUtils.isEOF(token)) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("no token after ##", new Object[0]);
                    continue;
                }
                APTUtils.LOG.log(Level.SEVERE, "no token after ##");
                continue;
            }
            tokensRightMerged.append(token.getTextID());
        }
        List<APTToken> valRight = paramsMap.get(CharSequences.create((CharSequence)tokensRightMerged));
        String rightText = valRight != null ? APTExpandedStream.toText(valRight, false) : tokensRightMerged.toString();
        if (tokenLeft.getType() == 8 && rightText.length() == 0 && APTUtils.isVaArgsToken(tokensRight.get(0))) {
            return new ArrayList<APTToken>();
        }
        String text = leftText + rightText;
        TokenStream ts = APTTokenStreamBuilder.buildTokenStream(text, "Unknown Language");
        List<APTToken> tokens = APTUtils.toList(ts);
        return tokens;
    }

    private static APTToken stringizeParam(List<APTToken> param) {
        assert (param != null);
        APTToken token = APTUtils.createAPTToken();
        token.setType(79);
        token.setText(APTExpandedStream.toText(param, true));
        return token;
    }

    private static String toText(List<APTToken> tokens, boolean stringize) {
        StringBuilder out = new StringBuilder();
        if (stringize) {
            out.append('\"');
        }
        for (int i = 0; i < tokens.size(); ++i) {
            APTToken token = tokens.get(i);
            if (stringize) {
                out.append(APTExpandedStream.escape(token.getTextID()));
                continue;
            }
            out.append(token.getTextID());
            if (i + 1 >= tokens.size() || APTUtils.areAdjacent(token, tokens.get(i + 1))) continue;
            out.append(' ');
        }
        if (stringize) {
            out.append('\"');
        }
        return out.toString();
    }

    private static CharSequence escape(CharSequence cs) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (c == '\"' || c == '\\') {
                out.append('\\');
            }
            out.append(c);
        }
        return out;
    }

    private static List<APTToken> expandParamValue(List<APTToken> paramValue, APTMacroCallback callback, boolean expandPPExpression) {
        ListBasedTokenStream valueStream = new ListBasedTokenStream(paramValue);
        APTExpandedStream expanedValue = new APTExpandedStream(valueStream, callback, expandPPExpression);
        List<APTToken> out = APTUtils.toList(expanedValue);
        return out;
    }
}

