/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.math.BigInteger;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.generated.APTBigIntegerExprParser;
import org.netbeans.modules.cnd.apt.impl.support.generated.APTExprParser;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTIfCondition;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.support.APTExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;

public final class APTConditionResolver {
    private static final boolean APT_EXPR_TRACE = Boolean.getBoolean("aptexpr.trace");
    public static final boolean PREPROCESSOR_ERROR_DEFAULT_RETURN_VALUE = false;

    private APTConditionResolver() {
    }

    public static boolean evaluate(APT cond, APTMacroCallback callback) throws TokenStreamException {
        boolean res = false;
        switch (cond.getType()) {
            case 8: {
                APTToken macro = ((APTIfndef)cond).getMacroName();
                res = macro == null ? false : !APTConditionResolver.isDefined(macro, callback);
                break;
            }
            case 7: {
                APTToken macro = ((APTIfdef)cond).getMacroName();
                res = macro == null ? false : APTConditionResolver.isDefined(macro, callback);
                break;
            }
            case 9: 
            case 10: {
                Boolean out = APTConditionResolver.evaluate((APTIfCondition)cond, callback, false);
                if (out == null) {
                    out = APTConditionResolver.evaluate((APTIfCondition)cond, callback, true);
                } else if (APT_EXPR_TRACE) {
                    Boolean val = APTConditionResolver.evaluate((APTIfCondition)cond, callback, true);
                    assert (out.equals(val)) : "different values when evaluate " + cond + " " + val + " vs. " + out;
                }
                res = out;
                break;
            }
            default: {
                assert (false) : "support only #ifdef,#ifndef,#if,#elif";
                break;
            }
        }
        return res;
    }

    private static boolean isDefined(APTToken macro, APTMacroCallback callback) {
        return callback.isDefined(macro);
    }

    private static Boolean evaluate(APTIfCondition apt, APTMacroCallback callback, boolean bigIntegers) throws TokenStreamException {
        Boolean res;
        TokenStream expr = apt.getCondition();
        TokenStream expandedTS = APTConditionResolver.expandTokenStream(expr, callback);
        try {
            if (bigIntegers) {
                APTBigIntegerExprParser parser = new APTBigIntegerExprParser(expandedTS, callback);
                BigInteger r = parser.expr();
                if (APT_EXPR_TRACE) {
                    System.out.println("Value is " + r);
                }
                res = BigInteger.ZERO.equals(r) ? Boolean.FALSE : Boolean.TRUE;
            } else {
                APTExprParser parser = new APTExprParser(expandedTS, callback);
                long r = parser.expr();
                if (APT_EXPR_TRACE) {
                    System.out.println("Value is " + r);
                }
                if (parser.areBigValuesUsed()) {
                    res = null;
                } else {
                    Boolean bl = res = r == 0L ? Boolean.FALSE : Boolean.TRUE;
                }
            }
            if (APTUtils.LOG.isLoggable(Level.FINE)) {
                APTUtils.LOG.log(Level.FINE, "stream {0} \n was expanded for condition resolving to \n {1} \n with result {2}", new Object[]{expr, expandedTS, res});
            }
        }
        catch (NullPointerException ex) {
            APTUtils.LOG.log(Level.SEVERE, "exception on resolving expression: {0}\n{1}", new Object[]{expr, ex});
            res = false;
        }
        catch (ArithmeticException ex) {
            if (DebugUtils.STANDALONE) {
                System.err.printf("arithmetic error \"%s\" on resolving expression:\n\t %s\n", ex.getMessage(), expr);
            } else {
                APTUtils.LOG.log(Level.WARNING, "arithmetic error \"{0}\" on resolving expression\n: {1}", new Object[]{ex.getMessage(), expr});
            }
            res = false;
        }
        return res;
    }

    private static TokenStream expandTokenStream(TokenStream orig, APTMacroCallback callback) {
        return new APTExpandedStream(orig, callback, true);
    }
}

