/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTConditionResolver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeFake;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.filesystems.FileSystem;

public abstract class APTAbstractWalker
extends APTWalker {
    private final APTPreprocHandler preprocHandler;
    private final CharSequence startPath;
    private final FileSystem startFileSystem;
    private final APTFileCacheEntry cacheEntry;

    protected APTAbstractWalker(APTFile apt, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler == null ? null : preprocHandler.getMacroMap());
        this.startPath = apt.getPath();
        this.startFileSystem = apt.getFileSystem();
        this.preprocHandler = preprocHandler;
        this.cacheEntry = cacheEntry;
    }

    @Override
    protected void preInit() {
        APTIncludeHandler includeHandler;
        super.preInit();
        if (this.preprocHandler != null && APTHandlersSupportImpl.isFirstLevel(includeHandler = this.preprocHandler.getIncludeHandler())) {
            Collection<IncludeDirEntry> extractIncludeFileEntries = APTHandlersSupportImpl.extractIncludeFileEntries(includeHandler);
            int index = 0 - extractIncludeFileEntries.size();
            for (IncludeDirEntry includeDirEntry : extractIncludeFileEntries) {
                APTIncludeFake fake = new APTIncludeFake(((Object)includeDirEntry.getAsSharedCharSequence()).toString(), index++);
                this.onAPT(fake, false);
            }
        }
    }

    @Override
    protected void onInclude(APT apt) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver resolver = this.getIncludeHandler().getResolver(this.startFileSystem, this.startPath);
            ResolvedPath resolvedPath = resolver.resolveInclude((APTInclude)apt, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + CndPathUtilitities.getBaseName((String)((Object)this.startPath).toString()) + " for:\n\t" + apt);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, apt});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)apt);
        }
    }

    @Override
    protected void onIncludeNext(APT apt) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver resolver = this.getIncludeHandler().getResolver(this.startFileSystem, this.startPath);
            ResolvedPath resolvedPath = resolver.resolveIncludeNext((APTIncludeNext)apt, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + CndPathUtilitities.getBaseName((String)((Object)this.startPath).toString()) + " for:\n\t" + apt);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, apt});
                }
            }
            this.includeImpl(resolvedPath, (APTInclude)apt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeImpl(ResolvedPath resolvedPath, APTInclude aptInclude) {
        block9: {
            try {
                this.beforeInclude(aptInclude, resolvedPath);
                if (this.cacheEntry != null) {
                    Object lock;
                    if (!this.startPath.equals(this.cacheEntry.getFilePath())) {
                        System.err.println("using not expected entry " + this.cacheEntry + " when work with file " + this.startPath);
                    }
                    if (this.cacheEntry.isSerial()) {
                        this.serialIncludeImpl(aptInclude, resolvedPath);
                        break block9;
                    }
                    Object object = lock = this.cacheEntry.getIncludeLock(aptInclude);
                    synchronized (object) {
                        this.serialIncludeImpl(aptInclude, resolvedPath);
                        break block9;
                    }
                }
                this.include(resolvedPath, aptInclude, null);
            }
            finally {
                this.afterInclude(aptInclude, resolvedPath);
            }
        }
    }

    protected abstract boolean include(ResolvedPath var1, APTInclude var2, PostIncludeData var3);

    protected abstract boolean hasIncludeActionSideEffects();

    @Override
    protected void onDefine(APT apt) {
        APTDefine define = (APTDefine)apt;
        if (define.isValid()) {
            this.getMacroMap().define(this.getRootFile(), define, APTMacro.Kind.DEFINED);
        } else if (DebugUtils.STANDALONE) {
            if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                System.err.println("INCORRECT #define directive: in " + CndPathUtilitities.getBaseName((String)((Object)this.startPath).toString()) + " for:\n\t" + apt);
            }
        } else {
            APTUtils.LOG.log(Level.SEVERE, "INCORRECT #define directive: in {0} for:\n\t{1}", new Object[]{CndPathUtilitities.getBaseName((String)((Object)this.startPath).toString()), apt});
        }
    }

    @Override
    protected void onPragmaNode(APT apt) {
        APTPragma pragma = (APTPragma)apt;
        APTToken name = pragma.getName();
        if (name != null && "once".contentEquals(name.getTextID())) {
            if (this.getMacroMap().isDefined(this.getFileOnceMacroName())) {
                super.stop();
            } else {
                APTDefine fileOnce = APTUtils.createAPTDefineOnce(this.getFileOnceMacroName());
                this.getMacroMap().define(this.getRootFile(), fileOnce, APTMacro.Kind.DEFINED);
            }
        }
    }

    protected final CharSequence getFileOnceMacroName() {
        return APTUtils.getFileOnceMacroName(this.getRootFile());
    }

    @Override
    protected void onUndef(APT apt) {
        APTUndefine undef = (APTUndefine)apt;
        this.getMacroMap().undef(this.getRootFile(), undef.getName());
    }

    @Override
    protected boolean onIf(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onIfdef(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onIfndef(APT apt) {
        return this.eval(apt);
    }

    @Override
    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        return !wasInPrevBranch && this.eval(apt);
    }

    @Override
    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        return !wasInPrevBranch;
    }

    @Override
    protected void onEndif(APT apt, boolean wasInBranch) {
    }

    protected void onEval(APT apt, boolean result) {
    }

    protected APTPreprocHandler getPreprocHandler() {
        return this.preprocHandler;
    }

    protected APTIncludeHandler getIncludeHandler() {
        return this.getPreprocHandler() == null ? null : this.getPreprocHandler().getIncludeHandler();
    }

    private boolean eval(APT apt) {
        if (APTUtils.LOG.isLoggable(Level.FINE)) {
            APTUtils.LOG.log(Level.FINE, "eval condition for {0}", new Object[]{apt});
        }
        boolean res = false;
        try {
            Boolean cachedRes;
            Boolean bl = cachedRes = this.cacheEntry != null ? this.cacheEntry.getEvalResult(apt) : null;
            if (cachedRes != null) {
                res = cachedRes;
            } else {
                res = APTConditionResolver.evaluate(apt, this.getMacroMap());
                if (this.cacheEntry != null) {
                    this.cacheEntry.setEvalResult(apt, res);
                }
            }
        }
        catch (TokenStreamException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on evaluating condition node {0}\n{1}", new Object[]{apt, ex});
        }
        this.onEval(apt, res);
        return res;
    }

    private void serialIncludeImpl(APTInclude aptInclude, ResolvedPath resolvedPath) {
        PostIncludeData postIncludeData = this.cacheEntry.getPostIncludeState(aptInclude);
        if (postIncludeData.hasPostIncludeMacroState() && !this.hasIncludeActionSideEffects()) {
            this.getPreprocHandler().getMacroMap().setState(postIncludeData.getPostIncludeMacroState());
            return;
        }
        if (this.include(resolvedPath, aptInclude, postIncludeData)) {
            APTMacroMap.State postIncludeMacroState = this.getPreprocHandler().getMacroMap().getState();
            PostIncludeData newData = new PostIncludeData(postIncludeMacroState, postIncludeData.getDeadBlocks());
            this.cacheEntry.setIncludeData(aptInclude, newData);
        } else if (postIncludeData != null && !postIncludeData.hasPostIncludeMacroState()) {
            postIncludeData.setDeadBlocks(null);
        }
    }
}

