/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.SnapshotHolderCache;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.TinyMaps;
import org.openide.util.CharSequences;

public final class APTMacroMapSnapshot {
    private static final Map<CharSequence, APTMacro> NO_MACROS = Collections.unmodifiableMap(new HashMap(0));
    private Object macros;
    final APTMacroMapSnapshot parent;
    public static final APTMacro UNDEFINED_MACRO = new UndefinedMacro();
    private static final Comparator<Map.Entry<CharSequence, APTMacro>> ENTRY_COMPARATOR = new EntryComparatorImpl();

    public APTMacroMapSnapshot(APTMacroMapSnapshot parent) {
        this.macros = this.createMacroMap(0);
        assert (parent == null || parent.parent == null || !parent.parent.isEmtpy()) : "how grand father could be empty " + parent;
        while (parent != null && parent.isEmtpy()) {
            parent = parent.parent;
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.freeze();
        }
    }

    private Map<CharSequence, APTMacro> createMacroMap(int prefferedSize) {
        if (prefferedSize == 0) {
            return NO_MACROS;
        }
        return TinyMaps.createMap((int)prefferedSize);
    }

    private void prepareMacroMapToAddMacro(CharSequence name, APTMacro macro) {
        assert (!(this.macros instanceof Holder)) : "frozen snap can not be modified";
        if (this.macros == NO_MACROS) {
            return;
        }
        if (this.macros instanceof Map) {
            Map map = (Map)this.macros;
            this.macros = TinyMaps.expandForNextKey((Map)map, (Object)name);
        } else {
            CharSequence key;
            APTMacro value;
            if (this.macros instanceof APTMacro) {
                value = (APTMacro)this.macros;
                key = value.getName().getTextID();
            } else {
                assert (this.macros instanceof CharSequence);
                value = UNDEFINED_MACRO;
                key = (CharSequence)this.macros;
            }
            if (key.equals(name)) {
                this.macros = NO_MACROS;
            } else {
                this.macros = this.createMacroMap(2);
                Map map = (Map)this.macros;
                map.put(key, value);
            }
        }
    }

    final void putMacro(CharSequence name, APTMacro macro) {
        this.prepareMacroMapToAddMacro(name, macro);
        if (this.macros == NO_MACROS) {
            if (macro == UNDEFINED_MACRO) {
                this.macros = name;
            } else {
                assert (macro.getName().getTextID().equals(name));
                this.macros = macro;
            }
        } else {
            assert (this.macros instanceof Map) : "unexpected class " + this.macros.getClass();
            Map map = (Map)this.macros;
            map.put(name, macro);
        }
    }

    public final APTMacro getMacro(APTToken token) {
        return this.getMacro(token.getTextID());
    }

    final APTMacro getMacro(CharSequence key) {
        assert (CharSequences.isCompact((CharSequence)key)) : "string can't be here " + key;
        APTMacroMapSnapshot currentSnap = this;
        while (currentSnap != null) {
            APTMacro macro = currentSnap.getMacroImpl(key);
            if (macro != null) {
                return macro;
            }
            currentSnap = currentSnap.parent;
        }
        return null;
    }

    private APTMacro getMacroImpl(CharSequence key) {
        if (this.macros == NO_MACROS) {
            return null;
        }
        if (this.macros instanceof CharSequence) {
            if (this.macros.equals(key)) {
                return UNDEFINED_MACRO;
            }
            return null;
        }
        if (this.macros instanceof APTMacro) {
            assert (this.macros != UNDEFINED_MACRO);
            if (((APTMacro)this.macros).getName().equals(key)) {
                return (APTMacro)this.macros;
            }
            return null;
        }
        assert (this.macros instanceof Map) : "unexpected to have get from frozen" + this.macros.getClass();
        APTMacro map = (APTMacro)((Map)this.macros).get(key);
        return map;
    }

    public String toString() {
        Map<CharSequence, APTMacro> tmpMap = APTMacroMapSnapshot.addAllMacros(this, null);
        return APTUtils.macros2String(tmpMap);
    }

    public static Map<CharSequence, APTMacro> addAllMacros(APTMacroMapSnapshot snap, Map<CharSequence, APTMacro> out) {
        if (snap != null) {
            int i = 0;
            LinkedList<APTMacroMapSnapshot> stack = new LinkedList<APTMacroMapSnapshot>();
            while (snap != null) {
                i += snap.size();
                stack.add(snap);
                snap = snap.parent;
            }
            if (out == null) {
                out = new HashMap<CharSequence, APTMacro>(i);
            }
            while (!stack.isEmpty()) {
                snap = (APTMacroMapSnapshot)stack.removeLast();
                if (snap.macros == NO_MACROS) continue;
                if (snap.macros instanceof Map) {
                    assert (stack.isEmpty()) : "map is allowed only as the last element " + stack;
                    Map map = (Map)snap.macros;
                    for (Map.Entry cur : map.entrySet()) {
                        if (cur.getValue() != UNDEFINED_MACRO) {
                            out.put((CharSequence)cur.getKey(), (APTMacro)cur.getValue());
                            continue;
                        }
                        out.remove(cur.getKey());
                    }
                    continue;
                }
                if (snap.macros instanceof Holder) {
                    Object[] arr = ((Holder)snap.macros).arr;
                    int collSize = arr.length / 2;
                    for (int j = 0; j < collSize; ++j) {
                        CharSequence key = (CharSequence)arr[j];
                        APTMacro value = (APTMacro)arr[j + collSize];
                        if (value != UNDEFINED_MACRO) {
                            out.put(key, value);
                            continue;
                        }
                        out.remove(key);
                    }
                    continue;
                }
                if (snap.macros instanceof APTMacro) {
                    assert (snap.macros != UNDEFINED_MACRO);
                    APTMacro m = (APTMacro)snap.macros;
                    out.put(m.getName().getTextID(), m);
                    continue;
                }
                assert (snap.macros instanceof CharSequence);
                out.remove((CharSequence)snap.macros);
            }
        }
        if (out == null) {
            out = new HashMap<CharSequence, APTMacro>();
        }
        return out;
    }

    public static int getMacroSize(APTMacroMapSnapshot snap) {
        int size = 0;
        while (snap != null) {
            size += snap.size();
            snap = snap.parent;
        }
        return size;
    }

    public boolean isEmtpy() {
        return this.size() == 0;
    }

    private int size() {
        if (this.macros == NO_MACROS) {
            return 0;
        }
        if (this.macros instanceof Map) {
            return ((Map)this.macros).size();
        }
        if (this.macros instanceof Holder) {
            return ((Holder)this.macros).arr.length / 2;
        }
        return 1;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        APTSerializeUtils.writeSnapshot(this.parent, output);
        if (this.macros == NO_MACROS) {
            output.writeInt(0);
        } else if (this.macros instanceof CharSequence) {
            output.writeInt(-1);
            output.writeCharSequenceUTF((CharSequence)this.macros);
        } else if (this.macros instanceof APTMacro) {
            output.writeInt(-2);
            APTSerializeUtils.writeMacro((APTMacro)this.macros, output);
        } else {
            assert (this.macros instanceof Holder) : "unexpected object " + this.macros;
            output.writeInt(this.size());
            APTMacroMapSnapshot.writeMacros(((Holder)this.macros).arr, output);
        }
    }

    public static void writeMacros(Object[] macros, RepositoryDataOutput output) throws IOException {
        assert (macros != null);
        int collSize = macros.length / 2;
        for (int i = 0; i < collSize; ++i) {
            CharSequence key = (CharSequence)macros[i];
            assert (CharSequences.isCompact((CharSequence)key));
            output.writeCharSequenceUTF(key);
            APTMacro macro = (APTMacro)macros[i + collSize];
            assert (macro != null);
            APTSerializeUtils.writeMacro(macro, output);
        }
    }

    public APTMacroMapSnapshot(RepositoryDataInput input) throws IOException {
        this.parent = APTSerializeUtils.readSnapshot(input);
        int collSize = input.readInt();
        if (collSize == -2) {
            this.macros = APTSerializeUtils.readMacro(input);
        } else if (collSize == -1) {
            this.macros = CharSequences.create((CharSequence)input.readCharSequenceUTF());
        } else if (collSize == 0) {
            this.macros = NO_MACROS;
        } else {
            Object[] arr = APTMacroMapSnapshot.readMacros(collSize, input);
            this.macros = SnapshotHolderCache.getManager().getHolder(new Holder(arr));
        }
    }

    private static Object[] readMacros(int collSize, RepositoryDataInput input) throws IOException {
        Object[] macros = new Object[collSize * 2];
        for (int i = 0; i < macros.length; ++i) {
            CharSequence key = CharSequences.create((CharSequence)input.readCharSequenceUTF());
            assert (key != null);
            APTMacro macro = APTSerializeUtils.readMacro(input);
            assert (macro != null);
            macros[i] = key;
            macros[i + collSize] = APTMacroCache.getManager().getMacro(macro);
        }
        return macros;
    }

    private void freeze() {
        if (this.macros instanceof Map && this.macros != NO_MACROS) {
            Object[] arr = APTMacroMapSnapshot.compact((Map)this.macros);
            this.macros = SnapshotHolderCache.getManager().getHolder(new Holder(arr));
        }
    }

    private static Object[] compact(Map<CharSequence, APTMacro> map) {
        assert (map != NO_MACROS);
        int size = map.size();
        assert (size > 0);
        Object[] out = new Object[size * 2];
        int index = 0;
        Map.Entry[] entries = new Map.Entry[size];
        for (Map.Entry<CharSequence, APTMacro> entry : map.entrySet()) {
            entries[index++] = entry;
        }
        index = 0;
        Arrays.sort(entries, ENTRY_COMPARATOR);
        for (Map.Entry entry : entries) {
            out[index] = entry.getKey();
            out[index + size] = entry.getValue();
            ++index;
        }
        return out;
    }

    private static class EntryComparatorImpl
    implements Comparator<Map.Entry<CharSequence, APTMacro>> {
        private final Comparator<CharSequence> charSeqComparator = CharSequences.comparator();

        @Override
        public int compare(Map.Entry<CharSequence, APTMacro> o1, Map.Entry<CharSequence, APTMacro> o2) {
            return this.charSeqComparator.compare(o1.getKey(), o2.getKey());
        }
    }

    static final class Holder {
        private final Object[] arr;
        private final int hashCode;

        public Holder(Object[] arr) {
            this.arr = arr;
            this.hashCode = Arrays.hashCode(this.arr);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return Arrays.equals(this.arr, other.arr);
        }
    }

    private static final class UndefinedMacro
    implements APTMacro {
        private UndefinedMacro() {
        }

        public String toString() {
            return "Macro undefined";
        }

        @Override
        public CharSequence getFile() {
            return CharSequences.empty();
        }

        @Override
        public APTMacro.Kind getKind() {
            return APTMacro.Kind.USER_SPECIFIED;
        }

        @Override
        public boolean isFunctionLike() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTToken getName() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public Collection<APTToken> getParams() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public TokenStream getBody() {
            throw new UnsupportedOperationException("Not supported in fake impl");
        }

        @Override
        public APTDefine getDefineNode() {
            throw new UnsupportedOperationException("Not supported in fake impl.");
        }
    }
}

