/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.impl.structure.APTBuilderImpl;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class APTMacroImpl
implements APTMacro {
    private final CharSequence file;
    private final APTDefine defineNode;
    private final APTMacro.Kind macroType;
    private volatile int hashCode = 0;

    public APTMacroImpl(CharSequence file, APTDefine defineNode, APTMacro.Kind macroType) {
        assert (defineNode.getName() != null);
        this.file = file;
        assert (file != null);
        assert (file.length() == 0 || macroType == APTMacro.Kind.DEFINED) : "file info has only #defined macro " + file;
        this.defineNode = (APTDefine)APTBuilderImpl.createLightCopy(defineNode);
        this.macroType = macroType;
    }

    @Override
    public CharSequence getFile() {
        return this.file;
    }

    @Override
    public APTMacro.Kind getKind() {
        return this.macroType;
    }

    @Override
    public boolean isFunctionLike() {
        return this.defineNode.isFunctionLike();
    }

    @Override
    public APTToken getName() {
        return this.defineNode.getName();
    }

    @Override
    public Collection<APTToken> getParams() {
        return this.defineNode.getParams();
    }

    @Override
    public TokenStream getBody() {
        return new ListBasedTokenStream(this.defineNode.getBody());
    }

    @Override
    public APTDefine getDefineNode() {
        return this.defineNode;
    }

    public boolean equals(Object obj) {
        boolean retValue;
        if (obj == null || !(obj instanceof APTMacroImpl)) {
            retValue = false;
        } else {
            APTMacroImpl other = (APTMacroImpl)obj;
            retValue = APTMacroImpl.equals(this, other);
        }
        return retValue;
    }

    private static boolean equals(APTMacroImpl one, APTMacroImpl other) {
        if (one.macroType != other.macroType) {
            return false;
        }
        if (one.file == other.file && one.file != null && !one.file.equals(other.file)) {
            return false;
        }
        return one.defineNode.equals(other.defineNode);
    }

    public int hashCode() {
        int retValue = this.hashCode;
        if (retValue == 0) {
            retValue = 31 * retValue + this.macroType.ordinal();
            retValue = 31 * retValue + (this.file == null ? 0 : this.file.hashCode());
            retValue = 31 * retValue + this.defineNode.hashCode();
            retValue = this.hashCode = APTUtils.hash(retValue);
        }
        return retValue;
    }

    public String toString() {
        TokenStream bodyStream;
        StringBuilder retValue = new StringBuilder();
        switch (this.getKind()) {
            case DEFINED: {
                retValue.append("<U>");
                break;
            }
            case COMPILER_PREDEFINED: {
                retValue.append("<S>");
                break;
            }
            case POSITION_PREDEFINED: {
                retValue.append("<S>");
                break;
            }
            default: {
                retValue.append("<S>");
            }
        }
        retValue.append("#define '");
        retValue.append(this.getName());
        if (this.getParams() != null) {
            retValue.append("[");
            boolean first = true;
            for (APTToken elem : this.getParams()) {
                if (!first) {
                    retValue.append(", ");
                }
                first = false;
                retValue.append(elem);
            }
            retValue.append("]");
        }
        if ((bodyStream = this.getBody()) != null) {
            retValue.append("'='");
            retValue.append(APTUtils.toString(bodyStream));
        }
        return retValue.toString();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public APTMacroImpl(RepositoryDataInput input) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

