/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.utils.cache.TextCache;

public final class APTLiteIdToken
extends APTTokenAbstact {
    private static final int COL_BITS = 10;
    private static final int MAX_COL = 1023;
    private static final int LINE_BITS = 22;
    private static final int MAX_LINE = 0x3FFFFF;
    private final int offset;
    private final int columnLineType;
    private CharSequence text = null;

    public static boolean isApplicable(int type, int offset, int column, int line) {
        return type == 91 && line <= 0x3FFFFF && column <= 1023;
    }

    public APTLiteIdToken(int offset, int column, int line) {
        this.offset = offset;
        this.columnLineType = ((column & 0x3FF) << 22) + (line & 0x3FFFFF);
        assert (column == this.getColumn());
        assert (line == this.getLine());
    }

    @Override
    public final CharSequence getTextID() {
        return this.text;
    }

    @Override
    public final void setTextID(CharSequence textID) {
        this.text = TextCache.getManager().getString(textID);
    }

    @Override
    public final String getText() {
        if (this.text != null) {
            return ((Object)this.text).toString();
        }
        return "";
    }

    @Override
    public final void setText(String t) {
        this.text = TextCache.getManager().getString((CharSequence)t);
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public void setType(int t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getColumn() {
        return this.columnLineType >> 22 & 0x3FF;
    }

    @Override
    public void setColumn(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLine() {
        return this.columnLineType & 0x3FFFFF;
    }

    @Override
    public void setLine(int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEndOffset() {
        return this.getOffset() + this.getTextID().length();
    }

    @Override
    public int getEndLine() {
        return this.getLine();
    }

    @Override
    public int getEndColumn() {
        return this.getColumn() + this.getTextID().length();
    }
}

