/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.wizards;

import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public abstract class AbstractWizardPanel
implements WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private boolean valid;
    private Message errMessage;

    public final Component getComponent() {
        return this.getJComponent();
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.valid) {
            throw new WizardValidationException(this.getJComponent(), this.errMessage.getMessage(), this.errMessage.getMessage());
        }
    }

    public void readSettings(WizardDescriptor settings) {
    }

    public void storeSettings(WizardDescriptor settings) {
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public Message getErrorMessage() {
        return this.errMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValid(boolean valid, Message message) {
        boolean oldValid = this.valid;
        Message oldMessage = this.errMessage;
        this.valid = valid;
        this.errMessage = message;
        if (oldValid != valid || oldMessage != null && !oldMessage.equals(message) || message != null && !message.equals(oldMessage)) {
            ChangeListener[] lists;
            ChangeEvent evt = new ChangeEvent(this);
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            for (ChangeListener list2 : lists) {
                list2.stateChanged(evt);
            }
        }
    }

    protected abstract void validateBeforeNext();

    protected abstract JComponent getJComponent();

    public static class Message {
        private final boolean info;
        private final String msg;

        public Message(String msg, boolean isInfo) {
            this.info = isInfo;
            this.msg = msg;
        }

        public boolean isInfo() {
            return this.info;
        }

        public String getMessage() {
            return this.msg;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Message) {
                Message other = (Message)obj;
                return (this.msg == null && other.msg == null || this.msg != null && this.msg.equals(other.msg)) && this.info == other.info;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + (this.info ? 1 : 0);
            hash = 17 * hash + (this.msg != null ? this.msg.hashCode() : 0);
            return hash;
        }
    }
}

