/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import javax.swing.Action;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class GitStatusNode
extends VCSStatusNode<GitFileNode> {
    private final FileInformation.Mode mode;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public GitStatusNode(GitFileNode node, FileInformation.Mode mode) {
        this(node, mode, Lookups.fixed((Object[])node.getLookupObjects()));
    }

    public GitStatusNode(GitFileNode node, FileInformation.Mode mode, Lookup lkp) {
        super((VCSFileNode)node, lkp);
        this.mode = mode;
        this.initProperties();
    }

    public Action getPreferredAction() {
        if (((GitFileNode)this.node).getInformation().containsStatus(FileInformation.Status.IN_CONFLICT)) {
            return SystemAction.get(ResolveConflictsAction.class);
        }
        return SystemAction.get(DiffAction.class);
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(klass);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)this.nameProperty);
        ps.put((Node.Property)this.pathProperty);
        ps.put((Node.Property)new GitStatusProperty(this));
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public void refresh() {
    }

    public static class GitStatusProperty
    extends NodeProperty<String> {
        public static final String NAME = "gitstatus";
        public static final String DISPLAY_NAME = NbBundle.getMessage(GitStatusNode.class, (String)"LBL_Status.DisplayName");
        public static final String DESCRIPTION = NbBundle.getMessage(GitStatusNode.class, (String)"LBL_Status.Description");
        private final GitFileNode fileNode;
        private final FileInformation.Mode mode;

        public GitStatusProperty(GitStatusNode statusNode) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            String sortable = Integer.toString(((GitFileNode)statusNode.getFileNode()).getInformation().getComparableStatus());
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + ((GitFileNode)statusNode.getFileNode()).getName());
            this.fileNode = (GitFileNode)statusNode.node;
            this.mode = statusNode.mode;
        }

        @Override
        public String getValue() {
            FileInformation finfo = this.fileNode.getInformation();
            return finfo.getStatusText(this.mode);
        }
    }

    protected static abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String name, Class<T> type, String displayName, String description) {
            super(name, type, displayName, description);
        }

        public String toString() {
            return this.getValue().toString();
        }

        public abstract T getValue();
    }
}

