/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.repository.remote.RemoteConfig;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepository;
import org.netbeans.modules.git.ui.repository.remote.SelectUriPanel;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.git.utils.WizardStepProgressSupport;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class SelectUriStep
extends AbstractWizardPanel
implements ActionListener,
ItemListener,
ChangeListener,
DocumentListener,
WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor> {
    private final Map<String, GitRemoteConfig> remotes;
    private final SelectUriPanel panel;
    private final JComponent[] inputFields;
    private GitProgressSupport supp;
    private final File repositoryFile;
    private Map<String, GitBranch> remoteBranches;
    private Map<String, String> remoteTags;
    private final RemoteRepository repository;
    private final Mode mode;
    private final Timer remoteNameEditTimer;

    public SelectUriStep(File repositoryFile, Map<String, GitRemoteConfig> remotes, Mode mode) {
        this.repositoryFile = repositoryFile;
        this.repository = new RemoteRepository(null);
        this.panel = new SelectUriPanel(this.repository.getPanel());
        this.remotes = remotes;
        this.inputFields = new JComponent[]{this.panel.cmbConfiguredRepositories, this.panel.rbConfiguredUri, this.panel.rbCreateNew, this.panel.lblRemoteNames, this.panel.cmbRemoteNames};
        this.mode = mode;
        if (mode == Mode.PUSH) {
            this.panel.remotesPanel.setVisible(false);
        }
        this.remoteNameEditTimer = new Timer(300, this);
        this.remoteNameEditTimer.setRepeats(false);
        this.remoteNameEditTimer.stop();
        this.fillPanel();
        this.attachListeners();
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SelectUriStep.this.enableFields();
                SelectUriStep.this.validateBeforeNext();
            }
        });
    }

    private void fillPanel() {
        LinkedList<RemoteUri> list = new LinkedList<RemoteUri>();
        for (Map.Entry<String, GitRemoteConfig> e : this.remotes.entrySet()) {
            boolean empty = true;
            if (this.mode == Mode.PUSH) {
                for (String uri : e.getValue().getPushUris()) {
                    list.add(new RemoteUri(e.getKey(), uri));
                    empty = false;
                }
            }
            if (!empty) continue;
            for (String uri : e.getValue().getUris()) {
                list.add(new RemoteUri(e.getKey(), uri));
            }
        }
        Object[] uris = list.toArray(new RemoteUri[list.size()]);
        Arrays.sort(uris);
        this.panel.cmbConfiguredRepositories.removeAllItems();
        this.panel.cmbConfiguredRepositories.setModel(new DefaultComboBoxModel<Object>(uris));
        this.panel.rbCreateNew.setSelected(list.isEmpty());
        if (!list.isEmpty()) {
            this.panel.cmbConfiguredRepositories.setSelectedIndex(0);
        }
        this.panel.rbConfiguredUri.setSelected(!this.panel.rbCreateNew.isSelected());
        this.panel.cmbRemoteNames.setModel(new DefaultComboBoxModel<Object>(this.remotes.keySet().toArray()));
    }

    private void attachListeners() {
        this.panel.rbCreateNew.addActionListener(this);
        this.panel.rbConfiguredUri.addActionListener(this);
        this.panel.cmbConfiguredRepositories.addActionListener(this);
        this.panel.cmbRemoteNames.addItemListener(this);
        ((JTextComponent)this.panel.cmbRemoteNames.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.repository.addChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.rbCreateNew || e.getSource() == this.panel.rbConfiguredUri || e.getSource() == this.panel.cmbConfiguredRepositories) {
            this.enableFields();
            this.validateBeforeNext();
        } else if (e.getSource() == this.remoteNameEditTimer) {
            this.validateBeforeNext();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.validateBeforeNext();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.restartTimer();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.restartTimer();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.restartTimer();
    }

    private void restartTimer() {
        this.remoteNameEditTimer.restart();
    }

    private void enableFields() {
        this.repository.setEnabled(this.panel.rbCreateNew.isSelected());
        this.panel.cmbConfiguredRepositories.setEnabled(this.panel.rbConfiguredUri.isSelected());
        this.panel.cmbRemoteNames.setEnabled(this.panel.rbCreateNew.isSelected());
        this.panel.lblRemoteNames.setEnabled(this.panel.rbCreateNew.isSelected());
        this.panel.cbPersistRemote.setEnabled(this.panel.rbCreateNew.isSelected());
    }

    @Override
    protected final void validateBeforeNext() {
        boolean valid = true;
        AbstractWizardPanel.Message msg = null;
        final boolean newRepositorySpecification = this.panel.rbCreateNew.isSelected();
        if (this.panel.rbConfiguredUri.isSelected()) {
            if (this.panel.cmbConfiguredRepositories.getSelectedIndex() == -1) {
                msg = new AbstractWizardPanel.Message(NbBundle.getMessage(SelectUriStep.class, (String)"MSG_SelectUriStep.errorEmptySelection"), false);
                valid = false;
            }
        } else if (this.panel.rbCreateNew.isSelected()) {
            valid = this.repository.isValid();
            msg = this.repository.getMessage();
            if (valid && this.mode != Mode.PUSH && ((JTextComponent)this.panel.cmbRemoteNames.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
                valid = false;
                msg = new AbstractWizardPanel.Message(NbBundle.getMessage(SelectUriStep.class, (String)"MSG_SelectUriStep.errorEmptyRemoteName"), false);
            }
        }
        this.setValid(valid, msg);
        if (valid && !EventQueue.isDispatchThread()) {
            final AbstractWizardPanel.Message[] message = new AbstractWizardPanel.Message[1];
            this.supp = new WizardStepProgressSupport(this.panel.progressPanel, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    String uri = SelectUriStep.this.getSelectedUri();
                    GitClient client = null;
                    try {
                        if (newRepositorySpecification) {
                            SelectUriStep.this.repository.store();
                            client = Git.getInstance().getClient(this.getRepositoryRoot(), this, false);
                        } else {
                            client = this.getClient();
                        }
                        SelectUriStep.this.remoteBranches = client.listRemoteBranches(uri, this.getProgressMonitor());
                        if (!this.isCanceled() && SelectUriStep.this.mode == Mode.PUSH) {
                            SelectUriStep.this.remoteTags = client.listRemoteTags(uri, this.getProgressMonitor());
                        }
                    }
                    catch (GitException ex) {
                        if (((SelectUriStep)SelectUriStep.this).panel.rbCreateNew.isSelected()) {
                            GitModuleConfig.getDefault().removeConnectionSettings(SelectUriStep.this.repository.getURI());
                        }
                        Logger.getLogger(SelectUriStep.class.getName()).log(Level.INFO, "Cannot connect to " + uri, ex);
                        message[0] = new AbstractWizardPanel.Message(NbBundle.getMessage(SelectUriStep.class, (String)"MSG_SelectUriStep.errorCannotConnect", (Object)uri), false);
                    }
                    finally {
                        if (client != null) {
                            client.release();
                        }
                    }
                }

                @Override
                public void setEnabled(boolean flag) {
                    SelectUriStep.this.setEnabled(flag);
                }
            };
            this.supp.start(Git.getInstance().getRequestProcessor(this.repositoryFile), this.repositoryFile, NbBundle.getMessage(SelectUriStep.class, (String)"LBL_SelectUriStep.progressName")).waitFinished();
            if (message[0] == null && this.supp.isCanceled()) {
                message[0] = new AbstractWizardPanel.Message(NbBundle.getMessage(SelectUriStep.class, (String)"MSG_SelectUriStep.validationCanceled"), true);
            }
            if (message[0] != null) {
                this.setValid(false, message[0]);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (message[0] != null) {
                        SelectUriStep.this.setValid(true, message[0]);
                    }
                    SelectUriStep.this.setEnabled(true);
                    SelectUriStep.this.enableFields();
                }
            });
        }
    }

    @Override
    protected JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(SelectUriStep.class.getName() + "." + this.mode.helpId);
    }

    public String getSelectedUri() {
        GitURI uri;
        String selectedUri = this.panel.rbConfiguredUri.isSelected() ? ((RemoteUri)this.panel.cmbConfiguredRepositories.getSelectedItem()).uri : ((uri = this.repository.getURI()) != null ? uri.toPrivateString().trim() : "");
        return selectedUri;
    }

    public GitRemoteConfig getSelectedRemote() {
        GitRemoteConfig selectedRemote = this.panel.rbConfiguredUri.isSelected() ? this.remotes.get(((RemoteUri)this.panel.cmbConfiguredRepositories.getSelectedItem()).remoteName) : RemoteConfig.createUpdatableRemote(this.repositoryFile, (String)this.panel.cmbRemoteNames.getSelectedItem()).toGitRemote();
        return selectedRemote;
    }

    public boolean isConfiguredRemoteSelected() {
        return this.panel.rbConfiguredUri.isSelected();
    }

    public void prepareValidation() {
        this.setEnabled(false);
    }

    private void setEnabled(boolean enabled) {
        for (JComponent inputField : this.inputFields) {
            inputField.setEnabled(enabled);
        }
        this.repository.setEnabled(enabled);
    }

    public void cancelBackgroundTasks() {
        if (this.supp != null) {
            this.supp.cancel();
        }
    }

    public Map<String, GitBranch> getRemoteBranches() {
        return this.remoteBranches;
    }

    public Map<String, String> getRemoteTags() {
        return this.remoteTags;
    }

    public boolean isPersistRemote() {
        return !this.isConfiguredRemoteSelected() && this.panel.cbPersistRemote.isSelected() && this.panel.cbPersistRemote.isVisible() && this.panel.cbPersistRemote.isEnabled();
    }

    public String getNewRemoteName() {
        return (String)this.panel.cmbRemoteNames.getSelectedItem();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.validateBeforeNext();
    }

    public void storeURI() {
        if (this.panel.rbCreateNew.isSelected()) {
            this.repository.store();
        }
    }

    private static class RemoteUri
    implements Comparable<RemoteUri> {
        private final String label;
        private final String uri;
        private final String remoteName;

        public RemoteUri(String remoteName, String uri) {
            this.uri = uri;
            this.remoteName = remoteName;
            this.label = NbBundle.getMessage(SelectUriPanel.class, (String)"SelectUriPanel.configuredRepository.uri", (Object[])new Object[]{remoteName, uri});
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(RemoteUri other) {
            int comp = this.remoteName.compareToIgnoreCase(other.remoteName);
            if (comp == 0) {
                comp = this.uri.compareToIgnoreCase(other.uri);
            }
            return comp;
        }
    }

    public static enum Mode {
        PULL("pull"),
        PUSH("push"),
        FETCH("fetch");

        private String helpId;

        private Mode(String helpId) {
            this.helpId = helpId;
        }
    }
}

