/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.ui.repository.RevisionInfoPanel;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RevisionInfoPanelController {
    private final RevisionInfoPanel panel;
    private static final String MSG_LOADING = NbBundle.getMessage(RevisionDialogController.class, (String)"MSG_RevisionInfoPanel.loading");
    private static final String MSG_UNKNOWN = NbBundle.getMessage(RevisionDialogController.class, (String)"MSG_RevisionInfoPanel.unknown");
    private final LoadInfoWorker loadInfoWorker = new LoadInfoWorker();
    private final RequestProcessor.Task loadInfoTask;
    private String currentCommit;
    private final File repository;
    private boolean valid;
    private final PropertyChangeSupport support;
    public static final String PROP_VALID = "RevisionInfoPanelController.valid";

    public RevisionInfoPanelController(File repository) {
        this.repository = repository;
        this.loadInfoTask = Git.getInstance().getRequestProcessor(null).create((Runnable)this.loadInfoWorker);
        this.panel = new RevisionInfoPanel();
        this.support = new PropertyChangeSupport(this);
        this.resetInfoFields();
    }

    public RevisionInfoPanel getPanel() {
        return this.panel;
    }

    public void loadInfo(String revision) {
        this.loadInfoTask.cancel();
        this.loadInfoWorker.monitor.cancel();
        this.currentCommit = revision;
        this.setValid(false);
        if (revision == null || revision.isEmpty()) {
            this.setUnknownRevision();
        } else {
            this.resetInfoFields();
            this.loadInfoTask.schedule(100);
        }
    }

    private void resetInfoFields() {
        this.panel.taMessage.setText(MSG_LOADING);
        this.panel.tbAuthor.setText(MSG_LOADING);
        this.panel.tbRevisionId.setText(MSG_LOADING);
    }

    public void updateInfoFields(String revision, GitRevisionInfo info) {
        assert (EventQueue.isDispatchThread());
        this.panel.tbAuthor.setText(info.getAuthor().toString());
        if (!this.panel.tbAuthor.getText().isEmpty()) {
            this.panel.tbAuthor.setCaretPosition(0);
        }
        if (revision.equals(info.getRevision())) {
            this.panel.tbRevisionId.setText(info.getRevision());
        } else {
            if (revision.startsWith("refs/heads/")) {
                revision = revision.substring("refs/heads/".length());
            } else if (revision.startsWith("refs/remotes/")) {
                revision = revision.substring("refs/remotes/".length());
            }
            this.panel.tbRevisionId.setText(revision + " (" + info.getRevision() + ')');
        }
        if (!this.panel.tbRevisionId.getText().isEmpty()) {
            this.panel.tbRevisionId.setCaretPosition(0);
        }
        this.panel.taMessage.setText(info.getFullMessage());
        if (!this.panel.taMessage.getText().isEmpty()) {
            this.panel.taMessage.setCaretPosition(0);
        }
    }

    private void setUnknownRevision() {
        this.panel.tbAuthor.setText(MSG_UNKNOWN);
        this.panel.tbRevisionId.setText(MSG_UNKNOWN);
        this.panel.taMessage.setText(MSG_UNKNOWN);
    }

    private void setValid(boolean flag) {
        boolean oldValue = this.valid;
        this.valid = flag;
        if (oldValue != this.valid) {
            this.support.firePropertyChange(PROP_VALID, oldValue, this.valid);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }

    private class LoadInfoWorker
    implements Runnable {
        ProgressMonitor.DefaultProgressMonitor monitor = new ProgressMonitor.DefaultProgressMonitor();

        private LoadInfoWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GitRevisionInfo revisionInfo;
            final String revision = RevisionInfoPanelController.this.currentCommit;
            GitClient client = null;
            try {
                this.monitor = new ProgressMonitor.DefaultProgressMonitor();
                if (Thread.interrupted()) {
                    return;
                }
                client = Git.getInstance().getClient(RevisionInfoPanelController.this.repository);
                revisionInfo = client.log(revision, (ProgressMonitor)this.monitor);
            }
            catch (GitException ex) {
                if (!(ex instanceof GitException.MissingObjectException)) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                revisionInfo = null;
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            final GitRevisionInfo info = revisionInfo;
            final ProgressMonitor.DefaultProgressMonitor m = this.monitor;
            if (!this.monitor.isCanceled()) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        if (!m.isCanceled()) {
                            if (info == null) {
                                RevisionInfoPanelController.this.setUnknownRevision();
                            } else {
                                RevisionInfoPanelController.this.updateInfoFields(revision, info);
                                RevisionInfoPanelController.this.setValid(true);
                            }
                        }
                    }
                });
            }
        }
    }
}

