/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.push.Bundle;
import org.netbeans.modules.git.ui.push.PushAction;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.actions.SystemAction;

public class PushToUpstreamAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.push(repository);
    }

    private void push(final File repository) {
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                info.refresh();
                GitBranch activeBranch = info.getActiveBranch();
                if (activeBranch == null) {
                    return;
                }
                String errorLabel = Bundle.LBL_Push_pushToUpstreamFailed();
                GitBranch trackedBranch = PushToUpstreamAction.this.getTrackedBranch(activeBranch, errorLabel);
                if (trackedBranch == null) {
                    return;
                }
                GitRemoteConfig cfg = PushToUpstreamAction.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                if (cfg == null) {
                    return;
                }
                String uri = cfg.getPushUris().isEmpty() ? (String)cfg.getUris().get(0) : (String)cfg.getPushUris().get(0);
                LinkedList<PushMapping> pushMappings = new LinkedList<PushMapping>();
                List fetchSpecs = cfg.getFetchRefSpecs();
                String remoteBranchName = PushToUpstreamAction.guessRemoteBranchName(fetchSpecs, trackedBranch.getName(), cfg.getRemoteName());
                if (remoteBranchName == null) {
                    PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_unknownRemoteBranchName(trackedBranch.getName()));
                }
                pushMappings.add(new PushMapping.PushBranchMapping(remoteBranchName, trackedBranch.getId(), activeBranch, false, false));
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                ((PushAction)SystemAction.get(PushAction.class)).push(repository, uri, pushMappings, cfg.getFetchRefSpecs());
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PushToUpstreamAction_preparing());
    }

    private static String parseRemote(String branchName) {
        int pos = branchName.lastIndexOf(47);
        String remoteName = null;
        if (pos > 0) {
            remoteName = branchName.substring(0, pos);
        }
        return remoteName;
    }

    protected GitBranch getTrackedBranch(GitBranch activeBranch, String errorLabel) {
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch == null) {
            PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_noTrackedBranch(activeBranch.getName()));
            return null;
        }
        if (!trackedBranch.isRemote()) {
            PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_trackedBranchLocal(trackedBranch.getName()));
            return null;
        }
        return trackedBranch;
    }

    protected static GitRemoteConfig getRemoteConfigForActiveBranch(GitBranch trackedBranch, RepositoryInfo info, String errorLabel) {
        GitRemoteConfig cfg;
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        String remoteName = PushToUpstreamAction.parseRemote(trackedBranch.getName());
        GitRemoteConfig gitRemoteConfig = cfg = remoteName == null ? null : remotes.get(remoteName);
        if (cfg == null) {
            PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_noRemote(trackedBranch.getName()));
            return null;
        }
        if (cfg.getPushUris().isEmpty() && cfg.getUris().isEmpty()) {
            PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_noUri(cfg.getRemoteName()));
            return null;
        }
        if (cfg.getFetchRefSpecs().isEmpty()) {
            PushToUpstreamAction.notifyError(errorLabel, Bundle.MSG_Err_noSpecs(cfg.getRemoteName()));
            return null;
        }
        return cfg;
    }

    private static void notifyError(String errorLabel, String errorMessage) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)errorMessage, errorLabel, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    private static String guessRemoteBranchName(List<String> fetchSpecs, String branchName, String remoteName) {
        String remoteBranchName = null;
        String branchShortName = branchName.startsWith(remoteName) ? branchName.substring(remoteName.length() + 1) : branchName.substring(branchName.lastIndexOf(47) + 1);
        for (String spec : fetchSpecs) {
            int pos;
            if (spec.startsWith("+")) {
                spec = spec.substring(1);
            }
            if ((pos = spec.lastIndexOf(58)) <= 0) continue;
            String left = spec.substring(0, pos);
            String right = spec.substring(pos + 1);
            if (!right.endsWith("refs/remotes/" + branchName) && !right.endsWith("refs/remotes/" + remoteName + "/*")) continue;
            if (left.endsWith("/*")) {
                remoteBranchName = branchShortName;
                break;
            }
            if (!left.startsWith("refs/heads/")) continue;
            remoteBranchName = left.substring("refs/heads/".length());
            break;
        }
        return remoteBranchName;
    }
}

