/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.ui.push.PushBranchesStep;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public abstract class PushMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1} [{2}]";
    private static final String BRANCH_MAPPING_LABEL_UPTODATE = "{0} -> {1}";
    private final String localName;

    protected PushMapping(String localName, String localId, String remoteName, String remoteId, boolean conflict, boolean preselected) {
        super(preselected);
        this.localName = localName;
        if (remoteName == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, localName, "<font color=\"#00b400\">A</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{localName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.added.description")});
        } else if (localId.equals(remoteId)) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL_UPTODATE, localName, remoteName);
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.uptodate.description", (Object)remoteName);
        } else if (conflict) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, remoteName, "<font color=\"#FF0000\">C</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.conflict.description", (Object[])new Object[]{remoteName});
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, localName, remoteName, "<font color=\"#0000FF\">U</font>");
            this.tooltip = NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.description", (Object[])new Object[]{remoteName, NbBundle.getMessage(PushBranchesStep.class, (String)"LBL_PushBranchMapping.Mode.updated.description")});
        }
    }

    public abstract String getRefSpec();

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof PushMapping) {
            return this.localName.compareTo(((PushMapping)t).localName);
        }
        return 0;
    }

    public static final class PushTagMapping
    extends PushMapping {
        private final GitTag tag;

        public PushTagMapping(GitTag tag) {
            super("tags/" + tag.getTagName(), tag.getTaggedObjectId(), null, null, false, false);
            this.tag = tag;
        }

        @Override
        public String getRefSpec() {
            return GitUtils.getPushTagRefSpec(this.tag.getTagName());
        }
    }

    public static final class PushBranchMapping
    extends PushMapping {
        private final GitBranch localBranch;
        private final String remoteBranchName;
        private final String remoteBranchId;

        public PushBranchMapping(String remoteBranchName, String remoteBranchId, GitBranch localBranch, boolean conflict, boolean preselected) {
            super(localBranch.getName(), localBranch.getId(), remoteBranchName, remoteBranchId, conflict, preselected);
            this.localBranch = localBranch;
            this.remoteBranchName = remoteBranchName;
            this.remoteBranchId = remoteBranchId;
        }

        public String getRemoteRepositoryBranchName() {
            return this.remoteBranchName == null ? this.localBranch.getName() : this.remoteBranchName;
        }

        public String getRemoteRepositoryBranchHeadId() {
            return this.remoteBranchId;
        }

        public String getLocalRepositoryBranchHeadId() {
            return this.localBranch == null ? null : this.localBranch.getId();
        }

        @Override
        public String getRefSpec() {
            return GitUtils.getPushRefSpec(this.localBranch.getName(), this.remoteBranchName == null ? this.localBranch.getName() : this.remoteBranchName);
        }
    }
}

