/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.push;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.push.PushWizard;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.hooks.GitHook;
import org.netbeans.modules.versioning.hooks.GitHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PushAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(PushAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.push(repository);
    }

    private void push(final File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refreshRemotes();
        final Map<String, GitRemoteConfig> remotes = info.getRemotes();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PushWizard wiz = new PushWizard(repository, remotes);
                if (wiz.show()) {
                    Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getPushUri());
                    PushAction.this.push(repository, wiz.getPushUri(), wiz.getPushMappings(), wiz.getFetchRefSpecs());
                }
            }
        });
    }

    public void push(File repository, final String remote, final Collection<PushMapping> pushMappins, final List<String> fetchRefSpecs) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                LinkedList<String> pushRefSpecs = new LinkedList<String>();
                for (PushMapping b : pushMappins) {
                    pushRefSpecs.add(b.getRefSpec());
                }
                LOG.log(Level.FINE, "Pushing {0}/{1} to {2}", new Object[]{pushRefSpecs, fetchRefSpecs, remote});
                try {
                    GitClient client = this.getClient();
                    Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
                    this.beforePush(hooks, pushMappins);
                    if (this.isCanceled()) {
                        return;
                    }
                    GitPushResult result = client.push(remote, pushRefSpecs, fetchRefSpecs, this.getProgressMonitor());
                    this.reportRemoteConflicts(result.getRemoteRepositoryUpdates());
                    this.logUpdates(result.getRemoteRepositoryUpdates(), "MSG_PushAction.updates.remoteUpdates");
                    this.logUpdates(result.getLocalRepositoryUpdates(), "MSG_PushAction.updates.localUpdates");
                    if (this.isCanceled()) {
                        return;
                    }
                    this.setProgress(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.finalizing"));
                    this.afterPush(hooks, result.getRemoteRepositoryUpdates());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }

            protected void logUpdates(Map<String, GitTransportUpdate> updates, String titleBundleName) {
                OutputLogger logger = this.getLogger();
                logger.output(NbBundle.getMessage(PushAction.class, (String)titleBundleName));
                if (updates.isEmpty()) {
                    logger.output(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.updates.noChange"));
                } else {
                    for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                        GitTransportUpdate update = e.getValue();
                        if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                            logger.output(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.updates.updateBranch", (Object[])new Object[]{update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()}));
                            continue;
                        }
                        logger.output(NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
                    }
                }
            }

            private void beforePush(Collection<GitHook> hooks, Collection<PushMapping> pushMapping) throws GitException {
                if (hooks.size() > 0) {
                    List<GitRevisionInfo> messages = this.getOutgoingRevisions(pushMapping);
                    if (!this.isCanceled() && !messages.isEmpty()) {
                        GitHookContext context = this.initializeHookContext(messages);
                        for (GitHook gitHook : hooks) {
                            try {
                                gitHook.beforePush(context);
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<GitRevisionInfo> getOutgoingRevisions(Collection<PushMapping> pushMappings) throws GitException {
                LinkedList<GitRevisionInfo> revisionList = new LinkedList<GitRevisionInfo>();
                HashSet<String> visitedRevisions = new HashSet<String>();
                GitClient client = Git.getInstance().getClient(this.getRepositoryRoot());
                try {
                    for (PushMapping mapping : pushMappings) {
                        if (mapping instanceof PushMapping.PushBranchMapping) {
                            PushMapping.PushBranchMapping branchMapping = (PushMapping.PushBranchMapping)mapping;
                            String remoteRevisionId = branchMapping.getRemoteRepositoryBranchHeadId();
                            String localRevisionId = branchMapping.getLocalRepositoryBranchHeadId();
                            revisionList.addAll(this.addRevisions(client, visitedRevisions, remoteRevisionId, localRevisionId));
                        }
                        if (!this.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                return revisionList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List<GitRevisionInfo> getPushedRevisions(Map<String, GitTransportUpdate> remoteRepositoryUpdates) throws GitException {
                LinkedList<GitRevisionInfo> revisionList = new LinkedList<GitRevisionInfo>();
                HashSet<String> visitedRevisions = new HashSet<String>();
                GitClient client = Git.getInstance().getClient(this.getRepositoryRoot());
                try {
                    for (Map.Entry<String, GitTransportUpdate> update : remoteRepositoryUpdates.entrySet()) {
                        String remoteRevisionId = update.getValue().getOldObjectId();
                        String localRevisionId = update.getValue().getNewObjectId();
                        revisionList.addAll(this.addRevisions(client, visitedRevisions, remoteRevisionId, localRevisionId));
                        if (!this.isCanceled()) continue;
                        break;
                    }
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                return revisionList;
            }

            private void afterPush(Collection<GitHook> hooks, Map<String, GitTransportUpdate> remoteRepositoryUpdates) throws GitException {
                if (hooks.size() > 0) {
                    List<GitRevisionInfo> messages = this.getPushedRevisions(remoteRepositoryUpdates);
                    if (!this.isCanceled() && !messages.isEmpty()) {
                        GitHookContext context = this.initializeHookContext(messages);
                        for (GitHook gitHook : hooks) {
                            gitHook.afterPush(context);
                        }
                    }
                }
            }

            private GitHookContext initializeHookContext(List<GitRevisionInfo> messages) {
                LinkedList<GitHookContext.LogEntry> entries = new LinkedList<GitHookContext.LogEntry>();
                for (GitRevisionInfo message : messages) {
                    entries.add(new GitHookContext.LogEntry(message.getFullMessage(), message.getAuthor().toString(), message.getRevision(), new Date(message.getCommitTime())));
                }
                GitHookContext context = new GitHookContext(new File[]{this.getRepositoryRoot()}, null, entries.toArray(new GitHookContext.LogEntry[entries.size()]));
                return context;
            }

            private List<GitRevisionInfo> addRevisions(GitClient client, Set<String> visitedRevisions, String remoteRevisionId, String localRevisionId) throws GitException {
                LinkedList<GitRevisionInfo> list;
                block7: {
                    list = new LinkedList<GitRevisionInfo>();
                    SearchCriteria crit = null;
                    if (localRevisionId != null) {
                        if (remoteRevisionId == null) {
                            crit = new SearchCriteria();
                            crit.setRevisionTo(localRevisionId);
                        } else {
                            crit = new SearchCriteria();
                            crit.setRevisionFrom(remoteRevisionId);
                            crit.setRevisionTo(localRevisionId);
                        }
                    }
                    if (crit != null) {
                        final 2 supp = this;
                        try {
                            GitRevisionInfo[] revisions;
                            for (GitRevisionInfo rev : revisions = client.log(crit, new ProgressMonitor(){

                                public boolean isCanceled() {
                                    return supp.isCanceled();
                                }

                                public void started(String command) {
                                }

                                public void finished() {
                                }

                                public void preparationsFailed(String message) {
                                }

                                public void notifyError(String message) {
                                }

                                public void notifyWarning(String message) {
                                }
                            })) {
                                boolean firstTime = visitedRevisions.add(rev.getRevision());
                                if (!firstTime) continue;
                                list.add(rev);
                            }
                        }
                        catch (GitException.MissingObjectException ex) {
                            if (remoteRevisionId != null && remoteRevisionId.equals(ex.getObjectName())) break block7;
                            throw ex;
                        }
                    }
                }
                return list;
            }

            private void reportRemoteConflicts(Map<String, GitTransportUpdate> updates) {
                LinkedList<GitTransportUpdate> errors = new LinkedList<GitTransportUpdate>();
                LinkedList<GitTransportUpdate> conflicts = new LinkedList<GitTransportUpdate>();
                block4: for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                    GitTransportUpdate update = e.getValue();
                    switch (update.getResult()) {
                        case OK: 
                        case UP_TO_DATE: {
                            continue block4;
                        }
                        case REJECTED_NONFASTFORWARD: {
                            conflicts.add(update);
                            continue block4;
                        }
                    }
                    errors.add(update);
                }
                String message = null;
                if (!errors.isEmpty()) {
                    message = NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.report.errors");
                } else if (!conflicts.isEmpty()) {
                    message = NbBundle.getMessage(PushAction.class, (String)"MSG_PushAction.report.conflicts");
                }
                if (message != null) {
                    JButton outputBtn = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)outputBtn, (String)NbBundle.getMessage(PushAction.class, (String)"CTL_PushAction.report.outputButton.text"));
                    outputBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushAction.class, (String)"CTL_PushAction.report.outputButton.desc"));
                    Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, NbBundle.getMessage(PushAction.class, (String)"LBL_PushAction.report.error.title"), 2, 0, new Object[]{outputBtn, NotifyDescriptor.CANCEL_OPTION}, (Object)outputBtn));
                    if (o == outputBtn) {
                        this.getLogger().getOpenOutputAction().actionPerformed(new ActionEvent((Object)PushAction.this, 1001, null));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(PushAction.class, (String)"LBL_PushAction.progressName"));
    }
}

