/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.output;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputLogger {
    private InputOutput log;
    private File repositoryRoot;
    private boolean writable;
    private static final RequestProcessor rp = new RequestProcessor("GitOutput", 1);
    private static final Logger LOG = Logger.getLogger(OutputLogger.class.getName());
    private static final WeakSet<InputOutput> openWindows = new WeakSet(5);
    private AbstractAction action;

    public static OutputLogger getLogger(File repositoryRoot) {
        if (repositoryRoot != null) {
            return new OutputLogger(repositoryRoot);
        }
        return new NullLogger();
    }

    private OutputLogger(File repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    private OutputLogger() {
    }

    private InputOutput getLog() {
        if (this.log == null) {
            LOG.log(Level.FINE, "Creating OutputLogger for {0}", this.repositoryRoot.getAbsolutePath());
            this.log = IOProvider.getDefault().getIO(this.repositoryRoot.getName() + " - " + this.repositoryRoot.getAbsolutePath(), false);
            this.writable = true;
            if (!openWindows.contains((Object)this.log)) {
                this.writable = false;
                this.writable = GitModuleConfig.getDefault().getAutoOpenOutput();
                openWindows.add((Object)this.log);
                if (!this.writable) {
                    this.log.closeInputOutput();
                }
            }
        }
        if (this.log.isClosed()) {
            LOG.log(Level.FINE, "Creating OutputLogger for {0}", this.repositoryRoot);
            this.log = IOProvider.getDefault().getIO(this.repositoryRoot.getName() + " - " + this.repositoryRoot.getAbsolutePath(), false);
            try {
                this.log.getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writable = false;
        }
        return this.log;
    }

    public void closeLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (OutputLogger.this.log != null) {
                    OutputLogger.this.log.getOut().close();
                    OutputLogger.this.log.getErr().close();
                    if (!OutputLogger.this.writable) {
                        OutputLogger.this.log.closeInputOutput();
                    }
                }
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.getLog().getOut().flush();
                OutputLogger.this.getLog().getErr().flush();
            }
        });
    }

    public void outputInRed(final String msg) {
        if (msg == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getErr();
                if (OutputLogger.this.writable) {
                    out.println(msg);
                    out.flush();
                }
            }
        });
    }

    public void output(final String msg) {
        if (msg == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getOut();
                out.println(msg);
                out.flush();
            }
        });
    }

    public Action getOpenOutputAction() {
        if (this.action == null) {
            this.action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputLogger.this.getLog().select();
                    OutputLogger.this.writable = true;
                    openWindows.add((Object)OutputLogger.this.log);
                }
            };
        }
        return this.action;
    }

    public void outputFile(final String message, final File file, final int linkStartPosition) {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getOut();
                out.print(message.substring(0, linkStartPosition));
                try {
                    out.println(message.substring(linkStartPosition), new OutputListener(){

                        public void outputLineSelected(OutputEvent ev) {
                        }

                        public void outputLineAction(OutputEvent ev) {
                            new OpenInEditorAction(new File[]{file}).actionPerformed(new ActionEvent(this, 1001, file.getAbsolutePath()));
                        }

                        public void outputLineCleared(OutputEvent ev) {
                        }
                    });
                }
                catch (IOException ex) {
                    out.println(message.substring(linkStartPosition));
                }
                out.flush();
            }
        });
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        @Override
        public void closeLog() {
        }

        @Override
        public void flushLog() {
        }

        @Override
        public void output(String msg) {
        }

        @Override
        public Action getOpenOutputAction() {
            return null;
        }
    }
}

