/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.BorderLayout;
import java.io.File;
import java.util.List;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(persistenceType=2, preferredID="Git.SearchHistoryTopComponent")
public class SearchHistoryTopComponent
extends TopComponent {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;
    private File[] files;
    private File repository;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(File repository, File[] files) {
        this();
        this.repository = repository;
        this.files = files;
        this.initComponents();
    }

    SearchHistoryTopComponent(File repository, File file, DiffResultsViewFactory fac) {
        this();
        this.repository = repository;
        this.files = new File[]{file};
        this.initComponents();
        this.shp.setDiffResultsViewFactory(fac);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    void setSearchCommitId(String commitId) {
        if (commitId != null) {
            this.scp.tfFrom.setText(commitId);
            this.scp.tfTo.setText(commitId);
        }
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.shp.activateDiffView(selectFirstRevision);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.shp = new SearchHistoryPanel(this.repository, this.files, this.scp);
        this.add(this.shp);
    }

    protected void componentClosed() {
        this.shp.releaseDiff();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    static class DiffResultsViewFactory {
        DiffResultsViewFactory() {
        }

        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

