/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.io.File;
import java.util.List;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.history.DiffResultsView;
import org.netbeans.modules.git.ui.history.DiffResultsViewForLine;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SearchHistoryAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        SearchHistoryAction.openSearch(repository, roots, Utils.getContextDisplayName((VCSContext)context));
        return null;
    }

    public static void openSearch(final File repository, final File[] roots, String contextName) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, roots);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                if (roots != null && (roots.length == 1 && roots[0].isFile() || roots.length > 1 && Utils.shareCommonDataObject((File[])roots))) {
                    tc.search(false);
                }
            }
        });
    }

    public static void openSearch(final File repository, final File root, String contextName, final String commitId) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, new File[]{root});
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.setSearchCommitId(commitId);
                tc.search(true);
            }
        });
    }

    public static void openSearch(final File repository, final File root, String contextName, final int lineNumber) {
        final String title = NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"LBL_SearchHistoryTopComponent.title", (Object)contextName);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(repository, root, new SearchHistoryTopComponent.DiffResultsViewFactory(){

                    @Override
                    DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
                        return new DiffResultsViewForLine(panel, results, lineNumber);
                    }
                });
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                tc.search(true);
                tc.activateDiffView(true);
            }
        });
    }
}

