/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.RevisionNodeChildren;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    static final String COLUMN_NAME_PATH = "path";
    private RepositoryRevision.Event event;
    private RepositoryRevision container;
    private String path;
    private String bgColor;
    private String fgColor;

    public RevisionNode(RepositoryRevision container, SearchHistoryPanel master) {
        super((Children)new RevisionNodeChildren(container, master), Lookups.fixed((Object[])new Object[]{master, container}));
        this.container = container;
        this.event = null;
        this.path = null;
        String rev = container.getLog().getRevision();
        String name = rev.length() > 7 ? rev.substring(0, 7) : rev;
        this.setName(name);
        this.initProperties();
    }

    public RevisionNode(RepositoryRevision.Event revision, SearchHistoryPanel master) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{master, revision}));
        this.path = revision.getPath();
        this.event = revision;
        this.setName(revision.getName());
        this.initProperties();
    }

    RepositoryRevision.Event getRevision() {
        return this.event;
    }

    RepositoryRevision getContainer() {
        return this.container;
    }

    RepositoryRevision.Event getEvent() {
        return this.event;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean context) {
        return null;
    }

    private void initProperties() {
        AttributeSet searchHiliteAttrs = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getFontColors("highlight-search");
        Color c = (Color)searchHiliteAttrs.getAttribute(StyleConstants.Background);
        if (c != null) {
            this.bgColor = RevisionNode.getColorString(c);
        }
        if ((c = (Color)searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
            this.fgColor = RevisionNode.getColorString(c);
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new UsernameProperty());
        ps.put((Node.Property)new MessageProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static String getColorString(Color c) {
        return "#" + RevisionNode.getHex(c.getRed()) + RevisionNode.getHex(c.getGreen()) + RevisionNode.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    private static String highlight(String author, String needle, String bgColor, String fgColor) {
        int idx;
        if (fgColor != null && bgColor != null && (idx = author.toLowerCase().indexOf(needle)) != -1) {
            return "<html><body>" + author.substring(0, idx) + "<span style=\"background-color: " + bgColor + "; color: " + fgColor + ";\">" + author.substring(idx, idx + needle.length()) + "</span>" + author.substring(idx + needle.length()) + "</body></html>";
        }
        return author;
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(Object value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            Object val = this.getValue();
            if (val instanceof Date) {
                val = DateFormat.getDateTimeInstance().format((Date)val);
            }
            renderer.setText(val.toString());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight h : ((SearchHistoryPanel)RevisionNode.this.getLookup().lookup(SearchHistoryPanel.class)).getSearchHighlights()) {
                    if (h.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE) continue;
                    return RevisionNode.highlight(RevisionNode.this.container.getLog().getFullMessage(), h.getSearchText(), RevisionNode.this.bgColor, RevisionNode.this.fgColor);
                }
                return RevisionNode.this.container.getLog().getFullMessage();
            }
            return "";
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return new Date(RevisionNode.this.container.getLog().getCommitTime());
            }
            return "";
        }

        public Class getValueType() {
            return Date.class;
        }
    }

    private class PathProperty
    extends CommitNodeProperty {
        public PathProperty() {
            super(RevisionNode.COLUMN_NAME_PATH, String.class, RevisionNode.COLUMN_NAME_PATH, RevisionNode.COLUMN_NAME_PATH);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return "";
            }
            return RevisionNode.this.event.getPath();
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight h : ((SearchHistoryPanel)RevisionNode.this.getLookup().lookup(SearchHistoryPanel.class)).getSearchHighlights()) {
                    if (h.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR) continue;
                    return RevisionNode.highlight(RevisionNode.this.container.getLog().getAuthor().toString(), h.getSearchText(), RevisionNode.this.bgColor, RevisionNode.this.fgColor);
                }
                return RevisionNode.this.container.getLog().getAuthor();
            }
            return "";
        }
    }

    private abstract class CommitNodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected CommitNodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor(this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }
}

