/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.RequestProcessor;

public class RepositoryRevision {
    private GitRevisionInfo message;
    private final List<Event> events = new ArrayList<Event>(5);
    private final List<Event> dummyEvents;
    private final Map<File, String> commonAncestors = new HashMap<File, String>();
    private final Set<GitTag> tags;
    private final Set<GitBranch> branches;
    private boolean eventsInitialized;
    private Search currentSearch;
    private final PropertyChangeSupport support;
    public static final String PROP_EVENTS_CHANGED = "eventsChanged";
    private final File repositoryRoot;
    private final File[] selectionRoots;

    RepositoryRevision(GitRevisionInfo message, File repositoryRoot, File[] selectionRoots, Set<GitTag> tags, Set<GitBranch> branches, File dummyFile, String dummyFileRelativePath) {
        this.message = message;
        this.repositoryRoot = repositoryRoot;
        this.selectionRoots = selectionRoots;
        this.tags = tags;
        this.branches = branches;
        this.support = new PropertyChangeSupport(this);
        this.dummyEvents = new ArrayList<Event>(1);
        if (dummyFile != null && dummyFileRelativePath != null) {
            this.dummyEvents.add(new Event(dummyFile, dummyFileRelativePath));
        }
    }

    public Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    Event[] getDummyEvents() {
        return this.dummyEvents.toArray(new Event[this.dummyEvents.size()]);
    }

    public GitRevisionInfo getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevision());
        text.append("\t");
        text.append(DateFormat.getDateTimeInstance().format(new Date(this.getLog().getCommitTime())));
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getShortMessage());
        return text.toString();
    }

    String getAncestorCommit(File file, GitClient client, ProgressMonitor pm) throws GitException {
        String ancestorCommit = this.commonAncestors.get(file);
        if (ancestorCommit == null && !this.commonAncestors.containsKey(file)) {
            GitRevisionInfo info = null;
            if (this.getLog().getParents().length == 1) {
                info = client.getPreviousRevision(file, this.getLog().getRevision(), pm);
            } else if (this.getLog().getParents().length > 1) {
                info = client.getCommonAncestor(this.getLog().getParents(), pm);
            }
            ancestorCommit = info == null ? null : info.getRevision();
            this.commonAncestors.put(file, ancestorCommit);
        }
        return ancestorCommit;
    }

    public GitBranch[] getBranches() {
        return this.branches == null ? new GitBranch[]{} : this.branches.toArray(new GitBranch[this.branches.size()]);
    }

    public GitTag[] getTags() {
        return this.tags == null ? new GitTag[]{} : this.tags.toArray(new GitTag[this.tags.size()]);
    }

    boolean expandEvents() {
        Search s = this.currentSearch;
        if (s == null && !this.eventsInitialized) {
            this.currentSearch = new Search();
            this.currentSearch.start(Git.getInstance().getRequestProcessor(this.repositoryRoot), this.repositoryRoot);
            return true;
        }
        return !this.eventsInitialized;
    }

    void cancelExpand() {
        Search s = this.currentSearch;
        if (s != null) {
            s.cancel();
            this.currentSearch = null;
        }
    }

    boolean isEventsInitialized() {
        return this.eventsInitialized;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    private class Search
    extends GitProgressSupport {
        private Search() {
        }

        @Override
        protected void perform() {
            Map<File, GitRevisionInfo.GitFileInfo> files;
            try {
                files = RepositoryRevision.this.getLog().getModifiedFiles();
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                files = Collections.emptyMap();
            }
            final List<Event> logEvents = this.prepareEvents(files);
            if (!this.isCanceled()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Search.this.isCanceled()) {
                            RepositoryRevision.this.events.clear();
                            RepositoryRevision.this.dummyEvents.clear();
                            RepositoryRevision.this.events.addAll(logEvents);
                            RepositoryRevision.this.eventsInitialized = true;
                            RepositoryRevision.this.currentSearch = null;
                            RepositoryRevision.this.support.firePropertyChange(RepositoryRevision.PROP_EVENTS_CHANGED, null, new ArrayList(RepositoryRevision.this.events));
                        }
                    }
                });
            }
        }

        @Override
        protected void finishProgress() {
        }

        @Override
        protected void startProgress() {
        }

        @Override
        protected ProgressHandle getProgressHandle() {
            return null;
        }

        private void start(RequestProcessor requestProcessor, File repositoryRoot) {
            this.start(requestProcessor, repositoryRoot, null);
        }

        private List<Event> prepareEvents(Map<File, GitRevisionInfo.GitFileInfo> files) {
            ArrayList<Event> logEvents = new ArrayList<Event>(files.size());
            HashSet<File> renamedFilesOriginals = new HashSet<File>(files.size());
            for (Map.Entry<File, GitRevisionInfo.GitFileInfo> e : files.entrySet()) {
                if (e.getValue().getStatus() != GitRevisionInfo.GitFileInfo.Status.RENAMED) continue;
                renamedFilesOriginals.add(e.getValue().getOriginalFile());
            }
            for (Map.Entry<File, GitRevisionInfo.GitFileInfo> e : files.entrySet()) {
                File selectionRoot;
                File f = e.getKey();
                if (renamedFilesOriginals.contains(f)) continue;
                GitRevisionInfo.GitFileInfo info = e.getValue();
                boolean underRoots = false;
                File[] arr$ = RepositoryRevision.this.selectionRoots;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(underRoots = VersioningSupport.isFlat((File)(selectionRoot = arr$[i$])) ? selectionRoot.equals(f.getParentFile()) : Utils.isAncestorOrEqual((File)selectionRoot, (File)f)); ++i$) {
                }
                logEvents.add(new Event(info, underRoots));
            }
            Collections.sort(logEvents);
            return logEvents;
        }
    }

    public class Event
    implements Comparable<Event> {
        private final File file;
        private final String path;
        private final GitRevisionInfo.GitFileInfo.Status status;
        private boolean underRoots;
        private final File originalFile;
        private final String originalPath;

        public Event(GitRevisionInfo.GitFileInfo changedPath, boolean underRoots) {
            this.path = changedPath.getRelativePath();
            this.file = changedPath.getFile();
            this.originalPath = changedPath.getOriginalPath() == null ? this.path : changedPath.getOriginalPath();
            this.originalFile = changedPath.getOriginalFile() == null ? this.file : changedPath.getOriginalFile();
            this.status = changedPath.getStatus();
            this.underRoots = underRoots;
        }

        private Event(File dummyFile, String dummyPath) {
            this.path = dummyPath;
            this.file = dummyFile;
            this.originalPath = dummyPath;
            this.originalFile = dummyFile;
            this.status = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
            this.underRoots = true;
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public File getFile() {
            return this.file;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getPath() {
            return this.path;
        }

        public char getAction() {
            switch (this.status) {
                case ADDED: {
                    return 'A';
                }
                case MODIFIED: {
                    return 'M';
                }
                case RENAMED: {
                    return 'R';
                }
                case COPIED: {
                    return 'C';
                }
                case REMOVED: {
                    return 'D';
                }
            }
            return '?';
        }

        public String toString() {
            return this.path;
        }

        @Override
        public int compareTo(Event other) {
            int retval = this.status.compareTo((Enum)other.status);
            if (retval == 0) {
                retval = this.path.compareTo(other.path);
            }
            return retval;
        }

        boolean isUnderRoots() {
            return this.underRoots;
        }

        String getOriginalPath() {
            return this.originalPath;
        }
    }
}

