/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.RevisionNode;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class DiffTreeTable
extends OutlineView {
    private RevisionsRootNode rootNode;
    private List<RepositoryRevision> results;
    private final SearchHistoryPanel master;
    private static final Icon NO_ICON = new NoIcon();

    public DiffTreeTable(SearchHistoryPanel master) {
        super(Bundle.LBL_DiffView_TreeColumnLabel());
        this.master = master;
        this.getOutline().setShowHorizontalLines(true);
        this.getOutline().setShowVerticalLines(false);
        this.getOutline().setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
    }

    private void setupColumns() {
        ResourceBundle loc = NbBundle.getBundle(DiffTreeTable.class);
        this.setPropertyColumns(new String[]{"path", loc.getString("LBL_DiffTree_Column_Path"), "date", loc.getString("LBL_DiffTree_Column_Time"), "username", loc.getString("LBL_DiffTree_Column_Username"), "message", loc.getString("LBL_DiffTree_Column_Message")});
        this.setPropertyColumnDescription("path", loc.getString("LBL_DiffTree_Column_Path_Desc"));
        this.setPropertyColumnDescription("date", loc.getString("LBL_DiffTree_Column_Time_Desc"));
        this.setPropertyColumnDescription("username", loc.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setPropertyColumnDescription("message", loc.getString("LBL_DiffTree_Column_Message_Desc"));
        TableColumnModel model = this.getOutline().getColumnModel();
        if (model instanceof ETableColumnModel) {
            ((ETableColumnModel)model).setColumnHidden(model.getColumn(1), true);
        }
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DiffTreeTable.this.getOutline().getColumnCount() == 4) {
                    int width = DiffTreeTable.this.getWidth();
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 25 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 15 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(width * 50 / 100);
                }
            }
        });
    }

    void setSelection(int idx) {
        this.getOutline().getSelectionModel().setValueIsAdjusting(false);
        this.getOutline().scrollRectToVisible(this.getOutline().getCellRect(idx, 1, true));
        this.getOutline().getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(RepositoryRevision container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(RepositoryRevision.Event revision) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, revision);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.getOutline().getSelectedRows();
    }

    public int getRowCount() {
        return this.getOutline().getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
    }

    public void setResults(List<RepositoryRevision> results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    public void refreshResults(List<RepositoryRevision> results) {
        this.results = results;
        ((RevisionsRootNodeChildren)this.rootNode.getChildren()).refreshKeys();
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
            DiffTreeTable.this.repaint();
        }

        protected Node[] createNodes(Object key) {
            RevisionNode node = key instanceof RepositoryRevision ? new RevisionNode((RepositoryRevision)key, DiffTreeTable.this.master) : new RevisionNode((RepositoryRevision.Event)key, DiffTreeTable.this.master);
            return new Node[]{node};
        }
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private class NoLeafIconRenderDataProvider
    implements RenderDataProvider {
        private RenderDataProvider delegate;

        public NoLeafIconRenderDataProvider(RenderDataProvider delegate) {
            this.delegate = delegate;
        }

        public String getDisplayName(Object o) {
            return this.delegate.getDisplayName(o);
        }

        public boolean isHtmlDisplayName(Object o) {
            return this.delegate.isHtmlDisplayName(o);
        }

        public Color getBackground(Object o) {
            return this.delegate.getBackground(o);
        }

        public Color getForeground(Object o) {
            return this.delegate.getForeground(o);
        }

        public String getTooltipText(Object o) {
            return this.delegate.getTooltipText(o);
        }

        public Icon getIcon(Object o) {
            if (DiffTreeTable.this.getOutline().getOutlineModel().isLeaf(o)) {
                return NO_ICON;
            }
            return null;
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren());
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }
}

