/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.io.File;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.fetch.GetRemoteChangesAction;
import org.netbeans.modules.git.ui.fetch.PullAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.actions.SystemAction;

public class PullFromUpstreamAction
extends GetRemoteChangesAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.pull(repository);
    }

    private void pull(final File repository) {
        GitProgressSupport.NoOutputLogging supp = new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                RepositoryInfo info = RepositoryInfo.getInstance(repository);
                info.refreshRemotes();
                String errorLabel = Bundle.LBL_Pull_pullFromUpstreamFailed();
                GitBranch trackedBranch = PullFromUpstreamAction.this.getTrackedBranch(info, errorLabel);
                if (trackedBranch == null) {
                    return;
                }
                GitRemoteConfig cfg = GetRemoteChangesAction.getRemoteConfigForActiveBranch(trackedBranch, info, errorLabel);
                if (cfg == null) {
                    return;
                }
                String uri = (String)cfg.getUris().get(0);
                Utils.logVCSExternalRepository((String)"GIT", (String)uri);
                ((PullAction)SystemAction.get(PullAction.class)).pull(repository, uri, cfg.getFetchRefSpecs(), trackedBranch.getName(), null);
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PullFromUpstreamAction_preparing());
    }
}

