/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.BranchMapping;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class PullBranchesStep
extends AbstractWizardPanel
implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    private GitRemoteConfig remote;
    private final File repository;
    private final ItemSelector<BranchMapping> branches;
    private String mergingBranch;
    private String currentBranch;
    private static final String REMOTE_BRANCH_NAME_WITH_REMOTE = "{0}/{1}";

    public PullBranchesStep(File repository) {
        this.repository = repository;
        this.branches = new ItemSelector(NbBundle.getMessage(PullBranchesStep.class, (String)"FetchBranchesPanel.jLabel1.text"));
        this.branches.addChangeListener(this);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                PullBranchesStep.this.validateBeforeNext();
            }
        });
        this.getJComponent().setName(NbBundle.getMessage(PullBranchesStep.class, (String)"LBL_FetchBranches.remoteBranches"));
    }

    @Override
    protected final void validateBeforeNext() {
        this.setValid(true, null);
        if (this.branches.getSelectedBranches().isEmpty()) {
            this.setValid(false, new AbstractWizardPanel.Message(NbBundle.getMessage(PullBranchesStep.class, (String)"MSG_FetchBranchesPanel.errorNoBranchSelected"), true));
        } else {
            this.setValid(true, new AbstractWizardPanel.Message(NbBundle.getMessage(PullBranchesStep.class, (String)"MSG_PullBranchesStep.mergingBranch", (Object)this.mergingBranch), true));
        }
    }

    @Override
    protected final JComponent getJComponent() {
        return this.branches.getPanel();
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(PullBranchesStep.class);
    }

    public void setRemote(GitRemoteConfig remote) {
        if (this.remote != remote && (this.remote == null || remote == null)) {
            this.remote = remote;
        }
        this.validateBeforeNext();
    }

    public void fillRemoteBranches(final Map<String, GitBranch> branches) {
        new GitProgressSupport.NoOutputLogging(){

            @Override
            protected void perform() {
                final HashMap<String, GitBranch> localBranches = new HashMap<String, GitBranch>();
                RepositoryInfo info = RepositoryInfo.getInstance(PullBranchesStep.this.repository);
                info.refresh();
                localBranches.putAll(info.getBranches());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PullBranchesStep.this.fillRemoteBranches(branches, localBranches);
                    }
                });
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(PullBranchesStep.class, (String)"MSG_FetchBranchesPanel.loadingLocalBranches"));
    }

    private void fillRemoteBranches(Map<String, GitBranch> branches, Map<String, GitBranch> localBranches) {
        ArrayList<BranchMapping> l = new ArrayList<BranchMapping>(branches.size());
        for (GitBranch branch : branches.values()) {
            GitBranch localBranch = localBranches.get(this.remote.getRemoteName() + "/" + branch.getName());
            boolean preselected = localBranch != null && !localBranch.getId().equals(branch.getId());
            l.add(new BranchMapping(branch.getName(), branch.getId(), localBranch, this.remote, preselected));
        }
        for (GitBranch branch : localBranches.values()) {
            if (!branch.isActive()) continue;
            this.currentBranch = branch.getName();
        }
        this.branches.setBranches(l);
        this.stateChanged(new ChangeEvent(this));
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.markMergingBranch();
        this.validateBeforeNext();
    }

    public String getBranchToMerge() {
        return this.mergingBranch;
    }

    public List<String> getSelectedRefSpecs() {
        LinkedList<String> specs = new LinkedList<String>();
        for (BranchMapping b : this.branches.getSelectedBranches()) {
            specs.add(b.getRefSpec());
        }
        return specs;
    }

    public boolean isFinishPanel() {
        return true;
    }

    private void markMergingBranch() {
        this.mergingBranch = null;
        for (BranchMapping mapping : this.branches.getSelectedBranches()) {
            if (!mapping.getRemoteBranchName().equals(this.currentBranch) && this.mergingBranch != null) continue;
            this.mergingBranch = MessageFormat.format(REMOTE_BRANCH_NAME_WITH_REMOTE, mapping.getRemoteName(), mapping.getRemoteBranchName());
        }
    }
}

