/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.util.Map;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

abstract class GetRemoteChangesAction
extends SingleRepositoryAction {
    GetRemoteChangesAction() {
    }

    protected void log(Map<String, GitTransportUpdate> updates, OutputLogger logger) {
        if (updates.isEmpty()) {
            logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.noChange"));
        } else {
            for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                GitTransportUpdate update = e.getValue();
                if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                    logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.updateBranch", (Object[])new Object[]{update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()}));
                    continue;
                }
                logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
            }
        }
    }

    private static String parseRemote(String branchName) {
        int pos = branchName.lastIndexOf(47);
        String remoteName = null;
        if (pos > 0) {
            remoteName = branchName.substring(0, pos);
        }
        return remoteName;
    }

    protected GitBranch getTrackedBranch(RepositoryInfo info, String errorLabel) {
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch == null) {
            return null;
        }
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch == null) {
            GetRemoteChangesAction.notifyError(errorLabel, Bundle.MSG_Err_noTrackedBranch(activeBranch.getName()));
            return null;
        }
        if (!trackedBranch.isRemote()) {
            GetRemoteChangesAction.notifyError(errorLabel, Bundle.MSG_Err_trackedBranchLocal(trackedBranch.getName()));
            return null;
        }
        return trackedBranch;
    }

    protected static GitRemoteConfig getRemoteConfigForActiveBranch(GitBranch trackedBranch, RepositoryInfo info, String errorLabel) {
        GitRemoteConfig cfg;
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        String remoteName = GetRemoteChangesAction.parseRemote(trackedBranch.getName());
        GitRemoteConfig gitRemoteConfig = cfg = remoteName == null ? null : remotes.get(remoteName);
        if (cfg == null) {
            GetRemoteChangesAction.notifyError(errorLabel, Bundle.MSG_Err_noRemote(trackedBranch.getName()));
            return null;
        }
        if (cfg.getUris().isEmpty()) {
            GetRemoteChangesAction.notifyError(errorLabel, Bundle.MSG_Err_noUri(cfg.getRemoteName()));
            return null;
        }
        if (cfg.getFetchRefSpecs().isEmpty()) {
            GetRemoteChangesAction.notifyError(errorLabel, Bundle.MSG_Err_noSpecs(cfg.getRemoteName()));
            return null;
        }
        return cfg;
    }

    private static void notifyError(String errorLabel, String errorMessage) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)errorMessage, errorLabel, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }
}

