/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.FetchWizard;
import org.netbeans.modules.git.ui.fetch.GetRemoteChangesAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class FetchAction
extends GetRemoteChangesAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.fetch(repository);
    }

    public void fetch(final File repository, GitRemoteConfig remote) {
        if (remote.getUris().size() != 1) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    FetchAction.this.fetch(repository);
                }
            });
        } else {
            this.fetch(repository, (String)remote.getUris().get(0), remote.getFetchRefSpecs(), null);
        }
    }

    private void fetch(final File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refreshRemotes();
        final Map<String, GitRemoteConfig> remotes = info.getRemotes();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FetchWizard wiz = new FetchWizard(repository, remotes);
                if (wiz.show()) {
                    Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getFetchUri());
                    FetchAction.this.fetch(repository, wiz.getFetchUri(), wiz.getFetchRefSpecs(), wiz.getRemoteToPersist());
                }
            }
        });
    }

    public void fetch(File repository, final String target, final List<String> fetchRefSpecs, final String remoteNameToUpdate) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    if (remoteNameToUpdate != null) {
                        GitRemoteConfig config = client.getRemote(remoteNameToUpdate, this.getProgressMonitor());
                        if (this.isCanceled()) {
                            return;
                        }
                        config = FetchAction.prepareConfig(config, remoteNameToUpdate, target, fetchRefSpecs);
                        client.setRemote(config, this.getProgressMonitor());
                        if (this.isCanceled()) {
                            return;
                        }
                    }
                    Map<String, GitTransportUpdate> updates = client.fetch(target, fetchRefSpecs, this.getProgressMonitor());
                    FetchAction.this.log(updates, this.getLogger());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction.progressName"));
    }

    static GitRemoteConfig prepareConfig(GitRemoteConfig original, String remoteName, String remoteUri, List<String> fetchRefSpecs) {
        List<String> refSpecs;
        List<Object> remoteUris;
        if (original != null) {
            remoteUris = new LinkedList(original.getUris());
            if (!remoteUris.contains(remoteUri)) {
                remoteUris.add(remoteUri);
            }
        } else {
            remoteUris = Arrays.asList(remoteUri);
        }
        if (original != null) {
            refSpecs = new LinkedList<String>(original.getFetchRefSpecs());
            for (String refSpec : fetchRefSpecs) {
                if (refSpecs.contains(refSpec)) continue;
                refSpecs.add(refSpec);
            }
        } else {
            refSpecs = fetchRefSpecs;
        }
        return new GitRemoteConfig(remoteName, remoteUris, original == null ? Collections.emptyList() : original.getPushUris(), refSpecs, original == null ? Collections.emptyList() : original.getPushRefSpecs());
    }
}

